/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorPartitionConversion;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorAssignRow {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorAssignRow.class);
    boolean[] isConvert;
    int[] projectionColumnNums;
    TypeInfo[] targetTypeInfos;
    int[] maxLengths;
    ObjectInspector[] convertSourceOI;
    Writable[] convertTargetWritables;

    private void allocateArrays(int count) {
        this.isConvert = new boolean[count];
        this.projectionColumnNums = new int[count];
        this.targetTypeInfos = new TypeInfo[count];
        this.maxLengths = new int[count];
    }

    private void allocateConvertArrays(int count) {
        this.convertSourceOI = new ObjectInspector[count];
        this.convertTargetWritables = new Writable[count];
    }

    private void initTargetEntry(int logicalColumnIndex, int projectionColumnNum, TypeInfo typeInfo) {
        this.isConvert[logicalColumnIndex] = false;
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.targetTypeInfos[logicalColumnIndex] = typeInfo;
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            switch (primitiveCategory) {
                case CHAR: {
                    this.maxLengths[logicalColumnIndex] = ((CharTypeInfo)primitiveTypeInfo).getLength();
                    break;
                }
                case VARCHAR: {
                    this.maxLengths[logicalColumnIndex] = ((VarcharTypeInfo)primitiveTypeInfo).getLength();
                    break;
                }
            }
        }
    }

    private void initConvertSourceEntry(int logicalColumnIndex, TypeInfo convertSourceTypeInfo) {
        this.isConvert[logicalColumnIndex] = true;
        ObjectInspector.Category convertSourceCategory = convertSourceTypeInfo.getCategory();
        this.convertSourceOI[logicalColumnIndex] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(convertSourceTypeInfo);
        if (convertSourceCategory == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory = ((PrimitiveTypeInfo)this.targetTypeInfos[logicalColumnIndex]).getPrimitiveCategory();
            switch (targetPrimitiveCategory) {
                case DATE: {
                    this.convertTargetWritables[logicalColumnIndex] = new DateWritable();
                    break;
                }
                case STRING: {
                    this.convertTargetWritables[logicalColumnIndex] = new Text();
                    break;
                }
            }
        }
    }

    public void init(StructObjectInspector structObjectInspector, List<Integer> projectedColumns) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        int count = fields.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int projectionColumnNum = projectedColumns.get(i);
            StructField field = fields.get(i);
            ObjectInspector fieldInspector = field.getFieldObjectInspector();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            this.initTargetEntry(i, projectionColumnNum, typeInfo);
        }
    }

    public void init(StructObjectInspector structObjectInspector) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        int count = fields.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            StructField field = fields.get(i);
            ObjectInspector fieldInspector = field.getFieldObjectInspector();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            this.initTargetEntry(i, i, typeInfo);
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        int count = typeNames.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeNames.get(i));
            this.initTargetEntry(i, i, typeInfo);
        }
    }

    public void init(TypeInfo typeInfo, int outputColumnNum) throws HiveException {
        this.allocateArrays(1);
        this.initTargetEntry(0, outputColumnNum, typeInfo);
    }

    public int initConversion(TypeInfo[] sourceTypeInfos, TypeInfo[] targetTypeInfos, boolean[] columnsToIncludeTruncated) {
        int targetColumnCount = columnsToIncludeTruncated == null ? targetTypeInfos.length : Math.min(targetTypeInfos.length, columnsToIncludeTruncated.length);
        int sourceColumnCount = Math.min(sourceTypeInfos.length, targetColumnCount);
        this.allocateArrays(sourceColumnCount);
        this.allocateConvertArrays(sourceColumnCount);
        for (int i = 0; i < sourceColumnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            TypeInfo sourceTypeInfo = sourceTypeInfos[i];
            TypeInfo targetTypeInfo = targetTypeInfos[i];
            if (!sourceTypeInfo.equals(targetTypeInfo)) {
                if (VectorPartitionConversion.isImplicitVectorColumnConversion(sourceTypeInfo, targetTypeInfo)) {
                    this.initTargetEntry(i, i, sourceTypeInfo);
                    continue;
                }
                this.initTargetEntry(i, i, targetTypeInfo);
                this.initConvertSourceEntry(i, sourceTypeInfo);
                continue;
            }
            this.initTargetEntry(i, i, targetTypeInfo);
        }
        return sourceColumnCount;
    }

    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex, Object object) {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        TypeInfo targetTypeInfo = this.targetTypeInfos[logicalColumnIndex];
        if (targetTypeInfo == null || targetTypeInfo.getCategory() == null) {
            return;
        }
        this.assignRowColumn(batch.cols[projectionColumnNum], batchIndex, targetTypeInfo, object);
    }

    private void assignRowColumn(ColumnVector columnVector, int batchIndex, TypeInfo targetTypeInfo, Object object) {
        if (object == null) {
            VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
            return;
        }
        block0 : switch (targetTypeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory = ((PrimitiveTypeInfo)targetTypeInfo).getPrimitiveCategory();
                switch (targetPrimitiveCategory) {
                    case VOID: {
                        VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                        return;
                    }
                    case BOOLEAN: {
                        if (object instanceof Boolean) {
                            ((LongColumnVector)columnVector).vector[batchIndex] = (Boolean)object != false ? 1 : 0;
                            break block0;
                        }
                        ((LongColumnVector)columnVector).vector[batchIndex] = ((BooleanWritable)object).get() ? 1 : 0;
                        break block0;
                    }
                    case BYTE: {
                        if (object instanceof Byte) {
                            ((LongColumnVector)columnVector).vector[batchIndex] = ((Byte)object).byteValue();
                            break block0;
                        }
                        ((LongColumnVector)columnVector).vector[batchIndex] = ((ByteWritable)((Object)object)).get();
                        break block0;
                    }
                    case SHORT: {
                        if (object instanceof Short) {
                            ((LongColumnVector)columnVector).vector[batchIndex] = ((Short)object).shortValue();
                            break block0;
                        }
                        ((LongColumnVector)columnVector).vector[batchIndex] = ((ShortWritable)object).get();
                        break block0;
                    }
                    case INT: {
                        if (object instanceof Integer) {
                            ((LongColumnVector)columnVector).vector[batchIndex] = ((Integer)object).intValue();
                            break block0;
                        }
                        ((LongColumnVector)columnVector).vector[batchIndex] = ((IntWritable)object).get();
                        break block0;
                    }
                    case LONG: {
                        if (object instanceof Long) {
                            ((LongColumnVector)columnVector).vector[batchIndex] = (Long)object;
                            break block0;
                        }
                        ((LongColumnVector)columnVector).vector[batchIndex] = ((LongWritable)object).get();
                        break block0;
                    }
                    case TIMESTAMP: {
                        if (object instanceof Timestamp) {
                            ((TimestampColumnVector)columnVector).set(batchIndex, (Timestamp)object);
                            break block0;
                        }
                        ((TimestampColumnVector)columnVector).set(batchIndex, ((TimestampWritable)object).getTimestamp());
                        break block0;
                    }
                    case DATE: {
                        if (object instanceof Date) {
                            ((LongColumnVector)columnVector).vector[batchIndex] = DateWritable.dateToDays((Date)object);
                            break block0;
                        }
                        ((LongColumnVector)columnVector).vector[batchIndex] = ((DateWritable)object).getDays();
                        break block0;
                    }
                    case FLOAT: {
                        if (object instanceof Float) {
                            ((DoubleColumnVector)columnVector).vector[batchIndex] = ((Float)object).floatValue();
                            break block0;
                        }
                        ((DoubleColumnVector)columnVector).vector[batchIndex] = ((FloatWritable)object).get();
                        break block0;
                    }
                    case DOUBLE: {
                        if (object instanceof Double) {
                            ((DoubleColumnVector)columnVector).vector[batchIndex] = (Double)object;
                            break block0;
                        }
                        ((DoubleColumnVector)columnVector).vector[batchIndex] = ((DoubleWritable)((Object)object)).get();
                        break block0;
                    }
                    case BINARY: {
                        if (object instanceof byte[]) {
                            byte[] bytes = (byte[])object;
                            ((BytesColumnVector)columnVector).setVal(batchIndex, bytes, 0, bytes.length);
                            break block0;
                        }
                        BytesWritable bw = (BytesWritable)object;
                        ((BytesColumnVector)columnVector).setVal(batchIndex, bw.getBytes(), 0, bw.getLength());
                        break block0;
                    }
                    case STRING: {
                        if (object instanceof String) {
                            String string = (String)object;
                            byte[] bytes = string.getBytes();
                            ((BytesColumnVector)columnVector).setVal(batchIndex, bytes, 0, bytes.length);
                            break block0;
                        }
                        Text tw = (Text)object;
                        ((BytesColumnVector)columnVector).setVal(batchIndex, tw.getBytes(), 0, tw.getLength());
                        break block0;
                    }
                    case VARCHAR: {
                        HiveVarchar hiveVarchar = object instanceof HiveVarchar ? (HiveVarchar)object : ((HiveVarcharWritable)object).getHiveVarchar();
                        byte[] bytes = hiveVarchar.getValue().getBytes();
                        ((BytesColumnVector)columnVector).setVal(batchIndex, bytes, 0, bytes.length);
                        break block0;
                    }
                    case CHAR: {
                        HiveChar hiveChar = object instanceof HiveChar ? (HiveChar)object : ((HiveCharWritable)object).getHiveChar();
                        byte[] bytes = hiveChar.getStrippedValue().getBytes();
                        ((BytesColumnVector)columnVector).setVal(batchIndex, bytes, 0, bytes.length);
                        break block0;
                    }
                    case DECIMAL: {
                        if (object instanceof HiveDecimal) {
                            ((DecimalColumnVector)columnVector).set(batchIndex, (HiveDecimal)object);
                            break block0;
                        }
                        ((DecimalColumnVector)columnVector).set(batchIndex, (HiveDecimalWritable)object);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        if (object instanceof HiveIntervalYearMonth) {
                            ((LongColumnVector)columnVector).vector[batchIndex] = ((HiveIntervalYearMonth)object).getTotalMonths();
                            break block0;
                        }
                        ((LongColumnVector)columnVector).vector[batchIndex] = ((HiveIntervalYearMonthWritable)object).getHiveIntervalYearMonth().getTotalMonths();
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        if (object instanceof HiveIntervalDayTime) {
                            ((IntervalDayTimeColumnVector)columnVector).set(batchIndex, (HiveIntervalDayTime)object);
                            break block0;
                        }
                        ((IntervalDayTimeColumnVector)columnVector).set(batchIndex, ((HiveIntervalDayTimeWritable)object).getHiveIntervalDayTime());
                        break block0;
                    }
                }
                throw new RuntimeException("Primitive category " + targetPrimitiveCategory.name() + " not supported");
            }
            case LIST: {
                ListColumnVector listColumnVector = (ListColumnVector)columnVector;
                ListTypeInfo listTypeInfo = (ListTypeInfo)targetTypeInfo;
                TypeInfo elementTypeInfo = listTypeInfo.getListElementTypeInfo();
                List list = (List)object;
                int size = list.size();
                int childCount = listColumnVector.childCount;
                listColumnVector.offsets[batchIndex] = childCount;
                listColumnVector.lengths[batchIndex] = size;
                listColumnVector.childCount = childCount + size;
                listColumnVector.child.ensureSize(childCount + size, true);
                for (int i = 0; i < size; ++i) {
                    this.assignRowColumn(listColumnVector.child, childCount + i, elementTypeInfo, list.get(i));
                }
                break;
            }
            case MAP: {
                MapColumnVector mapColumnVector = (MapColumnVector)columnVector;
                MapTypeInfo mapTypeInfo = (MapTypeInfo)targetTypeInfo;
                Map map = (Map)object;
                int size = map.size();
                int childCount = mapColumnVector.childCount;
                mapColumnVector.offsets[batchIndex] = childCount;
                mapColumnVector.lengths[batchIndex] = size;
                mapColumnVector.keys.ensureSize(childCount + size, true);
                mapColumnVector.values.ensureSize(childCount + size, true);
                for (Map.Entry entry : map.entrySet()) {
                    this.assignRowColumn(mapColumnVector.keys, childCount, mapTypeInfo.getMapKeyTypeInfo(), entry.getKey());
                    this.assignRowColumn(mapColumnVector.values, childCount, mapTypeInfo.getMapValueTypeInfo(), entry.getValue());
                    ++childCount;
                }
                mapColumnVector.childCount = childCount;
                break;
            }
            case STRUCT: {
                StructColumnVector structColumnVector = (StructColumnVector)columnVector;
                StructTypeInfo targetStructTypeInfo = (StructTypeInfo)targetTypeInfo;
                ArrayList<TypeInfo> targetFieldTypeInfos = targetStructTypeInfo.getAllStructFieldTypeInfos();
                int size = targetFieldTypeInfos.size();
                if (object instanceof List) {
                    List struct = (List)object;
                    for (int i = 0; i < size; ++i) {
                        this.assignRowColumn(structColumnVector.fields[i], batchIndex, (TypeInfo)targetFieldTypeInfos.get(i), struct.get(i));
                    }
                } else {
                    Object[] array = (Object[])object;
                    for (int i = 0; i < size; ++i) {
                        this.assignRowColumn(structColumnVector.fields[i], batchIndex, (TypeInfo)targetFieldTypeInfos.get(i), array[i]);
                    }
                }
                break;
            }
            case UNION: {
                StandardUnionObjectInspector.StandardUnion union = (StandardUnionObjectInspector.StandardUnion)object;
                UnionColumnVector unionColumnVector = (UnionColumnVector)columnVector;
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)targetTypeInfo;
                List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                byte tag = union.getTag();
                unionColumnVector.tags[batchIndex] = tag;
                this.assignRowColumn(unionColumnVector.fields[tag], batchIndex, objectTypeInfos.get(tag), union.getObject());
                break;
            }
            default: {
                throw new RuntimeException("Category " + targetTypeInfo.getCategory().name() + " not supported");
            }
        }
        columnVector.isNull[batchIndex] = false;
    }

    public void assignConvertRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex, Object object) {
        Preconditions.checkState(this.isConvert[logicalColumnIndex]);
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        this.assignConvertRowColumn(batch.cols[projectionColumnNum], batchIndex, this.targetTypeInfos[logicalColumnIndex], this.convertSourceOI[logicalColumnIndex], this.convertTargetWritables[logicalColumnIndex], object);
    }

    private void assignConvertRowColumn(ColumnVector columnVector, int batchIndex, TypeInfo targetTypeInfo, ObjectInspector sourceObjectInspector, Writable convertTargetWritable, Object object) {
        block47: {
            ObjectInspector.Category targetCategory = targetTypeInfo.getCategory();
            if (targetCategory == null) {
                return;
            }
            if (object == null) {
                VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                return;
            }
            try {
                block1 : switch (targetCategory) {
                    case PRIMITIVE: {
                        PrimitiveObjectInspector sourcePrimitiveOI = (PrimitiveObjectInspector)sourceObjectInspector;
                        PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory = ((PrimitiveTypeInfo)targetTypeInfo).getPrimitiveCategory();
                        switch (targetPrimitiveCategory) {
                            case VOID: {
                                VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                return;
                            }
                            case BOOLEAN: {
                                ((LongColumnVector)columnVector).vector[batchIndex] = PrimitiveObjectInspectorUtils.getBoolean(object, sourcePrimitiveOI) ? 1 : 0;
                                break block1;
                            }
                            case BYTE: {
                                ((LongColumnVector)columnVector).vector[batchIndex] = PrimitiveObjectInspectorUtils.getByte(object, sourcePrimitiveOI);
                                break block1;
                            }
                            case SHORT: {
                                ((LongColumnVector)columnVector).vector[batchIndex] = PrimitiveObjectInspectorUtils.getShort(object, sourcePrimitiveOI);
                                break block1;
                            }
                            case INT: {
                                ((LongColumnVector)columnVector).vector[batchIndex] = PrimitiveObjectInspectorUtils.getInt(object, sourcePrimitiveOI);
                                break block1;
                            }
                            case LONG: {
                                ((LongColumnVector)columnVector).vector[batchIndex] = PrimitiveObjectInspectorUtils.getLong(object, sourcePrimitiveOI);
                                break block1;
                            }
                            case TIMESTAMP: {
                                Timestamp timestamp = PrimitiveObjectInspectorUtils.getTimestamp(object, sourcePrimitiveOI);
                                if (timestamp == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                ((TimestampColumnVector)columnVector).set(batchIndex, timestamp);
                                break block1;
                            }
                            case DATE: {
                                Date date = PrimitiveObjectInspectorUtils.getDate(object, sourcePrimitiveOI);
                                if (date == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                DateWritable dateWritable = (DateWritable)convertTargetWritable;
                                if (dateWritable == null) {
                                    dateWritable = new DateWritable();
                                }
                                dateWritable.set(date);
                                ((LongColumnVector)columnVector).vector[batchIndex] = dateWritable.getDays();
                                break block1;
                            }
                            case FLOAT: {
                                ((DoubleColumnVector)columnVector).vector[batchIndex] = PrimitiveObjectInspectorUtils.getFloat(object, sourcePrimitiveOI);
                                break block1;
                            }
                            case DOUBLE: {
                                ((DoubleColumnVector)columnVector).vector[batchIndex] = PrimitiveObjectInspectorUtils.getDouble(object, sourcePrimitiveOI);
                                break block1;
                            }
                            case BINARY: {
                                BytesWritable bytesWritable = PrimitiveObjectInspectorUtils.getBinary(object, sourcePrimitiveOI);
                                if (bytesWritable == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                ((BytesColumnVector)columnVector).setVal(batchIndex, bytesWritable.getBytes(), 0, bytesWritable.getLength());
                                break block1;
                            }
                            case STRING: {
                                String string = PrimitiveObjectInspectorUtils.getString(object, sourcePrimitiveOI);
                                if (string == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                Text text = (Text)convertTargetWritable;
                                if (text == null) {
                                    text = new Text();
                                }
                                text.set(string);
                                ((BytesColumnVector)columnVector).setVal(batchIndex, text.getBytes(), 0, text.getLength());
                                break block1;
                            }
                            case VARCHAR: {
                                HiveVarchar hiveVarchar = PrimitiveObjectInspectorUtils.getHiveVarchar(object, sourcePrimitiveOI);
                                if (hiveVarchar == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                byte[] bytes = hiveVarchar.getValue().getBytes();
                                ((BytesColumnVector)columnVector).setVal(batchIndex, bytes, 0, bytes.length);
                                break block1;
                            }
                            case CHAR: {
                                HiveChar hiveChar = PrimitiveObjectInspectorUtils.getHiveChar(object, sourcePrimitiveOI);
                                if (hiveChar == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                byte[] bytes = hiveChar.getStrippedValue().getBytes();
                                ((BytesColumnVector)columnVector).setVal(batchIndex, bytes, 0, bytes.length);
                                break block1;
                            }
                            case DECIMAL: {
                                HiveDecimal hiveDecimal = PrimitiveObjectInspectorUtils.getHiveDecimal(object, sourcePrimitiveOI);
                                if (hiveDecimal == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                if (columnVector instanceof Decimal64ColumnVector) {
                                    Decimal64ColumnVector dec64ColVector = (Decimal64ColumnVector)columnVector;
                                    dec64ColVector.set(batchIndex, hiveDecimal);
                                    if (dec64ColVector.isNull[batchIndex]) {
                                        return;
                                    }
                                    break block47;
                                }
                                ((DecimalColumnVector)columnVector).set(batchIndex, hiveDecimal);
                                break block1;
                            }
                            case INTERVAL_YEAR_MONTH: {
                                HiveIntervalYearMonth intervalYearMonth = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(object, sourcePrimitiveOI);
                                if (intervalYearMonth == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                ((LongColumnVector)columnVector).vector[batchIndex] = intervalYearMonth.getTotalMonths();
                                break block1;
                            }
                            case INTERVAL_DAY_TIME: {
                                HiveIntervalDayTime intervalDayTime = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime(object, sourcePrimitiveOI);
                                if (intervalDayTime == null) {
                                    VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                                    return;
                                }
                                ((IntervalDayTimeColumnVector)columnVector).set(batchIndex, intervalDayTime);
                                break block1;
                            }
                            default: {
                                throw new RuntimeException("Primitive category " + targetPrimitiveCategory.name() + " not supported");
                            }
                        }
                    }
                    case LIST: {
                        ListColumnVector listColumnVector = (ListColumnVector)columnVector;
                        ListObjectInspector sourceListOI = (ListObjectInspector)sourceObjectInspector;
                        ObjectInspector sourceElementOI = sourceListOI.getListElementObjectInspector();
                        int size = sourceListOI.getListLength(object);
                        TypeInfo targetElementTypeInfo = ((ListTypeInfo)targetTypeInfo).getListElementTypeInfo();
                        listColumnVector.offsets[batchIndex] = listColumnVector.childCount;
                        listColumnVector.childCount += size;
                        listColumnVector.ensureSize(listColumnVector.childCount, true);
                        listColumnVector.lengths[batchIndex] = size;
                        for (int i = 0; i < size; ++i) {
                            Object element = sourceListOI.getListElement(object, i);
                            int offset = (int)(listColumnVector.offsets[batchIndex] + (long)i);
                            this.assignConvertRowColumn(listColumnVector.child, offset, targetElementTypeInfo, sourceElementOI, null, element);
                        }
                        break;
                    }
                    case MAP: {
                        MapColumnVector mapColumnVector = (MapColumnVector)columnVector;
                        MapObjectInspector mapObjectInspector = (MapObjectInspector)sourceObjectInspector;
                        MapTypeInfo mapTypeInfo = (MapTypeInfo)targetTypeInfo;
                        Map<?, ?> map = mapObjectInspector.getMap(object);
                        for (Map.Entry<?, ?> entry : map.entrySet()) {
                            this.assignConvertRowColumn(mapColumnVector.keys, batchIndex, mapTypeInfo.getMapKeyTypeInfo(), mapObjectInspector.getMapKeyObjectInspector(), null, entry.getKey());
                            this.assignConvertRowColumn(mapColumnVector.values, batchIndex, mapTypeInfo.getMapValueTypeInfo(), mapObjectInspector.getMapValueObjectInspector(), null, entry.getValue());
                        }
                        break;
                    }
                    case STRUCT: {
                        StructColumnVector structColumnVector = (StructColumnVector)columnVector;
                        StructObjectInspector sourceStructOI = (StructObjectInspector)sourceObjectInspector;
                        List<? extends StructField> sourceFields = sourceStructOI.getAllStructFieldRefs();
                        StructTypeInfo targetStructTypeInfo = (StructTypeInfo)targetTypeInfo;
                        ArrayList<TypeInfo> targetTypeInfos = targetStructTypeInfo.getAllStructFieldTypeInfos();
                        int size = targetTypeInfos.size();
                        for (int i = 0; i < size; ++i) {
                            if (i < sourceFields.size()) {
                                StructField sourceStructField = sourceFields.get(i);
                                ObjectInspector sourceFieldOI = sourceStructField.getFieldObjectInspector();
                                Object sourceData = sourceStructOI.getStructFieldData(object, sourceStructField);
                                this.assignConvertRowColumn(structColumnVector.fields[i], batchIndex, (TypeInfo)targetTypeInfos.get(i), sourceFieldOI, null, sourceData);
                                continue;
                            }
                            ColumnVector fieldColumnVector = structColumnVector.fields[i];
                            VectorizedBatchUtil.setNullColIsNullValue(fieldColumnVector, batchIndex);
                        }
                        break;
                    }
                    case UNION: {
                        UnionColumnVector unionColumnVector = (UnionColumnVector)columnVector;
                        UnionObjectInspector unionObjectInspector = (UnionObjectInspector)sourceObjectInspector;
                        UnionTypeInfo unionTypeInfo = (UnionTypeInfo)targetTypeInfo;
                        byte tag = unionObjectInspector.getTag(object);
                        this.assignConvertRowColumn(unionColumnVector.fields[tag], batchIndex, unionTypeInfo.getAllUnionObjectTypeInfos().get(tag), unionObjectInspector.getObjectInspectors().get(tag), null, unionObjectInspector.getField(tag));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Category " + targetCategory.name() + " not supported");
                    }
                }
            }
            catch (NumberFormatException e) {
                VectorizedBatchUtil.setNullColIsNullValue(columnVector, batchIndex);
                return;
            }
        }
        columnVector.isNull[batchIndex] = false;
    }

    public void assignRow(VectorizedRowBatch batch, int batchIndex, Object[] objects) {
        int count = this.isConvert.length;
        for (int i = 0; i < count; ++i) {
            if (this.isConvert[i]) {
                this.assignConvertRowColumn(batch, batchIndex, i, objects[i]);
                continue;
            }
            this.assignRowColumn(batch, batchIndex, i, objects[i]);
        }
    }

    public void assignRow(VectorizedRowBatch batch, int batchIndex, List<Object> standardObjects, int columnCount) {
        for (int i = 0; i < columnCount; ++i) {
            if (this.isConvert[i]) {
                this.assignConvertRowColumn(batch, batchIndex, i, standardObjects.get(i));
                continue;
            }
            this.assignRowColumn(batch, batchIndex, i, standardObjects.get(i));
        }
    }
}

