/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorPartitionConversion;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorDeserializeRow<T extends DeserializeRead> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorDeserializeRow.class);
    private T deserializeRead;
    private TypeInfo[] sourceTypeInfos;
    protected DataTypePhysicalVariation[] dataTypePhysicalVariations;
    private byte[] inputBytes;
    private boolean useReadField;
    private int[] readFieldLogicalIndices;
    private int[] projectionColumnNums;
    private Field[] topLevelFields;
    private VectorAssignRow convertVectorAssignRow;

    public VectorDeserializeRow(T deserializeRead) {
        this();
        this.deserializeRead = deserializeRead;
        this.sourceTypeInfos = ((DeserializeRead)deserializeRead).typeInfos();
        this.dataTypePhysicalVariations = ((DeserializeRead)deserializeRead).getDataTypePhysicalVariations();
    }

    private VectorDeserializeRow() {
    }

    private void allocateArrays(int count) {
        this.projectionColumnNums = new int[count];
        Arrays.fill(this.projectionColumnNums, -1);
        this.topLevelFields = new Field[count];
    }

    private Field allocatePrimitiveField(TypeInfo sourceTypeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        int maxLength;
        PrimitiveTypeInfo sourcePrimitiveTypeInfo = (PrimitiveTypeInfo)sourceTypeInfo;
        PrimitiveObjectInspector.PrimitiveCategory sourcePrimitiveCategory = sourcePrimitiveTypeInfo.getPrimitiveCategory();
        switch (sourcePrimitiveCategory) {
            case CHAR: {
                maxLength = ((CharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                break;
            }
            case VARCHAR: {
                maxLength = ((VarcharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                break;
            }
            default: {
                maxLength = 0;
            }
        }
        return new Field(sourcePrimitiveCategory, dataTypePhysicalVariation, maxLength);
    }

    private Field allocateComplexField(TypeInfo sourceTypeInfo) {
        ObjectInspector.Category category = sourceTypeInfo.getCategory();
        switch (category) {
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)sourceTypeInfo;
                ListComplexTypeHelper listHelper = new ListComplexTypeHelper(this.allocateField(listTypeInfo.getListElementTypeInfo(), DataTypePhysicalVariation.NONE));
                return new Field(category, listHelper, sourceTypeInfo);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)sourceTypeInfo;
                MapComplexTypeHelper mapHelper = new MapComplexTypeHelper(this.allocateField(mapTypeInfo.getMapKeyTypeInfo(), DataTypePhysicalVariation.NONE), this.allocateField(mapTypeInfo.getMapValueTypeInfo(), DataTypePhysicalVariation.NONE));
                return new Field(category, mapHelper, sourceTypeInfo);
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)sourceTypeInfo;
                ArrayList<TypeInfo> fieldTypeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
                int count = fieldTypeInfoList.size();
                Field[] fields = new Field[count];
                for (int i = 0; i < count; ++i) {
                    fields[i] = this.allocateField(fieldTypeInfoList.get(i), DataTypePhysicalVariation.NONE);
                }
                StructComplexTypeHelper structHelper = new StructComplexTypeHelper(fields);
                return new Field(category, structHelper, sourceTypeInfo);
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)sourceTypeInfo;
                List<TypeInfo> fieldTypeInfoList = unionTypeInfo.getAllUnionObjectTypeInfos();
                int count = fieldTypeInfoList.size();
                Field[] fields = new Field[count];
                for (int i = 0; i < count; ++i) {
                    fields[i] = this.allocateField(fieldTypeInfoList.get(i), DataTypePhysicalVariation.NONE);
                }
                UnionComplexTypeHelper unionHelper = new UnionComplexTypeHelper(fields);
                return new Field(category, unionHelper, sourceTypeInfo);
            }
        }
        throw new RuntimeException("Category " + (Object)((Object)category) + " not supported");
    }

    private Field allocateField(TypeInfo sourceTypeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        switch (sourceTypeInfo.getCategory()) {
            case PRIMITIVE: {
                return this.allocatePrimitiveField(sourceTypeInfo, dataTypePhysicalVariation);
            }
            case LIST: 
            case MAP: 
            case STRUCT: 
            case UNION: {
                return this.allocateComplexField(sourceTypeInfo);
            }
        }
        throw new RuntimeException("Category " + (Object)((Object)sourceTypeInfo.getCategory()) + " not supported");
    }

    private void initTopLevelField(int logicalColumnIndex, int projectionColumnNum, TypeInfo sourceTypeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.topLevelFields[logicalColumnIndex] = this.allocateField(sourceTypeInfo, dataTypePhysicalVariation);
    }

    private void addTopLevelConversion(int logicalColumnIndex, TypeInfo targetTypeInfo) {
        Field field = this.topLevelFields[logicalColumnIndex];
        field.setIsConvert(true);
        if (field.getIsPrimitive()) {
            PrimitiveTypeInfo targetPrimitiveTypeInfo = (PrimitiveTypeInfo)targetTypeInfo;
            switch (targetPrimitiveTypeInfo.getPrimitiveCategory()) {
                case CHAR: {
                    field.setMaxLength(((CharTypeInfo)targetPrimitiveTypeInfo).getLength());
                    break;
                }
                case VARCHAR: {
                    field.setMaxLength(((VarcharTypeInfo)targetPrimitiveTypeInfo).getLength());
                    break;
                }
            }
            field.setConversionWritable(VectorizedBatchUtil.getPrimitiveWritable(field.getPrimitiveCategory()));
        }
    }

    public void init(int[] outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns[i];
            this.initTopLevelField(i, outputColumn, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
        }
    }

    public void init(List<Integer> outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns.get(i);
            this.initTopLevelField(i, outputColumn, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
        }
    }

    public void init(int startColumn) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = startColumn + i;
            this.initTopLevelField(i, outputColumn, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
        }
    }

    public void init(boolean[] columnsToIncludeTruncated) throws HiveException {
        Preconditions.checkState(columnsToIncludeTruncated == null || columnsToIncludeTruncated.length == this.sourceTypeInfos.length);
        int columnCount = this.sourceTypeInfos.length;
        this.allocateArrays(columnCount);
        int includedCount = 0;
        int[] includedIndices = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            this.initTopLevelField(i, i, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
            includedIndices[includedCount++] = i;
        }
        if (includedCount < columnCount && ((DeserializeRead)this.deserializeRead).isReadFieldSupported()) {
            this.useReadField = true;
            this.readFieldLogicalIndices = Arrays.copyOf(includedIndices, includedCount);
        }
    }

    public void initConversion(TypeInfo[] targetTypeInfos, boolean[] columnsToIncludeTruncated) throws HiveException {
        Preconditions.checkState(targetTypeInfos.length >= this.sourceTypeInfos.length);
        Preconditions.checkState(columnsToIncludeTruncated == null || columnsToIncludeTruncated.length >= this.sourceTypeInfos.length);
        int columnCount = this.sourceTypeInfos.length;
        this.allocateArrays(columnCount);
        int includedCount = 0;
        int[] includedIndices = new int[columnCount];
        boolean atLeastOneConvert = false;
        for (int i = 0; i < columnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            TypeInfo sourceTypeInfo = this.sourceTypeInfos[i];
            TypeInfo targetTypeInfo = targetTypeInfos[i];
            if (!sourceTypeInfo.equals(targetTypeInfo)) {
                if (VectorPartitionConversion.isImplicitVectorColumnConversion(sourceTypeInfo, targetTypeInfo)) {
                    this.initTopLevelField(i, i, sourceTypeInfo, this.dataTypePhysicalVariations[i]);
                } else {
                    this.initTopLevelField(i, i, sourceTypeInfo, this.dataTypePhysicalVariations[i]);
                    this.addTopLevelConversion(i, targetTypeInfo);
                    atLeastOneConvert = true;
                }
            } else {
                this.initTopLevelField(i, i, sourceTypeInfo, this.dataTypePhysicalVariations[i]);
            }
            includedIndices[includedCount++] = i;
        }
        if (includedCount < columnCount && ((DeserializeRead)this.deserializeRead).isReadFieldSupported()) {
            this.useReadField = true;
            this.readFieldLogicalIndices = Arrays.copyOf(includedIndices, includedCount);
        }
        if (atLeastOneConvert) {
            this.convertVectorAssignRow = new VectorAssignRow();
            this.convertVectorAssignRow.initConversion(this.sourceTypeInfos, targetTypeInfos, columnsToIncludeTruncated);
        }
    }

    public void init() throws HiveException {
        this.init(0);
    }

    private void storePrimitiveRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
        switch (field.getPrimitiveCategory()) {
            case VOID: {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
                return;
            }
            case BOOLEAN: {
                ((LongColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentBoolean ? 1 : 0;
                break;
            }
            case BYTE: {
                ((LongColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentByte;
                break;
            }
            case SHORT: {
                ((LongColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentShort;
                break;
            }
            case INT: {
                ((LongColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentInt;
                break;
            }
            case LONG: {
                ((LongColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentLong;
                break;
            }
            case TIMESTAMP: {
                ((TimestampColumnVector)colVector).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentTimestampWritable.getTimestamp());
                break;
            }
            case DATE: {
                ((LongColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentDateWritable.getDays();
                break;
            }
            case FLOAT: {
                ((DoubleColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentFloat;
                break;
            }
            case DOUBLE: {
                ((DoubleColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentDouble;
                break;
            }
            case BINARY: 
            case STRING: {
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                if (((DeserializeRead)this.deserializeRead).currentExternalBufferNeeded) {
                    bytesColVec.ensureValPreallocated(((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                    ((DeserializeRead)this.deserializeRead).copyToExternalBuffer(bytesColVec.getValPreallocatedBytes(), bytesColVec.getValPreallocatedStart());
                    bytesColVec.setValPreallocated(batchIndex, ((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                    break;
                }
                if (canRetainByteRef && this.inputBytes == ((DeserializeRead)this.deserializeRead).currentBytes) {
                    bytesColVec.setRef(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                    break;
                }
                bytesColVec.setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                break;
            }
            case VARCHAR: {
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                if (((DeserializeRead)this.deserializeRead).currentExternalBufferNeeded) {
                    bytesColVec.ensureValPreallocated(((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                    byte[] convertBuffer = bytesColVec.getValPreallocatedBytes();
                    int convertBufferStart = bytesColVec.getValPreallocatedStart();
                    ((DeserializeRead)this.deserializeRead).copyToExternalBuffer(convertBuffer, convertBufferStart);
                    bytesColVec.setValPreallocated(batchIndex, StringExpr.truncate(convertBuffer, convertBufferStart, ((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen, field.getMaxLength()));
                    break;
                }
                if (canRetainByteRef && this.inputBytes == ((DeserializeRead)this.deserializeRead).currentBytes) {
                    bytesColVec.setRef(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.truncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, field.getMaxLength()));
                    break;
                }
                bytesColVec.setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.truncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, field.getMaxLength()));
                break;
            }
            case CHAR: {
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                if (((DeserializeRead)this.deserializeRead).currentExternalBufferNeeded) {
                    bytesColVec.ensureValPreallocated(((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                    byte[] convertBuffer = bytesColVec.getValPreallocatedBytes();
                    int convertBufferStart = bytesColVec.getValPreallocatedStart();
                    ((DeserializeRead)this.deserializeRead).copyToExternalBuffer(convertBuffer, convertBufferStart);
                    bytesColVec.setValPreallocated(batchIndex, StringExpr.rightTrimAndTruncate(convertBuffer, convertBufferStart, ((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen, field.getMaxLength()));
                    break;
                }
                if (canRetainByteRef && this.inputBytes == ((DeserializeRead)this.deserializeRead).currentBytes) {
                    bytesColVec.setRef(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.rightTrimAndTruncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, field.getMaxLength()));
                    break;
                }
                bytesColVec.setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.rightTrimAndTruncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, field.getMaxLength()));
                break;
            }
            case DECIMAL: {
                if (field.getDataTypePhysicalVariation() == DataTypePhysicalVariation.DECIMAL_64) {
                    ((Decimal64ColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentDecimal64;
                    break;
                }
                ((DecimalColumnVector)colVector).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentHiveDecimalWritable);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                ((LongColumnVector)colVector).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentHiveIntervalYearMonthWritable.getHiveIntervalYearMonth().getTotalMonths();
                break;
            }
            case INTERVAL_DAY_TIME: {
                ((IntervalDayTimeColumnVector)colVector).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentHiveIntervalDayTimeWritable.getHiveIntervalDayTime());
                break;
            }
            default: {
                throw new RuntimeException("Primitive category " + (Object)((Object)field.getPrimitiveCategory()) + " not supported");
            }
        }
    }

    private void storeComplexFieldRowColumn(ColumnVector fieldColVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
        if (!((DeserializeRead)this.deserializeRead).readComplexField()) {
            VectorizedBatchUtil.setNullColIsNullValue(fieldColVector, batchIndex);
            return;
        }
        if (field.getIsPrimitive()) {
            this.storePrimitiveRowColumn(fieldColVector, field, batchIndex, canRetainByteRef);
        } else {
            switch (field.getCategory()) {
                case LIST: {
                    this.storeListRowColumn(fieldColVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                case MAP: {
                    this.storeMapRowColumn(fieldColVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                case STRUCT: {
                    this.storeStructRowColumn(fieldColVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                case UNION: {
                    this.storeUnionRowColumn(fieldColVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                default: {
                    throw new RuntimeException("Category " + (Object)((Object)field.getCategory()) + " not supported");
                }
            }
        }
        fieldColVector.isNull[batchIndex] = false;
    }

    private void storeListRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
        ListColumnVector listColVector = (ListColumnVector)colVector;
        ColumnVector elementColVector = listColVector.child;
        int offset = listColVector.childCount;
        listColVector.isNull[batchIndex] = false;
        listColVector.offsets[batchIndex] = offset;
        ListComplexTypeHelper listHelper = (ListComplexTypeHelper)field.getComplexHelper();
        int listLength = 0;
        while (((DeserializeRead)this.deserializeRead).isNextComplexMultiValue()) {
            int childCapacity = listColVector.child.isNull.length;
            int childCount = listColVector.childCount;
            if ((double)childCapacity < (double)childCount / 0.75) {
                listColVector.child.ensureSize(childCapacity * 2, true);
            }
            this.storeComplexFieldRowColumn(elementColVector, listHelper.getElementField(), offset, canRetainByteRef);
            ++offset;
            ++listLength;
        }
        listColVector.childCount += listLength;
        listColVector.lengths[batchIndex] = listLength;
    }

    private void storeMapRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
        MapColumnVector mapColVector = (MapColumnVector)colVector;
        MapComplexTypeHelper mapHelper = (MapComplexTypeHelper)field.getComplexHelper();
        ColumnVector keysColVector = mapColVector.keys;
        ColumnVector valuesColVector = mapColVector.values;
        int offset = mapColVector.childCount;
        mapColVector.offsets[batchIndex] = offset;
        mapColVector.isNull[batchIndex] = false;
        int keyValueCount = 0;
        while (((DeserializeRead)this.deserializeRead).isNextComplexMultiValue()) {
            int childCapacity = mapColVector.keys.isNull.length;
            int childCount = mapColVector.childCount;
            if ((double)childCapacity < (double)childCount / 0.75) {
                mapColVector.keys.ensureSize(childCapacity * 2, true);
                mapColVector.values.ensureSize(childCapacity * 2, true);
            }
            this.storeComplexFieldRowColumn(keysColVector, mapHelper.getKeyField(), offset, canRetainByteRef);
            this.storeComplexFieldRowColumn(valuesColVector, mapHelper.getValueField(), offset, canRetainByteRef);
            ++offset;
            ++keyValueCount;
        }
        mapColVector.childCount += keyValueCount;
        mapColVector.lengths[batchIndex] = keyValueCount;
    }

    private void storeStructRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
        StructColumnVector structColVector = (StructColumnVector)colVector;
        ColumnVector[] colVectorFields = structColVector.fields;
        StructComplexTypeHelper structHelper = (StructComplexTypeHelper)field.getComplexHelper();
        Field[] fields = structHelper.getFields();
        structColVector.isNull[batchIndex] = false;
        int i = 0;
        for (ColumnVector colVectorField : colVectorFields) {
            this.storeComplexFieldRowColumn(colVectorField, fields[i], batchIndex, canRetainByteRef);
            ++i;
        }
        ((DeserializeRead)this.deserializeRead).finishComplexVariableFieldsType();
    }

    private void storeUnionRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
        ((DeserializeRead)this.deserializeRead).readComplexField();
        int tag = ((DeserializeRead)this.deserializeRead).currentInt;
        UnionColumnVector unionColVector = (UnionColumnVector)colVector;
        ColumnVector[] colVectorFields = unionColVector.fields;
        UnionComplexTypeHelper unionHelper = (UnionComplexTypeHelper)field.getComplexHelper();
        unionColVector.isNull[batchIndex] = false;
        unionColVector.tags[batchIndex] = tag;
        this.storeComplexFieldRowColumn(colVectorFields[tag], unionHelper.getFields()[tag], batchIndex, canRetainByteRef);
        ((DeserializeRead)this.deserializeRead).finishComplexVariableFieldsType();
    }

    private void storeRowColumn(VectorizedRowBatch batch, int batchIndex, Field field, int logicalColumnIndex, boolean canRetainByteRef) throws IOException {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[projectionColumnNum];
        if (field.getIsPrimitive()) {
            this.storePrimitiveRowColumn(colVector, field, batchIndex, canRetainByteRef);
        } else {
            switch (field.getCategory()) {
                case LIST: {
                    this.storeListRowColumn(colVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                case MAP: {
                    this.storeMapRowColumn(colVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                case STRUCT: {
                    this.storeStructRowColumn(colVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                case UNION: {
                    this.storeUnionRowColumn(colVector, field, batchIndex, canRetainByteRef);
                    break;
                }
                default: {
                    throw new RuntimeException("Category " + (Object)((Object)field.getCategory()) + " not supported");
                }
            }
        }
        colVector.isNull[batchIndex] = false;
    }

    private void convertRowColumn(VectorizedRowBatch batch, int batchIndex, Field field, int logicalColumnIndex) throws IOException {
        Object convertSourceWritable;
        int projectionColumnIndex = this.projectionColumnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[projectionColumnIndex];
        if (field.getIsPrimitive()) {
            convertSourceWritable = this.convertPrimitiveRowColumn(batchIndex, field);
        } else {
            switch (field.getCategory()) {
                case LIST: {
                    convertSourceWritable = this.convertListRowColumn(colVector, batchIndex, field);
                    break;
                }
                case MAP: {
                    convertSourceWritable = this.convertMapRowColumn(colVector, batchIndex, field);
                    break;
                }
                case STRUCT: {
                    convertSourceWritable = this.convertStructRowColumn(colVector, batchIndex, field);
                    break;
                }
                case UNION: {
                    convertSourceWritable = this.convertUnionRowColumn(colVector, batchIndex, field);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.convertVectorAssignRow.assignConvertRowColumn(batch, batchIndex, logicalColumnIndex, convertSourceWritable);
    }

    private Object convertComplexFieldRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
        if (!((DeserializeRead)this.deserializeRead).readComplexField()) {
            VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            return null;
        }
        colVector.isNull[batchIndex] = false;
        if (field.getIsPrimitive()) {
            return this.convertPrimitiveRowColumn(batchIndex, field);
        }
        switch (field.getCategory()) {
            case LIST: {
                return this.convertListRowColumn(colVector, batchIndex, field);
            }
            case MAP: {
                return this.convertMapRowColumn(colVector, batchIndex, field);
            }
            case STRUCT: {
                return this.convertStructRowColumn(colVector, batchIndex, field);
            }
            case UNION: {
                return this.convertUnionRowColumn(colVector, batchIndex, field);
            }
        }
        throw new RuntimeException();
    }

    private Object convertPrimitiveRowColumn(int batchIndex, Field field) throws IOException {
        Object writable = field.getConversionWritable();
        switch (field.getPrimitiveCategory()) {
            case VOID: {
                writable = null;
                break;
            }
            case BOOLEAN: {
                if (writable == null) {
                    writable = new BooleanWritable();
                }
                ((BooleanWritable)writable).set(((DeserializeRead)this.deserializeRead).currentBoolean);
                break;
            }
            case BYTE: {
                if (writable == null) {
                    writable = new ByteWritable();
                }
                ((ByteWritable)((Object)writable)).set(((DeserializeRead)this.deserializeRead).currentByte);
                break;
            }
            case SHORT: {
                if (writable == null) {
                    writable = new ShortWritable();
                }
                ((ShortWritable)writable).set(((DeserializeRead)this.deserializeRead).currentShort);
                break;
            }
            case INT: {
                if (writable == null) {
                    writable = new IntWritable();
                }
                ((IntWritable)writable).set(((DeserializeRead)this.deserializeRead).currentInt);
                break;
            }
            case LONG: {
                if (writable == null) {
                    writable = new LongWritable();
                }
                ((LongWritable)writable).set(((DeserializeRead)this.deserializeRead).currentLong);
                break;
            }
            case TIMESTAMP: {
                if (writable == null) {
                    writable = new TimestampWritable();
                }
                ((TimestampWritable)writable).set(((DeserializeRead)this.deserializeRead).currentTimestampWritable);
                break;
            }
            case DATE: {
                if (writable == null) {
                    writable = new DateWritable();
                }
                ((DateWritable)writable).set(((DeserializeRead)this.deserializeRead).currentDateWritable);
                break;
            }
            case FLOAT: {
                if (writable == null) {
                    writable = new FloatWritable();
                }
                ((FloatWritable)writable).set(((DeserializeRead)this.deserializeRead).currentFloat);
                break;
            }
            case DOUBLE: {
                if (writable == null) {
                    writable = new DoubleWritable();
                }
                ((DoubleWritable)((Object)writable)).set(((DeserializeRead)this.deserializeRead).currentDouble);
                break;
            }
            case BINARY: {
                if (writable == null) {
                    writable = new BytesWritable();
                }
                if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                    LOG.info("null binary entry: batchIndex " + batchIndex);
                }
                ((BytesWritable)writable).set(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                break;
            }
            case STRING: {
                if (writable == null) {
                    writable = new Text();
                }
                if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                    throw new RuntimeException("null string entry: batchIndex " + batchIndex);
                }
                ((Text)writable).set(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                break;
            }
            case VARCHAR: {
                if (writable == null) {
                    writable = new HiveVarcharWritable();
                }
                if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                    throw new RuntimeException("null varchar entry: batchIndex " + batchIndex);
                }
                int adjustedLength = StringExpr.truncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, field.getMaxLength());
                ((HiveVarcharWritable)writable).set(new String(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
                break;
            }
            case CHAR: {
                if (writable == null) {
                    writable = new HiveCharWritable();
                }
                if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                    throw new RuntimeException("null char entry: batchIndex " + batchIndex);
                }
                int adjustedLength = StringExpr.rightTrimAndTruncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, field.getMaxLength());
                ((HiveCharWritable)writable).set(new String(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
                break;
            }
            case DECIMAL: {
                if (writable == null) {
                    writable = new HiveDecimalWritable();
                }
                ((HiveDecimalWritable)writable).set(((DeserializeRead)this.deserializeRead).currentHiveDecimalWritable);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                if (writable == null) {
                    writable = new HiveIntervalYearMonthWritable();
                }
                ((HiveIntervalYearMonthWritable)writable).set(((DeserializeRead)this.deserializeRead).currentHiveIntervalYearMonthWritable);
                break;
            }
            case INTERVAL_DAY_TIME: {
                if (writable == null) {
                    writable = new HiveIntervalDayTimeWritable();
                }
                ((HiveIntervalDayTimeWritable)writable).set(((DeserializeRead)this.deserializeRead).currentHiveIntervalDayTimeWritable);
                break;
            }
            default: {
                throw new RuntimeException("Primitive category " + (Object)((Object)field.getPrimitiveCategory()) + " not supported");
            }
        }
        return writable;
    }

    private Object convertListRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
        SettableListObjectInspector listOI = (SettableListObjectInspector)field.objectInspector;
        ListComplexTypeHelper listHelper = (ListComplexTypeHelper)field.getComplexHelper();
        Field elementField = listHelper.getElementField();
        ArrayList<Object> tempList = new ArrayList<Object>();
        ListColumnVector listColumnVector = (ListColumnVector)colVector;
        while (((DeserializeRead)this.deserializeRead).isNextComplexMultiValue()) {
            tempList.add(this.convertComplexFieldRowColumn(listColumnVector.child, batchIndex, elementField));
        }
        int size = tempList.size();
        Object list = listOI.create(size);
        for (int i = 0; i < size; ++i) {
            listOI.set(list, i, tempList.get(i));
        }
        return list;
    }

    private Object convertMapRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
        SettableMapObjectInspector mapOI = (SettableMapObjectInspector)field.objectInspector;
        MapComplexTypeHelper mapHelper = (MapComplexTypeHelper)field.getComplexHelper();
        Field keyField = mapHelper.getKeyField();
        Field valueField = mapHelper.getValueField();
        MapColumnVector mapColumnVector = (MapColumnVector)colVector;
        Object map = mapOI.create();
        while (((DeserializeRead)this.deserializeRead).isNextComplexMultiValue()) {
            Object key = this.convertComplexFieldRowColumn(mapColumnVector.keys, batchIndex, keyField);
            Object value = this.convertComplexFieldRowColumn(mapColumnVector.values, batchIndex, valueField);
            mapOI.put(map, key, value);
        }
        return map;
    }

    private Object convertStructRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
        SettableStructObjectInspector structOI = (SettableStructObjectInspector)field.objectInspector;
        List<? extends StructField> structFields = structOI.getAllStructFieldRefs();
        StructComplexTypeHelper structHelper = (StructComplexTypeHelper)field.getComplexHelper();
        Field[] fields = structHelper.getFields();
        StructColumnVector structColumnVector = (StructColumnVector)colVector;
        Object struct = structOI.create();
        for (int i = 0; i < fields.length; ++i) {
            Object fieldObject = this.convertComplexFieldRowColumn(structColumnVector.fields[i], batchIndex, fields[i]);
            structOI.setStructFieldData(struct, structFields.get(i), fieldObject);
        }
        ((DeserializeRead)this.deserializeRead).finishComplexVariableFieldsType();
        return struct;
    }

    private Object convertUnionRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
        SettableUnionObjectInspector unionOI = (SettableUnionObjectInspector)field.objectInspector;
        UnionComplexTypeHelper unionHelper = (UnionComplexTypeHelper)field.getComplexHelper();
        Field[] fields = unionHelper.getFields();
        UnionColumnVector unionColumnVector = (UnionColumnVector)colVector;
        Object union = unionOI.create();
        int tag = ((DeserializeRead)this.deserializeRead).currentInt;
        unionOI.setFieldAndTag(union, new StandardUnionObjectInspector.StandardUnion((byte)tag, this.convertComplexFieldRowColumn(unionColumnVector.fields[tag], batchIndex, fields[tag])), (byte)tag);
        ((DeserializeRead)this.deserializeRead).finishComplexVariableFieldsType();
        return union;
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.inputBytes = bytes;
        ((DeserializeRead)this.deserializeRead).set(bytes, offset, length);
    }

    public void deserialize(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int count = this.topLevelFields.length;
        if (!this.useReadField) {
            for (int i = 0; i < count; ++i) {
                int projectionColumnNum = this.projectionColumnNums[i];
                if (projectionColumnNum == -1) {
                    ((DeserializeRead)this.deserializeRead).skipNextField();
                    continue;
                }
                if (!((DeserializeRead)this.deserializeRead).readNextField()) {
                    ColumnVector colVector = batch.cols[projectionColumnNum];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[i];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, i);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, i, false);
            }
        } else {
            for (int logicalIndex : this.readFieldLogicalIndices) {
                if (!((DeserializeRead)this.deserializeRead).readField(logicalIndex)) {
                    ColumnVector colVector = batch.cols[this.projectionColumnNums[logicalIndex]];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[logicalIndex];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, logicalIndex);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, logicalIndex, false);
            }
        }
    }

    public void deserializeByRef(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int count = this.topLevelFields.length;
        if (!this.useReadField) {
            for (int i = 0; i < count; ++i) {
                int projectionColumnNum = this.projectionColumnNums[i];
                if (projectionColumnNum == -1) {
                    ((DeserializeRead)this.deserializeRead).skipNextField();
                    continue;
                }
                if (!((DeserializeRead)this.deserializeRead).readNextField()) {
                    ColumnVector colVector = batch.cols[projectionColumnNum];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[i];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, i);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, i, true);
            }
        } else {
            for (int logicalIndex : this.readFieldLogicalIndices) {
                if (!((DeserializeRead)this.deserializeRead).readField(logicalIndex)) {
                    ColumnVector colVector = batch.cols[this.projectionColumnNums[logicalIndex]];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[logicalIndex];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, logicalIndex);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, logicalIndex, true);
            }
        }
    }

    public String getDetailedReadPositionString() {
        return ((DeserializeRead)this.deserializeRead).getDetailedReadPositionString();
    }

    private static class UnionComplexTypeHelper
    extends FieldsComplexTypeHelper {
        public UnionComplexTypeHelper(Field[] fields) {
            super(fields);
        }
    }

    private static class StructComplexTypeHelper
    extends FieldsComplexTypeHelper {
        public StructComplexTypeHelper(Field[] fields) {
            super(fields);
        }
    }

    private static class FieldsComplexTypeHelper
    extends ComplexTypeHelper {
        private Field[] fields;

        public FieldsComplexTypeHelper(Field[] fields) {
            this.fields = fields;
        }

        public Field[] getFields() {
            return this.fields;
        }
    }

    private static class MapComplexTypeHelper
    extends ComplexTypeHelper {
        private Field keyField;
        private Field valueField;

        public MapComplexTypeHelper(Field keyField, Field valueField) {
            this.keyField = keyField;
            this.valueField = valueField;
        }

        public Field getKeyField() {
            return this.keyField;
        }

        public Field getValueField() {
            return this.valueField;
        }
    }

    private static class ListComplexTypeHelper
    extends ComplexTypeHelper {
        private Field elementField;

        public ListComplexTypeHelper(Field elementField) {
            this.elementField = elementField;
        }

        public Field getElementField() {
            return this.elementField;
        }
    }

    private static class ComplexTypeHelper {
        private ComplexTypeHelper() {
        }
    }

    private static class Field {
        private boolean isPrimitive;
        private ObjectInspector.Category category;
        private PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        private DataTypePhysicalVariation dataTypePhysicalVariation;
        private int maxLength;
        private boolean isConvert;
        private Object conversionWritable;
        private ComplexTypeHelper complexTypeHelper;
        private ObjectInspector objectInspector;

        public Field(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, DataTypePhysicalVariation dataTypePhysicalVariation, int maxLength) {
            this.isPrimitive = true;
            this.category = ObjectInspector.Category.PRIMITIVE;
            this.primitiveCategory = primitiveCategory;
            this.dataTypePhysicalVariation = dataTypePhysicalVariation;
            this.maxLength = maxLength;
            this.isConvert = false;
            this.conversionWritable = null;
            this.complexTypeHelper = null;
            this.objectInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(primitiveCategory);
        }

        public Field(ObjectInspector.Category category, ComplexTypeHelper complexTypeHelper, TypeInfo typeInfo) {
            this.isPrimitive = false;
            this.category = category;
            this.objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo);
            this.primitiveCategory = null;
            this.dataTypePhysicalVariation = null;
            this.maxLength = 0;
            this.isConvert = false;
            this.conversionWritable = null;
            this.complexTypeHelper = complexTypeHelper;
        }

        public boolean getIsPrimitive() {
            return this.isPrimitive;
        }

        public ObjectInspector.Category getCategory() {
            return this.category;
        }

        public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
            return this.primitiveCategory;
        }

        public DataTypePhysicalVariation getDataTypePhysicalVariation() {
            return this.dataTypePhysicalVariation;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setIsConvert(boolean isConvert) {
            this.isConvert = isConvert;
        }

        public boolean getIsConvert() {
            return this.isConvert;
        }

        public void setConversionWritable(Object conversionWritable) {
            this.conversionWritable = conversionWritable;
        }

        public Object getConversionWritable() {
            return this.conversionWritable;
        }

        public ComplexTypeHelper getComplexHelper() {
            return this.complexTypeHelper;
        }

        public ObjectInspector getObjectInspector() {
            return this.objectInspector;
        }
    }
}

