/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorExtractRow {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorExtractRow.class);
    int[] projectionColumnNums;
    TypeInfo[] typeInfos;
    ObjectInspector[] objectInspectors;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String EMPTY_STRING = "";

    private void allocateArrays(int count) {
        this.projectionColumnNums = new int[count];
        this.typeInfos = new TypeInfo[count];
        this.objectInspectors = new ObjectInspector[count];
    }

    private void initEntry(int logicalColumnIndex, int projectionColumnNum, TypeInfo typeInfo) {
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.typeInfos[logicalColumnIndex] = typeInfo;
        this.objectInspectors[logicalColumnIndex] = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(typeInfo);
    }

    public void init(StructObjectInspector structObjectInspector, List<Integer> projectedColumns) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        int count = fields.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int projectionColumnNum = projectedColumns.get(i);
            StructField field = fields.get(i);
            ObjectInspector fieldInspector = field.getFieldObjectInspector();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            this.initEntry(i, projectionColumnNum, typeInfo);
        }
    }

    public void init(TypeInfo[] typeInfos, int[] projectedColumns) throws HiveException {
        int count = typeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            this.initEntry(i, projectedColumns[i], typeInfos[i]);
        }
    }

    @VisibleForTesting
    void init(List<String> typeNames) throws HiveException {
        int count = typeNames.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            this.initEntry(i, i, TypeInfoUtils.getTypeInfoFromTypeString(typeNames.get(i)));
        }
    }

    public void init(TypeInfo[] typeInfos) throws HiveException {
        int count = typeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            this.initEntry(i, i, typeInfos[i]);
        }
    }

    public int getCount() {
        return this.projectionColumnNums.length;
    }

    private Object extractRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex) {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[projectionColumnNum];
        return this.extractRowColumn(colVector, this.typeInfos[logicalColumnIndex], this.objectInspectors[logicalColumnIndex], batchIndex);
    }

    public Object extractRowColumn(ColumnVector colVector, TypeInfo typeInfo, ObjectInspector objectInspector, int batchIndex) {
        int adjustedIndex;
        if (colVector == null) {
            return null;
        }
        int n = adjustedIndex = colVector.isRepeating ? 0 : batchIndex;
        if (!colVector.noNulls && colVector.isNull[adjustedIndex]) {
            return null;
        }
        ObjectInspector.Category category = typeInfo.getCategory();
        switch (category) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
                Writable primitiveWritable = VectorizedBatchUtil.getPrimitiveWritable(primitiveCategory);
                switch (primitiveCategory) {
                    case VOID: {
                        return null;
                    }
                    case BOOLEAN: {
                        ((BooleanWritable)primitiveWritable).set(((LongColumnVector)colVector).vector[adjustedIndex] != 0L);
                        return primitiveWritable;
                    }
                    case BYTE: {
                        ((ByteWritable)primitiveWritable).set((byte)((LongColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case SHORT: {
                        ((ShortWritable)primitiveWritable).set((short)((LongColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case INT: {
                        ((IntWritable)primitiveWritable).set((int)((LongColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case LONG: {
                        ((LongWritable)primitiveWritable).set(((LongColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case TIMESTAMP: {
                        ((TimestampWritable)primitiveWritable).set(((TimestampColumnVector)colVector).asScratchTimestamp(adjustedIndex));
                        return primitiveWritable;
                    }
                    case DATE: {
                        ((DateWritable)primitiveWritable).set((int)((LongColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case FLOAT: {
                        ((FloatWritable)primitiveWritable).set((float)((DoubleColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case DOUBLE: {
                        ((DoubleWritable)primitiveWritable).set(((DoubleColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case BINARY: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        BytesWritable bytesWritable = (BytesWritable)primitiveWritable;
                        if (bytes == null || length == 0) {
                            if (length > 0) {
                                this.nullBytesReadError(primitiveCategory, batchIndex);
                            }
                            bytesWritable.set(EMPTY_BYTES, 0, 0);
                        } else {
                            bytesWritable.set(bytes, start, length);
                        }
                        return primitiveWritable;
                    }
                    case STRING: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        if (bytes == null || length == 0) {
                            if (length > 0) {
                                this.nullBytesReadError(primitiveCategory, batchIndex);
                            }
                            ((Text)primitiveWritable).set(EMPTY_BYTES, 0, 0);
                        } else {
                            ((Text)primitiveWritable).set(bytes, start, length);
                        }
                        return primitiveWritable;
                    }
                    case VARCHAR: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        HiveVarcharWritable hiveVarcharWritable = (HiveVarcharWritable)primitiveWritable;
                        if (bytes == null || length == 0) {
                            if (length > 0) {
                                this.nullBytesReadError(primitiveCategory, batchIndex);
                            }
                            hiveVarcharWritable.set(EMPTY_STRING, -1);
                        } else {
                            int adjustedLength = StringExpr.truncate(bytes, start, length, ((VarcharTypeInfo)primitiveTypeInfo).getLength());
                            if (adjustedLength == 0) {
                                hiveVarcharWritable.set(EMPTY_STRING, -1);
                            } else {
                                hiveVarcharWritable.set(new String(bytes, start, adjustedLength, Charsets.UTF_8), -1);
                            }
                        }
                        return primitiveWritable;
                    }
                    case CHAR: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        HiveCharWritable hiveCharWritable = (HiveCharWritable)primitiveWritable;
                        int maxLength = ((CharTypeInfo)primitiveTypeInfo).getLength();
                        if (bytes == null || length == 0) {
                            if (length > 0) {
                                this.nullBytesReadError(primitiveCategory, batchIndex);
                            }
                            hiveCharWritable.set(EMPTY_STRING, maxLength);
                        } else {
                            int adjustedLength = StringExpr.rightTrimAndTruncate(bytes, start, length, ((CharTypeInfo)primitiveTypeInfo).getLength());
                            if (adjustedLength == 0) {
                                hiveCharWritable.set(EMPTY_STRING, maxLength);
                            } else {
                                hiveCharWritable.set(new String(bytes, start, adjustedLength, Charsets.UTF_8), maxLength);
                            }
                        }
                        return primitiveWritable;
                    }
                    case DECIMAL: {
                        if (colVector instanceof Decimal64ColumnVector) {
                            Decimal64ColumnVector dec32ColVector = (Decimal64ColumnVector)colVector;
                            ((HiveDecimalWritable)primitiveWritable).deserialize64(dec32ColVector.vector[adjustedIndex], dec32ColVector.scale);
                        } else {
                            ((HiveDecimalWritable)primitiveWritable).set(((DecimalColumnVector)colVector).vector[adjustedIndex]);
                        }
                        return primitiveWritable;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ((HiveIntervalYearMonthWritable)primitiveWritable).set((int)((LongColumnVector)colVector).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case INTERVAL_DAY_TIME: {
                        ((HiveIntervalDayTimeWritable)primitiveWritable).set(((IntervalDayTimeColumnVector)colVector).asScratchIntervalDayTime(adjustedIndex));
                        return primitiveWritable;
                    }
                }
                throw new RuntimeException("Primitive category " + primitiveCategory.name() + " not supported");
            }
            case LIST: {
                ListColumnVector listColumnVector = (ListColumnVector)colVector;
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                ListObjectInspector listObjectInspector = (ListObjectInspector)objectInspector;
                int offset = (int)listColumnVector.offsets[adjustedIndex];
                int size = (int)listColumnVector.lengths[adjustedIndex];
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < size; ++i) {
                    list.add(this.extractRowColumn(listColumnVector.child, listTypeInfo.getListElementTypeInfo(), listObjectInspector.getListElementObjectInspector(), offset + i));
                }
                return list;
            }
            case MAP: {
                MapColumnVector mapColumnVector = (MapColumnVector)colVector;
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                MapObjectInspector mapObjectInspector = (MapObjectInspector)objectInspector;
                int offset = (int)mapColumnVector.offsets[adjustedIndex];
                int size = (int)mapColumnVector.lengths[adjustedIndex];
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                for (int i = 0; i < size; ++i) {
                    Object key = this.extractRowColumn(mapColumnVector.keys, mapTypeInfo.getMapKeyTypeInfo(), mapObjectInspector.getMapKeyObjectInspector(), offset + i);
                    Object value = this.extractRowColumn(mapColumnVector.values, mapTypeInfo.getMapValueTypeInfo(), mapObjectInspector.getMapValueObjectInspector(), offset + i);
                    map.put(key, value);
                }
                return map;
            }
            case STRUCT: {
                StructColumnVector structColumnVector = (StructColumnVector)colVector;
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                StandardStructObjectInspector structInspector = (StandardStructObjectInspector)objectInspector;
                ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                int size = fieldTypeInfos.size();
                List<? extends StructField> structFields = structInspector.getAllStructFieldRefs();
                Object struct = structInspector.create();
                for (int i = 0; i < size; ++i) {
                    StructField structField = structFields.get(i);
                    TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(i);
                    Object value = this.extractRowColumn(structColumnVector.fields[i], fieldTypeInfo, structField.getFieldObjectInspector(), adjustedIndex);
                    structInspector.setStructFieldData(struct, structField, value);
                }
                return struct;
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                UnionObjectInspector unionInspector = (UnionObjectInspector)objectInspector;
                List<ObjectInspector> unionInspectors = unionInspector.getObjectInspectors();
                UnionColumnVector unionColumnVector = (UnionColumnVector)colVector;
                byte tag = (byte)unionColumnVector.tags[adjustedIndex];
                Object object = this.extractRowColumn(unionColumnVector.fields[tag], objectTypeInfos.get(tag), unionInspectors.get(tag), adjustedIndex);
                StandardUnionObjectInspector.StandardUnion standardUnion = new StandardUnionObjectInspector.StandardUnion();
                standardUnion.setTag(tag);
                standardUnion.setObject(object);
                return standardUnion;
            }
        }
        throw new RuntimeException("Category " + category.name() + " not supported");
    }

    public void extractRow(VectorizedRowBatch batch, int batchIndex, Object[] objects) {
        for (int i = 0; i < this.projectionColumnNums.length; ++i) {
            objects[i] = this.extractRowColumn(batch, batchIndex, i);
        }
    }

    private void nullBytesReadError(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, int batchIndex) {
        throw new RuntimeException("null " + primitiveCategory.name() + " entry: batchIndex " + batchIndex);
    }
}

