/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DirectOperatorConversion;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.ExtractOperatorConversion;
import org.apache.calcite.adapter.druid.FloorOperatorConversion;
import org.apache.calcite.adapter.druid.SubstringOperatorConversion;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveConcat;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExtractDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFloorDate;

public class DruidSqlOperatorConverter {
    private static Map druidOperatorMap = null;

    private DruidSqlOperatorConverter() {
    }

    public static final Map<SqlOperator, org.apache.calcite.adapter.druid.DruidSqlOperatorConverter> getDefaultMap() {
        if (druidOperatorMap == null) {
            druidOperatorMap = new HashMap();
            DruidQuery.DEFAULT_OPERATORS_LIST.stream().forEach(op -> druidOperatorMap.put(op.calciteOperator(), op));
            druidOperatorMap.putAll(Maps.asMap(HiveFloorDate.ALL_FUNCTIONS, input -> new FloorOperatorConversion()));
            druidOperatorMap.putAll(Maps.asMap(HiveExtractDate.ALL_FUNCTIONS, input -> new ExtractOperatorConversion()));
            druidOperatorMap.put(HiveConcat.INSTANCE, new DirectOperatorConversion((SqlOperator)HiveConcat.INSTANCE, "concat"));
            druidOperatorMap.put(SqlStdOperatorTable.SUBSTRING, new DruidSubstringOperatorConversion());
        }
        return druidOperatorMap;
    }

    public static class DruidSubstringOperatorConversion
    extends SubstringOperatorConversion {
        @Nullable
        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
            String length;
            String indexStart;
            RexCall call = (RexCall)rexNode;
            String arg = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
            if (arg == null) {
                return null;
            }
            if (!((RexNode)call.getOperands().get(1)).isA(SqlKind.LITERAL)) {
                String indexExp = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(1)), (RelDataType)rowType, (DruidQuery)query);
                if (indexExp == null) {
                    return null;
                }
                indexStart = DruidQuery.format((String)"(%s - 1)", (Object[])new Object[]{indexExp});
            } else {
                int index = RexLiteral.intValue((RexNode)((RexNode)call.getOperands().get(1))) - 1;
                indexStart = DruidExpressions.numberLiteral((Number)index);
            }
            if (call.getOperands().size() > 2) {
                if (!((RexNode)call.getOperands().get(2)).isA(SqlKind.LITERAL)) {
                    length = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(2)), (RelDataType)rowType, (DruidQuery)query);
                    if (length == null) {
                        return null;
                    }
                } else {
                    length = DruidExpressions.numberLiteral((Number)RexLiteral.intValue((RexNode)((RexNode)call.getOperands().get(2))));
                }
            } else {
                length = DruidExpressions.numberLiteral((Number)-1);
            }
            return DruidQuery.format((String)"substring(%s, %s, %s)", (Object[])new Object[]{arg, indexStart, length});
        }
    }
}

