/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MaterializedViewDesc;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RuntimeValuesInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.parse.SemiJoinHint;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class ParseContext {
    private HashMap<TableScanOperator, ExprNodeDesc> opToPartPruner;
    private HashMap<TableScanOperator, PrunedPartitionList> opToPartList;
    private HashMap<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner;
    private Map<TableScanOperator, Map<String, ExprNodeDesc>> opToPartToSkewedPruner;
    private HashMap<String, TableScanOperator> topOps;
    private Set<JoinOperator> joinOps;
    private Set<MapJoinOperator> mapJoinOps;
    private Set<SMBMapJoinOperator> smbMapJoinOps;
    private List<ReduceSinkOperator> reduceSinkOperatorsAddedByEnforceBucketingSorting;
    private HashMap<String, SplitSample> nameToSplitSample;
    private List<LoadTableDesc> loadTableWork;
    private List<LoadFileDesc> loadFileWork;
    private List<ColumnStatsAutoGatherContext> columnStatsAutoGatherContexts;
    private Context ctx;
    private QueryState queryState;
    private HiveConf conf;
    private HashMap<String, String> idToTableNameMap;
    private int destTableId;
    private UnionProcContext uCtx;
    private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoReducer;
    private Map<String, PrunedPartitionList> prunedPartitions;
    private Map<String, ReadEntity> viewAliasToInput;
    private Map<String, Table> tabNameToTabObject;
    private LineageInfo lInfo;
    private GlobalLimitCtx globalLimitCtx;
    private HashSet<ReadEntity> semanticInputs;
    private List<Task<? extends Serializable>> rootTasks;
    private FetchTask fetchTask;
    private QueryProperties queryProperties;
    private TableDesc fetchTableDesc;
    private Operator<?> fetchSource;
    private ListSinkOperator fetchSink;
    private BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite;
    private CreateTableDesc createTableDesc;
    private CreateViewDesc createViewDesc;
    private MaterializedViewDesc materializedViewUpdateDesc;
    private boolean reduceSinkAddedBySortedDynPartition;
    private Map<SelectOperator, Table> viewProjectToViewSchema;
    private ColumnAccessInfo columnAccessInfo;
    private boolean needViewColumnAuthorization;
    private Set<FileSinkDesc> acidFileSinks = Collections.emptySet();
    private Map<ReduceSinkOperator, RuntimeValuesInfo> rsToRuntimeValuesInfo = new HashMap<ReduceSinkOperator, RuntimeValuesInfo>();
    private Map<ReduceSinkOperator, SemiJoinBranchInfo> rsToSemiJoinBranchInfo = new HashMap<ReduceSinkOperator, SemiJoinBranchInfo>();
    private Map<ExprNodeDesc, GroupByOperator> colExprToGBMap = new HashMap<ExprNodeDesc, GroupByOperator>();
    private Map<String, List<SemiJoinHint>> semiJoinHints;
    private boolean disableMapJoin;

    public ParseContext() {
    }

    public ParseContext(QueryState queryState, HashMap<TableScanOperator, ExprNodeDesc> opToPartPruner, HashMap<TableScanOperator, PrunedPartitionList> opToPartList, HashMap<String, TableScanOperator> topOps, Set<JoinOperator> joinOps, Set<SMBMapJoinOperator> smbMapJoinOps, List<LoadTableDesc> loadTableWork, List<LoadFileDesc> loadFileWork, List<ColumnStatsAutoGatherContext> columnStatsAutoGatherContexts, Context ctx, HashMap<String, String> idToTableNameMap, int destTableId, UnionProcContext uCtx, List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoReducer, Map<String, PrunedPartitionList> prunedPartitions, Map<String, Table> tabNameToTabObject, HashMap<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner, GlobalLimitCtx globalLimitCtx, HashMap<String, SplitSample> nameToSplitSample, HashSet<ReadEntity> semanticInputs, List<Task<? extends Serializable>> rootTasks, Map<TableScanOperator, Map<String, ExprNodeDesc>> opToPartToSkewedPruner, Map<String, ReadEntity> viewAliasToInput, List<ReduceSinkOperator> reduceSinkOperatorsAddedByEnforceBucketingSorting, BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite, CreateTableDesc createTableDesc, CreateViewDesc createViewDesc, MaterializedViewDesc materializedViewUpdateDesc, QueryProperties queryProperties, Map<SelectOperator, Table> viewProjectToTableSchema, Set<FileSinkDesc> acidFileSinks) {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.opToPartPruner = opToPartPruner;
        this.opToPartList = opToPartList;
        this.joinOps = joinOps;
        this.smbMapJoinOps = smbMapJoinOps;
        this.loadFileWork = loadFileWork;
        this.loadTableWork = loadTableWork;
        this.columnStatsAutoGatherContexts = columnStatsAutoGatherContexts;
        this.topOps = topOps;
        this.ctx = ctx;
        this.idToTableNameMap = idToTableNameMap;
        this.destTableId = destTableId;
        this.uCtx = uCtx;
        this.listMapJoinOpsNoReducer = listMapJoinOpsNoReducer;
        this.prunedPartitions = prunedPartitions;
        this.tabNameToTabObject = tabNameToTabObject;
        this.opToSamplePruner = opToSamplePruner;
        this.nameToSplitSample = nameToSplitSample;
        this.globalLimitCtx = globalLimitCtx;
        this.semanticInputs = semanticInputs;
        this.rootTasks = rootTasks;
        this.opToPartToSkewedPruner = opToPartToSkewedPruner;
        this.viewAliasToInput = viewAliasToInput;
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting = reduceSinkOperatorsAddedByEnforceBucketingSorting;
        this.analyzeRewrite = analyzeRewrite;
        this.createTableDesc = createTableDesc;
        this.createViewDesc = createViewDesc;
        this.materializedViewUpdateDesc = materializedViewUpdateDesc;
        this.queryProperties = queryProperties;
        this.viewProjectToViewSchema = viewProjectToTableSchema;
        boolean bl = this.needViewColumnAuthorization = viewProjectToTableSchema != null && !viewProjectToTableSchema.isEmpty();
        if (this.needViewColumnAuthorization) {
            this.columnAccessInfo = new ColumnAccessInfo();
        }
        if (acidFileSinks != null && !acidFileSinks.isEmpty()) {
            this.acidFileSinks = new HashSet<FileSinkDesc>();
            this.acidFileSinks.addAll(acidFileSinks);
        }
    }

    public Set<FileSinkDesc> getAcidSinks() {
        return this.acidFileSinks;
    }

    public boolean hasAcidWrite() {
        return !this.acidFileSinks.isEmpty();
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    public HashMap<TableScanOperator, ExprNodeDesc> getOpToPartPruner() {
        return this.opToPartPruner;
    }

    public void setOpToPartPruner(HashMap<TableScanOperator, ExprNodeDesc> opToPartPruner) {
        this.opToPartPruner = opToPartPruner;
    }

    public HashMap<TableScanOperator, PrunedPartitionList> getOpToPartList() {
        return this.opToPartList;
    }

    public List<ReduceSinkOperator> getReduceSinkOperatorsAddedByEnforceBucketingSorting() {
        return this.reduceSinkOperatorsAddedByEnforceBucketingSorting;
    }

    public void setReduceSinkOperatorsAddedByEnforceBucketingSorting(List<ReduceSinkOperator> reduceSinkOperatorsAddedByEnforceBucketingSorting) {
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting = reduceSinkOperatorsAddedByEnforceBucketingSorting;
    }

    public HashMap<String, TableScanOperator> getTopOps() {
        return this.topOps;
    }

    public void setTopOps(HashMap<String, TableScanOperator> topOps) {
        this.topOps = topOps;
    }

    public HashMap<String, SplitSample> getNameToSplitSample() {
        return this.nameToSplitSample;
    }

    public void setNameToSplitSample(HashMap<String, SplitSample> nameToSplitSample) {
        this.nameToSplitSample = nameToSplitSample;
    }

    public List<LoadTableDesc> getLoadTableWork() {
        return this.loadTableWork;
    }

    public List<LoadFileDesc> getLoadFileWork() {
        return this.loadFileWork;
    }

    public void setLoadFileWork(List<LoadFileDesc> loadFileWork) {
        this.loadFileWork = loadFileWork;
    }

    public HashMap<String, String> getIdToTableNameMap() {
        return this.idToTableNameMap;
    }

    public void setIdToTableNameMap(HashMap<String, String> idToTableNameMap) {
        this.idToTableNameMap = idToTableNameMap;
    }

    public int getDestTableId() {
        return this.destTableId;
    }

    public void setDestTableId(int destTableId) {
        this.destTableId = destTableId;
    }

    public UnionProcContext getUCtx() {
        return this.uCtx;
    }

    public void setUCtx(UnionProcContext uCtx) {
        this.uCtx = uCtx;
    }

    public Set<JoinOperator> getJoinOps() {
        return this.joinOps;
    }

    public void setJoinOps(Set<JoinOperator> joinOps) {
        this.joinOps = joinOps;
    }

    public List<AbstractMapJoinOperator<? extends MapJoinDesc>> getListMapJoinOpsNoReducer() {
        return this.listMapJoinOpsNoReducer;
    }

    public void setListMapJoinOpsNoReducer(List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoReducer) {
        this.listMapJoinOpsNoReducer = listMapJoinOpsNoReducer;
    }

    public HashMap<TableScanOperator, FilterDesc.SampleDesc> getOpToSamplePruner() {
        return this.opToSamplePruner;
    }

    public void setOpToSamplePruner(HashMap<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner) {
        this.opToSamplePruner = opToSamplePruner;
    }

    public Map<String, ColumnStatsList> getColStatsCache() {
        return this.ctx.getOpContext().getColStatsCache();
    }

    public ColumnStatsList getColStatsCached(PrunedPartitionList partList) {
        return this.ctx.getOpContext().getColStatsCache().get(partList.getKey());
    }

    public Map<String, PrunedPartitionList> getPrunedPartitions() {
        return this.prunedPartitions;
    }

    public void setPrunedPartitions(Map<String, PrunedPartitionList> prunedPartitions) {
        this.prunedPartitions = prunedPartitions;
    }

    public void setLineageInfo(LineageInfo lInfo) {
        this.lInfo = lInfo;
    }

    public LineageInfo getLineageInfo() {
        return this.lInfo;
    }

    public Set<MapJoinOperator> getMapJoinOps() {
        return this.mapJoinOps;
    }

    public void setMapJoinOps(Set<MapJoinOperator> mapJoinOps) {
        this.mapJoinOps = mapJoinOps;
    }

    public Set<SMBMapJoinOperator> getSmbMapJoinOps() {
        return this.smbMapJoinOps;
    }

    public void setSmbMapJoinOps(Set<SMBMapJoinOperator> smbMapJoinOps) {
        this.smbMapJoinOps = smbMapJoinOps;
    }

    public GlobalLimitCtx getGlobalLimitCtx() {
        return this.globalLimitCtx;
    }

    public void setGlobalLimitCtx(GlobalLimitCtx globalLimitCtx) {
        this.globalLimitCtx = globalLimitCtx;
    }

    public HashSet<ReadEntity> getSemanticInputs() {
        return this.semanticInputs;
    }

    public void replaceRootTask(Task<? extends Serializable> rootTask, List<? extends Task<? extends Serializable>> tasks) {
        this.rootTasks.remove(rootTask);
        this.rootTasks.addAll(tasks);
    }

    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(FetchTask fetchTask) {
        this.fetchTask = fetchTask;
    }

    public PrunedPartitionList getPrunedPartitions(TableScanOperator ts) throws SemanticException {
        return this.getPrunedPartitions(((TableScanDesc)ts.getConf()).getAlias(), ts);
    }

    public PrunedPartitionList getPrunedPartitions(String alias, TableScanOperator ts) throws SemanticException {
        PrunedPartitionList partsList = this.opToPartList.get(ts);
        if (partsList == null) {
            partsList = PartitionPruner.prune(ts, this, alias);
            this.opToPartList.put(ts, partsList);
        }
        return partsList;
    }

    public Map<TableScanOperator, Map<String, ExprNodeDesc>> getOpToPartToSkewedPruner() {
        return this.opToPartToSkewedPruner;
    }

    public void setOpPartToSkewedPruner(HashMap<TableScanOperator, Map<String, ExprNodeDesc>> opToPartToSkewedPruner) {
        this.opToPartToSkewedPruner = opToPartToSkewedPruner;
    }

    public Map<String, ReadEntity> getViewAliasToInput() {
        return this.viewAliasToInput;
    }

    public QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    public void setQueryProperties(QueryProperties queryProperties) {
        this.queryProperties = queryProperties;
    }

    public TableDesc getFetchTableDesc() {
        return this.fetchTableDesc;
    }

    public void setFetchTabledesc(TableDesc fetchTableDesc) {
        this.fetchTableDesc = fetchTableDesc;
    }

    public Operator<?> getFetchSource() {
        return this.fetchSource;
    }

    public void setFetchSource(Operator<?> fetchSource) {
        this.fetchSource = fetchSource;
    }

    public ListSinkOperator getFetchSink() {
        return this.fetchSink;
    }

    public void setFetchSink(ListSinkOperator fetchSink) {
        this.fetchSink = fetchSink;
    }

    public BaseSemanticAnalyzer.AnalyzeRewriteContext getAnalyzeRewrite() {
        return this.analyzeRewrite;
    }

    public void setAnalyzeRewrite(BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite) {
        this.analyzeRewrite = analyzeRewrite;
    }

    public CreateTableDesc getCreateTable() {
        return this.createTableDesc;
    }

    public void setCreateTable(CreateTableDesc createTableDesc) {
        this.createTableDesc = createTableDesc;
    }

    public CreateViewDesc getCreateViewDesc() {
        return this.createViewDesc;
    }

    public MaterializedViewDesc getMaterializedViewUpdateDesc() {
        return this.materializedViewUpdateDesc;
    }

    public void setReduceSinkAddedBySortedDynPartition(boolean reduceSinkAddedBySortedDynPartition) {
        this.reduceSinkAddedBySortedDynPartition = reduceSinkAddedBySortedDynPartition;
    }

    public boolean isReduceSinkAddedBySortedDynPartition() {
        return this.reduceSinkAddedBySortedDynPartition;
    }

    public Map<SelectOperator, Table> getViewProjectToTableSchema() {
        return this.viewProjectToViewSchema;
    }

    public ColumnAccessInfo getColumnAccessInfo() {
        return this.columnAccessInfo;
    }

    public void setColumnAccessInfo(ColumnAccessInfo columnAccessInfo) {
        this.columnAccessInfo = columnAccessInfo;
    }

    public boolean isNeedViewColumnAuthorization() {
        return this.needViewColumnAuthorization;
    }

    public void setNeedViewColumnAuthorization(boolean needViewColumnAuthorization) {
        this.needViewColumnAuthorization = needViewColumnAuthorization;
    }

    public Map<String, Table> getTabNameToTabObject() {
        return this.tabNameToTabObject;
    }

    public List<ColumnStatsAutoGatherContext> getColumnStatsAutoGatherContexts() {
        return this.columnStatsAutoGatherContexts;
    }

    public void setColumnStatsAutoGatherContexts(List<ColumnStatsAutoGatherContext> columnStatsAutoGatherContexts) {
        this.columnStatsAutoGatherContexts = columnStatsAutoGatherContexts;
    }

    public Collection<Operator> getAllOps() {
        ArrayList<Operator> ops = new ArrayList<Operator>();
        HashSet<Operator> visited = new HashSet<Operator>();
        for (Operator operator : this.getTopOps().values()) {
            ParseContext.getAllOps(ops, visited, operator);
        }
        return ops;
    }

    private static void getAllOps(List<Operator> builder, Set<Operator> visited, Operator<?> op) {
        boolean added = visited.add(op);
        builder.add(op);
        if (!added) {
            return;
        }
        if (op.getNumChild() > 0) {
            List<Operator<OperatorDesc>> children = op.getChildOperators();
            for (int i = 0; i < children.size(); ++i) {
                ParseContext.getAllOps(builder, visited, children.get(i));
            }
        }
    }

    public void setRsToRuntimeValuesInfoMap(Map<ReduceSinkOperator, RuntimeValuesInfo> rsToRuntimeValuesInfo) {
        this.rsToRuntimeValuesInfo = rsToRuntimeValuesInfo;
    }

    public Map<ReduceSinkOperator, RuntimeValuesInfo> getRsToRuntimeValuesInfoMap() {
        return this.rsToRuntimeValuesInfo;
    }

    public void setRsToSemiJoinBranchInfo(Map<ReduceSinkOperator, SemiJoinBranchInfo> rsToSemiJoinBranchInfo) {
        this.rsToSemiJoinBranchInfo = rsToSemiJoinBranchInfo;
    }

    public Map<ReduceSinkOperator, SemiJoinBranchInfo> getRsToSemiJoinBranchInfo() {
        return this.rsToSemiJoinBranchInfo;
    }

    public void setColExprToGBMap(Map<ExprNodeDesc, GroupByOperator> colExprToGBMap) {
        this.colExprToGBMap = colExprToGBMap;
    }

    public Map<ExprNodeDesc, GroupByOperator> getColExprToGBMap() {
        return this.colExprToGBMap;
    }

    public void setSemiJoinHints(Map<String, List<SemiJoinHint>> hints) {
        this.semiJoinHints = hints;
    }

    public Map<String, List<SemiJoinHint>> getSemiJoinHints() {
        return this.semiJoinHints;
    }

    public void setDisableMapJoin(boolean disableMapJoin) {
        this.disableMapJoin = disableMapJoin;
    }

    public boolean getDisableMapJoin() {
        return this.disableMapJoin;
    }
}

