/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperations {
    private static Logger logger = LoggerFactory.getLogger(FileOperations.class);
    private final List<Path> dataPathList;
    private final Path exportRootDataDir;
    private final String distCpDoAsUser;
    private HiveConf hiveConf;
    private final FileSystem dataFileSystem;
    private final FileSystem exportFileSystem;

    public FileOperations(List<Path> dataPathList, Path exportRootDataDir, String distCpDoAsUser, HiveConf hiveConf) throws IOException {
        this.dataPathList = dataPathList;
        this.exportRootDataDir = exportRootDataDir;
        this.distCpDoAsUser = distCpDoAsUser;
        this.hiveConf = hiveConf;
        this.dataFileSystem = dataPathList != null && !dataPathList.isEmpty() ? dataPathList.get(0).getFileSystem((Configuration)hiveConf) : null;
        this.exportFileSystem = exportRootDataDir.getFileSystem((Configuration)hiveConf);
    }

    public void export(ReplicationSpec forReplicationSpec) throws Exception {
        if (forReplicationSpec.isLazy()) {
            this.exportFilesAsList();
        } else {
            this.copyFiles();
        }
    }

    private void copyFiles() throws IOException, LoginException {
        for (Path dataPath : this.dataPathList) {
            FileStatus[] fileStatuses = LoadSemanticAnalyzer.matchFilesOrDir(this.dataFileSystem, dataPath);
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            for (FileStatus fileStatus : fileStatuses) {
                srcPaths.add(fileStatus.getPath());
            }
            new CopyUtils(this.distCpDoAsUser, this.hiveConf).doCopy(this.exportRootDataDir, srcPaths);
        }
    }

    private void exportFilesAsList() throws SemanticException, IOException {
        try (BufferedWriter writer = this.writer();){
            for (Path dataPath : this.dataPathList) {
                this.writeFilesList(this.listFilesInDir(dataPath), writer, AcidUtils.getAcidSubDir(dataPath));
            }
        }
    }

    private void writeFilesList(FileStatus[] fileStatuses, BufferedWriter writer, String encodedSubDirs) throws IOException {
        for (FileStatus fileStatus : fileStatuses) {
            if (fileStatus.isDirectory()) {
                Path subDir = fileStatus.getPath();
                this.writeFilesList(this.listFilesInDir(subDir), writer, this.encodedSubDir(encodedSubDirs, subDir));
                continue;
            }
            writer.write(this.encodedUri(fileStatus, encodedSubDirs));
            writer.newLine();
        }
    }

    private FileStatus[] listFilesInDir(Path path) throws IOException {
        return this.dataFileSystem.listStatus(path, p -> {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        });
    }

    private BufferedWriter writer() throws IOException {
        Path exportToFile = new Path(this.exportRootDataDir, "_files");
        if (this.exportFileSystem.exists(exportToFile)) {
            throw new IllegalArgumentException(exportToFile.toString() + " already exists and cant export data from path(dir) " + this.dataPathList);
        }
        logger.debug("exporting data files in dir : " + this.dataPathList + " to " + exportToFile);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)this.exportFileSystem.create(exportToFile)));
    }

    private String encodedSubDir(String encodedParentDirs, Path subDir) {
        if (null == encodedParentDirs) {
            return subDir.getName();
        }
        return encodedParentDirs + "/" + subDir.getName();
    }

    private String encodedUri(FileStatus fileStatus, String encodedSubDir) throws IOException {
        Path currentDataFilePath = fileStatus.getPath();
        String checkSum = ReplChangeManager.checksumFor(currentDataFilePath, this.dataFileSystem);
        return ReplChangeManager.encodeFileUri(currentDataFilePath.toString(), checkSum, encodedSubDir);
    }
}

