/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class DropPartitionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        try {
            DropPartitionMessage msg = this.deserializer.getDropPartitionMessage(context.dmd.getPayload());
            String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
            String actualTblName = context.isTableNameEmpty() ? msg.getTable() : context.tableName;
            Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = this.genPartSpecs(new Table(msg.getTableObj()), msg.getPartitions());
            if (partSpecs.size() > 0) {
                DropTableDesc dropPtnDesc = new DropTableDesc(actualDbName + "." + actualTblName, partSpecs, null, true, context.eventOnlyReplicationSpec());
                Task<DDLWork> dropPtnTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.readEntitySet, (HashSet<WriteEntity>)this.writeEntitySet, dropPtnDesc), context.hiveConf);
                context.log.debug("Added drop ptn task : {}:{},{}", new Object[]{dropPtnTask.getId(), dropPtnDesc.getTableName(), msg.getPartitions()});
                this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
                return Collections.singletonList(dropPtnTask);
            }
            throw new SemanticException("DROP PARTITION EVENT does not return any part descs for event message :" + context.dmd.getPayload());
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)e : new SemanticException("Error reading message members", e);
        }
    }

    private Map<Integer, List<ExprNodeGenericFuncDesc>> genPartSpecs(Table table, List<Map<String, String>> partitions) throws SemanticException {
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        int partPrefixLength = 0;
        if (partitions.size() > 0) {
            partPrefixLength = partitions.get(0).size();
        }
        ArrayList<ExprNodeGenericFuncDesc> partitionDesc = new ArrayList<ExprNodeGenericFuncDesc>();
        for (Map<String, String> ptn : partitions) {
            ExprNodeGenericFuncDesc expr = null;
            for (Map.Entry<String, String> kvp : ptn.entrySet()) {
                String key = kvp.getKey();
                String val = kvp.getValue();
                String type = table.getPartColByName(key).getType();
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo(type);
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(pti, key, null, true);
                ExprNodeGenericFuncDesc op = DDLSemanticAnalyzer.makeBinaryPredicate("=", column, new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, val));
                expr = expr == null ? op : DDLSemanticAnalyzer.makeBinaryPredicate("and", expr, op);
            }
            if (expr == null) continue;
            partitionDesc.add(expr);
        }
        if (partitionDesc.size() > 0) {
            partSpecs.put(partPrefixLength, partitionDesc);
        }
        return partSpecs;
    }
}

