/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.chrono.ISOChronology;

public abstract class UDFDateFloor
extends UDF {
    private final QueryGranularity granularity;
    private final TimestampWritable resultTS;
    private final TimestampLocalTZWritable resultTSLTZ;
    private static final Map<String, PeriodGranularity> CALENDRIC_GRANULARITIES = ImmutableMap.of("YEAR", new PeriodGranularity(new Period("P1Y"), null, null), "MONTH", new PeriodGranularity(new Period("P1M"), null, null), "QUARTER", new PeriodGranularity(new Period("P3M"), null, null), "WEEK", new PeriodGranularity(new Period("P1W"), null, null));

    public UDFDateFloor(String granularity) {
        this.granularity = QueryGranularity.fromString(granularity);
        this.resultTS = new TimestampWritable();
        this.resultTSLTZ = new TimestampLocalTZWritable();
    }

    public TimestampWritable evaluate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        long originalTimestamp = t.getTimestamp().getTime();
        long originalTimestampUTC = new DateTime(originalTimestamp).withZoneRetainFields(DateTimeZone.UTC).getMillis();
        long newTimestampUTC = this.granularity.truncate(originalTimestampUTC);
        long newTimestamp = new DateTime(newTimestampUTC, DateTimeZone.UTC).withZoneRetainFields(DateTimeZone.getDefault()).getMillis();
        this.resultTS.setTime(newTimestamp);
        return this.resultTS;
    }

    public TimestampLocalTZWritable evaluate(TimestampLocalTZWritable t) {
        if (t == null) {
            return null;
        }
        ZonedDateTime localZDT = t.getTimestampTZ().getZonedDateTime();
        long originalTimestampUTC = localZDT.withZoneSameLocal(ZoneOffset.UTC).toInstant().toEpochMilli();
        long newTimestampUTC = this.granularity.truncate(originalTimestampUTC);
        ZonedDateTime newLocalZDT = ZonedDateTime.of(LocalDateTime.ofInstant(Instant.ofEpochMilli(newTimestampUTC), ZoneOffset.UTC), localZDT.getZone());
        this.resultTSLTZ.set(new TimestampTZ(newLocalZDT));
        return this.resultTSLTZ;
    }

    private static class DurationGranularity
    extends BaseQueryGranularity {
        private final long length;
        private final long origin;

        public DurationGranularity(long millis, long origin) {
            this.length = millis;
            this.origin = origin % this.length;
        }

        @Override
        public long next(long t) {
            return t + this.getDurationMillis();
        }

        @Override
        public long truncate(long t) {
            long duration = this.getDurationMillis();
            long offset = t % duration - this.origin % duration;
            if (offset < 0L) {
                offset += duration;
            }
            return t - offset;
        }

        public long getDurationMillis() {
            return this.length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DurationGranularity that = (DurationGranularity)o;
            if (this.length != that.length) {
                return false;
            }
            return this.origin == that.origin;
        }

        public int hashCode() {
            int result = (int)(this.length ^ this.length >>> 32);
            result = 31 * result + (int)(this.origin ^ this.origin >>> 32);
            return result;
        }

        public String toString() {
            return "DurationGranularity{length=" + this.length + ", origin=" + this.origin + '}';
        }
    }

    private static class PeriodGranularity
    extends BaseQueryGranularity {
        private final Period period;
        private final Chronology chronology;
        private final long origin;
        private final boolean hasOrigin;
        private final boolean isCompound;

        public PeriodGranularity(Period period, DateTime origin, DateTimeZone tz) {
            this.period = period;
            Chronology chronology = this.chronology = tz == null ? ISOChronology.getInstanceUTC() : ISOChronology.getInstance(tz);
            if (origin == null) {
                this.origin = new DateTime(0L, DateTimeZone.UTC).withZoneRetainFields(this.chronology.getZone()).getMillis();
                this.hasOrigin = false;
            } else {
                this.origin = origin.getMillis();
                this.hasOrigin = true;
            }
            this.isCompound = PeriodGranularity.isCompoundPeriod(period);
        }

        @Override
        public DateTime toDateTime(long t) {
            return new DateTime(t, this.chronology.getZone());
        }

        @Override
        public long next(long t) {
            return this.chronology.add(this.period, t, 1);
        }

        @Override
        public long truncate(long t) {
            if (this.isCompound) {
                try {
                    return this.truncateMillisPeriod(t);
                }
                catch (UnsupportedOperationException e) {
                    return this.truncateCompoundPeriod(t);
                }
            }
            int years = this.period.getYears();
            if (years > 0) {
                if (years > 1 || this.hasOrigin) {
                    int y = this.chronology.years().getDifference(t, this.origin);
                    y -= y % years;
                    long tt = this.chronology.years().add(this.origin, y);
                    t = t < tt ? this.chronology.years().add(tt, -years) : tt;
                    return t;
                }
                return this.chronology.year().roundFloor(t);
            }
            int months = this.period.getMonths();
            if (months > 0) {
                if (months > 1 || this.hasOrigin) {
                    int m = this.chronology.months().getDifference(t, this.origin);
                    m -= m % months;
                    long tt = this.chronology.months().add(this.origin, m);
                    t = t < tt ? this.chronology.months().add(tt, -months) : tt;
                    return t;
                }
                return this.chronology.monthOfYear().roundFloor(t);
            }
            int weeks = this.period.getWeeks();
            if (weeks > 0) {
                if (weeks > 1 || this.hasOrigin) {
                    int w = this.chronology.weeks().getDifference(t, this.origin);
                    w -= w % weeks;
                    long tt = this.chronology.weeks().add(this.origin, w);
                    t = t < tt ? this.chronology.weeks().add(tt, -weeks) : tt;
                    return t;
                }
                t = this.chronology.dayOfWeek().roundFloor(t);
                return this.chronology.dayOfWeek().set(t, 1);
            }
            int days = this.period.getDays();
            if (days > 0) {
                if (days > 1 || this.hasOrigin) {
                    int d = this.chronology.days().getDifference(t, this.origin);
                    d -= d % days;
                    long tt = this.chronology.days().add(this.origin, d);
                    t = t < tt ? this.chronology.days().add(tt, -days) : tt;
                    return t;
                }
                t = this.chronology.hourOfDay().roundFloor(t);
                return this.chronology.hourOfDay().set(t, 0);
            }
            int hours = this.period.getHours();
            if (hours > 0) {
                if (hours > 1 || this.hasOrigin) {
                    long h = this.chronology.hours().getDifferenceAsLong(t, this.origin);
                    h -= h % (long)hours;
                    long tt = this.chronology.hours().add(this.origin, h);
                    t = t < tt ? this.chronology.hours().add(tt, -hours) : tt;
                    return t;
                }
                t = this.chronology.minuteOfHour().roundFloor(t);
                return this.chronology.minuteOfHour().set(t, 0);
            }
            int minutes = this.period.getMinutes();
            if (minutes > 0) {
                if (minutes > 1 || this.hasOrigin) {
                    long m = this.chronology.minutes().getDifferenceAsLong(t, this.origin);
                    m -= m % (long)minutes;
                    long tt = this.chronology.minutes().add(this.origin, m);
                    t = t < tt ? this.chronology.minutes().add(tt, -minutes) : tt;
                    return t;
                }
                t = this.chronology.secondOfMinute().roundFloor(t);
                return this.chronology.secondOfMinute().set(t, 0);
            }
            int seconds = this.period.getSeconds();
            if (seconds > 0) {
                if (seconds > 1 || this.hasOrigin) {
                    long s = this.chronology.seconds().getDifferenceAsLong(t, this.origin);
                    s -= s % (long)seconds;
                    long tt = this.chronology.seconds().add(this.origin, s);
                    t = t < tt ? this.chronology.seconds().add(tt, -seconds) : tt;
                    return t;
                }
                return this.chronology.millisOfSecond().set(t, 0);
            }
            int millis = this.period.getMillis();
            if (millis > 0) {
                if (millis > 1) {
                    long ms = this.chronology.millis().getDifferenceAsLong(t, this.origin);
                    ms -= ms % (long)millis;
                    long tt = this.chronology.millis().add(this.origin, ms);
                    t = t < tt ? this.chronology.millis().add(tt, -millis) : tt;
                    return t;
                }
                return t;
            }
            return t;
        }

        private static boolean isCompoundPeriod(Period period) {
            int[] values = period.getValues();
            boolean single = false;
            for (int v : values) {
                if (v <= 0) continue;
                if (single) {
                    return true;
                }
                single = true;
            }
            return false;
        }

        private long truncateCompoundPeriod(long t) {
            long current;
            if (t >= this.origin) {
                long next = this.origin;
                while (t >= (next = this.chronology.add(this.period, current = next, 1))) {
                }
            } else {
                current = this.origin;
                while (t < (current = this.chronology.add(this.period, current, -1))) {
                }
            }
            return current;
        }

        private long truncateMillisPeriod(long t) {
            if (this.chronology.days().isPrecise() && this.chronology.hours().isPrecise()) {
                long millis = this.period.toStandardDuration().getMillis();
                long offset = t % millis - this.origin % millis;
                if (offset < 0L) {
                    offset += millis;
                }
                return t - offset;
            }
            throw new UnsupportedOperationException("Period cannot be converted to milliseconds as some fields mays vary in length with chronology " + this.chronology.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PeriodGranularity that = (PeriodGranularity)o;
            if (this.hasOrigin != that.hasOrigin) {
                return false;
            }
            if (this.origin != that.origin) {
                return false;
            }
            if (!this.chronology.equals(that.chronology)) {
                return false;
            }
            return this.period.equals(that.period);
        }

        public int hashCode() {
            int result = this.period.hashCode();
            result = 31 * result + this.chronology.hashCode();
            result = 31 * result + (int)(this.origin ^ this.origin >>> 32);
            result = 31 * result + (this.hasOrigin ? 1 : 0);
            return result;
        }

        public String toString() {
            return "PeriodGranularity{period=" + this.period + ", timeZone=" + this.chronology.getZone() + ", origin=" + (this.hasOrigin ? Long.valueOf(this.origin) : "null") + '}';
        }
    }

    private static abstract class BaseQueryGranularity
    extends QueryGranularity {
        private BaseQueryGranularity() {
        }

        @Override
        public abstract long next(long var1);

        @Override
        public abstract long truncate(long var1);

        @Override
        public DateTime toDateTime(long offset) {
            return new DateTime(offset, DateTimeZone.UTC);
        }

        @Override
        public Iterable<Long> iterable(final long start, final long end) {
            return new Iterable<Long>(){

                @Override
                public Iterator<Long> iterator() {
                    return new Iterator<Long>(){
                        long curr;
                        long next;
                        {
                            this.curr = this.truncate(start);
                            this.next = this.next(this.curr);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.curr < end;
                        }

                        @Override
                        public Long next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            long retVal = this.curr;
                            this.curr = this.next;
                            this.next = this.next(this.curr);
                            return retVal;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
    }

    private static abstract class QueryGranularity {
        private QueryGranularity() {
        }

        public abstract long next(long var1);

        public abstract long truncate(long var1);

        public abstract DateTime toDateTime(long var1);

        public abstract Iterable<Long> iterable(long var1, long var3);

        public static QueryGranularity fromString(String str) {
            String name = str.toUpperCase();
            if (CALENDRIC_GRANULARITIES.containsKey(name)) {
                return (QueryGranularity)CALENDRIC_GRANULARITIES.get(name);
            }
            return new DurationGranularity(QueryGranularity.convertValue(str), 0L);
        }

        private static long convertValue(Object o) {
            if (o instanceof String) {
                return MillisIn.valueOf(((String)o).toUpperCase()).millis;
            }
            if (o instanceof ReadableDuration) {
                return ((ReadableDuration)o).getMillis();
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            throw new RuntimeException("Granularity not recognized");
        }

        private static enum MillisIn {
            SECOND(1000L),
            MINUTE(60000L),
            FIFTEEN_MINUTE(900000L),
            THIRTY_MINUTE(1800000L),
            HOUR(3600000L),
            DAY(86400000L);

            private final long millis;

            private MillisIn(long millis) {
                this.millis = millis;
            }
        }
    }
}

