/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.tools.FileDump;
import org.apache.orc.tools.PrintData;
import org.apache.orc.tools.ScanData;
import org.apache.orc.tools.convert.ConvertTool;
import org.apache.orc.tools.json.JsonSchemaFinder;

public class Driver {
    static Options createOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print help message");
        result.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.withDescription((String)"Set a configuration property");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        result.addOption(OptionBuilder.create((char)'D'));
        return result;
    }

    public static void main(String[] args) throws Exception {
        DriverOptions options = new DriverOptions(args);
        if (options.command == null) {
            System.err.println("ORC Java Tools");
            System.err.println();
            System.err.println("usage: java -jar orc-tools-*.jar [--help] [--define X=Y] <command> <args>");
            System.err.println();
            System.err.println("Commands:");
            System.err.println("   meta - print the metadata about the ORC file");
            System.err.println("   data - print the data from the ORC file");
            System.err.println("   scan - scan the ORC file");
            System.err.println("   convert - convert JSON files to ORC");
            System.err.println("   json-schema - scan JSON files to determine their schema");
            System.err.println();
            System.err.println("To get more help, provide -h to the command");
            System.exit(1);
        }
        Configuration conf = new Configuration();
        Properties confSettings = options.genericOptions.getOptionProperties("D");
        for (Map.Entry<Object, Object> pair : confSettings.entrySet()) {
            conf.set(pair.getKey().toString(), pair.getValue().toString());
        }
        if ("meta".equals(options.command)) {
            FileDump.main(conf, options.commandArgs);
        } else if ("data".equals(options.command)) {
            PrintData.main(conf, options.commandArgs);
        } else if ("scan".equals(options.command)) {
            ScanData.main(conf, options.commandArgs);
        } else if ("json-schema".equals(options.command)) {
            JsonSchemaFinder.main(conf, options.commandArgs);
        } else if ("convert".equals(options.command)) {
            ConvertTool.main(conf, options.commandArgs);
        } else {
            System.err.println("Unknown subcommand: " + options.command);
            System.exit(1);
        }
    }

    static class DriverOptions {
        final CommandLine genericOptions;
        final String command;
        final String[] commandArgs;

        DriverOptions(String[] args) throws ParseException {
            this.genericOptions = new GnuParser().parse(Driver.createOptions(), args, true);
            String[] unprocessed = this.genericOptions.getArgs();
            if (unprocessed.length == 0) {
                this.command = null;
                this.commandArgs = new String[0];
            } else {
                this.command = unprocessed[0];
                if (this.genericOptions.hasOption('h')) {
                    this.commandArgs = new String[]{"-h"};
                } else {
                    this.commandArgs = new String[unprocessed.length - 1];
                    System.arraycopy(unprocessed, 1, this.commandArgs, 0, this.commandArgs.length);
                }
            }
        }
    }
}

