/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.convert;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.tools.convert.JsonReader;
import org.apache.orc.tools.json.JsonSchemaFinder;

public class ConvertTool {
    static TypeDescription computeSchema(String[] filename) throws IOException {
        JsonSchemaFinder schemaFinder = new JsonSchemaFinder();
        for (String file : filename) {
            System.err.println("Scanning " + file + " for schema");
            schemaFinder.addFile(file);
        }
        return schemaFinder.getSchema();
    }

    public static void main(Configuration conf, String[] args) throws IOException, ParseException {
        CommandLine opts = ConvertTool.parseOptions(args);
        TypeDescription schema = opts.hasOption('s') ? TypeDescription.fromString(opts.getOptionValue('s')) : ConvertTool.computeSchema(opts.getArgs());
        String outFilename = opts.hasOption('o') ? opts.getOptionValue('o') : "output.orc";
        Writer writer = OrcFile.createWriter(new Path(outFilename), OrcFile.writerOptions(conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch();
        for (String file : opts.getArgs()) {
            System.err.println("Processing " + file);
            JsonReader reader = new JsonReader(new Path(file), schema, conf);
            while (reader.nextBatch(batch)) {
                writer.addRowBatch(batch);
            }
            reader.close();
        }
        writer.close();
    }

    static CommandLine parseOptions(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").desc("Provide help").build());
        options.addOption(Option.builder((String)"s").longOpt("schema").hasArg().desc("The schema to write in to the file").build());
        options.addOption(Option.builder((String)"o").longOpt("output").desc("Output filename").hasArg().build());
        CommandLine cli = new GnuParser().parse(options, args);
        if (cli.hasOption('h') || cli.getArgs().length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("convert", options);
            System.exit(1);
        }
        return cli;
    }
}

