/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.rpc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class RpcConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RpcConfiguration.class);
    public static final ImmutableSet<String> HIVE_SPARK_RSC_CONFIGS = ImmutableSet.of(HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT.varname, HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT.varname, HiveConf.ConfVars.SPARK_RPC_CHANNEL_LOG_LEVEL.varname, HiveConf.ConfVars.SPARK_RPC_MAX_MESSAGE_SIZE.varname, HiveConf.ConfVars.SPARK_RPC_MAX_THREADS.varname, HiveConf.ConfVars.SPARK_RPC_SECRET_RANDOM_BITS.varname, new String[]{HiveConf.ConfVars.SPARK_RPC_SERVER_ADDRESS.varname});
    public static final ImmutableSet<String> HIVE_SPARK_TIME_CONFIGS = ImmutableSet.of(HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT.varname, HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT.varname);
    public static final String RPC_SASL_OPT_PREFIX = "hive.spark.client.rpc.sasl.";
    private final Map<String, String> config;
    private static final HiveConf DEFAULT_CONF = new HiveConf();

    public RpcConfiguration(Map<String, String> config) {
        this.config = Collections.unmodifiableMap(config);
    }

    long getConnectTimeoutMs() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT.varname);
        return value != null ? Long.parseLong(value) : DEFAULT_CONF.getTimeVar(HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    int getMaxMessageSize() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_MAX_MESSAGE_SIZE.varname);
        return value != null ? Integer.parseInt(value) : HiveConf.ConfVars.SPARK_RPC_MAX_MESSAGE_SIZE.defaultIntVal;
    }

    long getServerConnectTimeoutMs() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT.varname);
        return value != null ? Long.parseLong(value) : DEFAULT_CONF.getTimeVar(HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    int getSecretBits() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_SECRET_RANDOM_BITS.varname);
        return value != null ? Integer.parseInt(value) : HiveConf.ConfVars.SPARK_RPC_SECRET_RANDOM_BITS.defaultIntVal;
    }

    String getServerAddress() throws IOException {
        String hiveHost = this.config.get(HiveConf.ConfVars.SPARK_RPC_SERVER_ADDRESS.varname);
        if (StringUtils.isEmpty(hiveHost) && (hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST")) == null) {
            hiveHost = this.config.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname);
        }
        return ServerUtils.getHostAddress(hiveHost).getHostName();
    }

    List<Integer> getServerPorts() throws IOException {
        String errMsg = "Incorrect RPC server port configuration for HiveServer2";
        String portString = this.config.get(HiveConf.ConfVars.SPARK_RPC_SERVER_PORT.varname);
        ArrayList<Integer> ports = new ArrayList<Integer>();
        try {
            if (!StringUtils.isEmpty(portString)) {
                for (String portRange : portString.split(",")) {
                    String[] range = portRange.split("-");
                    if (range.length == 0 || range.length > 2 || range.length == 2 && Integer.valueOf(range[0]) > Integer.valueOf(range[1])) {
                        throw new IOException(errMsg);
                    }
                    if (range.length == 1) {
                        ports.add(Integer.valueOf(range[0]));
                        continue;
                    }
                    for (int i = Integer.valueOf(range[0]).intValue(); i <= Integer.valueOf(range[1]); ++i) {
                        ports.add(i);
                    }
                }
            } else {
                ports.add(0);
            }
            return ports;
        }
        catch (NumberFormatException e) {
            throw new IOException(errMsg);
        }
    }

    String getRpcChannelLogLevel() {
        return this.config.get(HiveConf.ConfVars.SPARK_RPC_CHANNEL_LOG_LEVEL.varname);
    }

    public int getRpcThreadCount() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_MAX_THREADS.varname);
        return value != null ? Integer.parseInt(value) : HiveConf.ConfVars.SPARK_RPC_MAX_THREADS.defaultIntVal;
    }

    public static String getValue(HiveConf conf, String key) {
        if (HIVE_SPARK_TIME_CONFIGS.contains(key)) {
            HiveConf.ConfVars confVar = HiveConf.getConfVars(key);
            return String.valueOf(conf.getTimeVar(confVar, TimeUnit.MILLISECONDS));
        }
        return conf.get(key);
    }

    String getSaslMechanism() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_SASL_MECHANISM.varname);
        return value != null ? value : HiveConf.ConfVars.SPARK_RPC_SASL_MECHANISM.defaultStrVal;
    }

    Map<String, String> getSaslOptions() {
        HashMap<String, String> opts = new HashMap<String, String>();
        ImmutableMap<String, String> saslOpts = ImmutableMap.builder().put("javax.security.sasl.credentials", "credentials").put("javax.security.sasl.maxbuffer", "max_buffer").put("javax.security.sasl.policy.forward", "policy_forward_secrecy").put("javax.security.sasl.policy.noactive", "policy_noactive").put("javax.security.sasl.policy.noanonymous", "policy_noanonymous").put("javax.security.sasl.policy.nodictionary", "policy_nodictionary").put("javax.security.sasl.policy.noplaintext", "policy_noplaintext").put("javax.security.sasl.policy.credentials", "policy_pass_credentials").put("javax.security.sasl.qop", "qop").put("javax.security.sasl.rawsendsize", "raw_send_size").put("javax.security.sasl.reuse", "reuse").put("javax.security.sasl.server.authentication", "server_auth").put("javax.security.sasl.strength", "strength").build();
        for (Map.Entry e : saslOpts.entrySet()) {
            String value = this.config.get(RPC_SASL_OPT_PREFIX + (String)e.getValue());
            if (value == null) continue;
            opts.put((String)e.getKey(), value);
        }
        return opts;
    }
}

