/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueInputMerger
extends KeyValueReader {
    public static final Logger l4j = LoggerFactory.getLogger(KeyValueInputMerger.class);
    private PriorityQueue<KeyValueReader> pQueue = null;
    private KeyValueReader nextKVReader = null;
    private KeyValueReader prevKVReader = null;
    private ObjectInspector[] inputObjInspectors = null;
    private Deserializer deserializer = null;
    private List<StructField> structFields = null;
    private List<ObjectInspector> fieldOIs = null;
    private final Map<KeyValueReader, List<Object>> kvReaderStandardObjMap = new HashMap<KeyValueReader, List<Object>>();
    private final Map<KeyValueReader, Path> kvReaderPathMap = new IdentityHashMap<KeyValueReader, Path>();
    private IOContext ioCxt = null;

    public KeyValueInputMerger(List<KeyValueReader> multiMRInputs, Deserializer deserializer, ObjectInspector[] inputObjInspectors, List<String> sortCols) throws Exception {
        int initialCapacity = multiMRInputs.size();
        this.pQueue = new PriorityQueue<KeyValueReader>(initialCapacity, new KVReaderComparator());
        this.inputObjInspectors = inputObjInspectors;
        this.deserializer = deserializer;
        this.fieldOIs = new ArrayList<ObjectInspector>();
        this.structFields = new ArrayList<StructField>();
        StructObjectInspector structOI = (StructObjectInspector)inputObjInspectors[0];
        for (String field : sortCols) {
            StructField sf = structOI.getStructFieldRef(field);
            this.structFields.add(sf);
            ObjectInspector stdOI = ObjectInspectorUtils.getStandardObjectInspector(sf.getFieldObjectInspector());
            this.fieldOIs.add(stdOI);
        }
        l4j.info("Initialized the priority queue with multi mr inputs: " + multiMRInputs.size());
        for (KeyValueReader input : multiMRInputs) {
            TezGroupedSplit split = (TezGroupedSplit)((MRReader)input).getSplit();
            List splits = split.getGroupedSplits();
            Path path0 = ((HiveInputFormat.HiveInputSplit)((Object)splits.get(0))).getPath();
            this.kvReaderPathMap.put(input, path0);
            for (int i = 1; i < splits.size(); ++i) {
                Path path = ((HiveInputFormat.HiveInputSplit)((Object)splits.get(i))).getPath();
                assert (path0.equals((Object)path));
            }
            this.addToQueue(input);
        }
    }

    public void setIOCxt(IOContext ioCxt) {
        this.ioCxt = ioCxt;
    }

    private void addToQueue(KeyValueReader kvReader) throws IOException {
        if (kvReader.next()) {
            this.kvReaderStandardObjMap.remove(kvReader);
            this.pQueue.add(kvReader);
        }
    }

    public boolean next() throws IOException {
        if (this.nextKVReader != null) {
            this.addToQueue(this.nextKVReader);
        }
        this.nextKVReader = this.pQueue.poll();
        if (this.nextKVReader == null) {
            return false;
        }
        if (this.nextKVReader != this.prevKVReader) {
            this.prevKVReader = this.nextKVReader;
            this.ioCxt.setInputPath(this.kvReaderPathMap.get(this.nextKVReader));
        }
        return true;
    }

    public Object getCurrentKey() throws IOException {
        return this.nextKVReader.getCurrentKey();
    }

    public Object getCurrentValue() throws IOException {
        return this.nextKVReader.getCurrentValue();
    }

    public void clean() {
        this.ioCxt = null;
        this.prevKVReader = null;
    }

    class KVReaderComparator
    implements Comparator<KeyValueReader> {
        KVReaderComparator() {
        }

        @Override
        public int compare(KeyValueReader kvReadr1, KeyValueReader kvReadr2) {
            try {
                List row2;
                List row1;
                ObjectInspector oi = KeyValueInputMerger.this.inputObjInspectors[0];
                try {
                    if (KeyValueInputMerger.this.kvReaderStandardObjMap.containsKey(kvReadr1)) {
                        row1 = (List)KeyValueInputMerger.this.kvReaderStandardObjMap.get(kvReadr1);
                    } else {
                        row1 = (List)ObjectInspectorUtils.copyToStandardObject(KeyValueInputMerger.this.deserializer.deserialize((Writable)kvReadr1.getCurrentValue()), oi, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                        KeyValueInputMerger.this.kvReaderStandardObjMap.put(kvReadr1, row1);
                    }
                    if (KeyValueInputMerger.this.kvReaderStandardObjMap.containsKey(kvReadr2)) {
                        row2 = (List)KeyValueInputMerger.this.kvReaderStandardObjMap.get(kvReadr2);
                    } else {
                        row2 = (List)ObjectInspectorUtils.copyToStandardObject(KeyValueInputMerger.this.deserializer.deserialize((Writable)kvReadr2.getCurrentValue()), oi, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                        KeyValueInputMerger.this.kvReaderStandardObjMap.put(kvReadr2, row2);
                    }
                }
                catch (SerDeException e) {
                    throw new IOException(e);
                }
                StructObjectInspector structOI = (StructObjectInspector)oi;
                int compare = 0;
                int index = 0;
                for (StructField sf : KeyValueInputMerger.this.structFields) {
                    int pos = structOI.getAllStructFieldRefs().indexOf(sf);
                    Object key1 = row1.get(pos);
                    Object key2 = row2.get(pos);
                    ObjectInspector stdOI = (ObjectInspector)KeyValueInputMerger.this.fieldOIs.get(index);
                    compare = ObjectInspectorUtils.compare(key1, stdOI, key2, stdOI);
                    ++index;
                    if (compare == 0) continue;
                    return compare;
                }
                return compare;
            }
            catch (IOException e) {
                l4j.error("Caught exception while reading shuffle input", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

