/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.Decimal64ScalarMultiplyDecimal64Column;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

/**
 * Generated from template Decimal64ScalarArithmeticDecimal64ColumnUnscaled.txt.
 * Implements a vectorized arithmetic operator with a scalar on the left and a
 * column vector on the right unscaled. The result is output to an output column vector.
 */
public class Decimal64ScalarMultiplyDecimal64ColumnUnscaled extends Decimal64ScalarMultiplyDecimal64Column {

  public Decimal64ScalarMultiplyDecimal64ColumnUnscaled(long value, int colNum, int outputColumnNum) {
    super(value, colNum, outputColumnNum);
  }

  public Decimal64ScalarMultiplyDecimal64ColumnUnscaled() {
    super();
  }

  public String vectorExpressionParameters() {
    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo) inputTypeInfos[0];
    HiveDecimalWritable writable = new HiveDecimalWritable();
    writable.deserialize64(value, decimalTypeInfo.scale());
    return "decimal64Val " + value + ", decimalVal " + writable.toString() +
        ", " + getColumnParamString(1, inputColumnNum[0]);
  }

  @Override
  public VectorExpressionDescriptor.Descriptor getDescriptor() {
    return (new VectorExpressionDescriptor.Builder())
        .setMode(
            VectorExpressionDescriptor.Mode.PROJECTION)
        .setNumArguments(2)
        .setArgumentTypes(
            VectorExpressionDescriptor.ArgumentType.DECIMAL_64,
            VectorExpressionDescriptor.ArgumentType.DECIMAL_64)
        .setInputExpressionTypes(
            VectorExpressionDescriptor.InputExpressionType.SCALAR,
            VectorExpressionDescriptor.InputExpressionType.COLUMN)
        .setUnscaled(true).build();
  }
}
