/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class LazyHBaseRow
extends LazyStruct {
    private Result result;
    private List<HBaseSerDe.ColumnMapping> columnsMapping;
    private ArrayList<Object> cachedList;

    public LazyHBaseRow(LazySimpleStructObjectInspector oi) {
        super(oi);
    }

    public void init(Result r, List<HBaseSerDe.ColumnMapping> columnsMapping) {
        this.result = r;
        this.columnsMapping = columnsMapping;
        this.setParsed(false);
    }

    private void parse() {
        if (this.getFields() == null) {
            List fieldRefs = ((StructObjectInspector)this.getInspector()).getAllStructFieldRefs();
            LazyObject[] fields = new LazyObject[fieldRefs.size()];
            for (int i = 0; i < fields.length; ++i) {
                HBaseSerDe.ColumnMapping colMap = this.columnsMapping.get(i);
                fields[i] = colMap.qualifierName == null && !colMap.hbaseRowKey ? new LazyHBaseCellMap((LazyMapObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector()) : LazyFactory.createLazyObject((ObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector(), (boolean)colMap.binaryStorage.get(0));
            }
            this.setFields(fields);
            this.setFieldInited(new boolean[fields.length]);
        }
        Arrays.fill(this.getFieldInited(), false);
        this.setParsed(true);
    }

    public Object getField(int fieldID) {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.uncheckedGetField(fieldID);
    }

    private Object uncheckedGetField(int fieldID) {
        LazyObject[] fields = this.getFields();
        boolean[] fieldsInited = this.getFieldInited();
        if (!fieldsInited[fieldID]) {
            ByteArrayRef ref = null;
            HBaseSerDe.ColumnMapping colMap = this.columnsMapping.get(fieldID);
            if (colMap.hbaseRowKey) {
                ref = new ByteArrayRef();
                ref.setData(this.result.getRow());
            } else if (colMap.qualifierName == null) {
                ((LazyHBaseCellMap)fields[fieldID]).init(this.result, colMap.familyNameBytes, colMap.binaryStorage);
            } else {
                byte[] res = this.result.getValue(colMap.familyNameBytes, colMap.qualifierNameBytes);
                if (res == null) {
                    return null;
                }
                ref = new ByteArrayRef();
                ref.setData(res);
            }
            if (ref != null) {
                fields[fieldID].init(ref, 0, ref.getData().length);
            }
        }
        fieldsInited[fieldID] = true;
        return fields[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.getParsed()) {
            this.parse();
        }
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    public Object getObject() {
        return this;
    }
}

