/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseScanRange;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.ql.exec.ExprNodeConstantEvaluator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;

class HiveHBaseInputFormatUtil {
    private static final Log LOG = LogFactory.getLog(HiveHBaseInputFormatUtil.class);

    HiveHBaseInputFormatUtil() {
    }

    public static Scan getScan(JobConf jobConf) throws IOException {
        String filterObjectSerialized;
        String scanBatch;
        String scanCacheBlocks;
        String scanCache;
        ColumnMappings columnMappings;
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        boolean doColumnRegexMatching = jobConf.getBoolean("hbase.columns.mapping.regex.matching", true);
        List readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)jobConf);
        try {
            columnMappings = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping, doColumnRegexMatching);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        if (columnMappings.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        boolean readAllColumns = ColumnProjectionUtils.isReadAllColumns((Configuration)jobConf);
        Scan scan = new Scan();
        boolean empty = true;
        ArrayList<String> addedFamilies = new ArrayList<String>();
        if (!readAllColumns) {
            ColumnMappings.ColumnMapping[] columnsMapping = columnMappings.getColumnsMapping();
            Iterator iterator = readColIDs.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Object colMap = columnsMapping[i];
                if (((ColumnMappings.ColumnMapping)colMap).hbaseRowKey || ((ColumnMappings.ColumnMapping)colMap).hbaseTimestamp) continue;
                if (((ColumnMappings.ColumnMapping)colMap).qualifierName == null) {
                    scan.addFamily(((ColumnMappings.ColumnMapping)colMap).familyNameBytes);
                    addedFamilies.add(((ColumnMappings.ColumnMapping)colMap).familyName);
                } else if (!addedFamilies.contains(((ColumnMappings.ColumnMapping)colMap).familyName)) {
                    scan.addColumn(((ColumnMappings.ColumnMapping)colMap).familyNameBytes, ((ColumnMappings.ColumnMapping)colMap).qualifierNameBytes);
                }
                empty = false;
            }
        }
        if (empty) {
            if (readAllColumns) {
                for (ColumnMappings.ColumnMapping colMap : columnMappings) {
                    if (colMap.hbaseRowKey || colMap.hbaseTimestamp) continue;
                    if (colMap.qualifierName == null) {
                        scan.addFamily(colMap.familyNameBytes);
                        continue;
                    }
                    scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
                }
            } else {
                scan.setFilter((Filter)new FilterList(new Filter[]{new FirstKeyOnlyFilter(), new KeyOnlyFilter()}));
            }
        }
        if ((scanCache = jobConf.get("hbase.scan.cache")) != null) {
            scan.setCaching(Integer.parseInt(scanCache));
        }
        if ((scanCacheBlocks = jobConf.get("hbase.scan.cacheblock")) != null) {
            scan.setCacheBlocks(Boolean.parseBoolean(scanCacheBlocks));
        }
        if ((scanBatch = jobConf.get("hbase.scan.batch")) != null) {
            scan.setBatch(Integer.parseInt(scanBatch));
        }
        if ((filterObjectSerialized = jobConf.get("hive.io.filter.object")) != null) {
            HiveHBaseInputFormatUtil.setupScanRange(scan, filterObjectSerialized, jobConf, true);
        }
        return scan;
    }

    public static boolean getStorageFormatOfKey(String spec, String defaultFormat) throws IOException {
        String[] mapInfo = spec.split("#");
        boolean tblLevelDefault = "binary".equalsIgnoreCase(defaultFormat);
        switch (mapInfo.length) {
            case 1: {
                return tblLevelDefault;
            }
            case 2: {
                String storageType = mapInfo[1];
                if (storageType.equals("-")) {
                    return tblLevelDefault;
                }
                if ("string".startsWith(storageType)) {
                    return false;
                }
                if (!"binary".startsWith(storageType)) break;
                return true;
            }
        }
        throw new IOException("Malformed string: " + spec);
    }

    public static Map<String, List<IndexSearchCondition>> decompose(List<IndexSearchCondition> searchConditions) {
        HashMap<String, List<IndexSearchCondition>> result = new HashMap<String, List<IndexSearchCondition>>();
        for (IndexSearchCondition condition : searchConditions) {
            ArrayList<IndexSearchCondition> conditions = (ArrayList<IndexSearchCondition>)result.get(condition.getColumnDesc().getColumn());
            if (conditions == null) {
                conditions = new ArrayList<IndexSearchCondition>();
                result.put(condition.getColumnDesc().getColumn(), conditions);
            }
            conditions.add(condition);
        }
        return result;
    }

    static void setupScanRange(Scan scan, String filterObjectSerialized, JobConf jobConf, boolean filterOnly) throws IOException {
        HBaseScanRange range = (HBaseScanRange)SerializationUtilities.deserializeObject((String)filterObjectSerialized, HBaseScanRange.class);
        try {
            range.setup(scan, (Configuration)jobConf, filterOnly);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static void setupKeyRange(Scan scan, List<IndexSearchCondition> conditions, boolean isBinary) throws IOException {
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        for (IndexSearchCondition sc : conditions) {
            Object writable;
            PrimitiveObjectInspector objInspector;
            ExprNodeConstantEvaluator eval = new ExprNodeConstantEvaluator(sc.getConstantDesc());
            try {
                objInspector = (PrimitiveObjectInspector)eval.initialize(null);
                writable = eval.evaluate(null);
            }
            catch (ClassCastException cce) {
                throw new IOException("Currently only primitve types are supported. Found: " + sc.getConstantDesc().getTypeString());
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
            byte[] constantVal = HiveHBaseInputFormatUtil.getConstantVal(writable, objInspector, isBinary);
            String comparisonOp = sc.getComparisonOp();
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual".equals(comparisonOp)) {
                startRow = constantVal;
                stopRow = HiveHBaseInputFormatUtil.getNextBA(constantVal);
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan".equals(comparisonOp)) {
                stopRow = constantVal;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan".equals(comparisonOp)) {
                startRow = constantVal;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan".equals(comparisonOp)) {
                startRow = HiveHBaseInputFormatUtil.getNextBA(constantVal);
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan".equals(comparisonOp)) {
                stopRow = HiveHBaseInputFormatUtil.getNextBA(constantVal);
                continue;
            }
            throw new IOException(comparisonOp + " is not a supported comparison operator");
        }
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Bytes.toStringBinary((byte[])startRow) + " ~ " + Bytes.toStringBinary((byte[])stopRow)));
        }
    }

    static void setupTimeRange(Scan scan, List<IndexSearchCondition> conditions) throws IOException {
        long start = 0L;
        long end = Long.MAX_VALUE;
        for (IndexSearchCondition sc : conditions) {
            long timestamp = HiveHBaseInputFormatUtil.getTimestampVal(sc);
            String comparisonOp = sc.getComparisonOp();
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual".equals(comparisonOp)) {
                start = timestamp;
                end = timestamp + 1L;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan".equals(comparisonOp)) {
                end = timestamp;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan".equals(comparisonOp)) {
                start = timestamp;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan".equals(comparisonOp)) {
                start = timestamp + 1L;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan".equals(comparisonOp)) {
                end = timestamp + 1L;
                continue;
            }
            throw new IOException(comparisonOp + " is not a supported comparison operator");
        }
        scan.setTimeRange(start, end);
    }

    static long getTimestampVal(IndexSearchCondition sc) throws IOException {
        long timestamp;
        try {
            ExprNodeConstantEvaluator eval = new ExprNodeConstantEvaluator(sc.getConstantDesc());
            ObjectInspector inspector = eval.initialize(null);
            Object value = eval.evaluate(null);
            if (inspector instanceof LongObjectInspector) {
                timestamp = ((LongObjectInspector)inspector).get(value);
            } else {
                PrimitiveObjectInspector primitive = (PrimitiveObjectInspector)inspector;
                timestamp = PrimitiveObjectInspectorUtils.getTimestamp((Object)value, (PrimitiveObjectInspector)primitive).toEpochMilli();
            }
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        return timestamp;
    }

    static byte[] getConstantVal(Object writable, PrimitiveObjectInspector poi, boolean isKeyBinary) throws IOException {
        if (!isKeyBinary) {
            ByteStream.Output serializeStream = new ByteStream.Output();
            LazyUtils.writePrimitiveUTF8((OutputStream)serializeStream, (Object)writable, (PrimitiveObjectInspector)poi, (boolean)false, (byte)0, null);
            byte[] startRow = new byte[serializeStream.getLength()];
            System.arraycopy(serializeStream.getData(), 0, startRow, 0, serializeStream.getLength());
            return startRow;
        }
        PrimitiveObjectInspector.PrimitiveCategory pc = poi.getPrimitiveCategory();
        switch (poi.getPrimitiveCategory()) {
            case INT: {
                return Bytes.toBytes((int)((IntWritable)writable).get());
            }
            case BOOLEAN: {
                return Bytes.toBytes((boolean)((BooleanWritable)writable).get());
            }
            case LONG: {
                return Bytes.toBytes((long)((LongWritable)writable).get());
            }
            case FLOAT: {
                return Bytes.toBytes((float)((FloatWritable)writable).get());
            }
            case DOUBLE: {
                return Bytes.toBytes((double)((DoubleWritable)writable).get());
            }
            case SHORT: {
                return Bytes.toBytes((short)((ShortWritable)writable).get());
            }
            case STRING: {
                return Bytes.toBytes((String)((Text)writable).toString());
            }
            case BYTE: {
                return Bytes.toBytes((short)((ByteWritable)writable).get());
            }
        }
        throw new IOException("Type not supported " + pc);
    }

    static byte[] getNextBA(byte[] current) {
        byte[] next = new byte[current.length + 1];
        System.arraycopy(current, 0, next, 0, current.length);
        return next;
    }
}

