/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.hive.hplsql.Column;
import org.apache.hive.hplsql.Interval;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.Utils;

public class Var {
    public static final String DERIVED_TYPE = "DERIVED%TYPE";
    public static final String DERIVED_ROWTYPE = "DERIVED%ROWTYPE";
    public static Var Empty = new Var();
    public static Var Null = new Var(Type.NULL);
    public String name;
    public Type type;
    public Object value;
    int len;
    int scale;
    boolean constant = false;

    public Var() {
        this.type = Type.NULL;
    }

    public Var(Var var) {
        this.name = var.name;
        this.type = var.type;
        this.value = var.value;
        this.len = var.len;
        this.scale = var.scale;
    }

    public Var(Long value) {
        this.type = Type.BIGINT;
        this.value = value;
    }

    public Var(BigDecimal value) {
        this.type = Type.DECIMAL;
        this.value = value;
    }

    public Var(String name, Long value) {
        this.type = Type.BIGINT;
        this.name = name;
        this.value = value;
    }

    public Var(String value) {
        this.type = Type.STRING;
        this.value = value;
    }

    public Var(Double value) {
        this.type = Type.DOUBLE;
        this.value = value;
    }

    public Var(Date value) {
        this.type = Type.DATE;
        this.value = value;
    }

    public Var(Timestamp value, int scale) {
        this.type = Type.TIMESTAMP;
        this.value = value;
        this.scale = scale;
    }

    public Var(Interval value) {
        this.type = Type.INTERVAL;
        this.value = value;
    }

    public Var(ArrayList<String> value) {
        this.type = Type.STRINGLIST;
        this.value = value;
    }

    public Var(Boolean b) {
        this.type = Type.BOOL;
        this.value = b;
    }

    public Var(String name, Row row) {
        this.name = name;
        this.type = Type.ROW;
        this.value = new Row(row);
    }

    public Var(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public Var(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Var(String name, Type type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Var(Type type) {
        this.type = type;
    }

    public Var(String name, String type, String len, String scale, Var def) {
        this.name = name;
        this.setType(type);
        if (len != null) {
            this.len = Integer.parseInt(len);
        }
        if (scale != null) {
            this.scale = Integer.parseInt(scale);
        }
        if (def != null) {
            this.cast(def);
        }
    }

    public Var cast(Var val) {
        if (this.constant) {
            return this;
        }
        if (val == null || val.value == null) {
            this.value = null;
        } else if (this.type == Type.DERIVED_TYPE) {
            this.type = val.type;
            this.value = val.value;
        } else if (this.type == val.type && this.type == Type.STRING) {
            this.cast((String)val.value);
        } else if (this.type == val.type) {
            this.value = val.value;
        } else if (this.type == Type.STRING) {
            this.cast(val.toString());
        } else if (this.type == Type.BIGINT) {
            if (val.type == Type.STRING) {
                this.value = Long.parseLong((String)val.value);
            }
        } else if (this.type == Type.DECIMAL) {
            if (val.type == Type.STRING) {
                this.value = new BigDecimal((String)val.value);
            } else if (val.type == Type.BIGINT) {
                this.value = BigDecimal.valueOf(val.longValue());
            } else if (val.type == Type.DOUBLE) {
                this.value = BigDecimal.valueOf(val.doubleValue());
            }
        } else if (this.type == Type.DOUBLE) {
            if (val.type == Type.STRING) {
                this.value = new Double((String)val.value);
            } else if (val.type == Type.BIGINT || val.type == Type.DECIMAL) {
                this.value = val.doubleValue();
            }
        } else if (this.type == Type.DATE) {
            this.value = Utils.toDate(val.toString());
        } else if (this.type == Type.TIMESTAMP) {
            this.value = Utils.toTimestamp(val.toString());
        }
        return this;
    }

    public Var cast(String val) {
        if (!this.constant && this.type == Type.STRING) {
            int l;
            if (this.len != 0 && (l = val.length()) > this.len) {
                this.value = val.substring(0, this.len);
                return this;
            }
            this.value = val;
        }
        return this;
    }

    public void setValue(String str) {
        if (!this.constant && this.type == Type.STRING) {
            this.value = str;
        }
    }

    public Var setValue(Long val) {
        if (!this.constant && this.type == Type.BIGINT) {
            this.value = val;
        }
        return this;
    }

    public Var setValue(Boolean val) {
        if (!this.constant && this.type == Type.BOOL) {
            this.value = val;
        }
        return this;
    }

    public void setValue(Object value) {
        if (!this.constant) {
            this.value = value;
        }
    }

    public Var setValue(ResultSet rs, ResultSetMetaData rsm, int idx) throws SQLException {
        int type = rsm.getColumnType(idx);
        if (type == 1 || type == 12) {
            this.cast(new Var(rs.getString(idx)));
        } else if (type == 4 || type == -5 || type == 5 || type == -6) {
            this.cast(new Var(new Long(rs.getLong(idx))));
        } else if (type == 3 || type == 2) {
            this.cast(new Var(rs.getBigDecimal(idx)));
        } else if (type == 6 || type == 8) {
            this.cast(new Var(new Double(rs.getDouble(idx))));
        }
        return this;
    }

    public Var setValues(ResultSet rs, ResultSetMetaData rsm) throws SQLException {
        Row row = (Row)this.value;
        int idx = 1;
        for (Column column : row.getColumns()) {
            Var var = new Var(column.getName(), column.getType(), null, null, null);
            var.setValue(rs, rsm, idx);
            column.setValue(var);
            ++idx;
        }
        return this;
    }

    void setType(String type) {
        this.type = Var.defineType(type);
    }

    void setType(int type) {
        this.type = Var.defineType(type);
    }

    void setConstant(boolean constant) {
        this.constant = constant;
    }

    public static Type defineType(String type) {
        if (type == null) {
            return Type.NULL;
        }
        if (type.equalsIgnoreCase("INT") || type.equalsIgnoreCase("INTEGER") || type.equalsIgnoreCase("BIGINT") || type.equalsIgnoreCase("SMALLINT") || type.equalsIgnoreCase("TINYINT") || type.equalsIgnoreCase("BINARY_INTEGER") || type.equalsIgnoreCase("PLS_INTEGER") || type.equalsIgnoreCase("SIMPLE_INTEGER") || type.equalsIgnoreCase("INT2") || type.equalsIgnoreCase("INT4") || type.equalsIgnoreCase("INT8")) {
            return Type.BIGINT;
        }
        if (type.equalsIgnoreCase("CHAR") || type.equalsIgnoreCase("VARCHAR") || type.equalsIgnoreCase("VARCHAR2") || type.equalsIgnoreCase("STRING") || type.equalsIgnoreCase("XML")) {
            return Type.STRING;
        }
        if (type.equalsIgnoreCase("DEC") || type.equalsIgnoreCase("DECIMAL") || type.equalsIgnoreCase("NUMERIC") || type.equalsIgnoreCase("NUMBER")) {
            return Type.DECIMAL;
        }
        if (type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("FLOAT") || type.toUpperCase().startsWith("DOUBLE") || type.equalsIgnoreCase("BINARY_FLOAT") || type.toUpperCase().startsWith("BINARY_DOUBLE") || type.equalsIgnoreCase("SIMPLE_FLOAT") || type.toUpperCase().startsWith("SIMPLE_DOUBLE")) {
            return Type.DOUBLE;
        }
        if (type.equalsIgnoreCase("DATE")) {
            return Type.DATE;
        }
        if (type.equalsIgnoreCase("TIMESTAMP")) {
            return Type.TIMESTAMP;
        }
        if (type.equalsIgnoreCase("BOOL") || type.equalsIgnoreCase("BOOLEAN")) {
            return Type.BOOL;
        }
        if (type.equalsIgnoreCase("SYS_REFCURSOR")) {
            return Type.CURSOR;
        }
        if (type.equalsIgnoreCase("UTL_FILE.FILE_TYPE")) {
            return Type.FILE;
        }
        if (type.toUpperCase().startsWith("RESULT_SET_LOCATOR")) {
            return Type.RS_LOCATOR;
        }
        if (type.equalsIgnoreCase(DERIVED_TYPE)) {
            return Type.DERIVED_TYPE;
        }
        return Type.NULL;
    }

    public static Type defineType(int type) {
        if (type == 1 || type == 12) {
            return Type.STRING;
        }
        if (type == 4 || type == -5) {
            return Type.BIGINT;
        }
        return Type.NULL;
    }

    public void removeValue() {
        this.type = Type.NULL;
        this.name = null;
        this.value = null;
        this.len = 0;
        this.scale = 0;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Var var = (Var)obj;
        if (this == var) {
            return true;
        }
        if (var == null || var.value == null || this.value == null) {
            return false;
        }
        if (this.type == Type.BIGINT) {
            if (var.type == Type.BIGINT && ((Long)this.value).longValue() == ((Long)var.value).longValue()) {
                return true;
            }
            if (var.type == Type.DECIMAL) {
                return this.equals((BigDecimal)var.value, (Long)this.value);
            }
        } else {
            if (this.type == Type.STRING && var.type == Type.STRING && ((String)this.value).equals((String)var.value)) {
                return true;
            }
            if (this.type == Type.DECIMAL && var.type == Type.DECIMAL && ((BigDecimal)this.value).compareTo((BigDecimal)var.value) == 0) {
                return true;
            }
            if (this.type == Type.DOUBLE) {
                if (var.type == Type.DOUBLE && ((Double)this.value).compareTo((Double)var.value) == 0) {
                    return true;
                }
                if (var.type == Type.DECIMAL && ((Double)this.value).compareTo(((BigDecimal)var.value).doubleValue()) == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(BigDecimal d, Long i) {
        return d.compareTo(new BigDecimal(i)) == 0;
    }

    public int compareTo(Var v) {
        if (this == v) {
            return 0;
        }
        if (v == null) {
            return -1;
        }
        if (this.type == Type.BIGINT && v.type == Type.BIGINT) {
            return ((Long)this.value).compareTo((Long)v.value);
        }
        if (this.type == Type.STRING && v.type == Type.STRING) {
            return ((String)this.value).compareTo((String)v.value);
        }
        return -1;
    }

    public BigDecimal percentDiff(Var var) {
        BigDecimal d1 = new Var(Type.DECIMAL).cast(this).decimalValue();
        BigDecimal d2 = new Var(Type.DECIMAL).cast(var).decimalValue();
        if (d1 != null && d2 != null && d1.compareTo(BigDecimal.ZERO) != 0) {
            return d1.subtract(d2).abs().multiply(new BigDecimal(100)).divide(d1, 2, RoundingMode.HALF_UP);
        }
        return null;
    }

    public Var increment(Long i) {
        if (this.type == Type.BIGINT) {
            this.value = new Long((Long)this.value + i);
        }
        return this;
    }

    public Var decrement(Long i) {
        if (this.type == Type.BIGINT) {
            this.value = new Long((Long)this.value - i);
        }
        return this;
    }

    public int intValue() {
        if (this.type == Type.BIGINT) {
            return ((Long)this.value).intValue();
        }
        if (this.type == Type.STRING) {
            return Integer.parseInt((String)this.value);
        }
        throw new NumberFormatException();
    }

    public long longValue() {
        if (this.type == Type.BIGINT) {
            return (Long)this.value;
        }
        throw new NumberFormatException();
    }

    public BigDecimal decimalValue() {
        if (this.type == Type.DECIMAL) {
            return (BigDecimal)this.value;
        }
        throw new NumberFormatException();
    }

    public double doubleValue() {
        if (this.type == Type.DOUBLE) {
            return (Double)this.value;
        }
        if (this.type == Type.BIGINT) {
            return ((Long)this.value).doubleValue();
        }
        if (this.type == Type.DECIMAL) {
            return ((BigDecimal)this.value).doubleValue();
        }
        throw new NumberFormatException();
    }

    public boolean isTrue() {
        if (this.type == Type.BOOL && this.value != null) {
            return (Boolean)this.value;
        }
        return false;
    }

    public void negate() {
        if (this.type == Type.BOOL && this.value != null) {
            boolean v = (Boolean)this.value;
            this.value = !v;
        }
    }

    public boolean isNull() {
        return this.type == Type.NULL || this.value == null;
    }

    public String toString() {
        if (this.type == Type.IDENT) {
            return this.name;
        }
        if (this.value == null) {
            return null;
        }
        if (this.type == Type.BIGINT) {
            return ((Long)this.value).toString();
        }
        if (this.type == Type.STRING) {
            return (String)this.value;
        }
        if (this.type == Type.DATE) {
            return ((Date)this.value).toString();
        }
        if (this.type == Type.TIMESTAMP) {
            int len = 19;
            String t = ((Timestamp)this.value).toString();
            if (this.scale > 0) {
                len += this.scale + 1;
            }
            if (t.length() > len) {
                t = t.substring(0, len);
            }
            return t;
        }
        return this.value.toString();
    }

    public String toSqlString() {
        if (this.value == null) {
            return "NULL";
        }
        if (this.type == Type.STRING) {
            return Utils.quoteString((String)this.value);
        }
        return this.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static enum Type {
        BOOL,
        CURSOR,
        DATE,
        DECIMAL,
        DERIVED_TYPE,
        DERIVED_ROWTYPE,
        DOUBLE,
        FILE,
        IDENT,
        BIGINT,
        INTERVAL,
        ROW,
        RS_LOCATOR,
        STRING,
        STRINGLIST,
        TIMESTAMP,
        NULL;

    }
}

