/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hive.hplsql.Arguments;
import org.apache.hive.hplsql.Cmp;
import org.apache.hive.hplsql.ColumnDefinition;
import org.apache.hive.hplsql.ColumnType;
import org.apache.hive.hplsql.Conf;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Console;
import org.apache.hive.hplsql.Converter;
import org.apache.hive.hplsql.Copy;
import org.apache.hive.hplsql.Expression;
import org.apache.hive.hplsql.Handler;
import org.apache.hive.hplsql.HplSqlSessionState;
import org.apache.hive.hplsql.HplValidationException;
import org.apache.hive.hplsql.HplsqlBaseVisitor;
import org.apache.hive.hplsql.HplsqlLexer;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Interval;
import org.apache.hive.hplsql.Meta;
import org.apache.hive.hplsql.Package;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.ResultListener;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Select;
import org.apache.hive.hplsql.Signal;
import org.apache.hive.hplsql.SqlCodes;
import org.apache.hive.hplsql.Stmt;
import org.apache.hive.hplsql.StreamGobbler;
import org.apache.hive.hplsql.SyntaxErrorReporter;
import org.apache.hive.hplsql.TypeException;
import org.apache.hive.hplsql.UndefinedIdentException;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.JdbcQueryExecutor;
import org.apache.hive.hplsql.executor.Metadata;
import org.apache.hive.hplsql.executor.QueryException;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.functions.BuiltinFunctions;
import org.apache.hive.hplsql.functions.FunctionDatetime;
import org.apache.hive.hplsql.functions.FunctionMisc;
import org.apache.hive.hplsql.functions.FunctionRegistry;
import org.apache.hive.hplsql.functions.FunctionString;
import org.apache.hive.hplsql.functions.HmsFunctionRegistry;
import org.apache.hive.hplsql.functions.InMemoryFunctionRegistry;
import org.apache.hive.hplsql.objects.DbmOutput;
import org.apache.hive.hplsql.objects.DbmOutputClass;
import org.apache.hive.hplsql.objects.HplObject;
import org.apache.hive.hplsql.objects.Method;
import org.apache.hive.hplsql.objects.MethodParams;
import org.apache.hive.hplsql.objects.Table;
import org.apache.hive.hplsql.objects.TableClass;
import org.apache.hive.hplsql.objects.UtlFile;
import org.apache.hive.hplsql.objects.UtlFileClass;
import org.apache.hive.hplsql.packages.HmsPackageRegistry;
import org.apache.hive.hplsql.packages.InMemoryPackageRegistry;
import org.apache.hive.hplsql.packages.PackageRegistry;

public class Exec
extends HplsqlBaseVisitor<Integer>
implements Closeable {
    public static final String VERSION = "HPL/SQL 0.3.31";
    public static final String ERRORCODE = "ERRORCODE";
    public static final String SQLCODE = "SQLCODE";
    public static final String SQLSTATE = "SQLSTATE";
    public static final String HOSTCODE = "HOSTCODE";
    Exec exec;
    private IMetaStoreClient msc;
    FunctionRegistry functions;
    private BuiltinFunctions builtinFunctions;
    QueryExecutor queryExecutor;
    private HplSqlSessionState hplSqlSession;
    private PackageRegistry packageRegistry = new InMemoryPackageRegistry();
    private boolean packageLoading = false;
    private Map<String, TableClass> types = new HashMap<String, TableClass>();
    Stack<Scope> scopes = new Stack();
    Scope globalScope;
    Scope currentScope;
    Stack<Var> stack = new Stack();
    Stack<String> labels = new Stack();
    Stack<String> callStack = new Stack();
    Stack<Signal> signals = new Stack();
    Signal currentSignal;
    Scope currentHandlerScope;
    boolean resignal = false;
    HashMap<String, String> managedTables = new HashMap();
    HashMap<String, String> objectMap = new HashMap();
    HashMap<String, String> objectConnMap = new HashMap();
    HashMap<String, ArrayList<Var>> returnCursors = new HashMap();
    HashMap<String, Package> packages = new HashMap();
    Package currentPackageDecl = null;
    public ArrayList<String> stmtConnList = new ArrayList();
    Arguments arguments = new Arguments();
    public Conf conf;
    Expression expr;
    Converter converter;
    Meta meta;
    Select select;
    Stmt stmt;
    Conn conn;
    Console console = Console.STANDARD;
    int rowCount = 0;
    StringBuilder localUdf = new StringBuilder();
    boolean initRoutines = false;
    public boolean buildSql = false;
    public boolean inCallStmt = false;
    boolean udfRegistered = false;
    boolean udfRun = false;
    boolean dotHplsqlrcExists = false;
    boolean hplsqlrcExists = false;
    boolean trace = false;
    boolean info = true;
    boolean offline = false;

    public Exec() {
        this.exec = this;
        this.queryExecutor = new JdbcQueryExecutor(this);
    }

    public Exec(Conf conf, Console console, QueryExecutor queryExecutor, IMetaStoreClient msc, HplSqlSessionState hplSqlSession) {
        this.conf = conf;
        this.exec = this;
        this.console = console;
        this.queryExecutor = queryExecutor;
        this.msc = msc;
        this.hplSqlSession = hplSqlSession;
    }

    Exec(Exec exec) {
        this.exec = exec;
        this.console = exec.console;
        this.queryExecutor = exec.queryExecutor;
    }

    public Var setVariable(String name, Var value) {
        if (value == null || value == Var.Empty) {
            if (this.exec.stack.empty()) {
                return Var.Empty;
            }
            value = this.exec.stack.pop();
        }
        if (name.startsWith("hplsql.")) {
            this.exec.conf.setOption(name, value.toString());
            return Var.Empty;
        }
        Var var = this.findVariable(name);
        if (var != null) {
            var.cast(value);
        } else {
            var = new Var(value);
            var.setName(name);
            if (this.exec.currentScope != null) {
                this.exec.currentScope.addVariable(var);
            }
        }
        return var;
    }

    public Var setVariable(String name) {
        return this.setVariable(name, Var.Empty);
    }

    public Var setVariable(String name, String value) {
        return this.setVariable(name, new Var(value));
    }

    public Var setVariable(String name, int value) {
        return this.setVariable(name, new Var(Long.valueOf(value)));
    }

    public Var setVariableToNull(String name) {
        Var var = this.findVariable(name);
        if (var != null) {
            var.removeValue();
        } else {
            var = new Var();
            var.setName(name);
            if (this.exec.currentScope != null) {
                this.exec.currentScope.addVariable(var);
            }
        }
        return var;
    }

    public void addVariable(Var var) {
        if (this.currentPackageDecl != null) {
            this.currentPackageDecl.addVariable(var);
        } else if (this.exec.currentScope != null) {
            this.exec.currentScope.addVariable(var);
        }
    }

    public void addHandler(Handler handler) {
        if (this.exec.currentScope != null) {
            this.exec.currentScope.addHandler(handler);
        }
    }

    public void addReturnCursor(Var var) {
        String routine = this.callStackPeek();
        ArrayList cursors = this.returnCursors.computeIfAbsent(routine, k -> new ArrayList());
        cursors.add(var);
    }

    public Var consumeReturnCursor(String routine) {
        ArrayList<Var> cursors = this.returnCursors.get(routine.toUpperCase());
        if (cursors == null) {
            return null;
        }
        Var var = cursors.get(0);
        cursors.remove(0);
        return var;
    }

    public void stackPush(Var var) {
        this.exec.stack.push(var);
    }

    public void stackPush(String val) {
        this.exec.stack.push(new Var(val));
    }

    public void stackPush(StringBuilder val) {
        this.stackPush(val.toString());
    }

    public void stackPush(Boolean val) {
        this.exec.stack.push(new Var(val));
    }

    public Var stackPeek() {
        return this.exec.stack.peek();
    }

    public Var stackPop() {
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stack.pop();
        }
        return Var.Empty;
    }

    public void callStackPush(String val) {
        this.exec.callStack.push(val.toUpperCase());
    }

    public String callStackPeek() {
        if (!this.exec.callStack.isEmpty()) {
            return this.exec.callStack.peek();
        }
        return null;
    }

    public String callStackPop() {
        if (!this.exec.callStack.isEmpty()) {
            return this.exec.callStack.pop();
        }
        return null;
    }

    public Var findVariable(String name) {
        Var var;
        String name1 = name.toUpperCase();
        String name1a = null;
        String name2 = null;
        Scope cur = this.exec.currentScope;
        Package packCallContext = this.exec.getPackageCallContext();
        ArrayList<String> qualified = this.exec.meta.splitIdentifier(name);
        if (qualified != null) {
            name1 = qualified.get(0).toUpperCase();
            name2 = qualified.get(1).toUpperCase();
            Package pack = this.findPackage(name1);
            if (pack != null && (var = pack.findVariable(name2)) != null) {
                return var;
            }
        }
        if (name1.startsWith(":")) {
            name1a = name1.substring(1);
        }
        while (cur != null) {
            var = this.findVariable(cur.vars, name1);
            if (var == null && name1a != null) {
                var = this.findVariable(cur.vars, name1a);
            }
            if (var == null && packCallContext != null) {
                var = packCallContext.findVariable(name1);
            }
            if (var != null) {
                return var;
            }
            if (cur.type == Scope.Type.ROUTINE) {
                cur = this.exec.globalScope;
                continue;
            }
            cur = cur.parent;
        }
        return null;
    }

    public Var findVariable(Var name) {
        return this.findVariable(name.getName());
    }

    Var findVariable(Map<String, Var> vars, String name) {
        return vars.get(name.toUpperCase());
    }

    public Var findCursor(String name) {
        Var cursor = this.exec.findVariable(name);
        if (cursor != null && cursor.type == Var.Type.CURSOR) {
            return cursor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Package findPackage(String name) {
        Package pkg = this.packages.get(name.toUpperCase());
        if (pkg != null) {
            return pkg;
        }
        Optional<String> source = this.exec.packageRegistry.getPackage(name);
        if (source.isPresent()) {
            HplsqlLexer lexer = new HplsqlLexer((CharStream)new ANTLRInputStream(source.get()));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            HplsqlParser parser = this.newParser(tokens);
            this.exec.packageLoading = true;
            try {
                this.visit((ParseTree)parser.program());
            }
            finally {
                this.exec.packageLoading = false;
            }
        } else {
            return null;
        }
        return this.packages.get(name.toUpperCase());
    }

    public void enterScope(Scope scope) {
        this.exec.scopes.push(scope);
    }

    public void enterScope(Scope.Type type) {
        this.enterScope(type, null);
    }

    public void enterScope(Scope.Type type, Package pack) {
        this.exec.currentScope = new Scope(this.exec.currentScope, type, pack);
        this.enterScope(this.exec.currentScope);
    }

    public void enterGlobalScope() {
        this.currentScope = this.globalScope = new Scope(Scope.Type.GLOBAL);
        this.enterScope(this.globalScope);
    }

    public void leaveScope() {
        if (!this.exec.signals.empty()) {
            Scope scope = this.exec.scopes.peek();
            Signal signal = this.exec.signals.peek();
            if (this.exec.conf.onError != OnError.SETERROR) {
                this.runExitHandler();
            }
            if (signal.type == Signal.Type.LEAVE_ROUTINE && scope.type == Scope.Type.ROUTINE) {
                this.exec.signals.pop();
            }
        }
        this.exec.currentScope = this.exec.scopes.pop().getParent();
    }

    public void signal(Signal signal) {
        this.exec.signals.push(signal);
    }

    public void signal(Signal.Type type, String value, Exception exception) {
        this.signal(new Signal(type, value, exception));
    }

    public void signal(Signal.Type type, String value) {
        this.setSqlCode(SqlCodes.ERROR);
        this.signal(type, value, null);
    }

    public void signal(Signal.Type type) {
        this.setSqlCode(SqlCodes.ERROR);
        this.signal(type, null, null);
    }

    public void signal(Query query) {
        this.setSqlCode(query.getException());
        this.signal(Signal.Type.SQLEXCEPTION, query.errorText(), query.getException());
    }

    public void signal(QueryResult query) {
        this.setSqlCode(query.exception());
        this.signal(Signal.Type.SQLEXCEPTION, query.errorText(), query.exception());
    }

    public void signal(Exception exception) {
        this.setSqlCode(exception);
        this.signal(Signal.Type.SQLEXCEPTION, exception.getMessage(), exception);
    }

    public void resignal() {
        this.resignal(this.exec.currentSignal);
    }

    public void resignal(Signal signal) {
        if (signal != null) {
            this.exec.resignal = true;
            this.signal(signal);
        }
    }

    boolean runContinueHandler() {
        Scope cur = this.exec.currentScope;
        this.exec.currentSignal = this.exec.signals.pop();
        while (cur != null) {
            for (Handler h : cur.handlers) {
                if (h.execType != Handler.ExecType.CONTINUE || (h.type == Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type) && (h.type != Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type || !h.value.equalsIgnoreCase(this.exec.currentSignal.value))) continue;
                this.trace(h.ctx, "CONTINUE HANDLER");
                this.enterScope(Scope.Type.HANDLER);
                this.exec.currentHandlerScope = h.scope;
                this.visit((ParseTree)h.ctx.single_block_stmt());
                this.leaveScope();
                this.exec.currentSignal = null;
                return true;
            }
            cur = cur.parent;
        }
        this.exec.signals.push(this.exec.currentSignal);
        this.exec.currentSignal = null;
        return false;
    }

    boolean runExitHandler() {
        this.exec.currentSignal = this.exec.signals.pop();
        for (Handler h : this.currentScope.handlers) {
            if (h.execType != Handler.ExecType.EXIT || (h.type == Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type) && (h.type != Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type || !h.value.equalsIgnoreCase(this.currentSignal.value))) continue;
            this.trace(h.ctx, "EXIT HANDLER");
            this.enterScope(Scope.Type.HANDLER);
            this.exec.currentHandlerScope = h.scope;
            this.visit((ParseTree)h.ctx.single_block_stmt());
            this.leaveScope();
            this.exec.currentSignal = null;
            return true;
        }
        this.exec.signals.push(this.exec.currentSignal);
        this.exec.currentSignal = null;
        return false;
    }

    public Signal signalPop() {
        if (!this.exec.signals.empty()) {
            return this.exec.signals.pop();
        }
        return null;
    }

    public Signal signalPeek() {
        if (!this.exec.signals.empty()) {
            return this.exec.signals.peek();
        }
        return null;
    }

    public String labelPop() {
        if (!this.exec.labels.empty()) {
            return this.exec.labels.pop();
        }
        return "";
    }

    public Query executeQuery(ParserRuleContext ctx, Query query, String connProfile) {
        if (!this.exec.offline) {
            this.exec.rowCount = 0;
            this.exec.conn.executeQuery(query, connProfile);
            return query;
        }
        this.setSqlNoData();
        this.info(ctx, "Not executed - offline mode set");
        return query;
    }

    public void registerUdf() {
        String lu;
        if (this.udfRegistered) {
            return;
        }
        ArrayList<String> sql = new ArrayList<String>();
        String dir = Utils.getExecDir();
        String hplsqlJarName = "hplsql.jar";
        for (String jarName : new File(dir).list()) {
            if (!jarName.startsWith("hive-hplsql") || !jarName.endsWith(".jar")) continue;
            hplsqlJarName = jarName;
            break;
        }
        sql.add("ADD JAR " + dir + hplsqlJarName);
        sql.add("ADD JAR " + dir + "antlr4-runtime-4.5.jar");
        if (!this.conf.getLocation().equals("")) {
            sql.add("ADD FILE " + this.conf.getLocation());
        } else {
            sql.add("ADD FILE " + dir + "hplsql-site.xml");
        }
        if (this.dotHplsqlrcExists) {
            sql.add("ADD FILE " + dir + ".hplsqlrc");
        }
        if (this.hplsqlrcExists) {
            sql.add("ADD FILE " + dir + "hplsqlrc");
        }
        if ((lu = this.createLocalUdf()) != null) {
            sql.add("ADD FILE " + lu);
        }
        sql.add("CREATE TEMPORARY FUNCTION hplsql AS 'org.apache.hive.hplsql.udf.Udf'");
        this.exec.conn.addPreSql(this.exec.conf.defaultConnection, sql);
        this.udfRegistered = true;
    }

    void initOptions() {
        Iterator iterator = this.exec.conf.iterator();
        while (iterator.hasNext()) {
            Map.Entry item = (Map.Entry)iterator.next();
            String key = (String)item.getKey();
            String value = (String)item.getValue();
            if (key == null || value == null || !key.startsWith("hplsql.")) continue;
            if (key.compareToIgnoreCase("hplsql.conn.default") == 0) {
                this.exec.conf.defaultConnection = value;
                continue;
            }
            if (key.startsWith("hplsql.conn.init.")) {
                this.exec.conn.addConnectionInit(key.substring(17), value);
                continue;
            }
            if (key.startsWith("hplsql.conn.convert.")) {
                this.exec.conf.setConnectionConvert(key.substring(20), value);
                continue;
            }
            if (key.startsWith("hplsql.conn.")) {
                this.exec.conn.addConnection(key.substring(12), value);
                continue;
            }
            if (!key.startsWith("hplsql.")) continue;
            this.exec.conf.setOption(key, value);
        }
    }

    public void setSqlCode(int sqlcode) {
        Long code = sqlcode;
        Var var = this.findVariable(SQLCODE);
        if (var != null) {
            var.setValue(code);
        }
        if ((var = this.findVariable(ERRORCODE)) != null) {
            var.setValue(code);
        }
    }

    public void setSqlCode(Exception exception) {
        if (exception instanceof QueryException) {
            this.setSqlCode(((QueryException)exception).getErrorCode());
            this.setSqlState(((QueryException)exception).getSQLState());
        } else {
            this.setSqlCode(SqlCodes.ERROR);
            this.setSqlState("02000");
        }
    }

    public void setSqlState(String sqlstate) {
        Var var = this.findVariable(SQLSTATE);
        if (var != null) {
            var.setValue(sqlstate);
        }
    }

    public void setResultListener(ResultListener resultListener) {
        this.select.setResultListener(resultListener);
    }

    public void setHostCode(int code) {
        Var var = this.findVariable(HOSTCODE);
        if (var != null) {
            var.setValue(Long.valueOf(code));
        }
    }

    public void setSqlSuccess() {
        this.setSqlCode(SqlCodes.SUCCESS);
        this.setSqlState("00000");
    }

    public void setSqlNoData() {
        this.setSqlCode(SqlCodes.NO_DATA_FOUND);
        this.setSqlState("01000");
    }

    public Integer run(String[] args) throws Exception {
        if (!this.parseArguments(args)) {
            return -1;
        }
        this.init();
        try {
            this.parseAndEval(this.arguments);
        }
        finally {
            this.close();
        }
        return this.getProgramReturnCode();
    }

    public Var parseAndEval(Arguments arguments) {
        ParseTree tree;
        try (InputStream input = this.sourceStream(arguments);){
            tree = this.parse(input);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Var result = null;
        try {
            result = this.evaluate(tree, arguments.main);
        }
        catch (HplValidationException e) {
            this.signal(Signal.Type.VALIDATION, e.getMessage(), e);
        }
        if (result != null) {
            this.console.printLine(result.toString());
        }
        return result;
    }

    private Var evaluate(ParseTree tree, String execMain) {
        if (tree == null) {
            return null;
        }
        if (execMain != null) {
            this.initRoutines = true;
            this.visit(tree);
            this.initRoutines = false;
            this.exec.functions.exec(execMain.toUpperCase(), null);
        } else {
            this.visit(tree);
        }
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return null;
    }

    @Override
    public void close() {
        this.leaveScope();
        this.cleanup();
        this.printExceptions();
    }

    private InputStream sourceStream(Arguments arguments) throws FileNotFoundException {
        return arguments.execString != null ? new ByteArrayInputStream(arguments.execString.getBytes(StandardCharsets.UTF_8)) : new FileInputStream(arguments.fileName);
    }

    public void init() {
        this.enterGlobalScope();
        System.setProperty("log4j.configurationFile", "hive-log4j2.properties");
        if (this.conf == null) {
            this.conf = new Conf();
        }
        this.conf.init();
        this.conn = new Conn(this);
        this.meta = new Meta(this, this.queryExecutor);
        this.initOptions();
        this.expr = new Expression(this);
        this.select = new Select(this, this.queryExecutor);
        this.stmt = new Stmt(this, this.queryExecutor);
        this.converter = new Converter(this);
        this.builtinFunctions = new BuiltinFunctions(this, this.queryExecutor);
        new FunctionDatetime(this, this.queryExecutor).register(this.builtinFunctions);
        new FunctionMisc(this, this.queryExecutor).register(this.builtinFunctions);
        new FunctionString(this, this.queryExecutor).register(this.builtinFunctions);
        if (this.msc != null) {
            this.functions = new HmsFunctionRegistry(this, this.msc, this.builtinFunctions, this.hplSqlSession);
            this.packageRegistry = new HmsPackageRegistry(this.msc, this.hplSqlSession);
        } else {
            this.functions = new InMemoryFunctionRegistry(this, this.builtinFunctions);
        }
        this.addVariable(new Var(ERRORCODE, Var.Type.BIGINT, 0L));
        this.addVariable(new Var(SQLCODE, Var.Type.BIGINT, 0L));
        this.addVariable(new Var(SQLSTATE, Var.Type.STRING, "00000"));
        this.addVariable(new Var(HOSTCODE, Var.Type.BIGINT, 0L));
        for (Map.Entry<String, String> v : this.arguments.getVars().entrySet()) {
            this.addVariable(new Var(v.getKey(), Var.Type.STRING, v.getValue()));
        }
        this.includeRcFile();
        this.registerBuiltins();
    }

    private ParseTree parse(InputStream input) throws IOException {
        HplsqlLexer lexer = new HplsqlLexer((CharStream)new ANTLRInputStream(input));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HplsqlParser parser = this.newParser(tokens);
        HplsqlParser.ProgramContext tree = parser.program();
        if (this.trace) {
            this.console.printError("Configuration file: " + this.conf.getLocation());
            this.console.printError("Parser tree: " + tree.toStringTree(parser));
        }
        return tree;
    }

    protected void registerBuiltins() {
        Var dbmVar = new Var(Var.Type.HPL_OBJECT, "DBMS_OUTPUT");
        DbmOutput dbms = DbmOutputClass.INSTANCE.newInstance();
        dbms.initialize(this.console);
        dbmVar.setValue(dbms);
        dbmVar.setConstant(true);
        this.addVariable(dbmVar);
        Var utlFileVar = new Var(Var.Type.HPL_OBJECT, "UTL_FILE");
        UtlFile utlFile = UtlFileClass.INSTANCE.newInstance();
        utlFileVar.setValue(utlFile);
        utlFileVar.setConstant(true);
        this.addVariable(utlFileVar);
    }

    private HplsqlParser newParser(CommonTokenStream tokens) {
        HplsqlParser parser = new HplsqlParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new SyntaxErrorReporter(this.console));
        return parser;
    }

    boolean parseArguments(String[] args) {
        boolean parsed = this.arguments.parse(args);
        if (parsed && this.arguments.hasVersionOption()) {
            this.console.printError(VERSION);
            return false;
        }
        if (!parsed || this.arguments.hasHelpOption() || this.arguments.getExecString() == null && this.arguments.getFileName() == null) {
            this.arguments.printHelp();
            return false;
        }
        String execString = this.arguments.getExecString();
        String execFile = this.arguments.getFileName();
        if (this.arguments.hasTraceOption()) {
            this.trace = true;
        }
        if (this.arguments.hasOfflineOption()) {
            this.offline = true;
        }
        if (execString != null && execFile != null) {
            this.console.printError("The '-e' and '-f' options cannot be specified simultaneously.");
            return false;
        }
        return true;
    }

    void includeRcFile() {
        if (this.includeFile(".hplsqlrc", false)) {
            this.dotHplsqlrcExists = true;
        } else if (this.includeFile("hplsqlrc", false)) {
            this.hplsqlrcExists = true;
        }
        if (this.udfRun) {
            this.includeFile("hplsql_locals.sql", true);
        }
    }

    boolean includeFile(String file, boolean showError) {
        block4: {
            try {
                String content = FileUtils.readFileToString((File)new File(file), (String)"UTF-8");
                if (content != null && !content.isEmpty()) {
                    if (this.trace) {
                        this.trace(null, "INCLUDE CONTENT " + file + " (non-empty)");
                    }
                    new Exec(this).include(content);
                    return true;
                }
            }
            catch (Exception e) {
                if (!showError) break block4;
                this.error(null, "INCLUDE file error: " + e.getMessage());
            }
        }
        return false;
    }

    void include(String content) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        HplsqlLexer lexer = new HplsqlLexer((CharStream)new ANTLRInputStream((InputStream)input));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HplsqlParser parser = this.newParser(tokens);
        HplsqlParser.ProgramContext tree = parser.program();
        this.visit((ParseTree)tree);
    }

    @Override
    public Integer visitProgram(HplsqlParser.ProgramContext ctx) {
        return (Integer)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Integer visitBegin_end_block(HplsqlParser.Begin_end_blockContext ctx) {
        this.enterScope(Scope.Type.BEGIN_END);
        Integer rc = (Integer)this.visitChildren((RuleNode)ctx);
        this.leaveScope();
        return rc;
    }

    void cleanup() {
        for (Map.Entry<String, String> i : this.managedTables.entrySet()) {
            String sql = "DROP TABLE IF EXISTS " + i.getValue();
            QueryResult query = this.queryExecutor.executeQuery(sql, null);
            query.close();
            if (!this.trace) continue;
            this.trace(null, sql);
        }
    }

    public void printExceptions() {
        while (!this.signals.empty()) {
            Signal sig = this.signals.pop();
            if (sig.type == Signal.Type.VALIDATION) {
                this.error(((HplValidationException)sig.exception).getCtx(), sig.exception.getMessage());
                continue;
            }
            if (sig.type == Signal.Type.SQLEXCEPTION) {
                this.console.printError("Unhandled exception in HPL/SQL");
                continue;
            }
            if (sig.type == Signal.Type.UNSUPPORTED_OPERATION) {
                this.console.printError(sig.value == null ? "Unsupported operation" : sig.value);
                continue;
            }
            if (sig.exception != null) {
                this.console.printError("HPL/SQL error: " + ExceptionUtils.getStackTrace((Throwable)sig.exception));
                continue;
            }
            if (sig.value != null) {
                this.console.printError(sig.value);
                continue;
            }
            this.trace(null, "Signal: " + (Object)((Object)sig.type));
        }
    }

    Integer getProgramReturnCode() {
        int rc = 0;
        if (!this.signals.empty()) {
            Signal sig = this.signals.pop();
            if ((sig.type == Signal.Type.LEAVE_PROGRAM || sig.type == Signal.Type.LEAVE_ROUTINE) && sig.value != null) {
                try {
                    rc = Integer.parseInt(sig.value);
                }
                catch (NumberFormatException e) {
                    rc = 1;
                }
            }
        }
        return rc;
    }

    @Override
    public Integer visitStmt(HplsqlParser.StmtContext ctx) {
        if (ctx.semicolon_stmt() != null) {
            return 0;
        }
        if (this.initRoutines && ctx.create_procedure_stmt() == null && ctx.create_function_stmt() == null) {
            return 0;
        }
        if (this.exec.resignal) {
            if (this.exec.currentScope != this.exec.currentHandlerScope.parent) {
                return 0;
            }
            this.exec.resignal = false;
        }
        if (!this.exec.signals.empty() && this.exec.conf.onError != OnError.SETERROR && !this.runContinueHandler()) {
            return 0;
        }
        Var prev = this.stackPop();
        if (prev != null && prev.value != null) {
            this.console.printLine(prev.toString());
        }
        return (Integer)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Integer visitSelect_stmt(HplsqlParser.Select_stmtContext ctx) {
        return this.exec.select.select(ctx);
    }

    @Override
    public Integer visitCte_select_stmt(HplsqlParser.Cte_select_stmtContext ctx) {
        return this.exec.select.cte(ctx);
    }

    @Override
    public Integer visitFullselect_stmt(HplsqlParser.Fullselect_stmtContext ctx) {
        return this.exec.select.fullselect(ctx);
    }

    @Override
    public Integer visitSubselect_stmt(HplsqlParser.Subselect_stmtContext ctx) {
        return this.exec.select.subselect(ctx);
    }

    @Override
    public Integer visitSelect_list(HplsqlParser.Select_listContext ctx) {
        return this.exec.select.selectList(ctx);
    }

    @Override
    public Integer visitFrom_clause(HplsqlParser.From_clauseContext ctx) {
        return this.exec.select.from(ctx);
    }

    @Override
    public Integer visitFrom_table_name_clause(HplsqlParser.From_table_name_clauseContext ctx) {
        return this.exec.select.fromTable(ctx);
    }

    @Override
    public Integer visitFrom_subselect_clause(HplsqlParser.From_subselect_clauseContext ctx) {
        return this.exec.select.fromSubselect(ctx);
    }

    @Override
    public Integer visitFrom_join_clause(HplsqlParser.From_join_clauseContext ctx) {
        return this.exec.select.fromJoin(ctx);
    }

    @Override
    public Integer visitFrom_table_values_clause(HplsqlParser.From_table_values_clauseContext ctx) {
        return this.exec.select.fromTableValues(ctx);
    }

    @Override
    public Integer visitWhere_clause(HplsqlParser.Where_clauseContext ctx) {
        return this.exec.select.where(ctx);
    }

    @Override
    public Integer visitSelect_options_item(HplsqlParser.Select_options_itemContext ctx) {
        return this.exec.select.option(ctx);
    }

    @Override
    public Integer visitColumn_name(HplsqlParser.Column_nameContext ctx) {
        this.stackPush(this.meta.normalizeIdentifierPart(ctx.getText()));
        return 0;
    }

    @Override
    public Integer visitTable_name(HplsqlParser.Table_nameContext ctx) {
        String name = ctx.getText();
        String nameUp = name.toUpperCase();
        String nameNorm = this.meta.normalizeObjectIdentifier(name);
        String actualName = this.exec.managedTables.get(nameUp);
        String conn = this.exec.objectConnMap.get(nameUp);
        if (conn == null) {
            conn = this.conf.defaultConnection;
        }
        this.stmtConnList.add(conn);
        if (actualName != null) {
            this.stackPush(actualName);
            return 0;
        }
        actualName = this.exec.objectMap.get(nameUp);
        if (actualName != null) {
            this.stackPush(actualName);
            return 0;
        }
        this.stackPush(nameNorm);
        return 0;
    }

    @Override
    public Integer visitInsert_stmt(HplsqlParser.Insert_stmtContext ctx) {
        return this.exec.stmt.insert(ctx);
    }

    @Override
    public Integer visitInsert_directory_stmt(HplsqlParser.Insert_directory_stmtContext ctx) {
        return this.exec.stmt.insertDirectory(ctx);
    }

    @Override
    public Integer visitException_block_item(HplsqlParser.Exception_block_itemContext ctx) {
        if (this.exec.signals.empty()) {
            return 0;
        }
        if (this.exec.conf.onError == OnError.SETERROR || this.exec.conf.onError == OnError.STOP) {
            this.exec.signals.pop();
            return 0;
        }
        if (ctx.L_ID().toString().equalsIgnoreCase("OTHERS")) {
            this.trace(ctx, "EXCEPTION HANDLER");
            this.exec.signals.pop();
            this.enterScope(Scope.Type.HANDLER);
            this.visit((ParseTree)ctx.block());
            this.leaveScope();
        }
        return 0;
    }

    @Override
    public Integer visitDeclare_var_item(HplsqlParser.Declare_var_itemContext ctx) {
        String type = null;
        TableClass userDefinedType = null;
        Row row = null;
        String len = null;
        String scale = null;
        Var default_ = null;
        if (ctx.dtype().T_ROWTYPE() != null) {
            row = this.meta.getRowDataType(ctx, this.exec.conf.defaultConnection, ctx.dtype().qident().getText());
            if (row == null) {
                type = "DERIVED%ROWTYPE";
            }
        } else {
            type = this.getDataType(ctx);
            if (ctx.dtype_len() != null) {
                len = ctx.dtype_len().L_INT(0).getText();
                if (ctx.dtype_len().L_INT(1) != null) {
                    scale = ctx.dtype_len().L_INT(1).getText();
                }
            }
            if (ctx.dtype_default() != null) {
                default_ = this.evalPop(ctx.dtype_default());
            }
            if ((userDefinedType = this.types.get(type)) != null) {
                type = Var.Type.HPL_OBJECT.name();
            }
        }
        int cnt = ctx.ident().size();
        for (int i = 0; i < cnt; ++i) {
            String name = ctx.ident(i).getText();
            if (row == null) {
                Var var = new Var(name, type, len, scale, default_);
                if (userDefinedType != null && default_ == null) {
                    var.setValue(userDefinedType.newInstance());
                }
                this.exec.addVariable(var);
                if (ctx.T_CONSTANT() != null) {
                    var.setConstant(true);
                }
                if (!this.trace) continue;
                if (default_ != null) {
                    this.trace(ctx, "DECLARE " + name + " " + type + " = " + var.toSqlString());
                    continue;
                }
                this.trace(ctx, "DECLARE " + name + " " + type);
                continue;
            }
            this.exec.addVariable(new Var(name, row));
            if (!this.trace) continue;
            this.trace(ctx, "DECLARE " + name + " " + ctx.dtype().getText());
        }
        return 0;
    }

    String getDataType(HplsqlParser.Declare_var_itemContext ctx) {
        String type;
        if (ctx.dtype().T_TYPE() != null) {
            type = this.meta.getDataType(ctx, this.exec.conf.defaultConnection, ctx.dtype().qident().getText());
            if (type == null) {
                type = "DERIVED%TYPE";
            }
        } else {
            type = Exec.getFormattedText(ctx.dtype());
        }
        return type;
    }

    @Override
    public Integer visitAllocate_cursor_stmt(HplsqlParser.Allocate_cursor_stmtContext ctx) {
        return this.exec.stmt.allocateCursor(ctx);
    }

    @Override
    public Integer visitAssociate_locator_stmt(HplsqlParser.Associate_locator_stmtContext ctx) {
        return this.exec.stmt.associateLocator(ctx);
    }

    @Override
    public Integer visitDeclare_cursor_item(HplsqlParser.Declare_cursor_itemContext ctx) {
        return this.exec.stmt.declareCursor(ctx);
    }

    @Override
    public Integer visitDescribe_stmt(HplsqlParser.Describe_stmtContext ctx) {
        return this.exec.stmt.describe(ctx);
    }

    @Override
    public Integer visitDrop_stmt(HplsqlParser.Drop_stmtContext ctx) {
        return this.exec.stmt.drop(ctx);
    }

    @Override
    public Integer visitOpen_stmt(HplsqlParser.Open_stmtContext ctx) {
        return this.exec.stmt.open(ctx);
    }

    @Override
    public Integer visitFetch_stmt(HplsqlParser.Fetch_stmtContext ctx) {
        return this.exec.stmt.fetch(ctx);
    }

    @Override
    public Integer visitClose_stmt(HplsqlParser.Close_stmtContext ctx) {
        return this.exec.stmt.close(ctx);
    }

    @Override
    public Integer visitCmp_stmt(HplsqlParser.Cmp_stmtContext ctx) {
        return new Cmp(this.exec, this.queryExecutor).run(ctx);
    }

    @Override
    public Integer visitCopy_stmt(HplsqlParser.Copy_stmtContext ctx) {
        return new Copy(this.exec, this.queryExecutor).run(ctx);
    }

    @Override
    public Integer visitCopy_from_local_stmt(HplsqlParser.Copy_from_local_stmtContext ctx) {
        return new Copy(this.exec, this.queryExecutor).runFromLocal(ctx);
    }

    @Override
    public Integer visitDeclare_handler_item(HplsqlParser.Declare_handler_itemContext ctx) {
        this.trace(ctx, "DECLARE HANDLER");
        Handler.ExecType execType = Handler.ExecType.EXIT;
        Signal.Type type = Signal.Type.SQLEXCEPTION;
        String value = null;
        if (ctx.T_CONTINUE() != null) {
            execType = Handler.ExecType.CONTINUE;
        }
        if (ctx.ident() != null) {
            type = Signal.Type.USERDEFINED;
            value = ctx.ident().getText();
        } else if (ctx.T_NOT() != null && ctx.T_FOUND() != null) {
            type = Signal.Type.NOTFOUND;
        }
        this.addHandler(new Handler(execType, type, value, this.exec.currentScope, ctx));
        return 0;
    }

    @Override
    public Integer visitDeclare_condition_item(HplsqlParser.Declare_condition_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitDeclare_temporary_table_item(HplsqlParser.Declare_temporary_table_itemContext ctx) {
        return this.exec.stmt.declareTemporaryTable(ctx);
    }

    @Override
    public Integer visitCreate_table_stmt(HplsqlParser.Create_table_stmtContext ctx) {
        return this.exec.stmt.createTable(ctx);
    }

    @Override
    public Integer visitCreate_table_options_hive_item(HplsqlParser.Create_table_options_hive_itemContext ctx) {
        return this.exec.stmt.createTableHiveOptions(ctx);
    }

    @Override
    public Integer visitCreate_table_options_ora_item(HplsqlParser.Create_table_options_ora_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitCreate_table_options_td_item(HplsqlParser.Create_table_options_td_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitCreate_table_options_mssql_item(HplsqlParser.Create_table_options_mssql_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitCreate_table_options_db2_item(HplsqlParser.Create_table_options_db2_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitCreate_table_options_mysql_item(HplsqlParser.Create_table_options_mysql_itemContext ctx) {
        return this.exec.stmt.createTableMysqlOptions(ctx);
    }

    @Override
    public Integer visitCreate_local_temp_table_stmt(HplsqlParser.Create_local_temp_table_stmtContext ctx) {
        return this.exec.stmt.createLocalTemporaryTable(ctx);
    }

    @Override
    public Integer visitAlter_table_stmt(HplsqlParser.Alter_table_stmtContext ctx) {
        return 0;
    }

    @Override
    public Integer visitCreate_database_stmt(HplsqlParser.Create_database_stmtContext ctx) {
        return this.exec.stmt.createDatabase(ctx);
    }

    @Override
    public Integer visitCreate_function_stmt(HplsqlParser.Create_function_stmtContext ctx) {
        this.exec.functions.addUserFunction(ctx);
        this.addLocalUdf(ctx);
        return 0;
    }

    @Override
    public Integer visitCreate_package_stmt(HplsqlParser.Create_package_stmtContext ctx) {
        String name = ctx.ident(0).getText().toUpperCase();
        if (this.exec.packageLoading) {
            this.exec.currentPackageDecl = new Package(name, this.exec, this.builtinFunctions);
            this.exec.packages.put(name, this.exec.currentPackageDecl);
            this.exec.currentPackageDecl.createSpecification(ctx);
            this.exec.currentPackageDecl = null;
        } else {
            this.trace(ctx, "CREATE PACKAGE");
            this.exec.packages.remove(name);
            this.exec.packageRegistry.createPackageHeader(name, Exec.getFormattedText(ctx), ctx.T_REPLACE() != null);
        }
        return 0;
    }

    @Override
    public Integer visitCreate_package_body_stmt(HplsqlParser.Create_package_body_stmtContext ctx) {
        String name = ctx.ident(0).getText().toUpperCase();
        if (this.exec.packageLoading) {
            this.exec.currentPackageDecl = this.exec.packages.get(name);
            if (this.exec.currentPackageDecl == null) {
                this.exec.currentPackageDecl = new Package(name, this.exec, this.builtinFunctions);
                this.exec.currentPackageDecl.setAllMembersPublic(true);
                this.exec.packages.put(name, this.exec.currentPackageDecl);
            }
            this.exec.currentPackageDecl.createBody(ctx);
            this.exec.currentPackageDecl = null;
        } else {
            this.trace(ctx, "CREATE PACKAGE BODY");
            this.exec.packages.remove(name);
            this.exec.packageRegistry.createPackageBody(name, Exec.getFormattedText(ctx), ctx.T_REPLACE() != null);
        }
        return 0;
    }

    @Override
    public Integer visitCreate_procedure_stmt(HplsqlParser.Create_procedure_stmtContext ctx) {
        this.exec.functions.addUserProcedure(ctx);
        this.addLocalUdf(ctx);
        return 0;
    }

    public void dropProcedure(HplsqlParser.Drop_stmtContext ctx, String name, boolean checkIfExists) {
        if (checkIfExists && !this.functions.exists(name)) {
            this.trace(ctx, name + " DOES NOT EXIST");
            return;
        }
        this.functions.remove(name);
        this.trace(ctx, name + " DROPPED");
    }

    public void dropPackage(HplsqlParser.Drop_stmtContext ctx, String name, boolean checkIfExists) {
        if (checkIfExists && !this.packageRegistry.getPackage(name).isPresent()) {
            this.trace(ctx, name + " DOES NOT EXIST");
            return;
        }
        this.packages.remove(name);
        this.packageRegistry.dropPackage(name);
        this.trace(ctx, name + " DROPPED");
    }

    @Override
    public Integer visitCreate_index_stmt(HplsqlParser.Create_index_stmtContext ctx) {
        return 0;
    }

    void addLocalUdf(ParserRuleContext ctx) {
        if (this.exec == this) {
            this.localUdf.append(Exec.getFormattedText(ctx));
            this.localUdf.append("\n");
        }
    }

    String createLocalUdf() {
        if (this.localUdf.length() == 0) {
            return null;
        }
        try {
            String file = System.getProperty("user.dir") + "/" + "hplsql_locals.sql";
            PrintWriter writer = new PrintWriter(file, "UTF-8");
            writer.print(this.localUdf);
            writer.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Integer visitAssignment_stmt_single_item(HplsqlParser.Assignment_stmt_single_itemContext ctx) {
        String name = ctx.ident().getText();
        this.visit((ParseTree)ctx.expr());
        Var var = this.setVariable(name);
        if (this.trace) {
            this.trace(ctx, "SET " + name + " = " + var.toSqlString());
        }
        return 0;
    }

    @Override
    public Integer visitAssignment_stmt_multiple_item(HplsqlParser.Assignment_stmt_multiple_itemContext ctx) {
        int cnt = ctx.ident().size();
        int ecnt = ctx.expr().size();
        for (int i = 0; i < cnt; ++i) {
            String name = ctx.ident(i).getText();
            if (i >= ecnt) continue;
            this.visit((ParseTree)ctx.expr(i));
            Var var = this.setVariable(name);
            if (!this.trace) continue;
            this.trace(ctx, "SET " + name + " = " + var.toString());
        }
        return 0;
    }

    @Override
    public Integer visitAssignment_stmt_select_item(HplsqlParser.Assignment_stmt_select_itemContext ctx) {
        return this.stmt.assignFromSelect(ctx);
    }

    @Override
    public Integer visitAssignment_stmt_collection_item(HplsqlParser.Assignment_stmt_collection_itemContext ctx) {
        HplsqlParser.Expr_funcContext lhs = ctx.expr_func();
        Var var = this.findVariable(lhs.ident().getText());
        if (var == null || var.type != Var.Type.HPL_OBJECT) {
            this.stackPush(Var.Null);
            return 0;
        }
        MethodParams.Arity.UNARY.check(lhs.ident().getText(), lhs.expr_func_params().func_param());
        Var index = this.evalPop(lhs.expr_func_params().func_param(0));
        Var value = this.evalPop(ctx.expr());
        this.dispatch((ParserRuleContext)ctx, (HplObject)var.value, "__SETITEM__", Arrays.asList(index, value));
        return 0;
    }

    @Override
    public Integer visitExpr(HplsqlParser.ExprContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execSql(ctx);
        } else {
            this.exec.expr.exec(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitBool_expr(HplsqlParser.Bool_exprContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execBoolSql(ctx);
        } else {
            this.exec.expr.execBool(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitBool_expr_binary(HplsqlParser.Bool_expr_binaryContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execBoolBinarySql(ctx);
        } else {
            this.exec.expr.execBoolBinary(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitBool_expr_unary(HplsqlParser.Bool_expr_unaryContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execBoolUnarySql(ctx);
        } else {
            this.exec.expr.execBoolUnary(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitExpr_select(HplsqlParser.Expr_selectContext ctx) {
        if (ctx.select_stmt() != null) {
            this.stackPush(new Var(this.evalPop(ctx.select_stmt())));
        } else {
            this.visit((ParseTree)ctx.expr());
        }
        return 0;
    }

    @Override
    public Integer visitExpr_file(HplsqlParser.Expr_fileContext ctx) {
        if (ctx.file_name() != null) {
            this.stackPush(new Var(ctx.file_name().getText()));
        } else {
            this.visit((ParseTree)ctx.expr());
        }
        return 0;
    }

    @Override
    public Integer visitExpr_cursor_attribute(HplsqlParser.Expr_cursor_attributeContext ctx) {
        this.exec.expr.execCursorAttribute(ctx);
        return 0;
    }

    @Override
    public Integer visitExpr_func(HplsqlParser.Expr_funcContext ctx) {
        return this.functionCall(ctx, ctx.ident(), ctx.expr_func_params());
    }

    private int functionCall(ParserRuleContext ctx, HplsqlParser.IdentContext ident, HplsqlParser.Expr_func_paramsContext params) {
        String name = ident.getText();
        if (this.exec.buildSql) {
            this.exec.execSql(name, params);
        } else {
            Package pack;
            name = name.toUpperCase();
            Package packCallContext = this.exec.getPackageCallContext();
            ArrayList<String> qualified = this.exec.meta.splitIdentifier(name);
            boolean executed = false;
            if (qualified != null && (pack = this.findPackage(qualified.get(0))) != null) {
                executed = pack.execFunc(qualified.get(1), params);
            }
            if (!executed && packCallContext != null) {
                executed = packCallContext.execFunc(name, params);
            }
            if (!executed && !this.exec.functions.exec(name, params)) {
                Var var = this.findVariable(name);
                if (var != null && var.type == Var.Type.HPL_OBJECT) {
                    this.stackPush(this.dispatch(ctx, (HplObject)var.value, "__GETITEM__", params));
                } else {
                    throw new UndefinedIdentException(ctx, name);
                }
            }
        }
        return 0;
    }

    private Var dispatch(ParserRuleContext ctx, HplObject obj, String methodName, HplsqlParser.Expr_func_paramsContext paramCtx) {
        List<Var> params = paramCtx == null ? Collections.emptyList() : paramCtx.func_param().stream().map(this::evalPop).collect(Collectors.toList());
        return this.dispatch(ctx, obj, methodName, params);
    }

    private Var dispatch(ParserRuleContext ctx, HplObject obj, String methodName, List<Var> params) {
        Method<HplObject> method = obj.hplClass().methodDictionary().get(ctx, methodName);
        return method.call(obj, params);
    }

    public List<Table> intoTables(ParserRuleContext ctx, List<String> names) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (String name : names) {
            Var var = this.findVariable(name);
            if (var == null) {
                this.trace(ctx, "Variable not found: " + name);
                continue;
            }
            if (var.type == Var.Type.HPL_OBJECT && var.value instanceof Table) {
                tables.add((Table)var.value);
                continue;
            }
            throw new TypeException(ctx, Table.class, var.type, var.value);
        }
        if (tables.size() > 1 && tables.stream().anyMatch(tbl -> tbl.hplClass().rowType())) {
            throw new TypeException(ctx, "rowtype table should not be used when selecting into multiple tables");
        }
        return tables;
    }

    public void execSql(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        if (this.execUserSql(ctx, name)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(name);
        sql.append("(");
        if (ctx != null) {
            int cnt = ctx.func_param().size();
            for (int i = 0; i < cnt; ++i) {
                sql.append(this.evalPop(ctx.func_param(i).expr()));
                if (i + 1 >= cnt) continue;
                sql.append(", ");
            }
        }
        sql.append(")");
        this.exec.stackPush(sql);
    }

    private boolean execUserSql(HplsqlParser.Expr_func_paramsContext ctx, String name) {
        int i;
        if (!this.functions.exists(name)) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("hplsql('");
        sql.append(name);
        sql.append("(");
        int cnt = ctx.func_param().size();
        for (i = 0; i < cnt; ++i) {
            sql.append(":").append(i + 1);
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        sql.append(")'");
        if (cnt > 0) {
            sql.append(", ");
        }
        for (i = 0; i < cnt; ++i) {
            sql.append(this.evalPop(ctx.func_param(i).expr()));
            if (i + 1 >= cnt) continue;
            sql.append(", ");
        }
        sql.append(")");
        this.exec.stackPush(sql);
        this.exec.registerUdf();
        return true;
    }

    @Override
    public Integer visitExpr_agg_window_func(HplsqlParser.Expr_agg_window_funcContext ctx) {
        this.exec.stackPush(Exec.getFormattedText(ctx));
        return 0;
    }

    @Override
    public Integer visitExpr_spec_func(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.buildSql) {
            this.exec.builtinFunctions.specExecSql(ctx);
        } else {
            this.exec.builtinFunctions.specExec(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitInclude_stmt(@NotNull HplsqlParser.Include_stmtContext ctx) {
        return this.exec.stmt.include(ctx);
    }

    @Override
    public Integer visitIf_plsql_stmt(HplsqlParser.If_plsql_stmtContext ctx) {
        return this.exec.stmt.ifPlsql(ctx);
    }

    @Override
    public Integer visitIf_tsql_stmt(HplsqlParser.If_tsql_stmtContext ctx) {
        return this.exec.stmt.ifTsql(ctx);
    }

    @Override
    public Integer visitIf_bteq_stmt(HplsqlParser.If_bteq_stmtContext ctx) {
        return this.exec.stmt.ifBteq(ctx);
    }

    @Override
    public Integer visitUse_stmt(HplsqlParser.Use_stmtContext ctx) {
        return this.exec.stmt.use(ctx);
    }

    @Override
    public Integer visitValues_into_stmt(HplsqlParser.Values_into_stmtContext ctx) {
        return this.exec.stmt.values(ctx);
    }

    @Override
    public Integer visitWhile_stmt(HplsqlParser.While_stmtContext ctx) {
        return this.exec.stmt.while_(ctx);
    }

    @Override
    public Integer visitUnconditional_loop_stmt(HplsqlParser.Unconditional_loop_stmtContext ctx) {
        return this.exec.stmt.unconditionalLoop(ctx);
    }

    @Override
    public Integer visitFor_cursor_stmt(HplsqlParser.For_cursor_stmtContext ctx) {
        return this.exec.stmt.forCursor(ctx);
    }

    @Override
    public Integer visitFor_range_stmt(HplsqlParser.For_range_stmtContext ctx) {
        return this.exec.stmt.forRange(ctx);
    }

    @Override
    public Integer visitExec_stmt(HplsqlParser.Exec_stmtContext ctx) {
        this.exec.inCallStmt = true;
        Integer rc = this.exec.stmt.exec(ctx);
        this.exec.inCallStmt = false;
        return rc;
    }

    @Override
    public Integer visitCall_stmt(HplsqlParser.Call_stmtContext ctx) {
        this.exec.inCallStmt = true;
        try {
            if (ctx.expr_func() != null) {
                this.functionCall(ctx, ctx.expr_func().ident(), ctx.expr_func().expr_func_params());
            } else if (ctx.expr_dot() != null) {
                this.visitExpr_dot(ctx.expr_dot());
            } else if (ctx.ident() != null) {
                this.functionCall(ctx, ctx.ident(), null);
            }
        }
        finally {
            this.exec.inCallStmt = false;
        }
        return 0;
    }

    @Override
    public Integer visitExit_stmt(HplsqlParser.Exit_stmtContext ctx) {
        return this.exec.stmt.exit(ctx);
    }

    @Override
    public Integer visitBreak_stmt(HplsqlParser.Break_stmtContext ctx) {
        return this.exec.stmt.break_(ctx);
    }

    @Override
    public Integer visitLeave_stmt(HplsqlParser.Leave_stmtContext ctx) {
        return this.exec.stmt.leave(ctx);
    }

    @Override
    public Integer visitPrint_stmt(HplsqlParser.Print_stmtContext ctx) {
        return this.exec.stmt.print(ctx);
    }

    @Override
    public Integer visitQuit_stmt(HplsqlParser.Quit_stmtContext ctx) {
        return this.exec.stmt.quit(ctx);
    }

    @Override
    public Integer visitSignal_stmt(HplsqlParser.Signal_stmtContext ctx) {
        return this.exec.stmt.signal(ctx);
    }

    @Override
    public Integer visitSummary_stmt(HplsqlParser.Summary_stmtContext ctx) {
        return this.exec.stmt.summary(ctx);
    }

    @Override
    public Integer visitResignal_stmt(HplsqlParser.Resignal_stmtContext ctx) {
        return this.exec.stmt.resignal(ctx);
    }

    @Override
    public Integer visitReturn_stmt(HplsqlParser.Return_stmtContext ctx) {
        return this.exec.stmt.return_(ctx);
    }

    @Override
    public Integer visitSet_current_schema_option(HplsqlParser.Set_current_schema_optionContext ctx) {
        return this.exec.stmt.setCurrentSchema(ctx);
    }

    @Override
    public Integer visitTruncate_stmt(HplsqlParser.Truncate_stmtContext ctx) {
        return this.exec.stmt.truncate(ctx);
    }

    @Override
    public Integer visitCreate_table_type_stmt(HplsqlParser.Create_table_type_stmtContext ctx) {
        String name = ctx.ident().getText();
        String index = ctx.dtype().getText();
        if (!"BINARY_INTEGER".equalsIgnoreCase(index)) {
            throw new TypeException(ctx, "Unsupported table index: " + index + " Use: BINARY_INTEGER");
        }
        HplsqlParser.Tbl_typeContext tblType = ctx.tbl_type();
        if (tblType.sql_type() != null) {
            String dbTable = tblType.sql_type().qident().getText();
            if (tblType.sql_type().T_ROWTYPE() != null) {
                Row rowType = this.meta.getRowDataType(ctx, this.exec.conf.defaultConnection, dbTable);
                this.exec.addType(new TableClass(name, rowType.columnDefinitions(), true));
            } else if (dbTable.contains(".")) {
                String column = dbTable.substring(dbTable.indexOf(".") + 1);
                String colType = this.meta.getDataType(ctx, this.exec.conf.defaultConnection, dbTable);
                this.exec.addType(new TableClass(name, Collections.singletonList(new ColumnDefinition(column, ColumnType.parse(colType))), false));
            } else {
                throw new TypeException(ctx, "Invalid table type attribute. Expected %TYPE or %ROWTYPE");
            }
            if (this.trace) {
                this.trace(ctx, "CREATE TABLE TYPE: " + name + " TYPE: " + dbTable + " INDEX: " + index);
            }
        } else {
            String colType = tblType.dtype().getText();
            this.exec.addType(new TableClass(name, Collections.singletonList(ColumnDefinition.unnamed(ColumnType.parse(colType))), false));
            if (this.trace) {
                this.trace(ctx, "CREATE TABLE TYPE: " + name + " TYPE: " + colType + " INDEX: " + index);
            }
        }
        return 1;
    }

    private void addType(TableClass tableClass) {
        this.types.put(tableClass.typeName(), tableClass);
    }

    public TableClass getType(String name) {
        return this.types.get(name);
    }

    @Override
    public Integer visitMap_object_stmt(HplsqlParser.Map_object_stmtContext ctx) {
        String source = ctx.ident(0).getText();
        String target = null;
        String conn = null;
        if (ctx.T_TO() != null) {
            target = ctx.ident(1).getText();
            this.exec.objectMap.put(source.toUpperCase(), target);
        }
        if (ctx.T_AT() != null) {
            conn = ctx.T_TO() == null ? ctx.ident(1).getText() : ctx.ident(2).getText();
            this.exec.objectConnMap.put(source.toUpperCase(), conn);
        }
        if (this.trace) {
            String log = "MAP OBJECT " + source;
            if (target != null) {
                log = log + " AS " + target;
            }
            if (conn != null) {
                log = log + " AT " + conn;
            }
            this.trace(ctx, log);
        }
        return 0;
    }

    @Override
    public Integer visitUpdate_stmt(HplsqlParser.Update_stmtContext ctx) {
        return this.stmt.update(ctx);
    }

    @Override
    public Integer visitDelete_stmt(HplsqlParser.Delete_stmtContext ctx) {
        return this.stmt.delete(ctx);
    }

    @Override
    public Integer visitMerge_stmt(HplsqlParser.Merge_stmtContext ctx) {
        return this.stmt.merge(ctx);
    }

    @Override
    public Integer visitHive(@NotNull HplsqlParser.HiveContext ctx) {
        this.trace(ctx, "HIVE");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("hive");
        Var params = new Var(Var.Type.STRINGLIST, cmd);
        this.stackPush(params);
        this.visitChildren((RuleNode)ctx);
        this.stackPop();
        try {
            String[] cmdarr = new String[cmd.size()];
            cmd.toArray(cmdarr);
            if (this.trace) {
                this.trace(ctx, "HIVE Parameters: " + Utils.toString(cmdarr, ' '));
            }
            if (!this.offline) {
                Process p = Runtime.getRuntime().exec(cmdarr);
                new StreamGobbler(p.getInputStream(), this.console).start();
                new StreamGobbler(p.getErrorStream(), this.console).start();
                int rc = p.waitFor();
                if (this.trace) {
                    this.trace(ctx, "HIVE Process exit code: " + rc);
                }
            }
        }
        catch (Exception e) {
            this.setSqlCode(SqlCodes.ERROR);
            this.signal(Signal.Type.SQLEXCEPTION, e.getMessage(), e);
            return -1;
        }
        return 0;
    }

    @Override
    public Integer visitHive_item(HplsqlParser.Hive_itemContext ctx) {
        String param;
        Var params = this.stackPeek();
        ArrayList a = (ArrayList)params.value;
        switch (param = ctx.getChild(1).getText()) {
            case "e": {
                a.add("-e");
                a.add(this.evalPop(ctx.expr()).toString());
                break;
            }
            case "f": {
                a.add("-f");
                a.add(this.evalPop(ctx.expr()).toString());
                break;
            }
            case "hiveconf": {
                a.add("-hiveconf");
                a.add(ctx.L_ID().toString() + "=" + this.evalPop(ctx.expr()).toString());
            }
        }
        return 0;
    }

    @Override
    public Integer visitHost_cmd(HplsqlParser.Host_cmdContext ctx) {
        this.trace(ctx, "HOST");
        this.execHost(ctx, ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex())));
        return 0;
    }

    @Override
    public Integer visitHost_stmt(HplsqlParser.Host_stmtContext ctx) {
        this.trace(ctx, "HOST");
        this.execHost(ctx, this.evalPop(ctx.expr()).toString());
        return 0;
    }

    public void execHost(ParserRuleContext ctx, String cmd) {
        try {
            if (this.trace) {
                this.trace(ctx, "HOST Command: " + cmd);
            }
            Process p = Runtime.getRuntime().exec(cmd);
            new StreamGobbler(p.getInputStream(), this.console).start();
            new StreamGobbler(p.getErrorStream(), this.console).start();
            int rc = p.waitFor();
            if (this.trace) {
                this.trace(ctx, "HOST Process exit code: " + rc);
            }
            this.setHostCode(rc);
        }
        catch (Exception e) {
            this.setHostCode(1);
            this.signal(Signal.Type.SQLEXCEPTION);
        }
    }

    @Override
    public Integer visitExpr_stmt(HplsqlParser.Expr_stmtContext ctx) {
        this.visitChildren((RuleNode)ctx);
        return 0;
    }

    @Override
    public Integer visitExpr_concat(HplsqlParser.Expr_concatContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.operatorConcatSql(ctx);
        } else {
            this.exec.expr.operatorConcat(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitExpr_dot_method_call(HplsqlParser.Expr_dot_method_callContext ctx) {
        Var var;
        if (this.exec.buildSql) {
            this.exec.stackPush(new Var(Var.Type.IDENT, ctx.getText()));
            return 0;
        }
        Var var2 = var = ctx.ident() != null ? this.findVariable(ctx.ident().getText()) : this.evalPop(ctx.expr_func(0));
        if (var == null && ctx.ident() != null) {
            Package pkg = this.findPackage(ctx.ident().getText());
            String pkgFuncName = ctx.expr_func(0).ident().getText().toUpperCase();
            boolean executed = pkg.execFunc(pkgFuncName, ctx.expr_func(0).expr_func_params());
            Package packCallContext = this.exec.getPackageCallContext();
            if (!executed && packCallContext != null) {
                packCallContext.execFunc(pkgFuncName, ctx.expr_func(0).expr_func_params());
            }
            return 0;
        }
        HplsqlParser.Expr_funcContext method = ctx.expr_func(ctx.expr_func().size() - 1);
        switch (var.type) {
            case HPL_OBJECT: {
                Var result = this.dispatch((ParserRuleContext)ctx, (HplObject)var.value, method.ident().getText(), method.expr_func_params());
                this.stackPush(result);
                return 0;
            }
        }
        throw new TypeException(ctx, (Object)((Object)var.type) + " is not an object");
    }

    @Override
    public Integer visitExpr_dot_property_access(HplsqlParser.Expr_dot_property_accessContext ctx) {
        if (this.exec.buildSql) {
            this.exec.stackPush(new Var(Var.Type.IDENT, ctx.getText()));
            return 0;
        }
        Var var = ctx.expr_func() != null ? this.evalPop(ctx.expr_func()) : this.findVariable(ctx.ident(0).getText());
        String property = ctx.ident(ctx.ident().size() - 1).getText();
        if (var == null && ctx.expr_func() == null) {
            Package pkg = this.findPackage(ctx.ident(0).getText());
            Var variable = pkg.findVariable(property);
            if (variable != null) {
                this.stackPush(variable);
            } else {
                Package packCallContext = this.exec.getPackageCallContext();
                this.stackPush(packCallContext.findVariable(property));
            }
            return 0;
        }
        switch (var.type) {
            case HPL_OBJECT: {
                Var result = this.dispatch((ParserRuleContext)ctx, (HplObject)var.value, property, Collections.emptyList());
                this.stackPush(result);
                return 0;
            }
            case ROW: {
                this.stackPush(((Row)var.value).getValue(property));
                return 0;
            }
        }
        throw new TypeException(ctx, (Object)((Object)var.type) + " is not an object/row");
    }

    @Override
    public Integer visitExpr_case_simple(HplsqlParser.Expr_case_simpleContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execSimpleCaseSql(ctx);
        } else {
            this.exec.expr.execSimpleCase(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitExpr_case_searched(HplsqlParser.Expr_case_searchedContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execSearchedCaseSql(ctx);
        } else {
            this.exec.expr.execSearchedCase(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitGet_diag_stmt_exception_item(HplsqlParser.Get_diag_stmt_exception_itemContext ctx) {
        return this.exec.stmt.getDiagnosticsException(ctx);
    }

    @Override
    public Integer visitGet_diag_stmt_rowcount_item(HplsqlParser.Get_diag_stmt_rowcount_itemContext ctx) {
        return this.exec.stmt.getDiagnosticsRowCount(ctx);
    }

    @Override
    public Integer visitGrant_stmt(HplsqlParser.Grant_stmtContext ctx) {
        this.trace(ctx, "GRANT");
        return 0;
    }

    @Override
    public Integer visitLabel(HplsqlParser.LabelContext ctx) {
        if (ctx.L_ID() != null) {
            this.exec.labels.push(ctx.L_ID().toString());
        } else {
            String label = ctx.L_LABEL().getText();
            if (label.endsWith(":")) {
                label = label.substring(0, label.length() - 1);
            }
            this.exec.labels.push(label);
        }
        return 0;
    }

    @Override
    public Integer visitIdent(HplsqlParser.IdentContext ctx) {
        Var var;
        String ident;
        boolean hasSub = false;
        String actualIdent = ident = ctx.getText();
        if (ident.startsWith("-")) {
            hasSub = true;
            actualIdent = ident.substring(1);
        }
        if ((var = this.findVariable(actualIdent)) != null) {
            if (!this.exec.buildSql) {
                if (hasSub) {
                    Var var1 = new Var(var);
                    var1.negate();
                    this.exec.stackPush(var1);
                } else {
                    this.exec.stackPush(var);
                }
            } else {
                this.exec.stackPush(new Var(ident, Var.Type.STRING, var.toSqlString()));
            }
        } else if (this.exec.buildSql || this.exec.inCallStmt) {
            this.exec.stackPush(new Var(Var.Type.IDENT, ident));
        } else if (!this.exec.functions.exec(ident = ident.toUpperCase(), null)) {
            throw new UndefinedIdentException(ctx, ident);
        }
        return 0;
    }

    @Override
    public Integer visitSingle_quotedString(HplsqlParser.Single_quotedStringContext ctx) {
        if (this.exec.buildSql) {
            this.exec.stackPush(ctx.getText());
        } else {
            this.exec.stackPush(Utils.unquoteString(ctx.getText()));
        }
        return 0;
    }

    @Override
    public Integer visitInt_number(HplsqlParser.Int_numberContext ctx) {
        this.exec.stack.push(new Var(Long.valueOf(ctx.getText())));
        return 0;
    }

    @Override
    public Integer visitExpr_interval(HplsqlParser.Expr_intervalContext ctx) {
        int num = this.evalPop(ctx.expr()).intValue();
        Interval interval = new Interval().set(num, ctx.interval_item().getText());
        this.stackPush(new Var(interval));
        return 0;
    }

    @Override
    public Integer visitDec_number(HplsqlParser.Dec_numberContext ctx) {
        this.stackPush(new Var(new BigDecimal(ctx.getText())));
        return 0;
    }

    @Override
    public Integer visitBool_literal(HplsqlParser.Bool_literalContext ctx) {
        boolean val = true;
        if (ctx.T_FALSE() != null) {
            val = false;
        }
        this.stackPush(new Var(val));
        return 0;
    }

    @Override
    public Integer visitNull_const(HplsqlParser.Null_constContext ctx) {
        this.stackPush(new Var());
        return 0;
    }

    @Override
    public Integer visitDate_literal(HplsqlParser.Date_literalContext ctx) {
        if (!this.exec.buildSql) {
            String str = this.evalPop(ctx.string()).toString();
            this.stackPush(new Var(Var.Type.DATE, Utils.toDate(str)));
        } else {
            this.stackPush(Exec.getFormattedText(ctx));
        }
        return 0;
    }

    @Override
    public Integer visitTimestamp_literal(HplsqlParser.Timestamp_literalContext ctx) {
        if (!this.exec.buildSql) {
            String str = this.evalPop(ctx.string()).toString();
            int len = str.length();
            int precision = 0;
            if (len > 19 && len <= 29 && (precision = len - 20) > 3) {
                precision = 3;
            }
            this.stackPush(new Var(Utils.toTimestamp(str), precision));
        } else {
            this.stackPush(Exec.getFormattedText(ctx));
        }
        return 0;
    }

    Package getPackageCallContext() {
        Scope cur = this.exec.currentScope;
        while (cur != null) {
            if (cur.type == Scope.Type.ROUTINE) {
                return cur.pack;
            }
            cur = cur.parent;
        }
        return null;
    }

    public String getStatementConnection() {
        if (this.exec.stmtConnList.contains(this.exec.conf.defaultConnection)) {
            return this.exec.conf.defaultConnection;
        }
        if (!this.exec.stmtConnList.isEmpty()) {
            return this.exec.stmtConnList.get(0);
        }
        return this.exec.conf.defaultConnection;
    }

    String getObjectConnection(String name) {
        String conn = this.exec.objectConnMap.get(name.toUpperCase());
        if (conn != null) {
            return conn;
        }
        return this.exec.conf.defaultConnection;
    }

    Connection getConnection(String conn) throws Exception {
        if (conn == null || conn.equalsIgnoreCase("default")) {
            conn = this.exec.conf.defaultConnection;
        }
        return this.exec.conn.getConnection(conn);
    }

    void returnConnection(String name, Connection conn) {
        this.exec.conn.returnConnection(name, conn);
    }

    Conn.Type getConnectionType(String conn) {
        return this.exec.conn.getTypeByProfile(conn);
    }

    public Conn.Type getConnectionType() {
        return this.getConnectionType(this.exec.conf.defaultConnection);
    }

    public void addManagedTable(String name, String managedName) {
        this.exec.managedTables.put(name, managedName);
    }

    String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    String getText(ParserRuleContext ctx, Token start, Token stop) {
        return ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(start.getStartIndex(), stop.getStopIndex()));
    }

    void append(StringBuilder str, String appendStr, Token start, Token stop) {
        String spaces = start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(start.getStartIndex(), stop.getStopIndex()));
        spaces = spaces.substring(start.getText().length(), spaces.length() - stop.getText().length());
        str.append(spaces);
        str.append(appendStr);
    }

    void append(StringBuilder str, TerminalNode start, TerminalNode stop) {
        String text = start.getSymbol().getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(start.getSymbol().getStartIndex(), stop.getSymbol().getStopIndex()));
        str.append(text);
    }

    TerminalNode nvl(TerminalNode t1, TerminalNode t2) {
        if (t1 != null) {
            return t1;
        }
        return t2;
    }

    public Var evalPop(ParserRuleContext ctx) {
        this.visit((ParseTree)ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    String evalPop(HplsqlParser.DtypeContext type, HplsqlParser.Dtype_lenContext len) {
        if (this.isConvert(this.exec.conf.defaultConnection)) {
            return this.exec.converter.dataType(type, len);
        }
        return this.getText(type, type.getStart(), len == null ? type.getStop() : len.getStop());
    }

    public static String getFormattedText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    public void setUdfRun(boolean udfRun) {
        this.udfRun = udfRun;
    }

    boolean isConvert(String connName) {
        return this.exec.conf.getConnectionConvert(connName);
    }

    public int incRowCount() {
        return this.exec.rowCount++;
    }

    public void setRowCount(int rowCount) {
        this.exec.rowCount = rowCount;
    }

    public void trace(ParserRuleContext ctx, String message) {
        if (!this.trace) {
            return;
        }
        if (ctx != null) {
            this.console.printLine("Ln:" + ctx.getStart().getLine() + " " + message);
        } else {
            this.console.printLine(message);
        }
    }

    public void trace(ParserRuleContext ctx, Var var, Metadata meta, int idx) {
        if (var.type != Var.Type.ROW) {
            this.trace(ctx, "COLUMN: " + meta.columnName(idx) + ", " + meta.columnTypeName(idx));
            this.trace(ctx, "SET " + var.getName() + " = " + var.toString());
        } else {
            Row row = (Row)var.value;
            int cnt = row.size();
            for (int j = 1; j <= cnt; ++j) {
                Var v = row.getValue(j - 1);
                this.trace(ctx, "COLUMN: " + meta.columnName(j) + ", " + meta.columnTypeName(j));
                this.trace(ctx, "SET " + v.getName() + " = " + v.toString());
            }
        }
    }

    public void info(ParserRuleContext ctx, String message) {
        if (!this.info) {
            return;
        }
        if (ctx != null) {
            this.console.printError("Ln:" + ctx.getStart().getLine() + " " + message);
        } else {
            this.console.printError(message);
        }
    }

    public void error(ParserRuleContext ctx, String message) {
        if (ctx != null) {
            this.console.printError("Ln:" + ctx.getStart().getLine() + " " + message);
        } else {
            this.console.printError(message);
        }
    }

    public Stack<Var> getStack() {
        return this.exec.stack;
    }

    public int getRowCount() {
        return this.exec.rowCount;
    }

    public Conf getConf() {
        return this.exec.conf;
    }

    public Meta getMeta() {
        return this.exec.meta;
    }

    public boolean getTrace() {
        return this.exec.trace;
    }

    public boolean getInfo() {
        return this.exec.info;
    }

    public boolean getOffline() {
        return this.exec.offline;
    }

    public Console getConsole() {
        return this.console;
    }

    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    public IMetaStoreClient getMsc() {
        return this.msc;
    }

    public static enum OnError {
        EXCEPTION,
        SETERROR,
        STOP;

    }
}

