/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.udf;

import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.StoredProcedureRequest;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hive.hplsql.Arguments;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.thrift.TException;

@Description(name="hplsql", value="_FUNC_('query' [, :1, :2, ...n]) - Execute HPL/SQL query", extended="Example:\n > SELECT _FUNC_('CURRENT_DATE') FROM src LIMIT 1;\n")
@UDFType(deterministic=false)
public class Udf
extends GenericUDF {
    public static String NAME = "hplsql";
    transient Exec exec;
    StringObjectInspector queryOI;
    ObjectInspector[] argumentsOI;
    private String functionDefinition;

    public Udf() {
    }

    public Udf(Exec exec) {
        this.exec = exec;
    }

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length == 0) {
            throw new UDFArgumentLengthException("At least one argument must be specified");
        }
        if (!(arguments[0] instanceof StringObjectInspector)) {
            throw new UDFArgumentException("First argument must be a string");
        }
        SessionState sessionState = SessionState.get();
        if (sessionState != null) {
            this.functionDefinition = this.loadSource(sessionState, this.functionName(arguments[0]));
        }
        this.queryOI = (StringObjectInspector)arguments[0];
        this.argumentsOI = arguments;
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    protected String loadSource(SessionState sessionState, String functionName) throws UDFArgumentException {
        Exec exec = (Exec)sessionState.getDynamicVar(Exec.class);
        try {
            StoredProcedure storedProcedure = exec.getMsc().getStoredProcedure(new StoredProcedureRequest(SessionState.get().getCurrentCatalog(), SessionState.get().getCurrentDatabase(), functionName));
            return storedProcedure != null ? storedProcedure.getSource() : null;
        }
        catch (TException e) {
            throw new UDFArgumentException((Throwable)e);
        }
    }

    protected String functionName(ObjectInspector argument) {
        ConstantObjectInspector inspector = (ConstantObjectInspector)argument;
        String functionCall = inspector.getWritableConstantValue().toString();
        return functionCall.split("\\(")[0].toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.exec == null) {
            this.exec = new Exec();
            this.exec.setQueryExecutor(QueryExecutor.DISABLED);
            this.exec.init();
            if (this.functionDefinition != null) {
                this.exec.parseAndEval(Arguments.script(this.functionDefinition));
            }
        }
        this.exec.enterScope(Scope.Type.ROUTINE);
        this.setParameters(arguments);
        String query = this.queryOI.getPrimitiveJavaObject(arguments[0].get());
        try {
            Var result = this.exec.parseAndEval(Arguments.script(query));
            this.exec.callStackPop();
            String string = result != null ? result.toString() : null;
            return string;
        }
        finally {
            this.exec.close();
        }
    }

    void setParameters(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 1; i < arguments.length; ++i) {
            Object value;
            String name = ":" + i;
            if (this.argumentsOI[i] instanceof StringObjectInspector) {
                value = ((StringObjectInspector)this.argumentsOI[i]).getPrimitiveJavaObject(arguments[i].get());
                if (value == null) continue;
                this.exec.setVariable(name, (String)value);
                continue;
            }
            if (this.argumentsOI[i] instanceof IntObjectInspector) {
                value = (Integer)((IntObjectInspector)this.argumentsOI[i]).getPrimitiveJavaObject(arguments[i].get());
                if (value == null) continue;
                this.exec.setVariable(name, new Var(new Long(((Integer)value).intValue())));
                continue;
            }
            if (this.argumentsOI[i] instanceof LongObjectInspector) {
                value = (Long)((LongObjectInspector)this.argumentsOI[i]).getPrimitiveJavaObject(arguments[i].get());
                if (value == null) continue;
                this.exec.setVariable(name, new Var((Long)value));
                continue;
            }
            this.exec.setVariableToNull(name);
        }
    }

    public String getDisplayString(String[] children) {
        return "hplsql";
    }
}

