/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.functions.BuiltinFunctions;

public class FunctionString
extends BuiltinFunctions {
    public FunctionString(Exec e, QueryExecutor queryExecutor) {
        super(e, queryExecutor);
    }

    @Override
    public void register(BuiltinFunctions f) {
        f.map.put("CONCAT", this::concat);
        f.map.put("CHAR", this::char_);
        f.map.put("LEN", this::len);
        f.map.put("SUBSTR", this::substr);
        f.map.put("SUBSTRING", this::substr);
        f.map.put("TO_CHAR", this::toChar);
        f.map.put("UPPER", this::upper);
        f.specMap.put("SUBSTRING", this::substring);
    }

    void concat(HplsqlParser.Expr_func_paramsContext ctx) {
        StringBuilder val = new StringBuilder();
        this.appendSingleQuote(val);
        int cnt = FunctionString.getParamCount(ctx);
        boolean nulls = true;
        for (int i = 0; i < cnt; ++i) {
            Var c = this.evalPop(ctx.func_param(i).expr());
            if (c.isNull() || "null".equalsIgnoreCase((String)c.value)) continue;
            val.append(Utils.unquoteString(c.toString()));
            nulls = false;
        }
        if (nulls) {
            this.evalNull();
        } else {
            this.appendSingleQuote(val);
            this.evalString(val);
        }
    }

    void char_(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = FunctionString.getParamCount(ctx);
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalString(str);
    }

    void len(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        int len = Utils.unquoteString(this.evalPop(ctx.func_param(0).expr()).toString()).trim().length();
        this.evalInt(len);
    }

    void substr(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = BuiltinFunctions.getParamCount(ctx);
        if (cnt < 2) {
            this.evalNull();
            return;
        }
        String str = Utils.unquoteString(this.evalPop(ctx.func_param(0).expr()).toString());
        int start = this.evalPop(ctx.func_param(1).expr()).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (cnt > 2) {
            len = this.evalPop(ctx.func_param(2).expr()).intValue();
        }
        this.substr(str, start, len);
    }

    void substr(String str, int start, int len) {
        if (str == null) {
            this.evalNull();
            return;
        }
        if (str.isEmpty()) {
            this.evalString(str);
            return;
        }
        if (start == 0) {
            start = 1;
        }
        StringBuilder resultStr = new StringBuilder();
        if (len == -1) {
            if (start > 0) {
                String substring = str.substring(start - 1);
                this.appendSingleQuote(resultStr);
                resultStr.append(substring);
                this.appendSingleQuote(resultStr);
                this.evalString(resultStr);
            }
        } else {
            String substring = str.substring(start - 1, start - 1 + len);
            this.appendSingleQuote(resultStr);
            resultStr.append(substring);
            this.appendSingleQuote(resultStr);
            this.evalString(resultStr);
        }
    }

    private void appendSingleQuote(StringBuilder resultStr) {
        if (this.exec.buildSql) {
            resultStr.append("'");
        }
    }

    void substring(HplsqlParser.Expr_spec_funcContext ctx) {
        String str = this.evalPop(ctx.expr(0)).toString();
        int start = this.evalPop(ctx.expr(1)).intValue();
        int len = -1;
        if (start == 0) {
            start = 1;
        }
        if (ctx.T_FOR() != null) {
            len = this.evalPop(ctx.expr(2)).intValue();
        }
        this.substr(str, start, len);
    }

    void toChar(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = BuiltinFunctions.getParamCount(ctx);
        if (cnt != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString();
        this.evalString(str);
    }

    void upper(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() != 1) {
            this.evalNull();
            return;
        }
        String str = this.evalPop(ctx.func_param(0).expr()).toString().toUpperCase();
        this.evalString(str);
    }
}

