/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.executor;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.executor.ColumnMeta;
import org.apache.hive.hplsql.executor.Metadata;
import org.apache.hive.hplsql.executor.QueryException;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.executor.RowResult;

public class JdbcQueryExecutor
implements QueryExecutor {
    private final Exec exec;

    public JdbcQueryExecutor(Exec exec) {
        this.exec = exec;
    }

    @Override
    public QueryResult executeQuery(String sql, ParserRuleContext ctx) {
        String conn = this.exec.getStatementConnection();
        Query query = this.exec.executeQuery(ctx, new Query(sql), conn);
        ResultSet resultSet = query.getResultSet();
        if (resultSet == null) {
            return new QueryResult(null, () -> new Metadata(Collections.emptyList()), query.getException());
        }
        return new QueryResult(new JdbcRowResult(resultSet), () -> JdbcQueryExecutor.metadata(resultSet), query.getException());
    }

    private static Metadata metadata(ResultSet resultSet) {
        try {
            ResultSetMetaData meta = resultSet.getMetaData();
            ArrayList<ColumnMeta> colMetas = new ArrayList<ColumnMeta>();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                colMetas.add(new ColumnMeta(meta.getColumnName(i), meta.getColumnTypeName(i), meta.getColumnType(i)));
            }
            return new Metadata(colMetas);
        }
        catch (SQLException e) {
            throw new QueryException(e);
        }
    }

    private static class JdbcRowResult
    implements RowResult {
        private final ResultSet resultSet;

        private JdbcRowResult(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        public boolean next() {
            try {
                return this.resultSet.next();
            }
            catch (SQLException e) {
                throw new QueryException(e);
            }
        }

        @Override
        public <T> T get(int columnIndex, Class<T> type) {
            try {
                return this.resultSet.getObject(columnIndex + 1, type);
            }
            catch (SQLException e) {
                throw new QueryException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                throw new QueryException(e);
            }
        }
    }
}

