/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hwi;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.hive.hwi.HWISessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HWIContextListener
implements ServletContextListener {
    protected static final Logger l4j = LoggerFactory.getLogger((String)HWIContextListener.class.getName());

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        HWISessionManager hs = new HWISessionManager();
        l4j.debug("HWISessionManager created.");
        Thread t = new Thread(hs);
        t.start();
        l4j.debug("HWISessionManager thread started.");
        sc.setAttribute("hs", (Object)hs);
        l4j.debug("HWISessionManager placed in application context.");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        HWISessionManager hs = (HWISessionManager)sc.getAttribute("hs");
        if (hs == null) {
            l4j.error("HWISessionManager was not found in context");
        } else {
            l4j.error("HWISessionManager goOn set to false. Shutting down.");
            hs.setGoOn(false);
        }
    }
}

