/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.conf;

import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.storage.jdbc.QueryConditionBuilder;
import org.apache.hive.storage.jdbc.conf.CustomConfigManager;
import org.apache.hive.storage.jdbc.conf.CustomConfigManagerFactory;
import org.apache.hive.storage.jdbc.conf.DatabaseType;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;

public class JdbcStorageConfigManager {
    public static final String CONFIG_PREFIX = "hive.sql";
    private static final EnumSet<JdbcStorageConfig> DEFAULT_REQUIRED_PROPERTIES = EnumSet.of(JdbcStorageConfig.DATABASE_TYPE, JdbcStorageConfig.JDBC_URL, JdbcStorageConfig.JDBC_DRIVER_CLASS, JdbcStorageConfig.QUERY);

    private JdbcStorageConfigManager() {
    }

    public static void copyConfigurationToJob(Properties props, Map<String, String> jobProps) {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            jobProps.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
    }

    public static Configuration convertPropertiesToConfiguration(Properties props) {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        Configuration conf = new Configuration();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            conf.set(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return conf;
    }

    private static void checkRequiredPropertiesAreDefined(Properties props) {
        for (JdbcStorageConfig configKey : DEFAULT_REQUIRED_PROPERTIES) {
            String propertyKey = configKey.getPropertyName();
            if (props != null && props.containsKey(propertyKey) && !JdbcStorageConfigManager.isEmptyString(props.getProperty(propertyKey))) continue;
            throw new IllegalArgumentException("Property " + propertyKey + " is required.");
        }
        DatabaseType dbType = DatabaseType.valueOf(props.getProperty(JdbcStorageConfig.DATABASE_TYPE.getPropertyName()));
        CustomConfigManager configManager = CustomConfigManagerFactory.getCustomConfigManagerFor(dbType);
        configManager.checkRequiredProperties(props);
    }

    public static String getConfigValue(JdbcStorageConfig key, Configuration config) {
        return config.get(key.getPropertyName());
    }

    public static String getQueryToExecute(Configuration config) {
        String query = config.get(JdbcStorageConfig.QUERY.getPropertyName());
        String hiveFilterCondition = QueryConditionBuilder.getInstance().buildCondition(config);
        if (hiveFilterCondition != null && !hiveFilterCondition.trim().isEmpty()) {
            query = query + " WHERE " + hiveFilterCondition;
        }
        return query;
    }

    private static boolean isEmptyString(String value) {
        return value == null || value.trim().isEmpty();
    }
}

