/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.hive.jdbc.JdbcColumnAttributes;

public class JdbcColumn {
    private final String columnName;
    private final String tableName;
    private final String tableCatalog;
    private final String type;
    private final String comment;
    private final int ordinalPos;

    JdbcColumn(String columnName, String tableName, String tableCatalog, String type, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableCatalog = tableCatalog;
        this.type = type;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getType() {
        return this.type;
    }

    static String columnClassName(int columnType, JdbcColumnAttributes columnAttributes) throws SQLException {
        switch (columnType) {
            case 16: {
                return Boolean.class.getName();
            }
            case 1: 
            case 12: {
                return String.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 91: {
                return Date.class.getName();
            }
            case 6: {
                return Float.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 3: {
                return BigInteger.class.getName();
            }
            case -2: {
                return byte[].class.getName();
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return String.class.getName();
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    public static int hiveTypeToSqlType(String type) throws SQLException {
        if ("string".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("varchar".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("char".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("float".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("double".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return 16;
        }
        if ("tinyint".equalsIgnoreCase(type)) {
            return -6;
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("int".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return -5;
        }
        if ("date".equalsIgnoreCase(type)) {
            return 91;
        }
        if ("timestamp".equalsIgnoreCase(type)) {
            return 93;
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("binary".equalsIgnoreCase(type)) {
            return -2;
        }
        if ("map".equalsIgnoreCase(type)) {
            return 2000;
        }
        if ("array".equalsIgnoreCase(type)) {
            return 2003;
        }
        if ("struct".equalsIgnoreCase(type)) {
            return 2002;
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    static String getColumnTypeName(String type) throws SQLException {
        if ("string".equalsIgnoreCase(type)) {
            return "string";
        }
        if ("varchar".equalsIgnoreCase(type)) {
            return "varchar";
        }
        if ("char".equalsIgnoreCase(type)) {
            return "char";
        }
        if ("float".equalsIgnoreCase(type)) {
            return "float";
        }
        if ("double".equalsIgnoreCase(type)) {
            return "double";
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return "boolean";
        }
        if ("tinyint".equalsIgnoreCase(type)) {
            return "tinyint";
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return "smallint";
        }
        if ("int".equalsIgnoreCase(type)) {
            return "int";
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return "bigint";
        }
        if ("timestamp".equalsIgnoreCase(type)) {
            return "timestamp";
        }
        if ("date".equalsIgnoreCase(type)) {
            return "date";
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return "decimal";
        }
        if ("binary".equalsIgnoreCase(type)) {
            return "binary";
        }
        if ("void".equalsIgnoreCase(type)) {
            return "void";
        }
        if (type.equalsIgnoreCase("map")) {
            return "map";
        }
        if (type.equalsIgnoreCase("array")) {
            return "array";
        }
        if (type.equalsIgnoreCase("struct")) {
            return "struct";
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    static int columnDisplaySize(int columnType, JdbcColumnAttributes columnAttributes) throws SQLException {
        switch (columnType) {
            case 16: {
                return JdbcColumn.columnPrecision(columnType, columnAttributes);
            }
            case 1: 
            case 12: {
                return JdbcColumn.columnPrecision(columnType, columnAttributes);
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return JdbcColumn.columnPrecision(columnType, columnAttributes) + 1;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return JdbcColumn.columnPrecision(columnType, columnAttributes);
            }
            case 6: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 3: {
                return JdbcColumn.columnPrecision(columnType, columnAttributes) + 2;
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnPrecision(int columnType, JdbcColumnAttributes columnAttributes) throws SQLException {
        switch (columnType) {
            case 16: {
                return 1;
            }
            case 1: 
            case 12: {
                if (columnAttributes != null) {
                    return columnAttributes.precision;
                }
                return Integer.MAX_VALUE;
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return 29;
            }
            case 3: {
                return columnAttributes.precision;
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnScale(int columnType, JdbcColumnAttributes columnAttributes) throws SQLException {
        switch (columnType) {
            case -6: 
            case -5: 
            case -2: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 91: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: {
                return 9;
            }
            case 3: {
                return columnAttributes.scale;
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return 0;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    public Integer getNumPrecRadix() {
        if (this.type.equalsIgnoreCase("tinyint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("smallint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("int")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("bigint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("float")) {
            return 2;
        }
        if (this.type.equalsIgnoreCase("double")) {
            return 2;
        }
        if (this.type.equalsIgnoreCase("decimal")) {
            return 10;
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public int getOrdinalPos() {
        return this.ordinalPos;
    }
}

