/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hive.org.apache.thrift.EncodingUtils;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.hive.org.apache.thrift.meta_data.ListMetaData;
import org.apache.hive.org.apache.thrift.meta_data.StructMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TList;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AddPartitionsResult
implements TBase<AddPartitionsResult, _Fields>,
Serializable,
Cloneable,
Comparable<AddPartitionsResult> {
    private static final TStruct STRUCT_DESC = new TStruct("AddPartitionsResult");
    private static final TField PARTITIONS_FIELD_DESC = new TField("partitions", 15, 1);
    private static final TField IS_STATS_COMPLIANT_FIELD_DESC = new TField("isStatsCompliant", 2, 2);
    private static final TField PARTITION_COL_SCHEMA_FIELD_DESC = new TField("partitionColSchema", 15, 3);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new AddPartitionsResultStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new AddPartitionsResultTupleSchemeFactory();
    @Nullable
    private List<Partition> partitions;
    private boolean isStatsCompliant;
    @Nullable
    private List<FieldSchema> partitionColSchema;
    private static final int __ISSTATSCOMPLIANT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.PARTITIONS, _Fields.IS_STATS_COMPLIANT, _Fields.PARTITION_COL_SCHEMA};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public AddPartitionsResult() {
    }

    public AddPartitionsResult(AddPartitionsResult other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetPartitions()) {
            ArrayList<Partition> __this__partitions = new ArrayList<Partition>(other.partitions.size());
            for (Partition partition : other.partitions) {
                __this__partitions.add(new Partition(partition));
            }
            this.partitions = __this__partitions;
        }
        this.isStatsCompliant = other.isStatsCompliant;
        if (other.isSetPartitionColSchema()) {
            ArrayList<FieldSchema> __this__partitionColSchema = new ArrayList<FieldSchema>(other.partitionColSchema.size());
            for (FieldSchema fieldSchema : other.partitionColSchema) {
                __this__partitionColSchema.add(new FieldSchema(fieldSchema));
            }
            this.partitionColSchema = __this__partitionColSchema;
        }
    }

    @Override
    public AddPartitionsResult deepCopy() {
        return new AddPartitionsResult(this);
    }

    @Override
    public void clear() {
        this.partitions = null;
        this.setIsStatsCompliantIsSet(false);
        this.isStatsCompliant = false;
        this.partitionColSchema = null;
    }

    public int getPartitionsSize() {
        return this.partitions == null ? 0 : this.partitions.size();
    }

    @Nullable
    public Iterator<Partition> getPartitionsIterator() {
        return this.partitions == null ? null : this.partitions.iterator();
    }

    public void addToPartitions(Partition elem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<Partition>();
        }
        this.partitions.add(elem);
    }

    @Nullable
    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(@Nullable List<Partition> partitions) {
        this.partitions = partitions;
    }

    public void unsetPartitions() {
        this.partitions = null;
    }

    public boolean isSetPartitions() {
        return this.partitions != null;
    }

    public void setPartitionsIsSet(boolean value) {
        if (!value) {
            this.partitions = null;
        }
    }

    public boolean isIsStatsCompliant() {
        return this.isStatsCompliant;
    }

    public void setIsStatsCompliant(boolean isStatsCompliant) {
        this.isStatsCompliant = isStatsCompliant;
        this.setIsStatsCompliantIsSet(true);
    }

    public void unsetIsStatsCompliant() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetIsStatsCompliant() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setIsStatsCompliantIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getPartitionColSchemaSize() {
        return this.partitionColSchema == null ? 0 : this.partitionColSchema.size();
    }

    @Nullable
    public Iterator<FieldSchema> getPartitionColSchemaIterator() {
        return this.partitionColSchema == null ? null : this.partitionColSchema.iterator();
    }

    public void addToPartitionColSchema(FieldSchema elem) {
        if (this.partitionColSchema == null) {
            this.partitionColSchema = new ArrayList<FieldSchema>();
        }
        this.partitionColSchema.add(elem);
    }

    @Nullable
    public List<FieldSchema> getPartitionColSchema() {
        return this.partitionColSchema;
    }

    public void setPartitionColSchema(@Nullable List<FieldSchema> partitionColSchema) {
        this.partitionColSchema = partitionColSchema;
    }

    public void unsetPartitionColSchema() {
        this.partitionColSchema = null;
    }

    public boolean isSetPartitionColSchema() {
        return this.partitionColSchema != null;
    }

    public void setPartitionColSchemaIsSet(boolean value) {
        if (!value) {
            this.partitionColSchema = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PARTITIONS: {
                if (value == null) {
                    this.unsetPartitions();
                    break;
                }
                this.setPartitions((List)value);
                break;
            }
            case IS_STATS_COMPLIANT: {
                if (value == null) {
                    this.unsetIsStatsCompliant();
                    break;
                }
                this.setIsStatsCompliant((Boolean)value);
                break;
            }
            case PARTITION_COL_SCHEMA: {
                if (value == null) {
                    this.unsetPartitionColSchema();
                    break;
                }
                this.setPartitionColSchema((List)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PARTITIONS: {
                return this.getPartitions();
            }
            case IS_STATS_COMPLIANT: {
                return this.isIsStatsCompliant();
            }
            case PARTITION_COL_SCHEMA: {
                return this.getPartitionColSchema();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PARTITIONS: {
                return this.isSetPartitions();
            }
            case IS_STATS_COMPLIANT: {
                return this.isSetIsStatsCompliant();
            }
            case PARTITION_COL_SCHEMA: {
                return this.isSetPartitionColSchema();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof AddPartitionsResult) {
            return this.equals((AddPartitionsResult)that);
        }
        return false;
    }

    public boolean equals(AddPartitionsResult that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_partitions = this.isSetPartitions();
        boolean that_present_partitions = that.isSetPartitions();
        if (this_present_partitions || that_present_partitions) {
            if (!this_present_partitions || !that_present_partitions) {
                return false;
            }
            if (!this.partitions.equals(that.partitions)) {
                return false;
            }
        }
        boolean this_present_isStatsCompliant = this.isSetIsStatsCompliant();
        boolean that_present_isStatsCompliant = that.isSetIsStatsCompliant();
        if (this_present_isStatsCompliant || that_present_isStatsCompliant) {
            if (!this_present_isStatsCompliant || !that_present_isStatsCompliant) {
                return false;
            }
            if (this.isStatsCompliant != that.isStatsCompliant) {
                return false;
            }
        }
        boolean this_present_partitionColSchema = this.isSetPartitionColSchema();
        boolean that_present_partitionColSchema = that.isSetPartitionColSchema();
        if (this_present_partitionColSchema || that_present_partitionColSchema) {
            if (!this_present_partitionColSchema || !that_present_partitionColSchema) {
                return false;
            }
            if (!this.partitionColSchema.equals(that.partitionColSchema)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetPartitions() ? 131071 : 524287);
        if (this.isSetPartitions()) {
            hashCode = hashCode * 8191 + this.partitions.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIsStatsCompliant() ? 131071 : 524287);
        if (this.isSetIsStatsCompliant()) {
            hashCode = hashCode * 8191 + (this.isStatsCompliant ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionColSchema() ? 131071 : 524287);
        if (this.isSetPartitionColSchema()) {
            hashCode = hashCode * 8191 + this.partitionColSchema.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(AddPartitionsResult other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetPartitions(), other.isSetPartitions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitions() && (lastComparison = TBaseHelper.compareTo(this.partitions, other.partitions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsStatsCompliant(), other.isSetIsStatsCompliant());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsStatsCompliant() && (lastComparison = TBaseHelper.compareTo(this.isStatsCompliant, other.isStatsCompliant)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartitionColSchema(), other.isSetPartitionColSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionColSchema() && (lastComparison = TBaseHelper.compareTo(this.partitionColSchema, other.partitionColSchema)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        AddPartitionsResult.scheme(iprot).read(iprot, (AddPartitionsResult)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        AddPartitionsResult.scheme(oprot).write(oprot, (AddPartitionsResult)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AddPartitionsResult(");
        boolean first = true;
        if (this.isSetPartitions()) {
            sb.append("partitions:");
            if (this.partitions == null) {
                sb.append("null");
            } else {
                sb.append(this.partitions);
            }
            first = false;
        }
        if (this.isSetIsStatsCompliant()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("isStatsCompliant:");
            sb.append(this.isStatsCompliant);
            first = false;
        }
        if (this.isSetPartitionColSchema()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partitionColSchema:");
            if (this.partitionColSchema == null) {
                sb.append("null");
            } else {
                sb.append(this.partitionColSchema);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PARTITIONS, new FieldMetaData("partitions", 2, new ListMetaData(15, new StructMetaData(12, Partition.class))));
        tmpMap.put(_Fields.IS_STATS_COMPLIANT, new FieldMetaData("isStatsCompliant", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.PARTITION_COL_SCHEMA, new FieldMetaData("partitionColSchema", 2, new ListMetaData(15, new StructMetaData(12, FieldSchema.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(AddPartitionsResult.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PARTITIONS(1, "partitions"),
        IS_STATS_COMPLIANT(2, "isStatsCompliant"),
        PARTITION_COL_SCHEMA(3, "partitionColSchema");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PARTITIONS;
                }
                case 2: {
                    return IS_STATS_COMPLIANT;
                }
                case 3: {
                    return PARTITION_COL_SCHEMA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class AddPartitionsResultStandardSchemeFactory
    implements SchemeFactory {
        private AddPartitionsResultStandardSchemeFactory() {
        }

        public AddPartitionsResultStandardScheme getScheme() {
            return new AddPartitionsResultStandardScheme();
        }
    }

    private static class AddPartitionsResultTupleSchemeFactory
    implements SchemeFactory {
        private AddPartitionsResultTupleSchemeFactory() {
        }

        public AddPartitionsResultTupleScheme getScheme() {
            return new AddPartitionsResultTupleScheme();
        }
    }

    private static class AddPartitionsResultTupleScheme
    extends TupleScheme<AddPartitionsResult> {
        private AddPartitionsResultTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, AddPartitionsResult struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetPartitions()) {
                optionals.set(0);
            }
            if (struct.isSetIsStatsCompliant()) {
                optionals.set(1);
            }
            if (struct.isSetPartitionColSchema()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetPartitions()) {
                oprot.writeI32(struct.partitions.size());
                for (Partition _iter650 : struct.partitions) {
                    _iter650.write(oprot);
                }
            }
            if (struct.isSetIsStatsCompliant()) {
                oprot.writeBool(struct.isStatsCompliant);
            }
            if (struct.isSetPartitionColSchema()) {
                oprot.writeI32(struct.partitionColSchema.size());
                for (FieldSchema _iter651 : struct.partitionColSchema) {
                    _iter651.write(oprot);
                }
            }
        }

        @Override
        public void read(TProtocol prot, AddPartitionsResult struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                TList _list652 = iprot.readListBegin((byte)12);
                struct.partitions = new ArrayList<Partition>(_list652.size);
                for (int _i654 = 0; _i654 < _list652.size; ++_i654) {
                    Partition _elem653 = new Partition();
                    _elem653.read(iprot);
                    struct.partitions.add(_elem653);
                }
                struct.setPartitionsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.isStatsCompliant = iprot.readBool();
                struct.setIsStatsCompliantIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list655 = iprot.readListBegin((byte)12);
                struct.partitionColSchema = new ArrayList<FieldSchema>(_list655.size);
                for (int _i657 = 0; _i657 < _list655.size; ++_i657) {
                    FieldSchema _elem656 = new FieldSchema();
                    _elem656.read(iprot);
                    struct.partitionColSchema.add(_elem656);
                }
                struct.setPartitionColSchemaIsSet(true);
            }
        }
    }

    private static class AddPartitionsResultStandardScheme
    extends StandardScheme<AddPartitionsResult> {
        private AddPartitionsResultStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, AddPartitionsResult struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list642 = iprot.readListBegin();
                            struct.partitions = new ArrayList<Partition>(_list642.size);
                            for (int _i644 = 0; _i644 < _list642.size; ++_i644) {
                                Partition _elem643 = new Partition();
                                _elem643.read(iprot);
                                struct.partitions.add(_elem643);
                            }
                            iprot.readListEnd();
                            struct.setPartitionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 2) {
                            struct.isStatsCompliant = iprot.readBool();
                            struct.setIsStatsCompliantIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list645 = iprot.readListBegin();
                            struct.partitionColSchema = new ArrayList<FieldSchema>(_list645.size);
                            for (int _i647 = 0; _i647 < _list645.size; ++_i647) {
                                FieldSchema _elem646 = new FieldSchema();
                                _elem646.read(iprot);
                                struct.partitionColSchema.add(_elem646);
                            }
                            iprot.readListEnd();
                            struct.setPartitionColSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, AddPartitionsResult struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.partitions != null && struct.isSetPartitions()) {
                oprot.writeFieldBegin(PARTITIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitions.size()));
                for (Partition _iter648 : struct.partitions) {
                    _iter648.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsStatsCompliant()) {
                oprot.writeFieldBegin(IS_STATS_COMPLIANT_FIELD_DESC);
                oprot.writeBool(struct.isStatsCompliant);
                oprot.writeFieldEnd();
            }
            if (struct.partitionColSchema != null && struct.isSetPartitionColSchema()) {
                oprot.writeFieldBegin(PARTITION_COL_SCHEMA_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitionColSchema.size()));
                for (FieldSchema _iter649 : struct.partitionColSchema) {
                    _iter649.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

