/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hive.org.apache.thrift.EncodingUtils;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.hive.org.apache.thrift.meta_data.StructMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolException;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DecimalColumnStatsData
implements TBase<DecimalColumnStatsData, _Fields>,
Serializable,
Cloneable,
Comparable<DecimalColumnStatsData> {
    private static final TStruct STRUCT_DESC = new TStruct("DecimalColumnStatsData");
    private static final TField LOW_VALUE_FIELD_DESC = new TField("lowValue", 12, 1);
    private static final TField HIGH_VALUE_FIELD_DESC = new TField("highValue", 12, 2);
    private static final TField NUM_NULLS_FIELD_DESC = new TField("numNulls", 10, 3);
    private static final TField NUM_DVS_FIELD_DESC = new TField("numDVs", 10, 4);
    private static final TField BIT_VECTORS_FIELD_DESC = new TField("bitVectors", 11, 5);
    private static final TField HISTOGRAM_FIELD_DESC = new TField("histogram", 11, 6);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new DecimalColumnStatsDataStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new DecimalColumnStatsDataTupleSchemeFactory();
    @Nullable
    private Decimal lowValue;
    @Nullable
    private Decimal highValue;
    private long numNulls;
    private long numDVs;
    @Nullable
    private ByteBuffer bitVectors;
    @Nullable
    private ByteBuffer histogram;
    private static final int __NUMNULLS_ISSET_ID = 0;
    private static final int __NUMDVS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.LOW_VALUE, _Fields.HIGH_VALUE, _Fields.BIT_VECTORS, _Fields.HISTOGRAM};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DecimalColumnStatsData() {
    }

    public DecimalColumnStatsData(long numNulls, long numDVs) {
        this();
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
        this.numDVs = numDVs;
        this.setNumDVsIsSet(true);
    }

    public DecimalColumnStatsData(DecimalColumnStatsData other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetLowValue()) {
            this.lowValue = new Decimal(other.lowValue);
        }
        if (other.isSetHighValue()) {
            this.highValue = new Decimal(other.highValue);
        }
        this.numNulls = other.numNulls;
        this.numDVs = other.numDVs;
        if (other.isSetBitVectors()) {
            this.bitVectors = TBaseHelper.copyBinary(other.bitVectors);
        }
        if (other.isSetHistogram()) {
            this.histogram = TBaseHelper.copyBinary(other.histogram);
        }
    }

    @Override
    public DecimalColumnStatsData deepCopy() {
        return new DecimalColumnStatsData(this);
    }

    @Override
    public void clear() {
        this.lowValue = null;
        this.highValue = null;
        this.setNumNullsIsSet(false);
        this.numNulls = 0L;
        this.setNumDVsIsSet(false);
        this.numDVs = 0L;
        this.bitVectors = null;
        this.histogram = null;
    }

    @Nullable
    public Decimal getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(@Nullable Decimal lowValue) {
        this.lowValue = lowValue;
    }

    public void unsetLowValue() {
        this.lowValue = null;
    }

    public boolean isSetLowValue() {
        return this.lowValue != null;
    }

    public void setLowValueIsSet(boolean value) {
        if (!value) {
            this.lowValue = null;
        }
    }

    @Nullable
    public Decimal getHighValue() {
        return this.highValue;
    }

    public void setHighValue(@Nullable Decimal highValue) {
        this.highValue = highValue;
    }

    public void unsetHighValue() {
        this.highValue = null;
    }

    public boolean isSetHighValue() {
        return this.highValue != null;
    }

    public void setHighValueIsSet(boolean value) {
        if (!value) {
            this.highValue = null;
        }
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
    }

    public void unsetNumNulls() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetNumNulls() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setNumNullsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public long getNumDVs() {
        return this.numDVs;
    }

    public void setNumDVs(long numDVs) {
        this.numDVs = numDVs;
        this.setNumDVsIsSet(true);
    }

    public void unsetNumDVs() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetNumDVs() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setNumDVsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public byte[] getBitVectors() {
        this.setBitVectors(TBaseHelper.rightSize(this.bitVectors));
        return this.bitVectors == null ? null : this.bitVectors.array();
    }

    public ByteBuffer bufferForBitVectors() {
        return TBaseHelper.copyBinary(this.bitVectors);
    }

    public void setBitVectors(byte[] bitVectors) {
        this.bitVectors = bitVectors == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])bitVectors.clone());
    }

    public void setBitVectors(@Nullable ByteBuffer bitVectors) {
        this.bitVectors = TBaseHelper.copyBinary(bitVectors);
    }

    public void unsetBitVectors() {
        this.bitVectors = null;
    }

    public boolean isSetBitVectors() {
        return this.bitVectors != null;
    }

    public void setBitVectorsIsSet(boolean value) {
        if (!value) {
            this.bitVectors = null;
        }
    }

    public byte[] getHistogram() {
        this.setHistogram(TBaseHelper.rightSize(this.histogram));
        return this.histogram == null ? null : this.histogram.array();
    }

    public ByteBuffer bufferForHistogram() {
        return TBaseHelper.copyBinary(this.histogram);
    }

    public void setHistogram(byte[] histogram) {
        this.histogram = histogram == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])histogram.clone());
    }

    public void setHistogram(@Nullable ByteBuffer histogram) {
        this.histogram = TBaseHelper.copyBinary(histogram);
    }

    public void unsetHistogram() {
        this.histogram = null;
    }

    public boolean isSetHistogram() {
        return this.histogram != null;
    }

    public void setHistogramIsSet(boolean value) {
        if (!value) {
            this.histogram = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case LOW_VALUE: {
                if (value == null) {
                    this.unsetLowValue();
                    break;
                }
                this.setLowValue((Decimal)value);
                break;
            }
            case HIGH_VALUE: {
                if (value == null) {
                    this.unsetHighValue();
                    break;
                }
                this.setHighValue((Decimal)value);
                break;
            }
            case NUM_NULLS: {
                if (value == null) {
                    this.unsetNumNulls();
                    break;
                }
                this.setNumNulls((Long)value);
                break;
            }
            case NUM_DVS: {
                if (value == null) {
                    this.unsetNumDVs();
                    break;
                }
                this.setNumDVs((Long)value);
                break;
            }
            case BIT_VECTORS: {
                if (value == null) {
                    this.unsetBitVectors();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setBitVectors((byte[])value);
                    break;
                }
                this.setBitVectors((ByteBuffer)value);
                break;
            }
            case HISTOGRAM: {
                if (value == null) {
                    this.unsetHistogram();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setHistogram((byte[])value);
                    break;
                }
                this.setHistogram((ByteBuffer)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case LOW_VALUE: {
                return this.getLowValue();
            }
            case HIGH_VALUE: {
                return this.getHighValue();
            }
            case NUM_NULLS: {
                return this.getNumNulls();
            }
            case NUM_DVS: {
                return this.getNumDVs();
            }
            case BIT_VECTORS: {
                return this.getBitVectors();
            }
            case HISTOGRAM: {
                return this.getHistogram();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case LOW_VALUE: {
                return this.isSetLowValue();
            }
            case HIGH_VALUE: {
                return this.isSetHighValue();
            }
            case NUM_NULLS: {
                return this.isSetNumNulls();
            }
            case NUM_DVS: {
                return this.isSetNumDVs();
            }
            case BIT_VECTORS: {
                return this.isSetBitVectors();
            }
            case HISTOGRAM: {
                return this.isSetHistogram();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof DecimalColumnStatsData) {
            return this.equals((DecimalColumnStatsData)that);
        }
        return false;
    }

    public boolean equals(DecimalColumnStatsData that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_lowValue = this.isSetLowValue();
        boolean that_present_lowValue = that.isSetLowValue();
        if (this_present_lowValue || that_present_lowValue) {
            if (!this_present_lowValue || !that_present_lowValue) {
                return false;
            }
            if (!this.lowValue.equals(that.lowValue)) {
                return false;
            }
        }
        boolean this_present_highValue = this.isSetHighValue();
        boolean that_present_highValue = that.isSetHighValue();
        if (this_present_highValue || that_present_highValue) {
            if (!this_present_highValue || !that_present_highValue) {
                return false;
            }
            if (!this.highValue.equals(that.highValue)) {
                return false;
            }
        }
        boolean this_present_numNulls = true;
        boolean that_present_numNulls = true;
        if (this_present_numNulls || that_present_numNulls) {
            if (!this_present_numNulls || !that_present_numNulls) {
                return false;
            }
            if (this.numNulls != that.numNulls) {
                return false;
            }
        }
        boolean this_present_numDVs = true;
        boolean that_present_numDVs = true;
        if (this_present_numDVs || that_present_numDVs) {
            if (!this_present_numDVs || !that_present_numDVs) {
                return false;
            }
            if (this.numDVs != that.numDVs) {
                return false;
            }
        }
        boolean this_present_bitVectors = this.isSetBitVectors();
        boolean that_present_bitVectors = that.isSetBitVectors();
        if (this_present_bitVectors || that_present_bitVectors) {
            if (!this_present_bitVectors || !that_present_bitVectors) {
                return false;
            }
            if (!this.bitVectors.equals(that.bitVectors)) {
                return false;
            }
        }
        boolean this_present_histogram = this.isSetHistogram();
        boolean that_present_histogram = that.isSetHistogram();
        if (this_present_histogram || that_present_histogram) {
            if (!this_present_histogram || !that_present_histogram) {
                return false;
            }
            if (!this.histogram.equals(that.histogram)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetLowValue() ? 131071 : 524287);
        if (this.isSetLowValue()) {
            hashCode = hashCode * 8191 + this.lowValue.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetHighValue() ? 131071 : 524287);
        if (this.isSetHighValue()) {
            hashCode = hashCode * 8191 + this.highValue.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.numNulls);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.numDVs);
        hashCode = hashCode * 8191 + (this.isSetBitVectors() ? 131071 : 524287);
        if (this.isSetBitVectors()) {
            hashCode = hashCode * 8191 + this.bitVectors.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetHistogram() ? 131071 : 524287);
        if (this.isSetHistogram()) {
            hashCode = hashCode * 8191 + this.histogram.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(DecimalColumnStatsData other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetLowValue(), other.isSetLowValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLowValue() && (lastComparison = TBaseHelper.compareTo(this.lowValue, other.lowValue)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetHighValue(), other.isSetHighValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHighValue() && (lastComparison = TBaseHelper.compareTo(this.highValue, other.highValue)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNumNulls(), other.isSetNumNulls());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumNulls() && (lastComparison = TBaseHelper.compareTo(this.numNulls, other.numNulls)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNumDVs(), other.isSetNumDVs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumDVs() && (lastComparison = TBaseHelper.compareTo(this.numDVs, other.numDVs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBitVectors(), other.isSetBitVectors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBitVectors() && (lastComparison = TBaseHelper.compareTo(this.bitVectors, other.bitVectors)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetHistogram(), other.isSetHistogram());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHistogram() && (lastComparison = TBaseHelper.compareTo(this.histogram, other.histogram)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        DecimalColumnStatsData.scheme(iprot).read(iprot, (DecimalColumnStatsData)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        DecimalColumnStatsData.scheme(oprot).write(oprot, (DecimalColumnStatsData)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DecimalColumnStatsData(");
        boolean first = true;
        if (this.isSetLowValue()) {
            sb.append("lowValue:");
            if (this.lowValue == null) {
                sb.append("null");
            } else {
                sb.append(this.lowValue);
            }
            first = false;
        }
        if (this.isSetHighValue()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("highValue:");
            if (this.highValue == null) {
                sb.append("null");
            } else {
                sb.append(this.highValue);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("numNulls:");
        sb.append(this.numNulls);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numDVs:");
        sb.append(this.numDVs);
        first = false;
        if (this.isSetBitVectors()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bitVectors:");
            if (this.bitVectors == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString(this.bitVectors, sb);
            }
            first = false;
        }
        if (this.isSetHistogram()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("histogram:");
            if (this.histogram == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString(this.histogram, sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetNumNulls()) {
            throw new TProtocolException("Required field 'numNulls' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNumDVs()) {
            throw new TProtocolException("Required field 'numDVs' is unset! Struct:" + this.toString());
        }
        if (this.lowValue != null) {
            this.lowValue.validate();
        }
        if (this.highValue != null) {
            this.highValue.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.LOW_VALUE, new FieldMetaData("lowValue", 2, new StructMetaData(12, Decimal.class)));
        tmpMap.put(_Fields.HIGH_VALUE, new FieldMetaData("highValue", 2, new StructMetaData(12, Decimal.class)));
        tmpMap.put(_Fields.NUM_NULLS, new FieldMetaData("numNulls", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NUM_DVS, new FieldMetaData("numDVs", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.BIT_VECTORS, new FieldMetaData("bitVectors", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.HISTOGRAM, new FieldMetaData("histogram", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DecimalColumnStatsData.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        LOW_VALUE(1, "lowValue"),
        HIGH_VALUE(2, "highValue"),
        NUM_NULLS(3, "numNulls"),
        NUM_DVS(4, "numDVs"),
        BIT_VECTORS(5, "bitVectors"),
        HISTOGRAM(6, "histogram");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return LOW_VALUE;
                }
                case 2: {
                    return HIGH_VALUE;
                }
                case 3: {
                    return NUM_NULLS;
                }
                case 4: {
                    return NUM_DVS;
                }
                case 5: {
                    return BIT_VECTORS;
                }
                case 6: {
                    return HISTOGRAM;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class DecimalColumnStatsDataStandardSchemeFactory
    implements SchemeFactory {
        private DecimalColumnStatsDataStandardSchemeFactory() {
        }

        public DecimalColumnStatsDataStandardScheme getScheme() {
            return new DecimalColumnStatsDataStandardScheme();
        }
    }

    private static class DecimalColumnStatsDataTupleSchemeFactory
    implements SchemeFactory {
        private DecimalColumnStatsDataTupleSchemeFactory() {
        }

        public DecimalColumnStatsDataTupleScheme getScheme() {
            return new DecimalColumnStatsDataTupleScheme();
        }
    }

    private static class DecimalColumnStatsDataTupleScheme
    extends TupleScheme<DecimalColumnStatsData> {
        private DecimalColumnStatsDataTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, DecimalColumnStatsData struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.numNulls);
            oprot.writeI64(struct.numDVs);
            BitSet optionals = new BitSet();
            if (struct.isSetLowValue()) {
                optionals.set(0);
            }
            if (struct.isSetHighValue()) {
                optionals.set(1);
            }
            if (struct.isSetBitVectors()) {
                optionals.set(2);
            }
            if (struct.isSetHistogram()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetLowValue()) {
                struct.lowValue.write(oprot);
            }
            if (struct.isSetHighValue()) {
                struct.highValue.write(oprot);
            }
            if (struct.isSetBitVectors()) {
                oprot.writeBinary(struct.bitVectors);
            }
            if (struct.isSetHistogram()) {
                oprot.writeBinary(struct.histogram);
            }
        }

        @Override
        public void read(TProtocol prot, DecimalColumnStatsData struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.numNulls = iprot.readI64();
            struct.setNumNullsIsSet(true);
            struct.numDVs = iprot.readI64();
            struct.setNumDVsIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.lowValue = new Decimal();
                struct.lowValue.read(iprot);
                struct.setLowValueIsSet(true);
            }
            if (incoming.get(1)) {
                struct.highValue = new Decimal();
                struct.highValue.read(iprot);
                struct.setHighValueIsSet(true);
            }
            if (incoming.get(2)) {
                struct.bitVectors = iprot.readBinary();
                struct.setBitVectorsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.histogram = iprot.readBinary();
                struct.setHistogramIsSet(true);
            }
        }
    }

    private static class DecimalColumnStatsDataStandardScheme
    extends StandardScheme<DecimalColumnStatsData> {
        private DecimalColumnStatsDataStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, DecimalColumnStatsData struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.lowValue = new Decimal();
                            struct.lowValue.read(iprot);
                            struct.setLowValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.highValue = new Decimal();
                            struct.highValue.read(iprot);
                            struct.setHighValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.numNulls = iprot.readI64();
                            struct.setNumNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.numDVs = iprot.readI64();
                            struct.setNumDVsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.bitVectors = iprot.readBinary();
                            struct.setBitVectorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.histogram = iprot.readBinary();
                            struct.setHistogramIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, DecimalColumnStatsData struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.lowValue != null && struct.isSetLowValue()) {
                oprot.writeFieldBegin(LOW_VALUE_FIELD_DESC);
                struct.lowValue.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.highValue != null && struct.isSetHighValue()) {
                oprot.writeFieldBegin(HIGH_VALUE_FIELD_DESC);
                struct.highValue.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(NUM_NULLS_FIELD_DESC);
            oprot.writeI64(struct.numNulls);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_DVS_FIELD_DESC);
            oprot.writeI64(struct.numDVs);
            oprot.writeFieldEnd();
            if (struct.bitVectors != null && struct.isSetBitVectors()) {
                oprot.writeFieldBegin(BIT_VECTORS_FIELD_DESC);
                oprot.writeBinary(struct.bitVectors);
                oprot.writeFieldEnd();
            }
            if (struct.histogram != null && struct.isSetHistogram()) {
                oprot.writeFieldBegin(HISTOGRAM_FIELD_DESC);
                oprot.writeBinary(struct.histogram);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

