/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(TableFetcher.class);
    private final IMetaStoreClient client;
    private final String catalogName;
    private final String dbPattern;
    @VisibleForTesting
    final Set<String> tableTypes = new HashSet<String>();
    @VisibleForTesting
    String tableFilter;

    private TableFetcher(Builder builder) {
        this.client = builder.client;
        if ("*".equalsIgnoreCase(builder.catalogName)) {
            LOG.warn("Invalid wildcard '*' parameter for catalogName, exact catalog name is expected instead of regexp");
        }
        this.catalogName = Optional.ofNullable(builder.catalogName).orElse("hive");
        this.dbPattern = Optional.ofNullable(builder.dbPattern).orElse("");
        String tablePattern = Optional.ofNullable(builder.tablePattern).orElse("");
        String stringTableTypes = Optional.ofNullable(builder.tableTypes).orElse("");
        for (String type : stringTableTypes.split(",")) {
            try {
                this.tableTypes.add(TableType.valueOf(type.trim().toUpperCase()).name());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unknown table type: {}", (Object)type);
            }
        }
        this.buildTableFilter(tablePattern, builder.tableConditions);
    }

    private void buildTableFilter(String tablePattern, List<String> conditions) {
        boolean external = this.tableTypes.contains(TableType.EXTERNAL_TABLE.name());
        boolean managed = this.tableTypes.contains(TableType.MANAGED_TABLE.name());
        if (!managed && external) {
            conditions.add("hive_filter_field_tableType__ = \"" + TableType.EXTERNAL_TABLE.name() + "\" ");
        } else if (managed && !external) {
            conditions.add("hive_filter_field_tableType__ = \"" + TableType.MANAGED_TABLE.name() + "\" ");
        }
        if (!tablePattern.trim().isEmpty()) {
            conditions.add("hive_filter_field_tableName__ like \"" + tablePattern.replaceAll("\\*", ".*") + "\"");
        }
        this.tableFilter = String.join((CharSequence)" and ", conditions);
    }

    public List<TableName> getTables() throws Exception {
        ArrayList<TableName> candidates = new ArrayList<TableName>();
        if (this.tableTypes.isEmpty()) {
            LOG.info("Table fetcher returns empty list as no table types specified");
            return candidates;
        }
        List<String> databases = this.client.getDatabases(this.catalogName, this.dbPattern);
        for (String db : databases) {
            Database database = this.client.getDatabase(this.catalogName, db);
            if (MetaStoreUtils.checkIfDbNeedsToBeSkipped(database)) {
                LOG.debug("Skipping table under database: {}", (Object)db);
                continue;
            }
            if (MetaStoreUtils.isDbBeingPlannedFailedOver(database)) {
                LOG.info("Skipping table that belongs to database {} being failed over.", (Object)db);
                continue;
            }
            List<String> tablesNames = this.client.listTableNamesByFilter(this.catalogName, db, this.tableFilter, -1);
            tablesNames.forEach(tablesName -> candidates.add(TableName.fromString(tablesName, this.catalogName, db)));
        }
        return candidates;
    }

    public static class Builder {
        private final IMetaStoreClient client;
        private final String catalogName;
        private final String dbPattern;
        private final String tablePattern;
        private final List<String> tableConditions = new ArrayList<String>();
        private String tableTypes;

        public Builder(IMetaStoreClient client, String catalogName, String dbPattern, String tablePattern) {
            this.client = client;
            this.catalogName = catalogName;
            this.dbPattern = dbPattern;
            this.tablePattern = tablePattern;
        }

        public Builder tableTypes(String tableTypes) {
            this.tableTypes = tableTypes;
            return this;
        }

        public Builder tableCondition(String condition) {
            this.tableConditions.add(condition);
            return this;
        }

        public TableFetcher build() {
            return new TableFetcher(this);
        }
    }
}

