/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.SchemaToTypeInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public class AvroObjectInspectorGenerator {
    private final List<String> columnNames;
    private final List<TypeInfo> columnTypes;
    private final List<String> columnComments;
    private final ObjectInspector oi;

    public AvroObjectInspectorGenerator(Schema schema) throws SerDeException {
        this.verifySchemaIsARecord(schema);
        this.columnNames = AvroObjectInspectorGenerator.generateColumnNames(schema);
        this.columnTypes = SchemaToTypeInfo.generateColumnTypes(schema);
        this.columnComments = AvroObjectInspectorGenerator.generateColumnComments(schema);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.oi = this.createObjectInspector();
    }

    private void verifySchemaIsARecord(Schema schema) throws SerDeException {
        if (!schema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new AvroSerdeException("Schema for table must be of type RECORD. Received type: " + schema.getType());
        }
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<TypeInfo> getColumnTypes() {
        return this.columnTypes;
    }

    public ObjectInspector getObjectInspector() {
        return this.oi;
    }

    private ObjectInspector createObjectInspector() throws SerDeException {
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(this.columnNames.size());
        for (int i = 0; i < this.columnNames.size(); ++i) {
            columnOIs.add(i, this.createObjectInspectorWorker(this.columnTypes.get(i)));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, columnOIs, this.columnComments);
    }

    private ObjectInspector createObjectInspectorWorker(TypeInfo ti) throws SerDeException {
        if (!this.supportedCategories(ti)) {
            throw new AvroSerdeException("Don't yet support this type: " + ti);
        }
        return switch (ti.getCategory()) {
            case ObjectInspector.Category.PRIMITIVE -> {
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)ti;
                yield PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(pti);
            }
            case ObjectInspector.Category.STRUCT -> {
                StructTypeInfo sti = (StructTypeInfo)ti;
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>(sti.getAllStructFieldTypeInfos().size());
                for (TypeInfo typeInfo : sti.getAllStructFieldTypeInfos()) {
                    ois.add(this.createObjectInspectorWorker(typeInfo));
                }
                yield ObjectInspectorFactory.getStandardStructObjectInspector(sti.getAllStructFieldNames(), ois);
            }
            case ObjectInspector.Category.MAP -> {
                MapTypeInfo mti = (MapTypeInfo)ti;
                yield ObjectInspectorFactory.getStandardMapObjectInspector(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.STRING), this.createObjectInspectorWorker(mti.getMapValueTypeInfo()));
            }
            case ObjectInspector.Category.LIST -> {
                ListTypeInfo ati = (ListTypeInfo)ti;
                yield ObjectInspectorFactory.getStandardListObjectInspector(this.createObjectInspectorWorker(ati.getListElementTypeInfo()));
            }
            case ObjectInspector.Category.UNION -> {
                UnionTypeInfo uti = (UnionTypeInfo)ti;
                List<TypeInfo> allUnionObjectTypeInfos = uti.getAllUnionObjectTypeInfos();
                ArrayList<ObjectInspector> unionObjectInspectors = new ArrayList<ObjectInspector>(allUnionObjectTypeInfos.size());
                for (TypeInfo typeInfo : allUnionObjectTypeInfos) {
                    unionObjectInspectors.add(this.createObjectInspectorWorker(typeInfo));
                }
                yield ObjectInspectorFactory.getStandardUnionObjectInspector(unionObjectInspectors);
            }
            default -> throw new AvroSerdeException("No Hive categories matched: " + ti);
        };
    }

    private boolean supportedCategories(TypeInfo ti) {
        ObjectInspector.Category c = ti.getCategory();
        return c.equals((Object)ObjectInspector.Category.PRIMITIVE) || c.equals((Object)ObjectInspector.Category.MAP) || c.equals((Object)ObjectInspector.Category.LIST) || c.equals((Object)ObjectInspector.Category.STRUCT) || c.equals((Object)ObjectInspector.Category.UNION);
    }

    public static List<String> generateColumnNames(Schema schema) {
        List fields = schema.getFields();
        ArrayList<String> fieldsList = new ArrayList<String>(fields.size());
        for (Schema.Field field : fields) {
            fieldsList.add(field.name());
        }
        return fieldsList;
    }

    public static List<String> generateColumnComments(Schema schema) {
        List fields = schema.getFields();
        ArrayList<String> fieldComments = new ArrayList<String>(fields.size());
        for (Schema.Field field : fields) {
            String fieldComment = field.doc() == null ? "" : field.doc();
            fieldComments.add(fieldComment);
        }
        return fieldComments;
    }
}

