/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.jdbc.CsrfHttpRequestInterceptor;
import org.apache.hive.jdbc.EmbeddedCLIServicePortal;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.hive.jdbc.HivePreparedStatement;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.HttpBasicAuthInterceptor;
import org.apache.hive.jdbc.HttpDefaultResponseInterceptor;
import org.apache.hive.jdbc.HttpKerberosRequestInterceptor;
import org.apache.hive.jdbc.HttpRequestInterceptorBase;
import org.apache.hive.jdbc.HttpTokenAuthInterceptor;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.XsrfHttpRequestInterceptor;
import org.apache.hive.jdbc.ZooKeeperHiveClientException;
import org.apache.hive.jdbc.ZooKeeperHiveClientHelper;
import org.apache.hive.jdbc.jwt.HttpJwtAuthRequestInterceptor;
import org.apache.hive.jdbc.saml.HiveJdbcBrowserClientFactory;
import org.apache.hive.jdbc.saml.HiveJdbcSamlRedirectStrategy;
import org.apache.hive.jdbc.saml.HttpSamlAuthRequestInterceptor;
import org.apache.hive.jdbc.saml.IJdbcBrowserClient;
import org.apache.hive.jdbc.saml.IJdbcBrowserClientFactory;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.hive.org.apache.http.HttpRequest;
import org.apache.hive.org.apache.http.HttpResponse;
import org.apache.hive.org.apache.http.NoHttpResponseException;
import org.apache.hive.org.apache.http.client.HttpRequestRetryHandler;
import org.apache.hive.org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.hive.org.apache.http.client.config.RequestConfig;
import org.apache.hive.org.apache.http.client.methods.HttpUriRequest;
import org.apache.hive.org.apache.http.client.protocol.HttpClientContext;
import org.apache.hive.org.apache.http.config.Registry;
import org.apache.hive.org.apache.http.config.RegistryBuilder;
import org.apache.hive.org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.hive.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.hive.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.hive.org.apache.http.impl.client.BasicCookieStore;
import org.apache.hive.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hive.org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hive.org.apache.http.impl.client.HttpClients;
import org.apache.hive.org.apache.http.impl.client.RequestWrapper;
import org.apache.hive.org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.hive.org.apache.http.protocol.HttpContext;
import org.apache.hive.org.apache.http.ssl.SSLContexts;
import org.apache.hive.org.apache.http.util.Args;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.hive.org.apache.thrift.transport.THttpClient;
import org.apache.hive.org.apache.thrift.transport.TTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.session.SessionUtils;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TCloseSessionReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TSetClientInfoReq;
import org.apache.hive.service.rpc.thrift.TSetClientInfoResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(HiveConnection.class);
    private String jdbcUriString;
    private String host;
    private int port;
    private final Map<String, String> sessConfMap;
    private Utils.JdbcConnectionParams connParams;
    private final boolean isEmbeddedMode;
    private TTransport transport;
    private boolean assumeSubject;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();
    private int loginTimeout = 0;
    private TProtocolVersion protocol;
    int fetchSize;
    int fetchThreads;
    private String initFile = null;
    private String wmPool = null;
    private String wmApp = null;
    private Properties clientInfo;
    private Subject loggedInSubject;
    private int maxRetries = 1;
    private IJdbcBrowserClient browserClient;

    public TCLIService.Iface getClient() {
        return this.client;
    }

    public static List<Utils.JdbcConnectionParams> getAllUrls(String zookeeperBasedHS2Url) throws Exception {
        Utils.JdbcConnectionParams params = Utils.parseURL(zookeeperBasedHS2Url, new Properties());
        if (params.getZooKeeperEnsemble() == null || ZooKeeperHiveClientHelper.isZkHADynamicDiscoveryMode(params.getSessionVars())) {
            return Collections.singletonList(params);
        }
        return ZooKeeperHiveClientHelper.getDirectParamsList(params);
    }

    public static List<String> getAllUrlStrings(String zookeeperBasedHS2Url) throws Exception {
        ArrayList<String> jdbcUrls = new ArrayList<String>();
        List<Utils.JdbcConnectionParams> allConnectionParams = HiveConnection.getAllUrls(zookeeperBasedHS2Url);
        for (Utils.JdbcConnectionParams cp : allConnectionParams) {
            String jdbcUrl = HiveConnection.makeDirectJDBCUrlFromConnectionParams(cp);
            if (jdbcUrl == null || jdbcUrl.isEmpty()) continue;
            jdbcUrls.add(jdbcUrl);
        }
        return jdbcUrls;
    }

    private static String makeDirectJDBCUrlFromConnectionParams(Utils.JdbcConnectionParams cp) {
        StringBuilder url = new StringBuilder("");
        if (cp != null) {
            if (cp.getHost() != null) {
                url.append(cp.getHost());
                url.append(":");
                url.append(cp.getPort());
                url.append("/");
                url.append(cp.getDbName());
                if (cp.getSessionVars() != null && !cp.getSessionVars().isEmpty()) {
                    for (Map.Entry<String, String> sessVar : cp.getSessionVars().entrySet()) {
                        if (sessVar.getKey().equalsIgnoreCase("serviceDiscoveryMode") || sessVar.getKey().equalsIgnoreCase("zooKeeperNamespace")) continue;
                        url.append(";");
                        url.append(sessVar.getKey());
                        url.append("=");
                        url.append(sessVar.getValue());
                    }
                }
                if (cp.getHiveConfs() != null && !cp.getHiveConfs().isEmpty()) {
                    url.append("?");
                    boolean firstKV = true;
                    for (Map.Entry<String, String> hiveConf : cp.getHiveConfs().entrySet()) {
                        if (!firstKV) {
                            url.append(";");
                        } else {
                            firstKV = false;
                        }
                        url.append(hiveConf.getKey());
                        url.append("=");
                        url.append(hiveConf.getValue());
                    }
                }
                if (cp.getHiveVars() != null && !cp.getHiveVars().isEmpty()) {
                    url.append("#");
                    boolean firstKV = true;
                    for (Map.Entry<String, String> hiveVar : cp.getHiveVars().entrySet()) {
                        if (!firstKV) {
                            url.append(";");
                        } else {
                            firstKV = false;
                        }
                        url.append(hiveVar.getKey());
                        url.append("=");
                        url.append(hiveVar.getValue());
                    }
                }
            } else {
                return url.toString();
            }
        }
        return url.toString();
    }

    @VisibleForTesting
    public HiveConnection() {
        this.sessConfMap = null;
        this.isEmbeddedMode = true;
        this.fetchSize = 50;
        this.fetchThreads = 0;
    }

    public HiveConnection(String uri, Properties info) throws SQLException {
        this(uri, info, HiveJdbcBrowserClientFactory.get());
    }

    public HiveConnection(HiveConnection hiveConnection) throws SQLException {
        this(hiveConnection.getConnectedUrl(), hiveConnection.getClientInfo(), HiveJdbcBrowserClientFactory.get(), false);
        this.sessHandle = hiveConnection.sessHandle;
        this.connParams = hiveConnection.connParams;
        this.protocol = hiveConnection.protocol;
        this.fetchSize = hiveConnection.fetchSize;
        this.fetchThreads = hiveConnection.fetchThreads;
    }

    @VisibleForTesting
    protected int getNumRetries() {
        return this.maxRetries;
    }

    @VisibleForTesting
    protected HiveConnection(String uri, Properties info, IJdbcBrowserClientFactory browserClientFactory) throws SQLException {
        this(uri, info, browserClientFactory, true);
    }

    protected HiveConnection(String uri, Properties info, IJdbcBrowserClientFactory browserClientFactory, boolean initSession) throws SQLException {
        try {
            this.connParams = Utils.parseURL(uri, info);
        }
        catch (ZooKeeperHiveClientException e) {
            throw new SQLException(e);
        }
        this.jdbcUriString = this.connParams.getJdbcUriString();
        LOG.debug("Establishing connection to " + this.jdbcUriString);
        this.sessConfMap = this.connParams.getSessionVars();
        this.setupLoginTimeout();
        if (this.isKerberosAuthMode()) {
            LOG.debug("Configuring Kerberos mode");
            String[] config = new Configuration();
            config.set("hadoop.security.authentication", HiveAuthConstants.AuthTypes.KERBEROS.getAuthName());
            UserGroupInformation.setConfiguration((Configuration)config);
            this.host = this.isEnableCanonicalHostnameCheck() ? Utils.getCanonicalHostName(this.connParams.getHost()) : this.connParams.getHost();
        } else {
            if (this.isBrowserAuthMode() && !this.isHttpTransportMode()) {
                throw new SQLException("Browser auth mode is only applicable in http mode");
            }
            this.host = this.connParams.getHost();
        }
        this.port = this.connParams.getPort();
        this.isEmbeddedMode = this.connParams.isEmbeddedMode();
        if (this.sessConfMap.containsKey("initFile")) {
            this.initFile = this.sessConfMap.get("initFile");
        }
        this.wmPool = this.sessConfMap.get("wmPool");
        for (String application : Utils.JdbcConnectionParams.APPLICATION) {
            this.wmApp = this.sessConfMap.get(application);
            if (this.wmApp != null) break;
        }
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V2);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V4);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V5);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V7);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V10);
        if (this.isBrowserAuthMode()) {
            try {
                this.browserClient = browserClientFactory.create(this.connParams);
            }
            catch (IJdbcBrowserClient.HiveJdbcBrowserException e) {
                throw new SQLException("");
            }
        }
        if (this.isEmbeddedMode) {
            this.client = EmbeddedCLIServicePortal.get(this.connParams.getHiveConfs());
            this.connParams.getHiveConfs().clear();
            if (this.isBrowserAuthMode()) {
                throw new SQLException(new IllegalArgumentException("Browser mode is not supported in embedded mode"));
            }
            if (initSession) {
                this.openSession();
                this.executeInitSql();
            }
        } else {
            long retryInterval = 1000L;
            try {
                String strRetryInterval;
                String strRetries = this.sessConfMap.get("retries");
                if (StringUtils.isNotBlank(strRetries)) {
                    this.maxRetries = Integer.parseInt(strRetries);
                }
                if (StringUtils.isNotBlank(strRetryInterval = this.sessConfMap.get("retryInterval"))) {
                    retryInterval = Long.parseLong(strRetryInterval);
                }
            }
            catch (NumberFormatException strRetries) {
                // empty catch block
            }
            int numRetries = 0;
            while (true) {
                try {
                    this.openTransport();
                    this.client = new TCLIService.Client(new TBinaryProtocol(this.transport));
                    if (!initSession) break;
                    this.openSession();
                    this.executeInitSql();
                }
                catch (Exception e) {
                    LOG.warn("Failed to connect to " + this.connParams.getHost() + ":" + this.connParams.getPort());
                    Object errMsg = null;
                    String warnMsg = "Could not open client transport with JDBC Uri: " + this.jdbcUriString + ": ";
                    try {
                        this.close();
                    }
                    catch (Exception ex) {
                        LOG.debug("Error while closing the connection", ex);
                    }
                    if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(this.sessConfMap)) {
                        errMsg = "Could not open client transport for any of the Server URI's in ZooKeeper: ";
                        while (!Utils.updateConnParamsFromZooKeeper(this.connParams) && ++numRetries < this.maxRetries) {
                            this.connParams.getRejectedHostZnodePaths().clear();
                        }
                        this.jdbcUriString = this.connParams.getJdbcUriString();
                        this.host = this.isKerberosAuthMode() && this.isEnableCanonicalHostnameCheck() ? Utils.getCanonicalHostName(this.connParams.getHost()) : this.connParams.getHost();
                        this.port = this.connParams.getPort();
                    } else {
                        errMsg = warnMsg;
                        ++numRetries;
                    }
                    if (numRetries >= this.maxRetries) {
                        throw new SQLException((String)errMsg + e.getMessage(), " 08S01", e);
                    }
                    LOG.warn(warnMsg + e.getMessage() + " Retrying " + numRetries + " of " + this.maxRetries + " with retry interval " + retryInterval + "ms");
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        this.client = HiveConnection.newSynchronizedClient(this.client);
    }

    private void executeInitSql() throws SQLException {
        if (this.initFile != null) {
            try (Statement st = this.createStatement();){
                List<String> sqlList = HiveConnection.parseInitFile(this.initFile);
                for (String sql : sqlList) {
                    boolean hasResult = st.execute(sql);
                    if (!hasResult) continue;
                    ResultSet rs = st.getResultSet();
                    try {
                        while (rs.next()) {
                            System.out.println(rs.getString(1));
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Failed to execute initial SQL");
                throw new SQLException(e.getMessage());
            }
        }
    }

    public static List<String> parseInitFile(String initFile) throws IOException {
        File file = new File(initFile);
        List<String> initSqlList = null;
        try (BufferedReader br = null;){
            String line;
            FileInputStream input = new FileInputStream(file);
            br = new BufferedReader(new InputStreamReader((InputStream)input, "UTF-8"));
            StringBuilder sb = new StringBuilder("");
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("--")) continue;
                line = line.concat(" ");
                sb.append(line);
            }
            initSqlList = HiveConnection.getInitSql(sb.toString());
        }
        return initSqlList;
    }

    private static List<String> getInitSql(String sbLine) {
        char[] sqlArray = sbLine.toCharArray();
        ArrayList<String> initSqlList = new ArrayList<String>();
        int beginIndex = 0;
        for (int index = 0; index < sqlArray.length; ++index) {
            if (sqlArray[index] != ';') continue;
            String sql = sbLine.substring(beginIndex, index).trim();
            initSqlList.add(sql);
            beginIndex = index + 1;
        }
        return initSqlList;
    }

    private void openTransport() throws Exception {
        this.assumeSubject = "fromSubject".equals(this.sessConfMap.get("kerberosAuthType"));
        TTransport tTransport = this.transport = this.isHttpTransportMode() ? this.createHttpTransport() : this.createBinaryTransport();
        if (!this.transport.isOpen()) {
            this.transport.open();
        }
        this.logZkDiscoveryMessage("Connected to " + this.connParams.getHost() + ":" + this.connParams.getPort());
    }

    public String getConnectedUrl() {
        return this.jdbcUriString;
    }

    private String getServerHttpUrl(boolean useSsl) {
        String schemeName = useSsl ? "https" : "http";
        Object httpPath = this.sessConfMap.get("httpPath");
        if (httpPath == null) {
            httpPath = "/";
        } else if (!((String)httpPath).startsWith("/")) {
            httpPath = "/" + (String)httpPath;
        }
        return schemeName + "://" + IPStackUtils.concatHostPort(this.host, this.port) + (String)httpPath;
    }

    private TTransport createHttpTransport() throws SQLException, TTransportException {
        boolean useSsl = this.isSslConnection();
        this.validateSslForBrowserMode();
        CloseableHttpClient httpClient = this.getHttpClient(useSsl);
        this.transport = new THttpClient(this.getServerHttpUrl(useSsl), httpClient);
        HiveAuthUtils.configureThriftMaxMessageSize(this.transport, this.getMaxMessageSize());
        return this.transport;
    }

    protected void validateSslForBrowserMode() throws SQLException {
        if (this.disableSSLValidation()) {
            LOG.warn("SSL validation for the browser mode is disabled.");
            return;
        }
        if (this.isBrowserAuthMode() && !this.isSslConnection()) {
            throw new SQLException(new IllegalArgumentException("Browser mode is only supported with SSL is enabled"));
        }
    }

    private CloseableHttpClient getHttpClient(Boolean useSsl) throws SQLException {
        HttpRequestInterceptorBase requestInterceptor;
        boolean isCookieEnabled = this.sessConfMap.get("cookieAuth") == null || !"false".equalsIgnoreCase(this.sessConfMap.get("cookieAuth"));
        String cookieName = this.sessConfMap.get("cookieName") == null ? "hive.server2.auth" : this.sessConfMap.get("cookieName");
        BasicCookieStore cookieStore = isCookieEnabled ? new BasicCookieStore() : null;
        HttpClientBuilder httpClientBuilder = null;
        HashMap<String, String> additionalHttpHeaders = new HashMap<String, String>();
        HashMap<String, String> customCookies = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.sessConfMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("http.header.")) {
                additionalHttpHeaders.put(key.substring("http.header.".length()), entry.getValue());
            }
            if (!key.startsWith("http.cookie.")) continue;
            customCookies.put(key.substring("http.cookie.".length()), entry.getValue());
        }
        if (this.isKerberosAuthMode()) {
            if (this.assumeSubject) {
                AccessControlContext context = AccessController.getContext();
                this.loggedInSubject = Subject.getSubject(context);
                if (this.loggedInSubject == null) {
                    throw new SQLException("The Subject is not set");
                }
            }
            requestInterceptor = new HttpKerberosRequestInterceptor(this.sessConfMap.get("principal"), this.host, this.getServerHttpUrl(useSsl), this.loggedInSubject, cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies);
        } else if (this.isJwtAuthMode()) {
            String signedJwt = this.getJWT();
            Preconditions.checkArgument(signedJwt != null && !signedJwt.isEmpty(), "For jwt auth mode, a signed jwt must be provided");
            requestInterceptor = new HttpJwtAuthRequestInterceptor(signedJwt, cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies);
        } else {
            String tokenStr;
            requestInterceptor = this.isBrowserAuthMode() ? new HttpSamlAuthRequestInterceptor(this.browserClient, cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies) : ((tokenStr = this.getClientDelegationToken(this.sessConfMap)) != null ? new HttpTokenAuthInterceptor(tokenStr, cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies) : new HttpBasicAuthInterceptor(this.getUserName(), this.getPassword(), cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies));
        }
        httpClientBuilder = isCookieEnabled ? HttpClients.custom().setDefaultCookieStore(cookieStore).setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

            @Override
            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean ret;
                int statusCode = response.getStatusLine().getStatusCode();
                boolean sentCredentials = context.getAttribute("hive.server2.sentCredentials") != null && context.getAttribute("hive.server2.sentCredentials").equals("true");
                boolean bl = ret = statusCode == 401 && executionCount <= 1 && !sentCredentials;
                if (ret) {
                    context.setAttribute("hive.server2.retryserver", "true");
                }
                return ret;
            }

            @Override
            public long getRetryInterval() {
                return 0L;
            }
        }) : HttpClientBuilder.create();
        httpClientBuilder.setRetryHandler(new HttpRequestRetryHandler(){
            private final List<Class<? extends IOException>> nonRetriableClasses = Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class);
            private final List<Class<? extends IOException>> retriableClasses = Arrays.asList(SocketTimeoutException.class, SocketException.class, NoHttpResponseException.class);

            @Override
            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                Args.notNull(exception, "Exception parameter");
                Args.notNull(context, "HTTP context");
                if (executionCount > HiveConnection.this.maxRetries) {
                    LOG.error("Max retries (" + HiveConnection.this.maxRetries + ") exhausted.", exception);
                    return false;
                }
                if (this.retriableClasses.contains(exception.getClass())) {
                    LOG.info("Retrying " + exception.getClass() + " as it is in retriable classes list.");
                    return true;
                }
                if (this.nonRetriableClasses.contains(exception.getClass())) {
                    LOG.info("Not retrying as the class (" + exception.getClass() + ") is non-retriable class.");
                    return false;
                }
                for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
                    if (!rejectException.isInstance(exception)) continue;
                    LOG.info("Not retrying as the class (" + exception.getClass() + ") is an instance of is non-retriable class.");
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt(context);
                HttpRequest request = clientContext.getRequest();
                if (this.requestIsAborted(request)) {
                    LOG.info("Not retrying as request is aborted.");
                    return false;
                }
                if (this.handleAsIdempotent(request)) {
                    LOG.info("Retrying idempotent request. Attempt " + executionCount + " of " + HiveConnection.this.maxRetries);
                    return true;
                }
                if (!clientContext.isRequestSent()) {
                    LOG.info("Retrying unsent request. Attempt " + executionCount + " of " + HiveConnection.this.maxRetries);
                    return true;
                }
                LOG.info("Not retrying as the request is not idempotent or is already sent.");
                return false;
            }

            protected boolean handleAsIdempotent(HttpRequest request) {
                return !(request instanceof HttpEntityEnclosingRequest);
            }

            protected boolean requestIsAborted(HttpRequest request) {
                HttpRequest req = request;
                if (request instanceof RequestWrapper) {
                    req = ((RequestWrapper)request).getOriginal();
                }
                return req instanceof HttpUriRequest && ((HttpUriRequest)req).isAborted();
            }
        });
        if (this.isBrowserAuthMode()) {
            httpClientBuilder.setRedirectStrategy(new HiveJdbcSamlRedirectStrategy(this.browserClient));
        }
        requestInterceptor.setRequestTrackingEnabled(this.isRequestTrackingEnabled());
        httpClientBuilder.addInterceptorFirst(requestInterceptor.sessionId(this.getSessionId()));
        httpClientBuilder.addInterceptorLast(new HttpDefaultResponseInterceptor());
        httpClientBuilder.addInterceptorLast(new XsrfHttpRequestInterceptor());
        httpClientBuilder.addInterceptorLast(new CsrfHttpRequestInterceptor());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.loginTimeout * 1000).setConnectionRequestTimeout(this.loginTimeout * 1000).setSocketTimeout(this.loginTimeout * 1000).build();
        httpClientBuilder.setDefaultRequestConfig(config);
        if (useSsl.booleanValue()) {
            String useTwoWaySSL = this.sessConfMap.get("twoWay");
            String sslTrustStorePath = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = Utils.getPassword(this.sessConfMap, "trustStorePassword");
            try {
                SSLConnectionSocketFactory socketFactory;
                if (useTwoWaySSL != null && useTwoWaySSL.equalsIgnoreCase("true")) {
                    socketFactory = this.getTwoWaySSLSocketFactory();
                } else if (sslTrustStorePath == null || sslTrustStorePath.isEmpty()) {
                    socketFactory = SSLConnectionSocketFactory.getSocketFactory();
                } else {
                    String trustStoreType = this.sessConfMap.get("trustStoreType");
                    if (trustStoreType == null || trustStoreType.isEmpty()) {
                        trustStoreType = KeyStore.getDefaultType();
                    }
                    KeyStore sslTrustStore = KeyStore.getInstance(trustStoreType);
                    try (FileInputStream fis = new FileInputStream(sslTrustStorePath);){
                        sslTrustStore.load(fis, sslTrustStorePassword != null ? sslTrustStorePassword.toCharArray() : null);
                    }
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(sslTrustStore, null).build();
                    socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier(null));
                }
                Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", socketFactory).build();
                httpClientBuilder.setConnectionManager(new BasicHttpClientConnectionManager(registry));
            }
            catch (Exception e) {
                String msg = "Could not create an https connection to " + this.jdbcUriString + ". " + e.getMessage();
                throw new SQLException(msg, " 08S01", e);
            }
        }
        return httpClientBuilder.build();
    }

    private boolean isRequestTrackingEnabled() {
        return Boolean.parseBoolean(this.sessConfMap.get("requestTrack"));
    }

    private Supplier<String> getSessionId() {
        Supplier<String> sessionId = () -> {
            if (this.sessHandle == null) {
                return "NO_SESSION";
            }
            StringBuilder b = new StringBuilder();
            TBaseHelper.toString(this.sessHandle.getSessionId().bufferForGuid(), b);
            return b.toString().replaceAll("\\s", "");
        };
        return sessionId;
    }

    private String getJWT() {
        String jwtCredential = this.getJWTStringFromSession();
        if (jwtCredential == null || jwtCredential.isEmpty()) {
            jwtCredential = this.getJWTStringFromEnv();
        }
        return jwtCredential;
    }

    private String getJWTStringFromEnv() {
        String jwtCredential = System.getenv("JWT");
        if (jwtCredential == null || jwtCredential.isEmpty()) {
            LOG.debug("No JWT is specified in env variable {}", (Object)"JWT");
        } else {
            int startIndex = Math.max(0, jwtCredential.length() - 7);
            String lastSevenChars = jwtCredential.substring(startIndex);
            LOG.debug("Fetched JWT (ends with {}) from the env.", (Object)lastSevenChars);
        }
        return jwtCredential;
    }

    private String getJWTStringFromSession() {
        String jwtCredential = this.sessConfMap.get("jwt");
        if (jwtCredential == null || jwtCredential.isEmpty()) {
            LOG.debug("No JWT is specified in connection string.");
        } else {
            int startIndex = Math.max(0, jwtCredential.length() - 7);
            String lastSevenChars = jwtCredential.substring(startIndex);
            LOG.debug("Fetched JWT (ends with {}) from the session.", (Object)lastSevenChars);
        }
        return jwtCredential;
    }

    private TTransport createUnderlyingTransport() throws TTransportException, SQLException {
        int maxMessageSize = this.getMaxMessageSize();
        TTransport transport = null;
        if (this.isSslConnection()) {
            String sslTrustStore = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = Utils.getPassword(this.sessConfMap, "trustStorePassword");
            if (sslTrustStore == null || sslTrustStore.isEmpty()) {
                transport = HiveAuthUtils.getSSLSocket(this.host, this.port, this.loginTimeout, maxMessageSize);
            } else {
                String trustStoreAlgorithm;
                String trustStoreType = this.sessConfMap.get("trustStoreType");
                if (trustStoreType == null) {
                    trustStoreType = "";
                }
                if ((trustStoreAlgorithm = this.sessConfMap.get("trustManagerFactoryAlgorithm")) == null) {
                    trustStoreAlgorithm = "";
                }
                transport = HiveAuthUtils.getSSLSocket(this.host, this.port, this.loginTimeout, sslTrustStore, sslTrustStorePassword, trustStoreType, trustStoreAlgorithm, maxMessageSize);
            }
        } else {
            transport = HiveAuthUtils.getSocketTransport(this.host, this.port, this.loginTimeout, maxMessageSize);
        }
        return transport;
    }

    private int getMaxMessageSize() throws SQLException {
        String maxMessageSize = this.sessConfMap.get("thrift.client.max.message.size");
        if (maxMessageSize == null) {
            return -1;
        }
        try {
            return Integer.parseInt(maxMessageSize);
        }
        catch (Exception e) {
            String errFormat = "Invalid {} configuration of '{}'. Expected an integer specifying number of bytes. A configuration of <= 0 uses default max message size.";
            String errMsg = String.format(errFormat, "thrift.client.max.message.size", maxMessageSize);
            throw new SQLException(errMsg, "42000", e);
        }
    }

    private TTransport createBinaryTransport() throws SQLException, TTransportException {
        block12: {
            try {
                TTransport socketTransport = this.createUnderlyingTransport();
                if (!"noSasl".equals(this.sessConfMap.get("auth"))) {
                    HashMap<String, String> saslProps = new HashMap<String, String>();
                    SaslQOP saslQOP = SaslQOP.AUTH;
                    if (this.sessConfMap.containsKey("saslQop")) {
                        try {
                            saslQOP = SaslQOP.fromString(this.sessConfMap.get("saslQop"));
                        }
                        catch (IllegalArgumentException e) {
                            throw new SQLException("Invalid saslQop parameter. " + e.getMessage(), "42000", e);
                        }
                        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
                    } else {
                        saslProps.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
                    }
                    saslProps.put("javax.security.sasl.server.authentication", "true");
                    String tokenStr = null;
                    if ("delegationToken".equals(this.sessConfMap.get("auth"))) {
                        tokenStr = this.getClientDelegationToken(this.sessConfMap);
                    }
                    if (tokenStr != null) {
                        this.transport = KerberosSaslHelper.getTokenTransport(tokenStr, this.host, socketTransport, saslProps);
                    } else if (this.sessConfMap.containsKey("principal")) {
                        this.transport = KerberosSaslHelper.getKerberosTransport(this.sessConfMap.get("principal"), this.host, socketTransport, saslProps, this.assumeSubject);
                    } else {
                        String userName = this.getUserName();
                        String passwd = this.getPassword();
                        this.transport = PlainSaslHelper.getPlainTransport(userName, passwd, socketTransport);
                    }
                    break block12;
                }
                this.transport = socketTransport;
            }
            catch (SaslException e) {
                throw new SQLException("Could not create secure connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
            }
        }
        return this.transport;
    }

    SSLConnectionSocketFactory getTwoWaySSLSocketFactory() throws SQLException {
        SSLConnectionSocketFactory socketFactory = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            String keyStorePath = this.sessConfMap.get("sslKeyStore");
            String keyStorePassword = Utils.getPassword(this.sessConfMap, "keyStorePassword");
            String keyStoreType = this.sessConfMap.get("keyStoreType");
            keyStoreType = !StringUtils.isBlank(keyStoreType) ? keyStoreType : KeyStore.getDefaultType();
            KeyStore sslKeyStore = KeyStore.getInstance(keyStoreType);
            if (keyStorePath == null || keyStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslKeyStore Not configured for 2 way SSL connection, keyStorePath param is empty");
            }
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                sslKeyStore.load(fis, keyStorePassword.toCharArray());
            }
            keyManagerFactory.init(sslKeyStore, keyStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            String trustStorePath = this.sessConfMap.get("sslTrustStore");
            String trustStorePassword = Utils.getPassword(this.sessConfMap, "trustStorePassword");
            String trustStoreType = this.sessConfMap.get("trustStoreType");
            if (trustStoreType == null || trustStoreType.isEmpty()) {
                trustStoreType = KeyStore.getDefaultType();
            }
            KeyStore sslTrustStore = KeyStore.getInstance(trustStoreType);
            if (trustStorePath == null || trustStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslTrustStore Not configured for 2 way SSL connection");
            }
            try (FileInputStream fis = new FileInputStream(trustStorePath);){
                sslTrustStore.load(fis, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
            }
            trustManagerFactory.init(sslTrustStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            socketFactory = new SSLConnectionSocketFactory(context);
        }
        catch (Exception e) {
            throw new SQLException("Error while initializing 2 way ssl socket factory ", e);
        }
        return socketFactory;
    }

    private String getClientDelegationToken(Map<String, String> jdbcConnConf) throws SQLException {
        String tokenStr = null;
        if (!"delegationToken".equalsIgnoreCase(jdbcConnConf.get("auth"))) {
            return null;
        }
        DelegationTokenFetcher fetcher = new DelegationTokenFetcher();
        try {
            tokenStr = fetcher.getTokenStringFromFile();
        }
        catch (IOException e) {
            LOG.warn("Cannot get token from environment variable $HADOOP_TOKEN_FILE_LOCATION=" + System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        if (tokenStr == null) {
            try {
                return fetcher.getTokenFromSession();
            }
            catch (IOException e) {
                throw new SQLException("Error reading token ", e);
            }
        }
        return tokenStr;
    }

    /*
     * WARNING - void declaration
     */
    private void openSession() throws SQLException {
        LOG.debug("Opening Hive connection session");
        TOpenSessionReq openReq = new TOpenSessionReq();
        HashMap<String, String> openConf = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.connParams.getHiveConfs().entrySet()) {
            openConf.put("set:hiveconf:" + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.connParams.getHiveVars().entrySet()) {
            openConf.put("set:hivevar:" + entry.getKey(), entry.getValue());
        }
        LOG.debug("Default database: {}", (Object)this.connParams.getDbName());
        openConf.put("use:database", this.connParams.getDbName());
        if (this.wmPool != null) {
            openConf.put("set:hivevar:wmpool", this.wmPool);
        }
        if (this.wmApp != null) {
            openConf.put("set:hivevar:wmapp", this.wmApp);
        }
        if (this.sessConfMap.containsKey("hive.server2.proxy.user")) {
            openConf.put("hive.server2.proxy.user", this.sessConfMap.get("hive.server2.proxy.user"));
        }
        if (this.sessConfMap.containsKey("hiveCreateAsExternalLegacy")) {
            openConf.put("set:hiveconf:hive.create.as.external.legacy", this.sessConfMap.get("hiveCreateAsExternalLegacy").toLowerCase());
        }
        if (this.isHplSqlMode()) {
            openConf.put("set:hivevar:mode", "HPLSQL");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dumping initial configuration...");
            for (Map.Entry<String, String> entry : openConf.entrySet()) {
                LOG.debug("{}={}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        openReq.setConfiguration(openConf);
        if ("noSasl".equals(this.sessConfMap.get("auth"))) {
            openReq.setUsername(this.sessConfMap.get("user"));
            openReq.setPassword(this.sessConfMap.get("password"));
        }
        try {
            void var4_13;
            int numRetry = 1;
            if (this.isBrowserAuthMode()) {
                numRetry = 2;
                this.browserClient.startListening();
            }
            boolean bl = false;
            while (var4_13 < numRetry) {
                try {
                    this.openSession(openReq);
                }
                catch (TException e) {
                    if (this.isSamlRedirect(e)) {
                        boolean success = this.doBrowserSSO();
                        if (!success) {
                            String msg = this.browserClient.getServerResponse() == null || this.browserClient.getServerResponse().getMsg() == null ? "" : this.browserClient.getServerResponse().getMsg();
                            throw new SQLException("Could not establish connection to " + this.jdbcUriString + ": " + msg, " 08S01", e);
                        }
                    }
                    throw new SQLException("Could not establish connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
                }
                ++var4_13;
            }
        }
        catch (IJdbcBrowserClient.HiveJdbcBrowserException e) {
            throw new SQLException("Could not establish connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
        }
        finally {
            if (this.browserClient != null) {
                try {
                    this.browserClient.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close the browser SSO client : " + e.getMessage(), e);
                }
            }
        }
        this.isClosed = false;
    }

    @VisibleForTesting
    protected void injectBrowserSSOError() throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected boolean doBrowserSSO() throws SQLException {
        try {
            this.injectBrowserSSOError();
            Preconditions.checkNotNull(this.browserClient);
            try (IJdbcBrowserClient bc = this.browserClient;){
                this.browserClient.doBrowserSSO();
                IJdbcBrowserClient.HiveJdbcBrowserServerResponse response = this.browserClient.getServerResponse();
                if (response != null) {
                    boolean bl2 = response.isSuccessful();
                    return bl2;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception ex) {
            throw new SQLException("Browser based SSO failed: " + ex.getMessage(), " 08S01", ex);
        }
    }

    @VisibleForTesting
    public IJdbcBrowserClient getBrowserClient() {
        return this.browserClient;
    }

    private void openSession(TOpenSessionReq openReq) throws TException, SQLException {
        TOpenSessionResp openResp = this.client.OpenSession(openReq);
        Map<String, String> serverHiveConf = openResp.getConfiguration();
        this.updateServerHiveConf(serverHiveConf, this.connParams);
        Utils.verifySuccess(openResp.getStatus());
        if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
            throw new TException("Unsupported Hive2 protocol");
        }
        this.protocol = openResp.getServerProtocolVersion();
        this.sessHandle = openResp.getSessionHandle();
        HiveConf.ConfVars fetchSizeConf = HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE;
        int serverFetchSize = Optional.ofNullable(openResp.getConfiguration().get(fetchSizeConf.varname)).map(size -> Integer.parseInt(size)).orElse(fetchSizeConf.defaultIntVal);
        if (serverFetchSize <= 0) {
            throw new IllegalStateException("Default fetch size must be greater than 0");
        }
        this.fetchSize = Optional.ofNullable(this.sessConfMap.get("fetchSize")).map(size -> Integer.parseInt(size)).filter(v -> v > 0).orElse(serverFetchSize);
        HiveConf.ConfVars fetchThreadsConf = HiveConf.ConfVars.HIVE_JDBC_FETCH_THREADS;
        int serverFetchThreads = Optional.ofNullable(openResp.getConfiguration().get(fetchThreadsConf.varname)).map(size -> Integer.parseInt(size)).orElse(fetchThreadsConf.defaultIntVal);
        if (serverFetchThreads <= 0) {
            throw new IllegalStateException("Default fetch threads must be >= 0");
        }
        this.fetchThreads = Optional.ofNullable(this.sessConfMap.get("fetchThreads")).map(size -> Integer.parseInt(size)).filter(v -> v >= 0).orElse(serverFetchThreads);
    }

    private boolean isSamlRedirect(TException e) {
        if (e.getMessage().startsWith("HTTP Response code: ")) {
            String code = e.getMessage().substring("HTTP Response code: ".length());
            try {
                int statusCode = Integer.parseInt(code.trim());
                if (statusCode == 303 || statusCode == 302) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isHplSqlMode() {
        return "HPLSQL".equalsIgnoreCase(this.sessConfMap.getOrDefault("mode", ""));
    }

    @VisibleForTesting
    public void updateServerHiveConf(Map<String, String> serverHiveConf, Utils.JdbcConnectionParams connParams) {
        if (serverHiveConf != null) {
            Stream.of(HiveConf.ConfVars.values()).forEach(conf -> {
                String key = "hiveconf:" + conf.varname;
                if (serverHiveConf.containsKey(conf.varname) && !connParams.getHiveConfs().containsKey(key)) {
                    connParams.getHiveConfs().put(key, (String)serverHiveConf.get(conf.varname));
                }
            });
        }
    }

    String getUserName() {
        return this.getSessionValue("user", "anonymous");
    }

    private String getPassword() {
        return this.getSessionValue("password", "anonymous");
    }

    private boolean isSslConnection() {
        return "true".equalsIgnoreCase(this.sessConfMap.get("ssl"));
    }

    private boolean isKerberosAuthMode() {
        return !"noSasl".equals(this.sessConfMap.get("auth")) && !"delegationToken".equals(this.sessConfMap.get("auth")) && this.sessConfMap.containsKey("principal");
    }

    private boolean isEnableCanonicalHostnameCheck() {
        return Boolean.parseBoolean(this.sessConfMap.getOrDefault("kerberosEnableCanonicalHostnameCheck", "true"));
    }

    private boolean isBrowserAuthMode() {
        return "browser".equals(this.sessConfMap.get("auth"));
    }

    private boolean isJwtAuthMode() {
        return "jwt".equalsIgnoreCase(this.sessConfMap.get("auth")) || this.sessConfMap.containsKey("jwt");
    }

    private boolean disableSSLValidation() {
        return Boolean.parseBoolean(this.sessConfMap.get("browserDisableSslCheck"));
    }

    private boolean isHttpTransportMode() {
        String transportMode = this.sessConfMap.get("transportMode");
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    private void logZkDiscoveryMessage(String message) {
        if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(this.sessConfMap)) {
            LOG.info(message);
        }
    }

    private String getSessionValue(String varName, String varDefault) {
        String varValue = this.sessConfMap.get(varName);
        if (varValue == null || varValue.isEmpty()) {
            varValue = varDefault;
        }
        return varValue;
    }

    private void setupLoginTimeout() {
        String socketTimeoutStr = this.sessConfMap.getOrDefault("socketTimeout", "0");
        long timeOut = 0L;
        try {
            timeOut = Long.parseLong(socketTimeoutStr);
        }
        catch (NumberFormatException e) {
            LOG.info("Failed to parse socketTimeout of value " + socketTimeoutStr);
        }
        this.loginTimeout = timeOut > Integer.MAX_VALUE ? Integer.MAX_VALUE : (timeOut < 0L ? 0 : (int)timeOut);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    public String getDelegationToken(String owner, String renewer) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        TGetDelegationTokenReq req = new TGetDelegationTokenReq(this.sessHandle, owner, renewer);
        try {
            TGetDelegationTokenResp tokenResp = this.client.GetDelegationToken(req);
            Utils.verifySuccess(tokenResp.getStatus());
            return tokenResp.getDelegationToken();
        }
        catch (TException e) {
            throw new SQLException("Could not retrieve token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void cancelDelegationToken(String tokenStr) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        TCancelDelegationTokenReq cancelReq = new TCancelDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TCancelDelegationTokenResp cancelResp = this.client.CancelDelegationToken(cancelReq);
            Utils.verifySuccess(cancelResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not cancel token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void renewDelegationToken(String tokenStr) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        TRenewDelegationTokenReq cancelReq = new TRenewDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TRenewDelegationTokenResp renewResp = this.client.RenewDelegationToken(cancelReq);
            Utils.verifySuccess(renewResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not renew token: " + e.getMessage(), " 08S01", e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.isClosed) {
                TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
                this.client.CloseSession(closeReq);
            }
        }
        catch (TException e) {
            throw new SQLException("Error while cleaning up the server resources", e);
        }
        finally {
            this.isClosed = true;
            this.client = null;
            if (this.transport != null && this.transport.isOpen()) {
                this.transport.close();
                this.transport = null;
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        return new HiveStatement(this, this.client, this.sessHandle, false, this.fetchSize, this.fetchThreads);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Statement with resultset concurrency " + resultSetConcurrency + " is not supported", "HYC00");
        }
        if (resultSetType == 1005) {
            throw new SQLException("Statement with resultset type " + resultSetType + " is not supported", "HYC00");
        }
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HiveStatement(this, this.client, this.sessHandle, resultSetType == 1004);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo == null ? new Properties() : this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.clientInfo == null) {
            return null;
        }
        return this.clientInfo.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HiveDatabaseMetaData(this, this.client, this.sessHandle);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try (Statement stmt = this.createStatement();){
            String string;
            block14: {
                ResultSet res = stmt.executeQuery("SELECT current_database()");
                try {
                    if (!res.next()) {
                        throw new SQLException("Failed to get schema information");
                    }
                    string = res.getString(1);
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return string;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout value was negative");
        }
        if (this.isClosed) {
            return false;
        }
        boolean rc = false;
        try {
            new HiveDatabaseMetaData(this, this.client, this.sessHandle).getDatabaseProductName();
            rc = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (!autoCommit) {
            LOG.warn("Request to set autoCommit to false; Hive does not support autoCommit=false.");
            SQLWarning warning = new SQLWarning("Hive does not support autoCommit=false");
            if (this.warningChain == null) {
                this.warningChain = warning;
            } else {
                this.warningChain.setNextWarning(warning);
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
        this.sendClientInfo();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.put(name, value);
        this.sendClientInfo();
    }

    private void sendClientInfo() throws SQLClientInfoException {
        if (this.isClosed) {
            throw new SQLClientInfoException("Connection is closed", null);
        }
        TSetClientInfoReq req = new TSetClientInfoReq(this.sessHandle);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.clientInfo != null) {
            for (Map.Entry<Object, Object> e : this.clientInfo.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                map.put(e.getKey().toString(), e.getValue().toString());
            }
        }
        req.setConfiguration(map);
        try {
            TSetClientInfoResp openResp = this.client.SetClientInfo(req);
            Utils.verifySuccess(openResp.getStatus());
        }
        catch (SQLException | TException e) {
            LOG.error("Error sending client info", e);
            throw new SQLClientInfoException("Error sending client info", null, (Throwable)e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (readOnly) {
            throw new SQLException("Enabling read-only mode not supported");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (schema == null || schema.isEmpty()) {
            throw new SQLException("Schema name is null or empty");
        }
        if (schema.contains(";")) {
            throw new SQLException("invalid schema name");
        }
        try (Statement stmt = this.createStatement();){
            stmt.execute("use " + schema);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    public TProtocolVersion getProtocol() {
        return this.protocol;
    }

    public Utils.JdbcConnectionParams getConnParams() {
        return this.connParams;
    }

    public Utils.JdbcConnectionParams setConnParams(Utils.JdbcConnectionParams jdbcConnectionParams) {
        this.connParams = jdbcConnectionParams;
        return this.connParams;
    }

    public static TCLIService.Iface newSynchronizedClient(TCLIService.Iface client) {
        return (TCLIService.Iface)Proxy.newProxyInstance(HiveConnection.class.getClassLoader(), new Class[]{TCLIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    static class DelegationTokenFetcher {
        DelegationTokenFetcher() {
        }

        String getTokenStringFromFile() throws IOException {
            if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") == null) {
                return null;
            }
            Credentials cred = new Credentials();
            try (DataInputStream dis = new DataInputStream(new FileInputStream(System.getenv("HADOOP_TOKEN_FILE_LOCATION")));){
                cred.readTokenStorageStream(dis);
            }
            return this.getTokenFromCredential(cred, "hive");
        }

        String getTokenFromCredential(Credentials cred, String key) throws IOException {
            Token<? extends TokenIdentifier> token = cred.getToken(new Text(key));
            if (token == null) {
                LOG.warn("Delegation token with key: [hive] cannot be found.");
                return null;
            }
            return token.encodeToUrlString();
        }

        String getTokenFromSession() throws IOException {
            LOG.debug("Fetching delegation token from session.");
            return SessionUtils.getTokenStrForm("hiveserver2ClientToken");
        }
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final TCLIService.Iface client;
        private final ReentrantLock lock = new ReentrantLock(true);

        SynchronizedHandler(TCLIService.Iface client) {
            this.client = client;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                this.lock.lock();
                Object object = method.invoke((Object)this.client, args);
                return object;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TException) {
                    throw (TException)e.getTargetException();
                }
                throw new TException("Error in calling method " + method.getName(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TException("Error in calling method " + method.getName(), e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

