/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.thrift.partial;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.TUnion;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.ListMetaData;
import org.apache.hive.org.apache.thrift.meta_data.MapMetaData;
import org.apache.hive.org.apache.thrift.meta_data.SetMetaData;
import org.apache.hive.org.apache.thrift.meta_data.StructMetaData;
import org.apache.hive.org.apache.thrift.partial.EnumCache;
import org.apache.hive.org.apache.thrift.partial.ThriftField;
import org.apache.hive.org.apache.thrift.partial.Validate;

public class ThriftMetadata {
    static IllegalArgumentException fieldNotFoundException(String fieldName) {
        return new IllegalArgumentException("field not found: '" + fieldName + "'");
    }

    static UnsupportedOperationException unsupportedFieldTypeException(byte fieldType) {
        return new UnsupportedOperationException("field type not supported: '" + fieldType + "'");
    }

    public static class ThriftStruct<U extends TBase>
    extends ThriftStructBase {
        public final Map<Integer, ThriftObject> fields;

        ThriftStruct(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data, Iterable<ThriftField> fieldsData) {
            super(parent, fieldId, data);
            Class clasz = ThriftStruct.getStructClass(data);
            this.fields = ThriftStruct.getFields(this, clasz, fieldsData);
        }

        public <T extends TBase> T createNewStruct() {
            TBase instance = null;
            try {
                Class structClass = ThriftStruct.getStructClass(this.data);
                instance = (TBase)structClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return (T)instance;
        }

        public static <T extends TBase> ThriftStruct of(Class<T> clasz) {
            return ThriftStruct.fromFields(clasz, Collections.emptyList());
        }

        public static <T extends TBase> ThriftStruct fromFieldNames(Class<T> clasz, Collection<String> fieldNames) {
            return ThriftStruct.fromFields(clasz, ThriftField.fromNames(fieldNames));
        }

        public static <T extends TBase> ThriftStruct fromFields(Class<T> clasz, Iterable<ThriftField> fields) {
            Validate.checkNotNull(clasz, "clasz");
            Validate.checkNotNull(fields, "fields");
            return new ThriftStruct(null, FieldTypeEnum.ROOT, new FieldMetaData(FieldTypeEnum.ROOT.getFieldName(), 1, new StructMetaData(12, clasz)), fields);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toPrettyString(sb, 0);
            return sb.toString();
        }

        @Override
        protected void toPrettyString(StringBuilder sb, int level) {
            String indent = this.getIndent(level);
            String indent2 = this.getIndent(level + 1);
            this.append(sb, "%sstruct %s {\n", indent, this.getName());
            if (this.fields.size() == 0) {
                this.append(sb, "%s*;", indent2);
            } else {
                ArrayList<Integer> ids = new ArrayList<Integer>(this.fields.keySet());
                Collections.sort(ids);
                for (Integer id : ids) {
                    this.fields.get(id).toPrettyString(sb, level + 1);
                }
            }
            this.append(sb, "%s}\n", indent);
        }

        private static <U extends TBase> Map<Integer, ThriftObject> getFields(ThriftStruct parent, Class<U> clasz, Iterable<ThriftField> fieldsData) {
            boolean getAllFields;
            Map<? extends TFieldIdEnum, FieldMetaData> fieldsMetaData = FieldMetaData.getStructMetaDataMap(clasz);
            HashMap<Integer, ThriftObject> fields = new HashMap<Integer, ThriftObject>();
            boolean bl = getAllFields = !fieldsData.iterator().hasNext();
            if (getAllFields) {
                for (Map.Entry<? extends TFieldIdEnum, FieldMetaData> entry : fieldsMetaData.entrySet()) {
                    TFieldIdEnum fieldId = entry.getKey();
                    FieldMetaData fieldMetaData = entry.getValue();
                    ThriftObject field = ThriftObject.Factory.createNew(parent, fieldId, fieldMetaData, Collections.emptyList());
                    fields.put(Integer.valueOf(fieldId.getThriftFieldId()), field);
                }
            } else {
                for (ThriftField fieldData : fieldsData) {
                    String fieldName = fieldData.name;
                    FieldMetaData fieldMetaData = ThriftStruct.findFieldMetaData(fieldsMetaData, fieldName);
                    TFieldIdEnum fieldId = ThriftStruct.findFieldId(fieldsMetaData, fieldName);
                    ThriftObject field = ThriftObject.Factory.createNew(parent, fieldId, fieldMetaData, fieldData.fields);
                    fields.put(Integer.valueOf(fieldId.getThriftFieldId()), field);
                }
            }
            return fields;
        }

        private static FieldMetaData findFieldMetaData(Map<? extends TFieldIdEnum, FieldMetaData> fieldsMetaData, String fieldName) {
            for (FieldMetaData fieldData : fieldsMetaData.values()) {
                if (!fieldData.fieldName.equals(fieldName)) continue;
                return fieldData;
            }
            throw ThriftMetadata.fieldNotFoundException(fieldName);
        }

        private static TFieldIdEnum findFieldId(Map<? extends TFieldIdEnum, FieldMetaData> fieldsMetaData, String fieldName) {
            for (TFieldIdEnum tFieldIdEnum : fieldsMetaData.keySet()) {
                if (!tFieldIdEnum.getFieldName().equals(fieldName)) continue;
                return tFieldIdEnum;
            }
            throw ThriftMetadata.fieldNotFoundException(fieldName);
        }
    }

    public static class ThriftUnion<U extends TBase>
    extends ThriftStructBase {
        public ThriftUnion(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data, Iterable<ThriftField> fieldsData) {
            super(parent, fieldId, data);
        }

        @Override
        protected void toPrettyString(StringBuilder sb, int level) {
            String indent = this.getIndent(level);
            String indent2 = this.getIndent(level + 1);
            this.append(sb, "%sunion %s {\n", indent, this.getName());
            this.append(sb, "%s// unions not adequately supported at present.\n", indent2);
            this.append(sb, "%s}\n", indent);
        }
    }

    public static abstract class ThriftStructBase<U extends TBase>
    extends ThriftObject {
        public ThriftStructBase(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data) {
            super(parent, fieldId, data);
        }

        public Class<U> getStructClass() {
            return ThriftStructBase.getStructClass(this.data);
        }

        public static <U extends TBase> Class<U> getStructClass(FieldMetaData data) {
            return ((StructMetaData)data.valueMetaData).structClass;
        }

        public boolean isUnion() {
            return ThriftStructBase.isUnion(this.data);
        }

        public static boolean isUnion(FieldMetaData data) {
            return TUnion.class.isAssignableFrom(ThriftStructBase.getStructClass(data));
        }

        public static ThriftStructBase create(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data, Iterable<ThriftField> fieldsData) {
            if (ThriftStructBase.isUnion(data)) {
                return new ThriftUnion(parent, fieldId, data, fieldsData);
            }
            return new ThriftStruct(parent, fieldId, data, fieldsData);
        }
    }

    public static class ThriftMap
    extends ThriftContainer {
        public final ThriftObject keyData;
        public final ThriftObject valueData;

        ThriftMap(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data, List<ThriftField> fields) {
            super(parent, fieldId, data);
            this.keyData = ThriftObject.Factory.createNew(this, FieldTypeEnum.MAP_KEY, new FieldMetaData(this.getSubElementName(fieldId, "key"), 1, ((MapMetaData)data.valueMetaData).keyMetaData), Collections.emptyList());
            this.valueData = ThriftObject.Factory.createNew(this, FieldTypeEnum.MAP_VALUE, new FieldMetaData(this.getSubElementName(fieldId, "value"), 1, ((MapMetaData)data.valueMetaData).valueMetaData), fields);
        }

        @Override
        public boolean hasUnion() {
            return this.keyData instanceof ThriftUnion || this.valueData instanceof ThriftUnion;
        }

        @Override
        protected void toPrettyString(StringBuilder sb, int level) {
            this.append(sb, "%smap<\n", this.getIndent(level));
            this.append(sb, "%skey = {\n", this.getIndent(level + 1));
            this.keyData.toPrettyString(sb, level + 2);
            this.append(sb, "%s},\n", this.getIndent(level + 1));
            this.append(sb, "%svalue = {\n", this.getIndent(level + 1));
            this.valueData.toPrettyString(sb, level + 2);
            this.append(sb, "%s}\n", this.getIndent(level + 1));
            this.append(sb, "%s> %s;\n", this.getIndent(level), this.getName());
        }
    }

    public static class ThriftSet
    extends ThriftContainer {
        public final ThriftObject elementData;

        ThriftSet(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data, List<ThriftField> fields) {
            super(parent, fieldId, data);
            this.elementData = ThriftObject.Factory.createNew(this, FieldTypeEnum.SET_ELEMENT, new FieldMetaData(this.getSubElementName(fieldId), 1, ((SetMetaData)data.valueMetaData).elemMetaData), fields);
        }

        @Override
        public boolean hasUnion() {
            return this.elementData instanceof ThriftUnion;
        }

        @Override
        protected void toPrettyString(StringBuilder sb, int level) {
            this.append(sb, "%sset<\n", this.getIndent(level));
            this.elementData.toPrettyString(sb, level + 1);
            this.append(sb, "%s> %s;\n", this.getIndent(level), this.getName());
        }
    }

    public static class ThriftList
    extends ThriftContainer {
        public final ThriftObject elementData;

        ThriftList(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data, List<ThriftField> fields) {
            super(parent, fieldId, data);
            this.elementData = ThriftObject.Factory.createNew(this, FieldTypeEnum.LIST_ELEMENT, new FieldMetaData(this.getSubElementName(fieldId), 1, ((ListMetaData)data.valueMetaData).elemMetaData), fields);
        }

        @Override
        public boolean hasUnion() {
            return this.elementData instanceof ThriftUnion;
        }

        @Override
        protected void toPrettyString(StringBuilder sb, int level) {
            this.append(sb, "%slist<\n", this.getIndent(level));
            this.elementData.toPrettyString(sb, level + 1);
            this.append(sb, "%s> %s;\n", this.getIndent(level), this.getName());
        }
    }

    public static abstract class ThriftContainer
    extends ThriftObject {
        public ThriftContainer(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data) {
            super(parent, fieldId, data);
        }

        public abstract boolean hasUnion();
    }

    public static class ThriftEnum
    extends ThriftObject {
        private static EnumCache enums = new EnumCache();

        ThriftEnum(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data) {
            super(parent, fieldId, data);
        }

        @Override
        protected void toPrettyString(StringBuilder sb, int level) {
            this.append(sb, "%senum %s;\n", this.getIndent(level), this.getName());
        }
    }

    public static class ThriftPrimitive
    extends ThriftObject {
        ThriftPrimitive(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data) {
            super(parent, fieldId, data);
        }

        public boolean isBinary() {
            return this.data.valueMetaData.isBinary();
        }

        @Override
        protected void toPrettyString(StringBuilder sb, int level) {
            String fieldType = this.getTypeName();
            this.append(sb, "%s%s %s;\n", this.getIndent(level), fieldType, this.getName());
        }

        private String getTypeName() {
            byte fieldType = this.data.valueMetaData.type;
            switch (fieldType) {
                case 2: {
                    return "bool";
                }
                case 3: {
                    return "byte";
                }
                case 6: {
                    return "i16";
                }
                case 8: {
                    return "i32";
                }
                case 10: {
                    return "i64";
                }
                case 4: {
                    return "double";
                }
                case 11: {
                    if (this.isBinary()) {
                        return "binary";
                    }
                    return "string";
                }
            }
            throw ThriftMetadata.unsupportedFieldTypeException(fieldType);
        }
    }

    public static abstract class ThriftObject
    implements Serializable {
        public final ThriftObject parent;
        public final TFieldIdEnum fieldId;
        public final FieldMetaData data;
        public Object additionalData;
        protected List<String> noFields = Collections.emptyList();

        ThriftObject(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data) {
            this.parent = parent;
            this.fieldId = fieldId;
            this.data = data;
        }

        protected abstract void toPrettyString(StringBuilder var1, int var2);

        protected String getIndent(int level) {
            return StringUtils.repeat(" ", level * 4);
        }

        protected void append(StringBuilder sb, String format, Object ... args) {
            sb.append(String.format(format, args));
        }

        protected String getName() {
            return this.fieldId.getFieldName();
        }

        protected String getSubElementName(TFieldIdEnum fieldId) {
            return this.getSubElementName(fieldId, "element");
        }

        protected String getSubElementName(TFieldIdEnum fieldId, String suffix) {
            return String.format("%s_%s", fieldId.getFieldName(), suffix);
        }

        private static class Factory {
            private Factory() {
            }

            static ThriftObject createNew(ThriftObject parent, TFieldIdEnum fieldId, FieldMetaData data, List<ThriftField> fields) {
                byte fieldType = data.valueMetaData.type;
                switch (fieldType) {
                    case 12: {
                        return ThriftStructBase.create(parent, fieldId, data, fields);
                    }
                    case 15: {
                        return new ThriftList(parent, fieldId, data, fields);
                    }
                    case 13: {
                        return new ThriftMap(parent, fieldId, data, fields);
                    }
                    case 14: {
                        return new ThriftSet(parent, fieldId, data, fields);
                    }
                    case 16: {
                        return new ThriftEnum(parent, fieldId, data);
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 11: {
                        return new ThriftPrimitive(parent, fieldId, data);
                    }
                }
                throw ThriftMetadata.unsupportedFieldTypeException(fieldType);
            }
        }
    }

    private static enum ComparisonResult {
        UNKNOWN,
        EQUAL,
        NOT_EQUAL;

    }

    static enum FieldTypeEnum implements TFieldIdEnum
    {
        ROOT(0, "root"),
        ENUM(1, "enum"),
        LIST_ELEMENT(2, "listElement"),
        MAP_KEY(3, "mapKey"),
        MAP_VALUE(4, "mapValue"),
        SET_ELEMENT(5, "setElement");

        private short id;
        private String name;

        private FieldTypeEnum(short id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public short getThriftFieldId() {
            return this.id;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }
    }
}

