/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.saml;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Splitter;
import org.apache.hive.service.auth.saml.HiveSamlAuthTokenGenerator;
import org.apache.hive.service.auth.saml.HiveSamlGroupNameFilter;
import org.apache.hive.service.auth.saml.HiveSamlRelayStateStore;
import org.apache.hive.service.auth.saml.HiveSamlUtils;
import org.apache.hive.service.auth.saml.HttpSamlAuthenticationException;
import org.apache.hive.service.auth.saml.HttpSamlNoGroupsMatchedException;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.credentials.extractor.SAML2CredentialsExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSaml2Client
extends SAML2Client {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSaml2Client.class);
    private static HiveSaml2Client INSTANCE;
    private final HiveSamlGroupNameFilter groupNameFilter;

    private HiveSaml2Client(HiveConf conf) throws Exception {
        super(HiveSaml2Client.getSamlConfig(conf));
        this.setCallbackUrl(HiveSaml2Client.getCallBackUrl(conf));
        this.setName(HiveSaml2Client.class.getSimpleName());
        this.setStateGenerator(HiveSamlRelayStateStore.get());
        this.groupNameFilter = new HiveSamlGroupNameFilter(conf);
        this.init();
    }

    private static String getCallBackUrl(HiveConf conf) throws Exception {
        URI callbackURI = HiveSamlUtils.getCallBackUri(conf);
        return callbackURI.toString();
    }

    public static synchronized HiveSaml2Client get(HiveConf conf) throws HttpSamlAuthenticationException {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        try {
            INSTANCE = new HiveSaml2Client(conf);
        }
        catch (Exception e) {
            throw new HttpSamlAuthenticationException("Could not instantiate SAML2.0 client", e);
        }
        return INSTANCE;
    }

    private static SAML2Configuration getSamlConfig(HiveConf conf) throws Exception {
        String disallowedSignatureAlgos;
        SAML2Configuration saml2Configuration = new SAML2Configuration(conf.get(HiveConf.ConfVars.HIVE_SERVER2_SAML_KEYSTORE_PATH.varname), String.valueOf(conf.getPassword(HiveConf.ConfVars.HIVE_SERVER2_SAML_KEYSTORE_PASSWORD.varname)), String.valueOf(conf.getPassword(HiveConf.ConfVars.HIVE_SERVER2_SAML_PRIVATE_KEY_PASSWORD.varname)), conf.get(HiveConf.ConfVars.HIVE_SERVER2_SAML_IDP_METADATA.varname));
        saml2Configuration.setAuthnRequestBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        saml2Configuration.setResponseBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        saml2Configuration.setForceAuth(conf.getBoolean(HiveConf.ConfVars.HIVE_SERVER2_SAML_FORCE_AUTH.varname, false));
        saml2Configuration.setMaximumAuthenticationLifetime((int)conf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_SAML_AUTHENTICATION_LIFETIME, TimeUnit.SECONDS));
        String acsIndex = conf.get(HiveConf.ConfVars.HIVE_SERVER2_SAML_ACS_INDEX.varname, "");
        if (!acsIndex.isEmpty()) {
            saml2Configuration.setAssertionConsumerServiceIndex(conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_SAML_ACS_INDEX));
        }
        if (!(disallowedSignatureAlgos = conf.get(HiveConf.ConfVars.HIVE_SERVER2_SAML_BLACKLISTED_SIGNATURE_ALGORITHMS.varname, "")).isEmpty()) {
            LOG.info("List of disallowed signature algorithms: " + disallowedSignatureAlgos);
            List<String> blackListedSignAlgos = Splitter.on(',').splitToList(disallowedSignatureAlgos);
            saml2Configuration.setBlackListedSignatureSigningAlgorithms(blackListedSignAlgos);
        }
        saml2Configuration.setServiceProviderEntityId(conf.get(HiveConf.ConfVars.HIVE_SERVER2_SAML_SP_ID.varname, HiveSaml2Client.getCallBackUrl(conf)));
        saml2Configuration.setWantsAssertionsSigned(conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SAML_WANT_ASSERTIONS_SIGNED));
        saml2Configuration.setAuthnRequestSigned(conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SAML_SIGN_REQUESTS));
        return saml2Configuration;
    }

    @VisibleForTesting
    public static synchronized void shutdown() {
        INSTANCE = null;
        HiveSamlAuthTokenGenerator.shutdown();
    }

    public void setRedirect(HttpServletRequest request, HttpServletResponse response) throws HttpSamlAuthenticationException {
        int responsePort = HiveSamlUtils.validateSamlResponsePort(request);
        LOG.debug("Request has response port set as {}", (Object)responsePort);
        Optional redirect = this.getRedirectionAction((WebContext)new JEEContext(request, response));
        if (!redirect.isPresent()) {
            throw new HttpSamlAuthenticationException("Could not get the redirect response");
        }
        response.setStatus(((RedirectionAction)redirect.get()).getCode());
        WithLocationAction locationAction = (WithLocationAction)redirect.get();
        try {
            String location = locationAction.getLocation();
            LOG.debug("Sending a redirect response to location = {}", (Object)location);
            response.sendRedirect(locationAction.getLocation());
        }
        catch (IOException e) {
            throw new HttpSamlAuthenticationException(e);
        }
    }

    public String validate(HttpServletRequest request, HttpServletResponse response) throws HttpSamlAuthenticationException {
        Optional credentials;
        try {
            SAML2CredentialsExtractor credentialsExtractor = new SAML2CredentialsExtractor((SAML2Client)this);
            credentials = credentialsExtractor.extract((WebContext)new JEEContext(request, response));
        }
        catch (Exception ex) {
            throw new HttpSamlAuthenticationException("Could not validate the SAML response", ex);
        }
        if (!credentials.isPresent()) {
            throw new HttpSamlAuthenticationException("Credentials could not be extracted");
        }
        String nameId = ((SAML2Credentials)credentials.get()).getNameId().getValue();
        if (!this.groupNameFilter.apply(((SAML2Credentials)credentials.get()).getAttributes())) {
            LOG.warn("Could not match any groups for the nameid {}", (Object)nameId);
            throw new HttpSamlNoGroupsMatchedException("None of the configured groups match for the user");
        }
        return nameId;
    }
}

