/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.org.apache.thrift.TProcessorFactory;
import org.apache.hive.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.server.ServerContext;
import org.apache.hive.org.apache.thrift.server.TServer;
import org.apache.hive.org.apache.thrift.server.TServerEventHandler;
import org.apache.hive.org.apache.thrift.server.TThreadPoolServer;
import org.apache.hive.org.apache.thrift.transport.TServerSocket;
import org.apache.hive.org.apache.thrift.transport.TSocket;
import org.apache.hive.org.apache.thrift.transport.TTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;
import org.apache.hive.org.apache.thrift.transport.TTransportFactory;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    protected TServer server;

    public ThriftBinaryCLIService(CLIService cliService) {
        super(cliService, ThriftBinaryCLIService.class.getSimpleName());
    }

    @Override
    protected HiveServer2TransportMode getTransportMode() {
        return HiveServer2TransportMode.binary;
    }

    @Override
    protected void initServer() {
        try {
            String threadPoolName = "HiveServer2-Handler-Pool";
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryWithGarbageCleanup(threadPoolName));
            this.hiveAuthFactory = new HiveAuthFactory(this.hiveConf, false);
            TTransportFactory transportFactory = this.hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = this.hiveAuthFactory.getAuthProcFactory(this);
            TServerSocket serverSocket = null;
            ArrayList<String> sslVersionBlacklist = new ArrayList<String>();
            for (String sslVersion : this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST).split(",")) {
                sslVersionBlacklist.add(sslVersion);
            }
            if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL)) {
                serverSocket = HiveAuthUtils.getServerSocket(this.hiveHost, this.portNum);
            } else {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                String keyStorePassword = ShimLoader.getHadoopShims().getPassword(this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname);
                String keyStoreType = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_TYPE).trim();
                String keyStoreAlgorithm = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYMANAGERFACTORY_ALGORITHM).trim();
                String includeCiphersuites = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_BINARY_INCLUDE_CIPHERSUITES).trim();
                serverSocket = HiveAuthUtils.getServerSSLSocket(this.hiveHost, this.portNum, keyStorePath, keyStorePassword, keyStoreType, keyStoreAlgorithm, sslVersionBlacklist, includeCiphersuites);
            }
            int maxMessageSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_MESSAGE_SIZE);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args(new TServerSocket(serverSocket.getServerSocket()){

                @Override
                public TSocket accept() throws TTransportException {
                    TSocket ts = super.accept();
                    int maxThriftMessageSize = (int)HiveConf.getSizeVar(ThriftBinaryCLIService.this.hiveConf, HiveConf.ConfVars.HIVE_THRIFT_CLIENT_MAX_MESSAGE_SIZE);
                    return HiveAuthUtils.configureThriftMaxMessageSize(ts, maxThriftMessageSize);
                }
            }).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory(new TBinaryProtocol.Factory())).inputProtocolFactory(new TBinaryProtocol.Factory(true, true, maxMessageSize, maxMessageSize))).executorService(executorService);
            this.server = new TThreadPoolServer(sargs);
            this.server.setServerEventHandler(new TServerEventHandler(){

                @Override
                public ServerContext createContext(TProtocol input, TProtocol output) {
                    Metrics metrics = MetricsFactory.getInstance();
                    if (metrics != null) {
                        metrics.incrementCounter("open_connections");
                        metrics.incrementCounter("cumulative_connection_count");
                    }
                    return new ThriftCLIService.ThriftCLIServerContext();
                }

                @Override
                public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
                    block7: {
                        ThriftCLIService.ThriftCLIServerContext context;
                        Optional<SessionHandle> sessionHandle;
                        Metrics metrics = MetricsFactory.getInstance();
                        if (metrics != null) {
                            metrics.decrementCounter("open_connections");
                        }
                        if ((sessionHandle = (context = (ThriftCLIService.ThriftCLIServerContext)serverContext).getSessionHandle()).isPresent()) {
                            ThriftCLIService.LOG.warn("Client connection bound to {} unexpectedly closed: closing this Hive session to release its resources. The connection processed {} total messages during its lifetime of {}ms. Inspect the client connection for time-out, firewall killing the connection, invalid load balancer configuration, etc.", sessionHandle, context.getMessagesProcessedCount(), context.getDuration().toMillis());
                            try {
                                boolean close = ThriftBinaryCLIService.this.cliService.getSessionManager().getSession(sessionHandle.get()).getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_CLOSE_SESSION_ON_DISCONNECT);
                                if (close) {
                                    ThriftBinaryCLIService.this.cliService.closeSession(sessionHandle.get());
                                    break block7;
                                }
                                ThriftCLIService.LOG.warn("Session not actually closed because configuration {} is set to false", (Object)HiveConf.ConfVars.HIVE_SERVER2_CLOSE_SESSION_ON_DISCONNECT.varname);
                            }
                            catch (HiveSQLException e) {
                                ThriftCLIService.LOG.warn("Failed to close session", e);
                            }
                        } else if (context.getSessionCount() == 0) {
                            ThriftCLIService.LOG.info("A client connection was closed before creating a Hive session. Most likely it is a client that is connecting to this server then immediately closing the socket (i.e., TCP health check or port scanner)");
                        }
                    }
                }

                @Override
                public void preServe() {
                }

                @Override
                public void processContext(ServerContext serverContext, TTransport input, TTransport output) {
                    ThriftCLIService.ThriftCLIServerContext context = (ThriftCLIService.ThriftCLIServerContext)serverContext;
                    ThriftBinaryCLIService.this.currentServerContext.set(context);
                    context.incMessagesProcessedCount();
                }
            });
            String msg = "Starting " + ThriftBinaryCLIService.class.getSimpleName() + " on port " + this.portNum + " with " + this.minWorkerThreads + "..." + this.maxWorkerThreads + " worker threads";
            LOG.info(msg);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init thrift server", e);
        }
    }

    @Override
    public void run() {
        try {
            this.server.serve();
        }
        catch (Throwable t2) {
            if (t2 instanceof InterruptedException) {
                LOG.info("Caught " + t2.getClass().getSimpleName() + ". Shutting down.");
            } else {
                LOG.error("Exception caught by " + this.getClass().getSimpleName() + ". Exiting.", t2);
            }
            System.exit(-1);
        }
    }

    @Override
    protected void stopServer() {
        this.server.stop();
        this.server = null;
        LOG.info("Thrift server has stopped");
    }
}

