/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.server.ServerContext;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.ServiceUtils;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.JobProgressUpdate;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.ProgressMonitorStatusMapper;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.TezProgressMonitorStatusMapper;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TCancelOperationReq;
import org.apache.hive.service.rpc.thrift.TCancelOperationResp;
import org.apache.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.hive.service.rpc.thrift.TCloseSessionReq;
import org.apache.hive.service.rpc.thrift.TCloseSessionResp;
import org.apache.hive.service.rpc.thrift.TDownloadDataReq;
import org.apache.hive.service.rpc.thrift.TDownloadDataResp;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import org.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import org.apache.hive.service.rpc.thrift.TGetColumnsReq;
import org.apache.hive.service.rpc.thrift.TGetColumnsResp;
import org.apache.hive.service.rpc.thrift.TGetCrossReferenceReq;
import org.apache.hive.service.rpc.thrift.TGetCrossReferenceResp;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import org.apache.hive.service.rpc.thrift.TGetFunctionsResp;
import org.apache.hive.service.rpc.thrift.TGetInfoReq;
import org.apache.hive.service.rpc.thrift.TGetInfoResp;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.hive.service.rpc.thrift.TGetPrimaryKeysReq;
import org.apache.hive.service.rpc.thrift.TGetPrimaryKeysResp;
import org.apache.hive.service.rpc.thrift.TGetQueryIdReq;
import org.apache.hive.service.rpc.thrift.TGetQueryIdResp;
import org.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import org.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.rpc.thrift.TGetSchemasReq;
import org.apache.hive.service.rpc.thrift.TGetSchemasResp;
import org.apache.hive.service.rpc.thrift.TGetTableTypesReq;
import org.apache.hive.service.rpc.thrift.TGetTableTypesResp;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.hive.service.rpc.thrift.TGetTablesResp;
import org.apache.hive.service.rpc.thrift.TGetTypeInfoReq;
import org.apache.hive.service.rpc.thrift.TGetTypeInfoResp;
import org.apache.hive.service.rpc.thrift.TJobExecutionStatus;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TProgressUpdateResp;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TSetClientInfoReq;
import org.apache.hive.service.rpc.thrift.TSetClientInfoResp;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.hive.service.rpc.thrift.TUploadDataReq;
import org.apache.hive.service.rpc.thrift.TUploadDataResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThriftCLIService
extends AbstractService
implements TCLIService.Iface,
Runnable {
    protected static final Logger LOG = LoggerFactory.getLogger(ThriftCLIService.class);
    protected CLIService cliService;
    private static final TStatus OK_STATUS = new TStatus(TStatusCode.SUCCESS_STATUS);
    protected HiveAuthFactory hiveAuthFactory;
    protected int portNum;
    protected InetAddress serverIPAddress;
    protected String hiveHost;
    private boolean isStarted = false;
    protected boolean isEmbedded = false;
    protected HiveConf hiveConf;
    protected int minWorkerThreads;
    protected int maxWorkerThreads;
    protected long workerKeepAliveTime;
    private Thread serverThread;
    protected ThreadLocal<ServerContext> currentServerContext;

    public ThriftCLIService(CLIService service, String serviceName) {
        super(serviceName);
        this.cliService = service;
        this.currentServerContext = new ThreadLocal();
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
        if (this.hiveHost == null) {
            this.hiveHost = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
        }
        try {
            this.serverIPAddress = ServerUtils.getHostAddress(this.hiveHost);
        }
        catch (UnknownHostException e) {
            throw new ServiceException(e);
        }
        if (this.getTransportMode() == HiveServer2TransportMode.http) {
            this.workerKeepAliveTime = hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_WORKER_KEEPALIVE_TIME, TimeUnit.SECONDS);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_HTTP_PORT");
            this.portNum = portString != null ? Integer.parseInt(portString) : hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT);
        } else {
            this.workerKeepAliveTime = hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_WORKER_KEEPALIVE_TIME, TimeUnit.SECONDS);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_PORT");
            this.portNum = portString != null ? Integer.parseInt(portString) : hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
        }
        this.minWorkerThreads = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS);
        this.maxWorkerThreads = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS);
        super.init(hiveConf);
    }

    protected abstract void initServer();

    @Override
    public synchronized void start() {
        super.start();
        if (!this.isStarted && !this.isEmbedded) {
            this.initServer();
            this.serverThread = new Thread(this);
            this.serverThread.setName("Thrift Server");
            this.serverThread.start();
            this.isStarted = true;
        }
    }

    protected abstract void stopServer();

    @Override
    public synchronized void stop() {
        if (this.isStarted && !this.isEmbedded) {
            if (this.serverThread != null) {
                this.serverThread.interrupt();
                this.serverThread = null;
            }
            this.stopServer();
            this.isStarted = false;
        }
        super.stop();
    }

    public int getPortNumber() {
        return this.portNum;
    }

    public InetAddress getServerIPAddress() {
        return this.serverIPAddress;
    }

    @Override
    public TGetDelegationTokenResp GetDelegationToken(TGetDelegationTokenReq req) throws TException {
        TGetDelegationTokenResp resp = new TGetDelegationTokenResp();
        if (this.hiveAuthFactory == null || !this.hiveAuthFactory.isSASLKerberosUser()) {
            resp.setStatus(this.unsecureTokenErrorStatus());
        } else {
            try {
                String token = this.cliService.getDelegationToken(new SessionHandle(req.getSessionHandle()), this.hiveAuthFactory, req.getOwner(), req.getRenewer());
                resp.setDelegationToken(token);
                resp.setStatus(OK_STATUS);
            }
            catch (HiveSQLException e) {
                LOG.error("Failed to get delegation token [request: {}]", (Object)req, (Object)e);
                TStatus tokenErrorStatus = HiveSQLException.toTStatus(e);
                tokenErrorStatus.setSqlState("42000");
                resp.setStatus(tokenErrorStatus);
            }
        }
        return resp;
    }

    @Override
    public TCancelDelegationTokenResp CancelDelegationToken(TCancelDelegationTokenReq req) throws TException {
        TCancelDelegationTokenResp resp = new TCancelDelegationTokenResp();
        if (this.hiveAuthFactory == null || !this.hiveAuthFactory.isSASLKerberosUser()) {
            resp.setStatus(this.unsecureTokenErrorStatus());
        } else {
            try {
                this.cliService.cancelDelegationToken(new SessionHandle(req.getSessionHandle()), this.hiveAuthFactory, req.getDelegationToken());
                resp.setStatus(OK_STATUS);
            }
            catch (HiveSQLException e) {
                LOG.error("Failed to cancel delegation token [request: {}]", (Object)req, (Object)e);
                resp.setStatus(HiveSQLException.toTStatus(e));
            }
        }
        return resp;
    }

    @Override
    public TRenewDelegationTokenResp RenewDelegationToken(TRenewDelegationTokenReq req) throws TException {
        TRenewDelegationTokenResp resp = new TRenewDelegationTokenResp();
        if (this.hiveAuthFactory == null || !this.hiveAuthFactory.isSASLKerberosUser()) {
            resp.setStatus(this.unsecureTokenErrorStatus());
        } else {
            try {
                this.cliService.renewDelegationToken(new SessionHandle(req.getSessionHandle()), this.hiveAuthFactory, req.getDelegationToken());
                resp.setStatus(OK_STATUS);
            }
            catch (HiveSQLException e) {
                LOG.error("Failed to renew delegation token [request: {}]", e);
                resp.setStatus(HiveSQLException.toTStatus(e));
            }
        }
        return resp;
    }

    private TStatus unsecureTokenErrorStatus() {
        TStatus errorStatus = new TStatus(TStatusCode.ERROR_STATUS);
        errorStatus.setErrorMessage("Delegation token only supported over remote client with kerberos authentication");
        return errorStatus;
    }

    @Override
    public TOpenSessionResp OpenSession(TOpenSessionReq req) throws TException {
        LOG.info("Client protocol version: " + req.getClient_protocol());
        TOpenSessionResp resp = new TOpenSessionResp();
        String userName = null;
        try {
            userName = this.getUserName(req);
            SessionHandle sessionHandle = this.getSessionHandle(req, resp, userName);
            int fetchSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE.varname, Integer.toString(fetchSize));
            map.put(HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST.varname, String.valueOf(this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST)));
            resp.setSessionHandle(sessionHandle.toTSessionHandle());
            resp.setConfiguration(map);
            resp.setStatus(OK_STATUS);
            ThriftCLIServerContext context = (ThriftCLIServerContext)this.currentServerContext.get();
            if (context != null) {
                context.setSessionHandle(sessionHandle);
            }
            LOG.info("Login attempt is successful for user : " + userName);
        }
        catch (Exception e) {
            LOG.error("Login attempt failed for user : {}", (Object)userName, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TSetClientInfoResp SetClientInfo(TSetClientInfoReq req) throws TException {
        TSetClientInfoResp resp = null;
        if (req.isSetConfiguration()) {
            StringBuilder sb = null;
            SessionHandle sh = null;
            for (Map.Entry<String, String> e : req.getConfiguration().entrySet()) {
                if (sb == null) {
                    sh = new SessionHandle(req.getSessionHandle());
                    sb = new StringBuilder("Client information for ").append(sh).append(": ");
                } else {
                    sb.append(", ");
                }
                sb.append(e.getKey()).append(" = ").append(e.getValue());
                if (!"ApplicationName".equals(e.getKey())) continue;
                try {
                    this.cliService.setApplicationName(sh, e.getValue());
                }
                catch (Exception ex) {
                    LOG.error("Failed setting application name", ex);
                    resp = new TSetClientInfoResp(HiveSQLException.toTStatus(ex));
                }
            }
            if (sb != null) {
                LOG.info("{}", (Object)sb);
            }
        }
        return resp == null ? new TSetClientInfoResp(OK_STATUS) : resp;
    }

    private String getIpAddress() {
        String clientIpAddress = this.getTransportMode() == HiveServer2TransportMode.http ? SessionManager.getIpAddress() : (this.hiveAuthFactory != null && this.hiveAuthFactory.isSASLWithKerberizedHadoop() ? this.hiveAuthFactory.getIpAddress() : TSetIpAddressProcessor.getUserIpAddress());
        return clientIpAddress;
    }

    private String getUserName(TOpenSessionReq req) throws HiveSQLException, IOException {
        String userName = null;
        if (this.hiveAuthFactory != null && this.hiveAuthFactory.isSASLWithKerberizedHadoop()) {
            userName = this.hiveAuthFactory.getRemoteUser();
        }
        if (userName == null) {
            userName = TSetIpAddressProcessor.getUserName();
        }
        if (this.getTransportMode() == HiveServer2TransportMode.http) {
            userName = SessionManager.getUserName();
        }
        if (userName == null) {
            userName = req.getUsername();
        }
        if (this.cliService.getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_KERBEROS_USE_SHORTNAME)) {
            userName = this.getShortName(userName);
        }
        String effectiveClientUser = this.getProxyUser(userName, req.getConfiguration(), this.getIpAddress());
        LOG.debug("Client's username: {}", (Object)effectiveClientUser);
        return effectiveClientUser;
    }

    private String getShortName(String userName) throws IOException {
        String ret = null;
        if (userName != null) {
            if (this.hiveAuthFactory != null && this.hiveAuthFactory.isSASLKerberosUser()) {
                HadoopShims.KerberosNameShim fullKerberosName = ShimLoader.getHadoopShims().getKerberosNameShim(userName);
                ret = fullKerberosName.getShortName();
            } else {
                int indexOfDomainMatch = ServiceUtils.indexOfDomainMatch(userName);
                ret = indexOfDomainMatch <= 0 ? userName : userName.substring(0, indexOfDomainMatch);
            }
        }
        return ret;
    }

    private SessionHandle getSessionHandle(TOpenSessionReq req, TOpenSessionResp res, String userName) throws HiveSQLException, LoginException, IOException {
        SessionHandle sessionHandle;
        String ipAddress = this.getIpAddress();
        LOG.info("Creating Hive session handle for user [{}] from IP {}", (Object)req.getUsername(), (Object)ipAddress);
        TProtocolVersion protocol = this.getMinVersion(CLIService.SERVER_VERSION, req.getClient_protocol());
        if (this.cliService.getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS) && userName != null) {
            String delegationTokenStr = this.getDelegationToken(userName);
            sessionHandle = this.cliService.openSessionWithImpersonation(protocol, userName, req.getPassword(), ipAddress, req.getConfiguration(), delegationTokenStr);
        } else {
            sessionHandle = this.cliService.openSession(protocol, userName, req.getPassword(), ipAddress, req.getConfiguration());
        }
        res.setServerProtocolVersion(protocol);
        return sessionHandle;
    }

    private double getProgressedPercentage(OperationHandle opHandle) throws HiveSQLException {
        Preconditions.checkArgument(OperationType.EXECUTE_STATEMENT == opHandle.getOperationType());
        Operation operation = this.cliService.getSessionManager().getOperationManager().getOperation(opHandle);
        SessionState state = operation.getParentSession().getSessionState();
        ProgressMonitor monitor = state.getProgressMonitor();
        return monitor == null ? 0.0 : monitor.progressedPercentage();
    }

    private String getDelegationToken(String userName) throws HiveSQLException, LoginException, IOException {
        try {
            return this.cliService.getDelegationTokenFromMetaStore(userName);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    private TProtocolVersion getMinVersion(TProtocolVersion ... versions) {
        TProtocolVersion[] values = TProtocolVersion.values();
        int current = values[values.length - 1].getValue();
        for (TProtocolVersion version : versions) {
            if (current <= version.getValue()) continue;
            current = version.getValue();
        }
        for (TProtocolVersion version : values) {
            if (version.getValue() != current) continue;
            return version;
        }
        throw new IllegalArgumentException("never");
    }

    @Override
    public TCloseSessionResp CloseSession(TCloseSessionReq req) throws TException {
        TCloseSessionResp resp = new TCloseSessionResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            this.cliService.closeSession(sessionHandle);
            resp.setStatus(OK_STATUS);
            ThriftCLIServerContext context = (ThriftCLIServerContext)this.currentServerContext.get();
            if (context != null) {
                context.clearSessionHandle();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close the session", e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetInfoResp GetInfo(TGetInfoReq req) throws TException {
        TGetInfoResp resp = new TGetInfoResp();
        try {
            GetInfoValue getInfoValue = this.cliService.getInfo(new SessionHandle(req.getSessionHandle()), GetInfoType.getGetInfoType(req.getInfoType()));
            resp.setInfoValue(getInfoValue.toTGetInfoValue());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get info", e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TExecuteStatementResp ExecuteStatement(TExecuteStatementReq req) throws TException {
        TExecuteStatementResp resp = new TExecuteStatementResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            String statement = req.getStatement();
            Map<String, String> confOverlay = req.getConfOverlay();
            Boolean runAsync = req.isRunAsync();
            long queryTimeout = req.getQueryTimeout();
            OperationHandle operationHandle = runAsync != false ? this.cliService.executeStatementAsync(sessionHandle, statement, confOverlay, queryTimeout) : this.cliService.executeStatement(sessionHandle, statement, confOverlay, queryTimeout);
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            SessionManager sessionManager = this.cliService.getSessionManager();
            if (sessionManager.getOperationManager().canShowDrilldownLink(operationHandle)) {
                StringBuilder urlBuilder = new StringBuilder("The url to track the statement: ").append(this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL) ? "https" : "http").append("://").append(sessionManager.getHiveServer2HostName()).append(":").append(this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT)).append("/query_page.html?operationId=").append(operationHandle.getHandleIdentifier().toString());
                TStatus successWithInfo = new TStatus(TStatusCode.SUCCESS_WITH_INFO_STATUS);
                successWithInfo.addToInfoMessages(urlBuilder.toString());
                resp.setStatus(successWithInfo);
            } else {
                resp.setStatus(OK_STATUS);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to execute statement [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetTypeInfoResp GetTypeInfo(TGetTypeInfoReq req) throws TException {
        TGetTypeInfoResp resp = new TGetTypeInfoResp();
        try {
            OperationHandle operationHandle = this.cliService.getTypeInfo(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get type info [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetCatalogsResp GetCatalogs(TGetCatalogsReq req) throws TException {
        TGetCatalogsResp resp = new TGetCatalogsResp();
        try {
            OperationHandle opHandle = this.cliService.getCatalogs(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed getting catalogs [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetSchemasResp GetSchemas(TGetSchemasReq req) throws TException {
        TGetSchemasResp resp = new TGetSchemasResp();
        try {
            OperationHandle opHandle = this.cliService.getSchemas(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get schemas [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetTablesResp GetTables(TGetTablesReq req) throws TException {
        TGetTablesResp resp = new TGetTablesResp();
        try {
            OperationHandle opHandle = this.cliService.getTables(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getTableTypes());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get tables [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetTableTypesResp GetTableTypes(TGetTableTypesReq req) throws TException {
        TGetTableTypesResp resp = new TGetTableTypesResp();
        try {
            OperationHandle opHandle = this.cliService.getTableTypes(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get table types [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetColumnsResp GetColumns(TGetColumnsReq req) throws TException {
        TGetColumnsResp resp = new TGetColumnsResp();
        try {
            OperationHandle opHandle = this.cliService.getColumns(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getColumnName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get column types [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetFunctionsResp GetFunctions(TGetFunctionsReq req) throws TException {
        TGetFunctionsResp resp = new TGetFunctionsResp();
        try {
            OperationHandle opHandle = this.cliService.getFunctions(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getFunctionName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get function: [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetOperationStatusResp GetOperationStatus(TGetOperationStatusReq req) throws TException {
        TGetOperationStatusResp resp = new TGetOperationStatusResp();
        OperationHandle operationHandle = new OperationHandle(req.getOperationHandle());
        try {
            OperationStatus operationStatus = this.cliService.getOperationStatus(operationHandle, req.isGetProgressUpdate());
            HiveConf sessionConf = this.cliService.getHiveSessionConf(operationHandle);
            if (operationStatus.getState().equals((Object)OperationState.FINISHED)) {
                long numModifiedRows = operationStatus.getNumModifiedRows();
                resp.setNumModifiedRows(numModifiedRows);
            }
            resp.setOperationState(operationStatus.getState().toTOperationState());
            resp.setErrorMessage(operationStatus.getState().getErrorMessage());
            HiveSQLException opException = operationStatus.getOperationException();
            resp.setTaskStatus(operationStatus.getTaskStatus());
            resp.setOperationStarted(operationStatus.getOperationStarted());
            resp.setOperationCompleted(operationStatus.getOperationCompleted());
            if (operationStatus.isHasResultSetIsSet()) {
                resp.setHasResultSet(operationStatus.getHasResultSet());
            }
            JobProgressUpdate progressUpdate = operationStatus.jobProgressUpdate();
            ProgressMonitorStatusMapper mapper = ProgressMonitorStatusMapper.DEFAULT;
            if ("tez".equals(sessionConf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
                mapper = new TezProgressMonitorStatusMapper();
            }
            TJobExecutionStatus executionStatus = mapper.forStatus(progressUpdate.status);
            resp.setProgressUpdateResponse(new TProgressUpdateResp(progressUpdate.headers(), progressUpdate.rows(), progressUpdate.progressedPercentage, executionStatus, progressUpdate.footerSummary, progressUpdate.startTimeMillis));
            if (opException != null) {
                resp.setSqlState(opException.getSQLState());
                resp.setErrorCode(opException.getErrorCode());
                if (opException.getErrorCode() == 29999) {
                    resp.setErrorMessage(StringUtils.stringifyException(opException));
                } else {
                    resp.setErrorMessage(opException.getMessage());
                }
            } else if (executionStatus == TJobExecutionStatus.NOT_AVAILABLE && OperationType.EXECUTE_STATEMENT.equals((Object)operationHandle.getOperationType())) {
                resp.getProgressUpdateResponse().setProgressedPercentage(this.getProgressedPercentage(operationHandle));
            }
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get operation status [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TCancelOperationResp CancelOperation(TCancelOperationReq req) throws TException {
        TCancelOperationResp resp = new TCancelOperationResp();
        try {
            this.cliService.cancelOperation(new OperationHandle(req.getOperationHandle()));
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get cancel operation [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TCloseOperationResp CloseOperation(TCloseOperationReq req) throws TException {
        TCloseOperationResp resp = new TCloseOperationResp();
        try {
            this.cliService.closeOperation(new OperationHandle(req.getOperationHandle()));
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to close operation [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetResultSetMetadataResp GetResultSetMetadata(TGetResultSetMetadataReq req) throws TException {
        TGetResultSetMetadataResp resp = new TGetResultSetMetadataResp();
        try {
            TableSchema schema = this.cliService.getResultSetMetadata(new OperationHandle(req.getOperationHandle()));
            resp.setSchema(schema.toTTableSchema());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get result set metadata [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TFetchResultsResp FetchResults(TFetchResultsReq req) throws TException {
        TFetchResultsResp resp = new TFetchResultsResp();
        int maxFetchSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_MAX_FETCH_SIZE);
        if (req.getMaxRows() > (long)maxFetchSize) {
            LOG.warn("Fetch Size greater than maximum allowed. Capping fetch size. [req={}, max={}]", (Object)req.getMaxRows(), (Object)maxFetchSize);
            req.setMaxRows(maxFetchSize);
        }
        try {
            RowSet rowSet = this.cliService.fetchResults(new OperationHandle(req.getOperationHandle()), FetchOrientation.getFetchOrientation(req.getOrientation()), req.getMaxRows(), FetchType.getFetchType(req.getFetchType()));
            resp.setResults(rowSet.toTRowSet());
            resp.setHasMoreRows(false);
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed fetch results [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetPrimaryKeysResp GetPrimaryKeys(TGetPrimaryKeysReq req) throws TException {
        TGetPrimaryKeysResp resp = new TGetPrimaryKeysResp();
        try {
            OperationHandle opHandle = this.cliService.getPrimaryKeys(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get primary keys [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetCrossReferenceResp GetCrossReference(TGetCrossReferenceReq req) throws TException {
        TGetCrossReferenceResp resp = new TGetCrossReferenceResp();
        try {
            OperationHandle opHandle = this.cliService.getCrossReference(new SessionHandle(req.getSessionHandle()), req.getParentCatalogName(), req.getParentSchemaName(), req.getParentTableName(), req.getForeignCatalogName(), req.getForeignSchemaName(), req.getForeignTableName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.error("Failed to get cross reference [request: {}]", (Object)req, (Object)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetQueryIdResp GetQueryId(TGetQueryIdReq req) throws TException {
        try {
            return new TGetQueryIdResp(this.cliService.getQueryId(req.getOperationHandle()));
        }
        catch (HiveSQLException e) {
            LOG.error("Failed to get query ID [request: {}]", (Object)req, (Object)e);
            throw new TException(e);
        }
        catch (Exception e) {
            return new TGetQueryIdResp("");
        }
    }

    @Override
    public TUploadDataResp UploadData(TUploadDataReq req) throws TException {
        TUploadDataResp resp = new TUploadDataResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            OperationHandle operationHandle = this.cliService.uploadData(sessionHandle, req.bufferForValues(), req.getTableName(), req.getPath());
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error UploadData: ", e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TDownloadDataResp DownloadData(TDownloadDataReq req) throws TException {
        TDownloadDataResp resp = new TDownloadDataResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            OperationHandle operationHandle = this.cliService.downloadData(sessionHandle, req.getTableName(), req.getQuery(), req.getFormat(), req.getDownloadOptions());
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error download data: ", e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public abstract void run();

    protected abstract HiveServer2TransportMode getTransportMode();

    private String getProxyUser(String realUser, Map<String, String> sessionConf, String ipAddress) throws HiveSQLException {
        String proxyUser = null;
        if (this.getTransportMode() == HiveServer2TransportMode.http) {
            proxyUser = SessionManager.getProxyUserName();
            LOG.debug("Proxy user from query string: {}", (Object)proxyUser);
        }
        if (proxyUser == null && sessionConf != null && sessionConf.containsKey("hive.server2.proxy.user")) {
            String proxyUserFromThriftBody = sessionConf.get("hive.server2.proxy.user");
            LOG.debug("Proxy user from thrift body: {}", (Object)proxyUserFromThriftBody);
            proxyUser = proxyUserFromThriftBody;
        }
        if (proxyUser == null) {
            return realUser;
        }
        if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ALLOW_USER_SUBSTITUTION)) {
            throw new HiveSQLException("Proxy user substitution is not allowed");
        }
        if (HiveAuthConstants.AuthTypes.NONE.toString().equalsIgnoreCase(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION))) {
            return proxyUser;
        }
        HiveAuthFactory.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hiveConf);
        LOG.debug("Verified proxy user: {}", (Object)proxyUser);
        return proxyUser;
    }

    static class ThriftCLIServerContext
    implements ServerContext {
        private final long createTime = System.nanoTime();
        private Optional<SessionHandle> hiveSessionHandle = Optional.empty();
        private int messagesProcessedCounter = 0;
        private int sessionCount = 0;

        public void setSessionHandle(SessionHandle hiveSessionHandle) {
            this.hiveSessionHandle = Optional.of(hiveSessionHandle);
            ++this.sessionCount;
        }

        public void clearSessionHandle() {
            this.hiveSessionHandle = Optional.empty();
        }

        public Optional<SessionHandle> getSessionHandle() {
            return this.hiveSessionHandle;
        }

        public int getMessagesProcessedCount() {
            return this.messagesProcessedCounter;
        }

        public void incMessagesProcessedCount() {
            ++this.messagesProcessedCounter;
        }

        public Duration getDuration() {
            return Duration.ofNanos(System.nanoTime() - this.createTime);
        }

        public int getSessionCount() {
            return this.sessionCount;
        }

        @Override
        public <T> T unwrap(Class<T> aClass) {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> aClass) {
            return false;
        }
    }
}

