/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.ServiceInstance;
import org.apache.hadoop.hive.llap.registry.ServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.ServiceRegistry;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapFixedRegistryImpl
implements ServiceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(LlapFixedRegistryImpl.class);
    @InterfaceAudience.Private
    public static final String FIXED_REGISTRY_RESOLVE_HOST_NAMES = "fixed.registry.resolve.host.names";
    private final int port;
    private final int shuffle;
    private final int mngPort;
    private final String[] hosts;
    private final int memory;
    private final int vcores;
    private final boolean resolveHosts;
    private final Map<String, String> srv = new HashMap<String, String>();

    public LlapFixedRegistryImpl(String hosts, Configuration conf) {
        this.hosts = hosts.split(",");
        this.port = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT);
        this.shuffle = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_YARN_SHUFFLE_PORT);
        this.resolveHosts = conf.getBoolean(FIXED_REGISTRY_RESOLVE_HOST_NAMES, true);
        this.mngPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_MANAGEMENT_RPC_PORT);
        for (Map.Entry kv : conf) {
            if (!((String)kv.getKey()).startsWith("llap.daemon.") && !((String)kv.getKey()).startsWith("hive.llap.") && !((String)kv.getKey()).startsWith("llap.")) continue;
            this.srv.put((String)kv.getKey(), (String)kv.getValue());
        }
        this.memory = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB);
        this.vcores = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
    }

    @Override
    public void start() throws InterruptedException {
    }

    @Override
    public void stop() throws InterruptedException {
    }

    @Override
    public void register() throws IOException {
    }

    @Override
    public void unregister() throws IOException {
    }

    public static String getWorkerIdentity(String host) {
        return "host-" + host;
    }

    @Override
    public ServiceInstanceSet getInstances(String component) throws IOException {
        return new FixedServiceInstanceSet();
    }

    public String toString() {
        return String.format("FixedRegistry hosts=%s", StringUtils.join((CharSequence)",", (String[])this.hosts));
    }

    private final class FixedServiceInstanceSet
    implements ServiceInstanceSet {
        private final Map<String, ServiceInstance> instances = new LinkedHashMap<String, ServiceInstance>();

        public FixedServiceInstanceSet() {
            for (String host : LlapFixedRegistryImpl.this.hosts) {
                this.instances.put(LlapFixedRegistryImpl.getWorkerIdentity(host), new FixedServiceInstance(host));
            }
        }

        @Override
        public Map<String, ServiceInstance> getAll() {
            return this.instances;
        }

        @Override
        public List<ServiceInstance> getAllInstancesOrdered() {
            LinkedList<ServiceInstance> list = new LinkedList<ServiceInstance>();
            list.addAll(this.instances.values());
            Collections.sort(list, new Comparator<ServiceInstance>(){

                @Override
                public int compare(ServiceInstance o1, ServiceInstance o2) {
                    return o2.getWorkerIdentity().compareTo(o2.getWorkerIdentity());
                }
            });
            return list;
        }

        @Override
        public ServiceInstance getInstance(String name) {
            return this.instances.get(name);
        }

        @Override
        public Set<ServiceInstance> getByHost(String host) {
            HashSet<ServiceInstance> byHost = new HashSet<ServiceInstance>();
            ServiceInstance inst = this.getInstance(LlapFixedRegistryImpl.getWorkerIdentity(host));
            if (inst != null) {
                byHost.add(inst);
            }
            return byHost;
        }

        @Override
        public void refresh() throws IOException {
        }
    }

    private final class FixedServiceInstance
    implements ServiceInstance {
        private final String host;

        public FixedServiceInstance(String host) {
            if (LlapFixedRegistryImpl.this.resolveHosts) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(host);
                    if (NetUtils.isLocalAddress((InetAddress)inetAddress)) {
                        InetSocketAddress socketAddress = new InetSocketAddress(0);
                        socketAddress = NetUtils.getConnectAddress((InetSocketAddress)socketAddress);
                        LOG.info("Adding host identified as local: " + host + " as " + socketAddress.getHostName());
                        host = socketAddress.getHostName();
                    }
                }
                catch (UnknownHostException e) {
                    LOG.warn("Ignoring resolution issues for host: " + host, (Throwable)e);
                }
            }
            this.host = host;
        }

        @Override
        public String getWorkerIdentity() {
            return LlapFixedRegistryImpl.getWorkerIdentity(this.host);
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getRpcPort() {
            return LlapFixedRegistryImpl.this.port;
        }

        @Override
        public int getManagementPort() {
            return LlapFixedRegistryImpl.this.mngPort;
        }

        @Override
        public int getShufflePort() {
            return LlapFixedRegistryImpl.this.shuffle;
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        @Override
        public Map<String, String> getProperties() {
            HashMap<String, String> properties = new HashMap<String, String>(LlapFixedRegistryImpl.this.srv);
            return properties;
        }

        @Override
        public Resource getResource() {
            return Resource.newInstance((int)LlapFixedRegistryImpl.this.memory, (int)LlapFixedRegistryImpl.this.vcores);
        }

        public String toString() {
            return "FixedServiceInstance{host=" + this.host + ", memory=" + LlapFixedRegistryImpl.this.memory + ", vcores=" + LlapFixedRegistryImpl.this.vcores + '}';
        }
    }
}

