/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.protobuf.ByteString;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections4.ListUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapBaseRecordReader;
import org.apache.hadoop.hive.llap.LlapInputSplit;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.SubmitWorkInfo;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.ext.LlapTaskUmbilicalExternalClient;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezHeartbeatRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapBaseInputFormat<V extends WritableComparable<?>>
implements InputFormat<NullWritable, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapBaseInputFormat.class);
    private static String driverName = "org.apache.hive.jdbc.HiveDriver";
    private static final Object lock = new Object();
    private static final Map<String, List<Connection>> connectionMap = new HashMap<String, List<Connection>>();
    private String url;
    private String user;
    private String pwd;
    private String query;
    private final Random rand = new Random();
    public static final String URL_KEY = "llap.if.hs2.connection";
    public static final String QUERY_KEY = "llap.if.query";
    public static final String USER_KEY = "llap.if.user";
    public static final String PWD_KEY = "llap.if.pwd";
    public static final String HANDLE_ID = "llap.if.handleid";
    public static final String DB_KEY = "llap.if.database";
    public final String SPLIT_QUERY = "select get_splits(\"%s\",%d)";
    public static final LlapServiceInstance[] serviceInstanceArray = new LlapServiceInstance[0];
    private static final char ESCAPE_CHAR = '\\';
    private static final char[] escapedChars;

    public LlapBaseInputFormat(String url, String user, String pwd, String query) {
        this.url = url;
        this.user = user;
        this.pwd = pwd;
        this.query = query;
    }

    public LlapBaseInputFormat() {
    }

    public RecordReader<NullWritable, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        LlapInputSplit llapSplit = (LlapInputSplit)split;
        HiveConf.setVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZK_REGISTRY_USER, (String)llapSplit.getLlapUser());
        SubmitWorkInfo submitWorkInfo = SubmitWorkInfo.fromBytes((byte[])llapSplit.getPlanBytes());
        LlapServiceInstance serviceInstance = this.getServiceInstance(job, llapSplit);
        String host = serviceInstance.getHost();
        int llapSubmitPort = serviceInstance.getRpcPort();
        LOG.info("Found service instance for host " + host + " with rpc port " + llapSubmitPort + " and outputformat port " + serviceInstance.getOutputFormatPort());
        byte[] llapTokenBytes = llapSplit.getTokenBytes();
        Token llapToken = null;
        if (llapTokenBytes != null) {
            DataInputBuffer in = new DataInputBuffer();
            in.reset(llapTokenBytes, 0, llapTokenBytes.length);
            llapToken = new Token();
            llapToken.readFields((DataInput)in);
        }
        LlapRecordReaderTaskUmbilicalExternalResponder umbilicalResponder = new LlapRecordReaderTaskUmbilicalExternalResponder();
        LlapTaskUmbilicalExternalClient llapClient = new LlapTaskUmbilicalExternalClient((Configuration)job, submitWorkInfo.getTokenIdentifier(), submitWorkInfo.getToken(), (LlapTaskUmbilicalExternalClient.LlapTaskUmbilicalExternalResponder)umbilicalResponder, llapToken);
        int attemptNum = 0;
        TaskAttemptID taskAttemptId = TaskAttemptID.forName((String)job.get("mapreduce.task.attempt.id"));
        if (taskAttemptId != null) {
            attemptNum = taskAttemptId.getId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting attempt number to " + attemptNum + " from task attempt ID in conf: " + job.get("mapreduce.task.attempt.id"));
            }
        }
        LlapDaemonProtocolProtos.SubmitWorkRequestProto request = this.constructSubmitWorkRequestProto(submitWorkInfo, llapSplit.getSplitNum(), attemptNum, llapClient.getAddress(), (Token<JobTokenIdentifier>)submitWorkInfo.getToken(), llapSplit.getFragmentBytes(), llapSplit.getFragmentBytesSignature(), job);
        llapClient.submitWork(request, host, llapSubmitPort);
        Socket socket = new Socket(host, serviceInstance.getOutputFormatPort());
        LOG.debug("Socket connected");
        LlapDaemonProtocolProtos.SignableVertexSpec vertex = LlapDaemonProtocolProtos.SignableVertexSpec.parseFrom((byte[])submitWorkInfo.getVertexBinary());
        String fragmentId = Converters.createTaskAttemptId((LlapDaemonProtocolProtos.QueryIdentifierProto)vertex.getQueryIdentifier(), (int)vertex.getVertexIndex(), (int)request.getFragmentNumber(), (int)request.getAttemptNumber()).toString();
        OutputStream socketStream = socket.getOutputStream();
        LlapDaemonProtocolProtos.LlapOutputSocketInitMessage.Builder builder = LlapDaemonProtocolProtos.LlapOutputSocketInitMessage.newBuilder().setFragmentId(fragmentId);
        if (llapSplit.getTokenBytes() != null) {
            builder.setToken(ByteString.copyFrom((byte[])llapSplit.getTokenBytes()));
        }
        builder.build().writeDelimitedTo(socketStream);
        socketStream.flush();
        LOG.info("Registered id: " + fragmentId);
        LlapBaseRecordReader recordReader = new LlapBaseRecordReader(socket.getInputStream(), llapSplit.getSchema(), Text.class, job, (Closeable)llapClient, (Closeable)socket);
        umbilicalResponder.setRecordReader(recordReader);
        return recordReader;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        ArrayList<LlapInputSplit> ins = new ArrayList<LlapInputSplit>();
        if (this.url == null) {
            this.url = job.get(URL_KEY);
        }
        if (this.query == null) {
            this.query = job.get(QUERY_KEY);
        }
        if (this.user == null) {
            this.user = job.get(USER_KEY);
        }
        if (this.pwd == null) {
            this.pwd = job.get(PWD_KEY);
        }
        String database = job.get(DB_KEY);
        if (this.url == null || this.query == null) {
            throw new IllegalStateException();
        }
        String handleId = job.get(HANDLE_ID);
        if (handleId == null) {
            handleId = UUID.randomUUID().toString();
            LOG.info("Handle ID not specified - generated handle ID {}", (Object)handleId);
        }
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        LOG.info("Handle ID {}: query={}", (Object)handleId, (Object)this.query);
        String escapedQuery = StringUtils.escapeString((String)this.query, (char)'\\', (char[])escapedChars);
        String sql = String.format("select get_splits(\"%s\",%d)", escapedQuery, numSplits);
        try {
            Connection conn = DriverManager.getConnection(this.url, this.user, this.pwd);
            try (Statement stmt = conn.createStatement();){
                if (database != null && !database.isEmpty()) {
                    stmt.execute("USE " + database);
                }
                ResultSet res = stmt.executeQuery(sql);
                while (res.next()) {
                    DataInputStream in = new DataInputStream(res.getBinaryStream(1));
                    LlapInputSplit is = new LlapInputSplit();
                    is.readFields((DataInput)in);
                    ins.add(is);
                }
                res.close();
            }
            catch (Exception e) {
                LOG.error("Closing connection due to error", (Throwable)e);
                conn.close();
                throw e;
            }
            this.addConnection(handleId, conn);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return ins.toArray(new InputSplit[ins.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(String handleId, Connection connection) {
        Object object = lock;
        synchronized (object) {
            List<Connection> handleConnections = connectionMap.get(handleId);
            if (handleConnections == null) {
                handleConnections = new ArrayList<Connection>();
                connectionMap.put(handleId, handleConnections);
            }
            handleConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(String handleId) throws IOException {
        List<Connection> handleConnections;
        Iterator<Connection> iterator = lock;
        synchronized (iterator) {
            handleConnections = connectionMap.remove(handleId);
        }
        if (handleConnections != null) {
            LOG.debug("Closing {} connections for handle ID {}", (Object)handleConnections.size(), (Object)handleId);
            for (Connection conn : handleConnections) {
                try {
                    conn.close();
                }
                catch (Exception err) {
                    LOG.error("Error while closing connection for " + handleId, (Throwable)err);
                }
            }
        } else {
            LOG.debug("No connection found for handle ID {}", (Object)handleId);
        }
    }

    public static void closeAll() {
        LOG.debug("Closing all handles");
        for (String handleId : connectionMap.keySet()) {
            try {
                LlapBaseInputFormat.close(handleId);
            }
            catch (Exception err) {
                LOG.error("Error closing handle ID " + handleId, (Throwable)err);
            }
        }
    }

    private LlapServiceInstance getServiceInstance(JobConf job, LlapInputSplit llapSplit) throws IOException {
        String host;
        LlapRegistryService registryService = LlapRegistryService.getClient((Configuration)job);
        LlapServiceInstance serviceInstance = null;
        String[] hosts = llapSplit.getLocations();
        if (hosts != null && hosts.length > 0 && (serviceInstance = this.getServiceInstanceForHost(registryService, host = llapSplit.getLocations()[0])) == null) {
            LOG.info("No service instances found for " + host + " in registry.");
        }
        if (serviceInstance == null && (serviceInstance = this.getServiceInstanceRandom(registryService)) == null) {
            throw new IOException("No service instances found in registry");
        }
        return serviceInstance;
    }

    private LlapServiceInstance getServiceInstanceForHost(LlapRegistryService registryService, String host) throws IOException {
        InetAddress address = InetAddress.getByName(host);
        LlapServiceInstanceSet instanceSet = registryService.getInstances();
        LlapServiceInstance serviceInstance = null;
        String name = address.getHostName();
        LOG.info("Searching service instance by hostname " + name);
        serviceInstance = this.selectServiceInstance(instanceSet.getByHost(name));
        if (serviceInstance != null) {
            return serviceInstance;
        }
        name = address.getCanonicalHostName();
        LOG.info("Searching service instance by canonical hostname " + name);
        serviceInstance = this.selectServiceInstance(instanceSet.getByHost(name));
        if (serviceInstance != null) {
            return serviceInstance;
        }
        name = address.getHostAddress();
        LOG.info("Searching service instance by address " + name);
        serviceInstance = this.selectServiceInstance(instanceSet.getByHost(name));
        if (serviceInstance != null) {
            return serviceInstance;
        }
        return serviceInstance;
    }

    private LlapServiceInstance getServiceInstanceRandom(LlapRegistryService registryService) throws IOException {
        LlapServiceInstanceSet instanceSet = registryService.getInstances();
        LlapServiceInstance serviceInstance = null;
        LOG.info("Finding random live service instance");
        Collection allInstances = instanceSet.getAll();
        if (allInstances.size() > 0) {
            int randIdx = this.rand.nextInt(allInstances.size());
            serviceInstance = allInstances.toArray(serviceInstanceArray)[randIdx];
        }
        return serviceInstance;
    }

    private LlapServiceInstance selectServiceInstance(Set<LlapServiceInstance> serviceInstances) {
        if (serviceInstances == null || serviceInstances.isEmpty()) {
            return null;
        }
        Iterator<LlapServiceInstance> iterator = serviceInstances.iterator();
        if (iterator.hasNext()) {
            LlapServiceInstance serviceInstance = iterator.next();
            return serviceInstance;
        }
        LOG.info("No live service instances were found");
        return null;
    }

    private LlapDaemonProtocolProtos.SubmitWorkRequestProto constructSubmitWorkRequestProto(SubmitWorkInfo submitWorkInfo, int taskNum, int attemptNum, InetSocketAddress address, Token<JobTokenIdentifier> token, byte[] fragmentBytes, byte[] fragmentBytesSignature, JobConf job) throws IOException {
        ApplicationId appId = submitWorkInfo.getFakeAppId();
        String user = System.getenv(ApplicationConstants.Environment.USER.name());
        LOG.info("Setting user in submitWorkRequest to: " + user);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)attemptNum), (int)taskNum);
        Credentials credentials = new Credentials();
        TokenCache.setSessionToken(token, (Credentials)credentials);
        ByteBuffer credentialsBinary = this.serializeCredentials(credentials);
        LlapDaemonProtocolProtos.FragmentRuntimeInfo.Builder runtimeInfo = LlapDaemonProtocolProtos.FragmentRuntimeInfo.newBuilder();
        runtimeInfo.setCurrentAttemptStartTime(System.currentTimeMillis());
        runtimeInfo.setWithinDagPriority(0);
        runtimeInfo.setDagStartTime(submitWorkInfo.getCreationTime());
        runtimeInfo.setFirstAttemptStartTime(submitWorkInfo.getCreationTime());
        runtimeInfo.setNumSelfAndUpstreamTasks(submitWorkInfo.getVertexParallelism());
        runtimeInfo.setNumSelfAndUpstreamCompletedTasks(0);
        LlapDaemonProtocolProtos.SubmitWorkRequestProto.Builder builder = LlapDaemonProtocolProtos.SubmitWorkRequestProto.newBuilder();
        LlapDaemonProtocolProtos.VertexOrBinary.Builder vertexBuilder = LlapDaemonProtocolProtos.VertexOrBinary.newBuilder();
        vertexBuilder.setVertexBinary(ByteString.copyFrom((byte[])submitWorkInfo.getVertexBinary()));
        if (submitWorkInfo.getVertexSignature() != null) {
            builder.setWorkSpecSignature(ByteString.copyFrom((byte[])submitWorkInfo.getVertexSignature()));
        }
        builder.setWorkSpec(vertexBuilder.build());
        builder.setFragmentNumber(taskNum);
        builder.setAttemptNumber(attemptNum);
        builder.setContainerIdString(containerId.toString());
        builder.setAmHost(LlapUtil.getAmHostNameFromAddress((InetSocketAddress)address, (Configuration)job));
        builder.setAmPort(address.getPort());
        builder.setCredentialsBinary(ByteString.copyFrom((ByteBuffer)credentialsBinary));
        builder.setFragmentRuntimeInfo(runtimeInfo.build());
        builder.setInitialEventBytes(ByteString.copyFrom((byte[])fragmentBytes));
        if (fragmentBytesSignature != null) {
            builder.setInitialEventSignature(ByteString.copyFrom((byte[])fragmentBytesSignature));
        }
        return builder.build();
    }

    private ByteBuffer serializeCredentials(Credentials credentials) throws IOException {
        Credentials containerCredentials = new Credentials();
        containerCredentials.addAll(credentials);
        DataOutputBuffer containerTokens_dob = new DataOutputBuffer();
        containerCredentials.writeTokenStorageToStream((DataOutputStream)containerTokens_dob);
        return ByteBuffer.wrap(containerTokens_dob.getData(), 0, containerTokens_dob.getLength());
    }

    static {
        ShutdownHookManager.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                LlapBaseInputFormat.closeAll();
            }
        });
        escapedChars = new char[]{'\"', '\\'};
    }

    private static class LlapRecordReaderTaskUmbilicalExternalResponder
    implements LlapTaskUmbilicalExternalClient.LlapTaskUmbilicalExternalResponder {
        protected LlapBaseRecordReader<?> recordReader = null;
        protected LinkedBlockingQueue<LlapBaseRecordReader.ReaderEvent> queuedEvents = new LinkedBlockingQueue();

        public void submissionFailed(String fragmentId, Throwable throwable) {
            try {
                this.sendOrQueueEvent(LlapBaseRecordReader.ReaderEvent.errorEvent((String)("Received submission failed event for fragment ID " + fragmentId + ": " + throwable.toString())));
            }
            catch (Exception err) {
                LOG.error("Error during heartbeat responder:", (Throwable)err);
            }
        }

        public void heartbeat(TezHeartbeatRequest request) {
            List inEvents = request.getEvents();
            for (TezEvent tezEvent : ListUtils.emptyIfNull((List)inEvents)) {
                EventType eventType = tezEvent.getEventType();
                try {
                    switch (eventType) {
                        case TASK_ATTEMPT_COMPLETED_EVENT: {
                            this.sendOrQueueEvent(LlapBaseRecordReader.ReaderEvent.doneEvent());
                            break;
                        }
                        case TASK_ATTEMPT_FAILED_EVENT: {
                            TaskAttemptFailedEvent taskFailedEvent = (TaskAttemptFailedEvent)tezEvent.getEvent();
                            this.sendOrQueueEvent(LlapBaseRecordReader.ReaderEvent.errorEvent((String)taskFailedEvent.getDiagnostics()));
                            break;
                        }
                        case TASK_STATUS_UPDATE_EVENT: {
                            break;
                        }
                        default: {
                            LOG.warn("Unhandled event type " + eventType);
                            break;
                        }
                    }
                }
                catch (Exception err) {
                    LOG.error("Error during heartbeat responder:", (Throwable)err);
                }
            }
        }

        public void taskKilled(TezTaskAttemptID taskAttemptId) {
            try {
                this.sendOrQueueEvent(LlapBaseRecordReader.ReaderEvent.errorEvent((String)("Received task killed event for task ID " + taskAttemptId)));
            }
            catch (Exception err) {
                LOG.error("Error during heartbeat responder:", (Throwable)err);
            }
        }

        public void heartbeatTimeout(String taskAttemptId) {
            try {
                this.sendOrQueueEvent(LlapBaseRecordReader.ReaderEvent.errorEvent((String)("Timed out waiting for heartbeat for task ID " + taskAttemptId)));
            }
            catch (Exception err) {
                LOG.error("Error during heartbeat responder:", (Throwable)err);
            }
        }

        public synchronized LlapBaseRecordReader<?> getRecordReader() {
            return this.recordReader;
        }

        public synchronized void setRecordReader(LlapBaseRecordReader recordReader) {
            this.recordReader = recordReader;
            if (recordReader == null) {
                return;
            }
            while (!this.queuedEvents.isEmpty()) {
                LlapBaseRecordReader.ReaderEvent readerEvent = this.queuedEvents.poll();
                LOG.debug("Sending queued event to record reader: " + readerEvent.getEventType());
                recordReader.handleEvent(readerEvent);
            }
        }

        protected synchronized void sendOrQueueEvent(LlapBaseRecordReader.ReaderEvent readerEvent) {
            LlapBaseRecordReader<?> recordReader = this.getRecordReader();
            if (recordReader != null) {
                recordReader.handleEvent(readerEvent);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No registered record reader, queueing event " + readerEvent.getEventType() + " with message " + readerEvent.getMessage());
                }
                try {
                    this.queuedEvents.put(readerEvent);
                }
                catch (Exception err) {
                    throw new RuntimeException("Unexpected exception while queueing reader event", err);
                }
            }
        }

        public void clearQueuedEvents() {
            this.queuedEvents.clear();
        }
    }
}

