/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.List;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;

public class SimpleBufferManager
implements BufferUsageManager {
    private final Allocator allocator;
    private final LlapDaemonCacheMetrics metrics;

    public SimpleBufferManager(Allocator allocator, LlapDaemonCacheMetrics metrics) {
        if (LlapIoImpl.LOGL.isInfoEnabled()) {
            LlapIoImpl.LOG.info("Simple buffer manager");
        }
        this.allocator = allocator;
        this.metrics = metrics;
    }

    private boolean lockBuffer(LlapDataBuffer buffer) {
        int rc = buffer.incRef();
        if (rc <= 0) {
            return false;
        }
        this.metrics.incrCacheNumLockedBuffers();
        return true;
    }

    private void unlockBuffer(LlapDataBuffer buffer) {
        if (buffer.decRef() == 0) {
            if (DebugUtils.isTraceCachingEnabled()) {
                LlapIoImpl.LOG.info("Deallocating " + buffer + " that was not cached");
            }
            this.allocator.deallocate((MemoryBuffer)buffer);
        }
        this.metrics.decrCacheNumLockedBuffers();
    }

    @Override
    public void decRefBuffer(MemoryBuffer buffer) {
        this.unlockBuffer((LlapDataBuffer)buffer);
    }

    @Override
    public void decRefBuffers(List<MemoryBuffer> cacheBuffers) {
        for (MemoryBuffer b : cacheBuffers) {
            this.unlockBuffer((LlapDataBuffer)b);
        }
    }

    @Override
    public boolean incRefBuffer(MemoryBuffer buffer) {
        return this.lockBuffer((LlapDataBuffer)buffer);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }
}

