/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.daemon.impl.QueryInfo;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.shufflehandler.ShuffleHandler;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTracker
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(QueryTracker.class);
    private final ScheduledExecutorService executorService;
    private final ConcurrentHashMap<QueryIdentifier, QueryInfo> queryInfoMap = new ConcurrentHashMap();
    private final String[] localDirsBase;
    private final FileSystem localFs;
    private final long defaultDeleteDelaySeconds;
    private final Set<QueryIdentifier> completedDagMap = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Lock lock = new ReentrantLock();
    private final ConcurrentMap<QueryIdentifier, ReadWriteLock> dagSpecificLocks = new ConcurrentHashMap<QueryIdentifier, ReadWriteLock>();
    private final ConcurrentMap<QueryIdentifier, ConcurrentMap<String, LlapDaemonProtocolProtos.SourceStateProto>> sourceCompletionMap = new ConcurrentHashMap<QueryIdentifier, ConcurrentMap<String, LlapDaemonProtocolProtos.SourceStateProto>>();
    private final ConcurrentHashMap<QueryIdentifier, String> queryIdentifierToHiveQueryId = new ConcurrentHashMap();

    public QueryTracker(Configuration conf, String[] localDirsBase) {
        super("QueryTracker");
        this.localDirsBase = localDirsBase;
        try {
            this.localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to setup local filesystem instance", e);
        }
        this.defaultDeleteDelaySeconds = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_FILE_CLEANUP_DELAY_SECONDS, (TimeUnit)TimeUnit.SECONDS);
        int numCleanerThreads = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_FILE_CLEANER_THREADS);
        this.executorService = Executors.newScheduledThreadPool(numCleanerThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("QueryFileCleaner %d").build());
    }

    QueryFragmentInfo registerFragment(QueryIdentifier queryIdentifier, String appIdString, String dagName, int dagIdentifier, String vertexName, int fragmentNumber, int attemptNumber, String user, LlapDaemonProtocolProtos.FragmentSpecProto fragmentSpec, Token<JobTokenIdentifier> appToken) throws IOException {
        ReadWriteLock dagLock = this.getDagLock(queryIdentifier);
        dagLock.readLock().lock();
        try {
            if (!this.completedDagMap.contains(queryIdentifier)) {
                QueryInfo queryInfo = this.queryInfoMap.get(queryIdentifier);
                if (queryInfo == null) {
                    queryInfo = new QueryInfo(queryIdentifier, appIdString, dagName, dagIdentifier, user, this.getSourceCompletionMap(queryIdentifier), this.localDirsBase, this.localFs);
                    this.queryInfoMap.putIfAbsent(queryIdentifier, queryInfo);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registering request for {} with the ShuffleHandler", (Object)queryIdentifier);
                }
                ShuffleHandler.get().registerDag(appIdString, dagIdentifier, appToken, user, queryInfo.getLocalDirs());
                QueryFragmentInfo queryFragmentInfo = queryInfo.registerFragment(vertexName, fragmentNumber, attemptNumber, fragmentSpec);
                return queryFragmentInfo;
            }
            this.dagSpecificLocks.remove(queryIdentifier);
            throw new RuntimeException("Dag " + dagName + " already complete. Rejecting fragment [" + vertexName + ", " + fragmentNumber + ", " + attemptNumber + "]");
        }
        finally {
            dagLock.readLock().unlock();
        }
    }

    void fragmentComplete(QueryFragmentInfo fragmentInfo) {
        QueryIdentifier qId = fragmentInfo.getQueryInfo().getQueryIdentifier();
        QueryInfo queryInfo = this.queryInfoMap.get(qId);
        if (queryInfo == null) {
            LOG.info("Ignoring fragmentComplete message for unknown query: {}", (Object)qId);
        } else {
            queryInfo.unregisterFragment(fragmentInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<QueryFragmentInfo> queryComplete(QueryIdentifier queryIdentifier, long deleteDelay) {
        if (deleteDelay == -1L) {
            deleteDelay = this.defaultDeleteDelaySeconds;
        }
        ReadWriteLock dagLock = this.getDagLock(queryIdentifier);
        dagLock.writeLock().lock();
        try {
            this.rememberCompletedDag(queryIdentifier);
            LOG.info("Processing queryComplete for queryIdentifier={} with deleteDelay={} seconds", (Object)queryIdentifier, (Object)deleteDelay);
            QueryInfo queryInfo = this.queryInfoMap.remove(queryIdentifier);
            if (queryInfo == null) {
                LOG.warn("Ignoring query complete for unknown dag: {}", (Object)queryIdentifier);
                List<QueryFragmentInfo> list = Collections.emptyList();
                return list;
            }
            String[] localDirs = queryInfo.getLocalDirsNoCreate();
            if (localDirs != null) {
                for (String localDir : localDirs) {
                    this.cleanupDir(localDir, deleteDelay);
                    ShuffleHandler.get().unregisterDag(localDir, queryInfo.getAppIdString(), queryInfo.getDagIdentifier());
                }
            }
            this.sourceCompletionMap.remove(queryIdentifier);
            String savedQueryId = this.queryIdentifierToHiveQueryId.remove(queryIdentifier);
            this.dagSpecificLocks.remove(queryIdentifier);
            if (savedQueryId != null) {
                ObjectCacheFactory.removeLlapQueryCache((String)savedQueryId);
            }
            List<QueryFragmentInfo> list = queryInfo.getRegisteredFragments();
            return list;
        }
        finally {
            dagLock.writeLock().unlock();
        }
    }

    public void rememberCompletedDag(QueryIdentifier queryIdentifier) {
        if (this.completedDagMap.add(queryIdentifier)) {
            this.executorService.schedule(new DagMapCleanerCallable(queryIdentifier), 1L, TimeUnit.HOURS);
        } else {
            LOG.warn("Couldn't add {} to completed dag set", (Object)queryIdentifier);
        }
    }

    void registerSourceStateChange(QueryIdentifier queryIdentifier, String sourceName, LlapDaemonProtocolProtos.SourceStateProto sourceState) {
        this.getSourceCompletionMap(queryIdentifier).put(sourceName, sourceState);
        QueryInfo queryInfo = this.queryInfoMap.get(queryIdentifier);
        if (queryInfo != null) {
            queryInfo.sourceStateUpdated(sourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadWriteLock getDagLock(QueryIdentifier queryIdentifier) {
        this.lock.lock();
        try {
            ReadWriteLock dagLock = (ReadWriteLock)this.dagSpecificLocks.get(queryIdentifier);
            if (dagLock == null) {
                dagLock = new ReentrantReadWriteLock();
                this.dagSpecificLocks.put(queryIdentifier, dagLock);
            }
            ReadWriteLock readWriteLock = dagLock;
            return readWriteLock;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ConcurrentMap<String, LlapDaemonProtocolProtos.SourceStateProto> getSourceCompletionMap(QueryIdentifier queryIdentifier) {
        ConcurrentHashMap dagMap = (ConcurrentHashMap)this.sourceCompletionMap.get(queryIdentifier);
        if (dagMap == null) {
            dagMap = new ConcurrentHashMap();
            ConcurrentHashMap old = this.sourceCompletionMap.putIfAbsent(queryIdentifier, dagMap);
            dagMap = old != null ? old : dagMap;
        }
        return dagMap;
    }

    public void registerDagQueryId(QueryIdentifier queryIdentifier, String hiveQueryIdString) {
        if (hiveQueryIdString == null) {
            return;
        }
        this.queryIdentifierToHiveQueryId.putIfAbsent(queryIdentifier, hiveQueryIdString);
    }

    public void serviceStart() {
        LOG.info(this.getName() + " started");
    }

    public void serviceStop() {
        this.executorService.shutdownNow();
        LOG.info(this.getName() + " stopped");
    }

    private void cleanupDir(String dir, long deleteDelay) {
        LOG.info("Scheduling deletion of {} after {} seconds", (Object)dir, (Object)deleteDelay);
        this.executorService.schedule(new FileCleanerCallable(dir), deleteDelay, TimeUnit.SECONDS);
    }

    private class DagMapCleanerCallable
    extends CallableWithNdc<Void> {
        private final QueryIdentifier queryIdentifier;

        private DagMapCleanerCallable(QueryIdentifier queryIdentifier) {
            this.queryIdentifier = queryIdentifier;
        }

        protected Void callInternal() {
            QueryTracker.this.completedDagMap.remove(this.queryIdentifier);
            return null;
        }
    }

    private class FileCleanerCallable
    extends CallableWithNdc<Void> {
        private final String dirToDelete;

        private FileCleanerCallable(String dirToDelete) {
            this.dirToDelete = dirToDelete;
        }

        protected Void callInternal() {
            Path pathToDelete = new Path(this.dirToDelete);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting path: " + pathToDelete);
            }
            try {
                QueryTracker.this.localFs.delete(new Path(this.dirToDelete), true);
            }
            catch (IOException e) {
                LOG.warn("Ignoring exception while cleaning up path: " + pathToDelete, (Throwable)e);
            }
            return null;
        }
    }
}

