/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.llap.daemon.FragmentCompletionHandler;
import org.apache.hadoop.hive.llap.daemon.HistoryLogger;
import org.apache.hadoop.hive.llap.daemon.KilledTaskHandler;
import org.apache.hadoop.hive.llap.daemon.impl.AMReporter;
import org.apache.hadoop.hive.llap.daemon.impl.LlapTaskReporter;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.hive.llap.protocol.LlapTaskUmbilicalProtocol;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.hive.ql.io.IOContextMap;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;
import org.apache.tez.runtime.internals.api.TaskReporterInterface;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.task.EndReason;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.apache.tez.runtime.task.TezTaskRunner2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunnerCallable
extends CallableWithNdc<TaskRunner2Result> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunnerCallable.class);
    private final LlapDaemonProtocolProtos.SubmitWorkRequestProto request;
    private final Configuration conf;
    private final Map<String, String> envMap;
    private final String pid;
    private final ObjectRegistryImpl objectRegistry;
    private final ExecutionContext executionContext;
    private final Credentials credentials;
    private final long memoryAvailable;
    private final ConfParams confParams;
    private final Token<JobTokenIdentifier> jobToken;
    private final AMReporter amReporter;
    private final TaskSpec taskSpec;
    private final QueryFragmentInfo fragmentInfo;
    private final KilledTaskHandler killedTaskHandler;
    private final FragmentCompletionHandler fragmentCompletionHanler;
    private volatile TezTaskRunner2 taskRunner;
    private volatile TaskReporterInterface taskReporter;
    private volatile ListeningExecutorService executor;
    private LlapTaskUmbilicalProtocol umbilical;
    private volatile long startTime;
    private volatile String threadName;
    private final LlapDaemonExecutorMetrics metrics;
    private final String requestId;
    private final String queryId;
    private final HadoopShim tezHadoopShim;
    private boolean shouldRunTask = true;
    final Stopwatch runtimeWatch = new Stopwatch();
    final Stopwatch killtimerWatch = new Stopwatch();
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicBoolean isCompleted = new AtomicBoolean(false);
    private final AtomicBoolean killInvoked = new AtomicBoolean(false);

    @VisibleForTesting
    public TaskRunnerCallable(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, QueryFragmentInfo fragmentInfo, Configuration conf, ExecutionContext executionContext, Map<String, String> envMap, Credentials credentials, long memoryAvailable, AMReporter amReporter, ConfParams confParams, LlapDaemonExecutorMetrics metrics, KilledTaskHandler killedTaskHandler, FragmentCompletionHandler fragmentCompleteHandler, HadoopShim tezHadoopShim) {
        this.pid = null;
        this.request = request;
        this.fragmentInfo = fragmentInfo;
        this.conf = conf;
        this.executionContext = executionContext;
        this.envMap = envMap;
        this.objectRegistry = new ObjectRegistryImpl();
        this.credentials = credentials;
        this.memoryAvailable = memoryAvailable;
        this.confParams = confParams;
        this.jobToken = TokenCache.getSessionToken((Credentials)credentials);
        this.taskSpec = Converters.getTaskSpecfromProto((LlapDaemonProtocolProtos.FragmentSpecProto)request.getFragmentSpec());
        this.amReporter = amReporter;
        if (this.jobToken != null) {
            this.amReporter.registerTask(request.getAmHost(), request.getAmPort(), request.getUser(), this.jobToken, fragmentInfo.getQueryInfo().getQueryIdentifier());
        }
        this.metrics = metrics;
        this.requestId = request.getFragmentSpec().getFragmentIdentifierString();
        this.queryId = request.getFragmentSpec().getDagName();
        this.killedTaskHandler = killedTaskHandler;
        this.fragmentCompletionHanler = fragmentCompleteHandler;
        this.tezHadoopShim = tezHadoopShim;
    }

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskRunner2Result callInternal() throws Exception {
        this.isStarted.set(true);
        this.startTime = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("canFinish: " + this.taskSpec.getTaskAttemptID() + ": " + this.canFinish());
        }
        this.amReporter.unregisterTask(this.request.getAmHost(), this.request.getAmPort());
        TaskRunnerCallable taskRunnerCallable = this;
        synchronized (taskRunnerCallable) {
            if (!this.shouldRunTask) {
                LOG.info("Not starting task {} since it was killed earlier", (Object)this.taskSpec.getTaskAttemptID());
                return new TaskRunner2Result(EndReason.KILL_REQUESTED, null, false);
            }
        }
        ExecutorService executorReal = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TezTaskRunner").build());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executorReal);
        this.runtimeWatch.start();
        UserGroupInformation taskUgi = UserGroupInformation.createRemoteUser((String)this.request.getUser());
        taskUgi.addCredentials(this.credentials);
        HashMap<String, ByteBuffer> serviceConsumerMetadata = new HashMap<String, ByteBuffer>();
        serviceConsumerMetadata.put("mapreduce_shuffle", TezCommonUtils.convertJobTokenToBytes(this.jobToken));
        Multimap<String, String> startedInputsMap = this.createStartedInputMap(this.request.getFragmentSpec());
        UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser((String)this.request.getTokenIdentifier());
        final InetSocketAddress address = NetUtils.createSocketAddrForHost((String)this.request.getAmHost(), (int)this.request.getAmPort());
        SecurityUtil.setTokenService(this.jobToken, (InetSocketAddress)address);
        taskOwner.addToken(this.jobToken);
        this.umbilical = (LlapTaskUmbilicalProtocol)taskOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<LlapTaskUmbilicalProtocol>(){

            @Override
            public LlapTaskUmbilicalProtocol run() throws Exception {
                return (LlapTaskUmbilicalProtocol)RPC.getProxy(LlapTaskUmbilicalProtocol.class, (long)1L, (InetSocketAddress)address, (Configuration)TaskRunnerCallable.this.conf);
            }
        });
        this.taskReporter = new LlapTaskReporter(this.umbilical, this.confParams.amHeartbeatIntervalMsMax, this.confParams.amCounterHeartbeatInterval, this.confParams.amMaxEventsPerHeartbeat, new AtomicLong(0L), this.request.getContainerIdString());
        String attemptId = this.fragmentInfo.getFragmentIdentifierString();
        IOContextMap.setThreadAttemptId((String)attemptId);
        try {
            TaskRunner2Result taskRunner2Result;
            TaskRunnerCallable taskRunnerCallable2 = this;
            synchronized (taskRunnerCallable2) {
                if (this.shouldRunTask) {
                    this.taskRunner = new TezTaskRunner2(this.conf, taskUgi, this.fragmentInfo.getLocalDirs(), this.taskSpec, this.request.getAppAttemptNumber(), serviceConsumerMetadata, this.envMap, startedInputsMap, this.taskReporter, this.executor, (ObjectRegistry)this.objectRegistry, this.pid, this.executionContext, this.memoryAvailable, false, this.tezHadoopShim);
                }
            }
            if (this.taskRunner == null) {
                LOG.info("Not starting task {} since it was killed earlier", (Object)this.taskSpec.getTaskAttemptID());
                taskRunnerCallable2 = new TaskRunner2Result(EndReason.KILL_REQUESTED, null, false);
                return taskRunnerCallable2;
            }
            try {
                TaskRunner2Result result = this.taskRunner.run();
                if (result.isContainerShutdownRequested()) {
                    LOG.warn("Unexpected container shutdown requested while running task. Ignoring");
                }
                this.isCompleted.set(true);
                taskRunner2Result = result;
            }
            catch (Throwable throwable) {
                FileSystem.closeAllForUGI((UserGroupInformation)taskUgi);
                LOG.info("ExecutionTime for Container: " + this.request.getContainerIdString() + "=" + this.runtimeWatch.stop().elapsedMillis());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("canFinish post completion: " + this.taskSpec.getTaskAttemptID() + ": " + this.canFinish());
                }
                throw throwable;
            }
            FileSystem.closeAllForUGI((UserGroupInformation)taskUgi);
            LOG.info("ExecutionTime for Container: " + this.request.getContainerIdString() + "=" + this.runtimeWatch.stop().elapsedMillis());
            if (LOG.isDebugEnabled()) {
                LOG.debug("canFinish post completion: " + this.taskSpec.getTaskAttemptID() + ": " + this.canFinish());
            }
            return taskRunner2Result;
        }
        finally {
            IOContextMap.clearThreadAttempt((String)attemptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killTask() {
        if (!this.isCompleted.get()) {
            if (!this.killInvoked.getAndSet(true)) {
                TaskRunnerCallable taskRunnerCallable = this;
                synchronized (taskRunnerCallable) {
                    LOG.info("Kill task requested for id={}, taskRunnerSetup={}", (Object)this.taskSpec.getTaskAttemptID(), (Object)(this.taskRunner != null ? 1 : 0));
                    if (this.taskRunner != null) {
                        this.killtimerWatch.start();
                        LOG.info("Issuing kill to task {}", (Object)this.taskSpec.getTaskAttemptID());
                        boolean killed = this.taskRunner.killTask();
                        if (killed) {
                            LOG.info("Kill request for task {} completed. Informing AM", (Object)this.taskSpec.getTaskAttemptID());
                            this.reportTaskKilled();
                        } else {
                            LOG.info("Kill request for task {} did not complete because the task is already complete", (Object)this.taskSpec.getTaskAttemptID());
                        }
                        this.shouldRunTask = false;
                    } else {
                        LOG.debug("Reporting taskKilled for non-started fragment {}", (Object)this.getRequestId());
                        this.reportTaskKilled();
                    }
                    if (!this.isStarted.get()) {
                        this.fragmentCompletionHanler.fragmentComplete(this.fragmentInfo);
                        this.amReporter.unregisterTask(this.request.getAmHost(), this.request.getAmPort());
                    }
                }
            } else {
                LOG.warn("Ignoring kill request for task {} since a previous kill request was processed", (Object)this.taskSpec.getTaskAttemptID());
            }
        } else {
            LOG.info("Ignoring kill request for task {} since it's already complete", (Object)this.taskSpec.getTaskAttemptID());
        }
    }

    public void reportTaskKilled() {
        this.killedTaskHandler.taskKilled(this.request.getAmHost(), this.request.getAmPort(), this.request.getUser(), this.jobToken, this.fragmentInfo.getQueryInfo().getQueryIdentifier(), this.taskSpec.getTaskAttemptID());
    }

    public boolean canFinish() {
        return this.fragmentInfo.canFinish();
    }

    private Multimap<String, String> createStartedInputMap(LlapDaemonProtocolProtos.FragmentSpecProto fragmentSpec) {
        HashMultimap startedInputMap = HashMultimap.create();
        for (LlapDaemonProtocolProtos.IOSpecProto inputSpec : fragmentSpec.getInputSpecsList()) {
            if (!inputSpec.getIoDescriptor().getClassName().equals(UnorderedKVInput.class.getName())) continue;
            startedInputMap.put((Object)fragmentSpec.getVertexName(), (Object)inputSpec.getConnectedVertexName());
        }
        return startedInputMap;
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.taskReporter != null) {
            this.taskReporter.shutdown();
        }
        if (this.umbilical != null) {
            RPC.stopProxy((Object)this.umbilical);
        }
    }

    public String toString() {
        return this.requestId + " {canFinish: " + this.canFinish() + ", vertexParallelism: " + this.request.getFragmentSpec().getVertexParallelism() + ", selfAndUpstreamParallelism: " + this.request.getFragmentRuntimeInfo().getNumSelfAndUpstreamTasks() + ", selfAndUpstreamComplete: " + this.request.getFragmentRuntimeInfo().getNumSelfAndUpstreamCompletedTasks() + ", firstAttemptStartTime: " + this.getFragmentRuntimeInfo().getFirstAttemptStartTime() + ", dagStartTime:" + this.getFragmentRuntimeInfo().getDagStartTime() + ", withinDagPriority: " + this.getFragmentRuntimeInfo().getWithinDagPriority() + "}";
    }

    public int hashCode() {
        return this.requestId.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskRunnerCallable)) {
            return false;
        }
        return this.requestId.equals(((TaskRunnerCallable)((Object)obj)).getRequestId());
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryFragmentInfo getFragmentInfo() {
        return this.fragmentInfo;
    }

    public TaskRunnerCallback getCallback() {
        return new TaskRunnerCallback(this.request, this);
    }

    public LlapDaemonProtocolProtos.SubmitWorkRequestProto getRequest() {
        return this.request;
    }

    public static String getTaskIdentifierString(LlapDaemonProtocolProtos.SubmitWorkRequestProto request) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppId=").append(request.getApplicationIdString()).append(", containerId=").append(request.getContainerIdString()).append(", Dag=").append(request.getFragmentSpec().getDagName()).append(", Vertex=").append(request.getFragmentSpec().getVertexName()).append(", FragmentNum=").append(request.getFragmentSpec().getFragmentNumber()).append(", Attempt=").append(request.getFragmentSpec().getAttemptNumber());
        return sb.toString();
    }

    public LlapDaemonProtocolProtos.FragmentRuntimeInfo getFragmentRuntimeInfo() {
        return this.request.getFragmentRuntimeInfo();
    }

    public LlapDaemonProtocolProtos.FragmentSpecProto getFragmentSpec() {
        return this.request.getFragmentSpec();
    }

    public static class ConfParams {
        final int amHeartbeatIntervalMsMax;
        final long amCounterHeartbeatInterval;
        final int amMaxEventsPerHeartbeat;

        public ConfParams(int amHeartbeatIntervalMsMax, long amCounterHeartbeatInterval, int amMaxEventsPerHeartbeat) {
            this.amHeartbeatIntervalMsMax = amHeartbeatIntervalMsMax;
            this.amCounterHeartbeatInterval = amCounterHeartbeatInterval;
            this.amMaxEventsPerHeartbeat = amMaxEventsPerHeartbeat;
        }
    }

    final class TaskRunnerCallback
    implements FutureCallback<TaskRunner2Result> {
        private final LlapDaemonProtocolProtos.SubmitWorkRequestProto request;
        private final TaskRunnerCallable taskRunnerCallable;

        TaskRunnerCallback(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, TaskRunnerCallable taskRunnerCallable) {
            this.request = request;
            this.taskRunnerCallable = taskRunnerCallable;
        }

        public void onSuccess(TaskRunner2Result result) {
            TaskRunnerCallable.this.isCompleted.set(true);
            switch (result.getEndReason()) {
                case SUCCESS: {
                    LOG.debug("Successfully finished {}", (Object)TaskRunnerCallable.this.requestId);
                    TaskRunnerCallable.this.metrics.incrExecutorTotalSuccess();
                    break;
                }
                case CONTAINER_STOP_REQUESTED: {
                    LOG.info("Received container stop request (AM preemption) for {}", (Object)TaskRunnerCallable.this.requestId);
                    break;
                }
                case KILL_REQUESTED: {
                    LOG.info("Killed task {}", (Object)TaskRunnerCallable.this.requestId);
                    if (TaskRunnerCallable.this.killtimerWatch.isRunning()) {
                        TaskRunnerCallable.this.killtimerWatch.stop();
                        long elapsed = TaskRunnerCallable.this.killtimerWatch.elapsedMillis();
                        LOG.info("Time to die for task {}", (Object)elapsed);
                    }
                    TaskRunnerCallable.this.metrics.incrPreemptionTimeLost(TaskRunnerCallable.this.runtimeWatch.elapsedMillis());
                    TaskRunnerCallable.this.metrics.incrExecutorTotalKilled();
                    break;
                }
                case COMMUNICATION_FAILURE: {
                    LOG.info("Failed to run {} due to communication failure", (Object)TaskRunnerCallable.this.requestId);
                    TaskRunnerCallable.this.metrics.incrExecutorTotalExecutionFailed();
                    break;
                }
                case TASK_ERROR: {
                    LOG.info("Failed to run {} due to task error", (Object)TaskRunnerCallable.this.requestId);
                    TaskRunnerCallable.this.metrics.incrExecutorTotalExecutionFailed();
                }
            }
            TaskRunnerCallable.this.fragmentCompletionHanler.fragmentComplete(TaskRunnerCallable.this.fragmentInfo);
            this.taskRunnerCallable.shutdown();
            HistoryLogger.logFragmentEnd(this.request.getApplicationIdString(), this.request.getContainerIdString(), TaskRunnerCallable.this.executionContext.getHostName(), this.request.getFragmentSpec().getDagName(), TaskRunnerCallable.this.fragmentInfo.getQueryInfo().getDagIdentifier(), this.request.getFragmentSpec().getVertexName(), this.request.getFragmentSpec().getFragmentNumber(), this.request.getFragmentSpec().getAttemptNumber(), this.taskRunnerCallable.threadName, this.taskRunnerCallable.startTime, true);
            TaskRunnerCallable.this.metrics.decrExecutorNumQueuedRequests();
        }

        public void onFailure(Throwable t) {
            LOG.error("TezTaskRunner execution failed for : " + TaskRunnerCallable.getTaskIdentifierString(this.request), t);
            TaskRunnerCallable.this.isCompleted.set(true);
            TaskRunnerCallable.this.fragmentCompletionHanler.fragmentComplete(TaskRunnerCallable.this.fragmentInfo);
            this.taskRunnerCallable.shutdown();
            HistoryLogger.logFragmentEnd(this.request.getApplicationIdString(), this.request.getContainerIdString(), TaskRunnerCallable.this.executionContext.getHostName(), this.request.getFragmentSpec().getDagName(), TaskRunnerCallable.this.fragmentInfo.getQueryInfo().getDagIdentifier(), this.request.getFragmentSpec().getVertexName(), this.request.getFragmentSpec().getFragmentNumber(), this.request.getFragmentSpec().getAttemptNumber(), this.taskRunnerCallable.threadName, this.taskRunnerCallable.startTime, false);
            if (TaskRunnerCallable.this.metrics != null) {
                TaskRunnerCallable.this.metrics.decrExecutorNumQueuedRequests();
            }
        }
    }
}

