/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LogLevels;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.Cache;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelFifoCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.SimpleAllocator;
import org.apache.hadoop.hive.llap.cache.SimpleBufferManager;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonQueueMetrics;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcCacheKey;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.metrics2.util.MBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapIoImpl
implements LlapIo<VectorizedRowBatch> {
    public static final Logger LOG = LoggerFactory.getLogger(LlapIoImpl.class);
    public static final LogLevels LOGL = new LogLevels(LOG);
    private static final String MODE_CACHE = "cache";
    private static final String MODE_ALLOCATOR = "allocator";
    private final ColumnVectorProducer cvp;
    private final ListeningExecutorService executor;
    private LlapDaemonCacheMetrics cacheMetrics;
    private LlapDaemonQueueMetrics queueMetrics;
    private ObjectName buddyAllocatorMXBean;
    private Allocator allocator;

    private LlapIoImpl(Configuration conf) throws IOException {
        boolean useAllocOnly;
        String ioMode = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MODE);
        boolean useLowLevelCache = MODE_CACHE.equalsIgnoreCase(ioMode);
        boolean bl = useAllocOnly = !useLowLevelCache && MODE_ALLOCATOR.equalsIgnoreCase(ioMode);
        if (LOGL.isInfoEnabled()) {
            LOG.info("Initializing LLAP IO in " + ioMode + " mode");
        }
        String displayName = "LlapDaemonCacheMetrics-" + MetricsUtils.getHostName();
        String sessionId = conf.get("llap.daemon.metrics.sessionid");
        this.cacheMetrics = LlapDaemonCacheMetrics.create(displayName, sessionId);
        displayName = "LlapDaemonQueueMetrics-" + MetricsUtils.getHostName();
        int[] intervals = conf.getInts(String.valueOf(HiveConf.ConfVars.LLAP_QUEUE_METRICS_PERCENTILE_INTERVALS));
        this.queueMetrics = LlapDaemonQueueMetrics.create(displayName, sessionId, intervals);
        LOG.info("Started llap daemon metrics with displayName: " + displayName + " sessionId: " + sessionId);
        Cache<OrcCacheKey> cache = null;
        OrcMetadataCache metadataCache = null;
        LowLevelCacheImpl orcCache = null;
        BufferUsageManager bufferManager = null;
        if (useLowLevelCache) {
            boolean useLrfu = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_USE_LRFU);
            LowLevelCachePolicy cachePolicy = useLrfu ? new LowLevelLrfuCachePolicy(conf) : new LowLevelFifoCachePolicy(conf);
            LowLevelCacheMemoryManager memManager = new LowLevelCacheMemoryManager(conf, cachePolicy, this.cacheMetrics);
            BuddyAllocator allocator = new BuddyAllocator(conf, memManager, this.cacheMetrics);
            this.allocator = allocator;
            orcCache = new LowLevelCacheImpl(this.cacheMetrics, cachePolicy, allocator, true);
            metadataCache = new OrcMetadataCache(memManager, cachePolicy);
            cachePolicy.setEvictionListener(new EvictionDispatcher(orcCache, metadataCache));
            cachePolicy.setParentDebugDumper(orcCache);
            orcCache.init();
            bufferManager = orcCache;
        } else {
            if (useAllocOnly) {
                LowLevelCacheMemoryManager memManager = new LowLevelCacheMemoryManager(conf, null, this.cacheMetrics);
                this.allocator = new BuddyAllocator(conf, memManager, this.cacheMetrics);
            } else {
                this.allocator = new SimpleAllocator(conf);
            }
            bufferManager = new SimpleBufferManager(this.allocator, this.cacheMetrics);
        }
        int numThreads = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE);
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("IO-Elevator-Thread-%d").setDaemon(true).build()));
        this.cvp = new OrcColumnVectorProducer(metadataCache, orcCache, bufferManager, cache, conf, this.cacheMetrics, this.queueMetrics);
        if (LOGL.isInfoEnabled()) {
            LOG.info("LLAP IO initialized");
        }
        this.registerMXBeans();
    }

    private void registerMXBeans() {
        this.buddyAllocatorMXBean = MBeans.register((String)"LlapDaemon", (String)"BuddyAllocatorInfo", (Object)this.allocator);
    }

    public InputFormat<NullWritable, VectorizedRowBatch> getInputFormat(InputFormat sourceInputFormat) {
        return new LlapInputFormat(sourceInputFormat, this.cvp, this.executor);
    }

    public LlapDaemonCacheMetrics getCacheMetrics() {
        return this.cacheMetrics;
    }

    public LlapDaemonQueueMetrics getQueueMetrics() {
        return this.queueMetrics;
    }

    public void close() {
        LOG.info("Closing LlapIoImpl..");
        if (this.buddyAllocatorMXBean != null) {
            MBeans.unregister((ObjectName)this.buddyAllocatorMXBean);
            this.buddyAllocatorMXBean = null;
        }
        this.executor.shutdownNow();
    }
}

