/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;

public class OrcMetadataCache {
    private final ConcurrentHashMap<Long, OrcFileMetadata> metadata = new ConcurrentHashMap();
    private final ConcurrentHashMap<OrcBatchKey, OrcStripeMetadata> stripeMetadata = new ConcurrentHashMap();
    private final MemoryManager memoryManager;
    private final LowLevelCachePolicy policy;

    public OrcMetadataCache(MemoryManager memoryManager, LowLevelCachePolicy policy) {
        this.memoryManager = memoryManager;
        this.policy = policy;
    }

    public OrcFileMetadata putFileMetadata(OrcFileMetadata metaData) {
        long memUsage = metaData.getMemoryUsage();
        this.memoryManager.reserveMemory(memUsage, false);
        OrcFileMetadata val = this.metadata.putIfAbsent(metaData.getFileId(), metaData);
        return this.touchOnPut(metaData, val, memUsage);
    }

    public OrcStripeMetadata putStripeMetadata(OrcStripeMetadata metaData) {
        long memUsage = metaData.getMemoryUsage();
        this.memoryManager.reserveMemory(memUsage, false);
        OrcStripeMetadata val = this.stripeMetadata.putIfAbsent(metaData.getKey(), metaData);
        return this.touchOnPut(metaData, val, memUsage);
    }

    private <T extends LlapCacheableBuffer> T touchOnPut(T newVal, T oldVal, long memUsage) {
        if (oldVal == null) {
            oldVal = newVal;
            this.policy.cache(oldVal, LowLevelCache.Priority.HIGH);
        } else {
            this.memoryManager.releaseMemory(memUsage);
            this.policy.notifyLock(oldVal);
        }
        this.policy.notifyUnlock(oldVal);
        return oldVal;
    }

    public OrcStripeMetadata getStripeMetadata(OrcBatchKey stripeKey) throws IOException {
        return (OrcStripeMetadata)this.touchOnGet((LlapCacheableBuffer)this.stripeMetadata.get(stripeKey));
    }

    public OrcFileMetadata getFileMetadata(long fileId) throws IOException {
        return (OrcFileMetadata)this.touchOnGet((LlapCacheableBuffer)this.metadata.get(fileId));
    }

    private <T extends LlapCacheableBuffer> T touchOnGet(T result) {
        if (result != null) {
            this.policy.notifyLock(result);
            this.policy.notifyUnlock(result);
        }
        return result;
    }

    public void notifyEvicted(OrcFileMetadata buffer) {
        this.metadata.remove(buffer.getFileId());
    }

    public void notifyEvicted(OrcStripeMetadata buffer) {
        this.stripeMetadata.remove(buffer.getKey());
    }
}

