/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCustomMetricsInfo;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorInfo;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@Metrics(about="LlapDaemon Executor Metrics", context="executors")
public class LlapDaemonExecutorMetrics
implements MetricsSource {
    private final String name;
    private final JvmMetrics jvmMetrics;
    private final String sessionId;
    private final MetricsRegistry registry;
    private final int numExecutors;
    private final ThreadMXBean threadMXBean;
    private final Map<Integer, MetricsInfo> cpuMetricsInfoMap;
    private final Map<Integer, MetricsInfo> userMetricsInfoMap;
    final MutableGaugeLong[] executorThreadCpuTime;
    final MutableGaugeLong[] executorThreadUserTime;
    @Metric
    MutableCounterLong executorTotalRequestHandled;
    @Metric
    MutableCounterLong executorNumQueuedRequests;
    @Metric
    MutableCounterLong executorTotalSuccess;
    @Metric
    MutableCounterLong executorTotalIKilled;
    @Metric
    MutableCounterLong executorTotalExecutionFailed;
    @Metric
    MutableCounterLong preemptionTimeLost;

    private LlapDaemonExecutorMetrics(String displayName, JvmMetrics jm, String sessionId, int numExecutors) {
        this.name = displayName;
        this.jvmMetrics = jm;
        this.sessionId = sessionId;
        this.registry = new MetricsRegistry("LlapDaemonExecutorRegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
        this.numExecutors = numExecutors;
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.executorThreadCpuTime = new MutableGaugeLong[numExecutors];
        this.executorThreadUserTime = new MutableGaugeLong[numExecutors];
        this.cpuMetricsInfoMap = new ConcurrentHashMap<Integer, MetricsInfo>();
        this.userMetricsInfoMap = new ConcurrentHashMap<Integer, MetricsInfo>();
        for (int i = 0; i < numExecutors; ++i) {
            LlapDaemonCustomMetricsInfo mic = new LlapDaemonCustomMetricsInfo(LlapDaemonExecutorInfo.ExecutorThreadCPUTime.name() + "_" + i, LlapDaemonExecutorInfo.ExecutorThreadCPUTime.description());
            LlapDaemonCustomMetricsInfo miu = new LlapDaemonCustomMetricsInfo(LlapDaemonExecutorInfo.ExecutorThreadUserTime.name() + "_" + i, LlapDaemonExecutorInfo.ExecutorThreadUserTime.description());
            this.cpuMetricsInfoMap.put(i, mic);
            this.userMetricsInfoMap.put(i, miu);
            this.executorThreadCpuTime[i] = this.registry.newGauge((MetricsInfo)mic, 0L);
            this.executorThreadUserTime[i] = this.registry.newGauge((MetricsInfo)miu, 0L);
        }
    }

    public static LlapDaemonExecutorMetrics create(String displayName, String sessionId, int numExecutors) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)"LlapDaemon", (String)sessionId, (MetricsSystem)ms);
        return (LlapDaemonExecutorMetrics)ms.register(displayName, "LlapDaemon Executor Metrics", (Object)new LlapDaemonExecutorMetrics(displayName, jm, sessionId, numExecutors));
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapDaemonExecutorInfo.ExecutorMetrics).setContext("executors").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getExecutorStats(rb);
    }

    public void incrExecutorTotalRequestsHandled() {
        this.executorTotalRequestHandled.incr();
    }

    public void incrExecutorNumQueuedRequests() {
        this.executorNumQueuedRequests.incr();
    }

    public void decrExecutorNumQueuedRequests() {
        this.executorNumQueuedRequests.incr(-1L);
    }

    public void incrExecutorTotalSuccess() {
        this.executorTotalSuccess.incr();
    }

    public void incrExecutorTotalExecutionFailed() {
        this.executorTotalExecutionFailed.incr();
    }

    public void incrPreemptionTimeLost(long value) {
        this.preemptionTimeLost.incr(value);
    }

    public void incrExecutorTotalKilled() {
        this.executorTotalIKilled.incr();
    }

    private void getExecutorStats(MetricsRecordBuilder rb) {
        this.updateThreadMetrics(rb);
        rb.addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalRequestsHandled, this.executorTotalRequestHandled.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorNumQueuedRequests, this.executorNumQueuedRequests.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalSuccess, this.executorTotalSuccess.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalExecutionFailure, this.executorTotalExecutionFailed.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.ExecutorTotalInterrupted, this.executorTotalIKilled.value()).addCounter((MetricsInfo)LlapDaemonExecutorInfo.PreemptionTimeLost, this.preemptionTimeLost.value());
    }

    private void updateThreadMetrics(MetricsRecordBuilder rb) {
        if (this.threadMXBean.isThreadCpuTimeSupported() && this.threadMXBean.isThreadCpuTimeEnabled()) {
            int i;
            long[] ids = this.threadMXBean.getAllThreadIds();
            ThreadInfo[] infos = this.threadMXBean.getThreadInfo(ids);
            for (i = 0; i < ids.length; ++i) {
                ThreadInfo threadInfo = infos[i];
                String threadName = threadInfo.getThreadName();
                long threadId = ids[i];
                for (int j = 0; j < this.numExecutors; ++j) {
                    if (!threadName.equals("ContainerExecutor " + j)) continue;
                    this.executorThreadCpuTime[j].set(this.threadMXBean.getThreadCpuTime(threadId));
                    this.executorThreadUserTime[j].set(this.threadMXBean.getThreadUserTime(threadId));
                }
            }
            for (i = 0; i < this.numExecutors; ++i) {
                rb.addGauge(this.cpuMetricsInfoMap.get(i), this.executorThreadCpuTime[i].value());
                rb.addGauge(this.userMetricsInfoMap.get(i), this.executorThreadUserTime[i].value());
            }
        }
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public String getName() {
        return this.name;
    }
}

