/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import org.apache.hadoop.hive.llap.metrics.LlapDaemonQueueInfo;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;

@Metrics(about="LlapDaemon Queue Metrics", context="queue")
public class LlapDaemonQueueMetrics
implements MetricsSource {
    private final String name;
    private final String sessionId;
    private final MetricsRegistry registry;
    private long maxTime = Long.MIN_VALUE;
    @Metric
    MutableGaugeInt queueSize;
    @Metric
    MutableRate rateOfProcessing;
    final MutableQuantiles[] processingTimes;
    @Metric
    MutableGaugeLong maxProcessingTime;

    private LlapDaemonQueueMetrics(String displayName, String sessionId, int[] intervals) {
        this.name = displayName;
        this.sessionId = sessionId;
        this.registry = new MetricsRegistry("LlapDaemonQueueRegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
        int len = intervals == null ? 0 : intervals.length;
        this.processingTimes = new MutableQuantiles[len];
        for (int i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.processingTimes[i] = this.registry.newQuantiles(LlapDaemonQueueInfo.PercentileProcessingTime.name() + "_" + interval + "s", LlapDaemonQueueInfo.PercentileProcessingTime.description(), "ops", "latency", interval);
        }
    }

    public static LlapDaemonQueueMetrics create(String displayName, String sessionId, int[] intervals) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        return (LlapDaemonQueueMetrics)ms.register(displayName, null, (Object)new LlapDaemonQueueMetrics(displayName, sessionId, intervals));
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapDaemonQueueInfo.QueueMetrics).setContext("queue").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getQueueStats(rb);
    }

    public String getName() {
        return this.name;
    }

    public void setQueueSize(int size) {
        this.queueSize.set(size);
    }

    public void addProcessingTime(long latency) {
        this.rateOfProcessing.add(latency);
        if (latency > this.maxTime) {
            this.maxTime = latency;
            this.maxProcessingTime.set(this.maxTime);
        }
        for (MutableQuantiles q : this.processingTimes) {
            q.add(latency);
        }
    }

    private void getQueueStats(MetricsRecordBuilder rb) {
        rb.addGauge((MetricsInfo)LlapDaemonQueueInfo.QueueSize, this.queueSize.value()).addGauge((MetricsInfo)LlapDaemonQueueInfo.MaxProcessingTime, this.maxProcessingTime.value()).addGauge((MetricsInfo)LlapDaemonQueueInfo.MaxProcessingTime, this.maxProcessingTime.value());
        this.rateOfProcessing.snapshot(rb, true);
        for (MutableQuantiles q : this.processingTimes) {
            q.snapshot(rb, true);
        }
    }
}

