/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.old;

import org.apache.hadoop.hive.llap.old.BufferPool;
import org.apache.hadoop.hive.llap.old.ChunkPool;

public class BufferInProgress {
    public final BufferPool.WeakBuffer buffer;
    public int offset;
    private final int bufferLimit;
    private ChunkPool.Chunk chunkInProgress = null;
    private int chunkInProgressRows = 0;

    public BufferInProgress(BufferPool.WeakBuffer buffer) {
        this.buffer = buffer;
        this.bufferLimit = buffer.getContents().limit();
        this.offset = 0;
    }

    public ChunkPool.Chunk ensureChunk() {
        if (this.chunkInProgress == null) {
            this.chunkInProgress = new ChunkPool.Chunk(this.buffer, this.offset, 0);
            this.chunkInProgressRows = 0;
        }
        return this.chunkInProgress;
    }

    public ChunkPool.Chunk extractChunk() {
        ChunkPool.Chunk result = this.chunkInProgress;
        this.chunkInProgress = null;
        this.chunkInProgressRows = 0;
        return result;
    }

    public void update(int newOffset, int rowsWritten) {
        if (newOffset > this.bufferLimit) {
            throw new AssertionError((Object)("Offset is beyond buffer limit: " + newOffset + "/" + this.bufferLimit + "; previous offset " + this.offset + ", chunk " + this.chunkInProgress));
        }
        this.chunkInProgress.length += newOffset - this.offset;
        this.offset = newOffset;
        this.chunkInProgressRows += rowsWritten;
    }

    public int getChunkInProgressRows() {
        return this.chunkInProgressRows;
    }

    public int getSpaceLeft() {
        return this.getSpaceLeft(-1);
    }

    public int getSpaceLeft(int offset) {
        offset = offset >= 0 ? offset : this.offset;
        return this.buffer.getContents().limit() - offset;
    }
}

