/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.old;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.old.CachePolicy;

public class BufferPool {
    private final CachePolicy cachePolicy = null;
    private final Object evictionNotifyObj = new Object();
    private int evictionIsWaiting;
    private final long maxCacheSize;
    private final int bufferSize;

    public BufferPool(Configuration conf) {
        this.maxCacheSize = 0L;
        this.bufferSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeakBuffer allocateBuffer() throws InterruptedException {
        ByteBuffer newBuffer = ByteBuffer.allocate(this.bufferSize);
        WeakBuffer wb = new WeakBuffer(this, newBuffer);
        if (!wb.lock(false)) {
            throw new AssertionError((Object)"Cannot lock a new buffer");
        }
        if (DebugUtils.isTraceLockingEnabled()) {
            LlapIoImpl.LOG.info("Locked " + wb + " after creation");
        }
        boolean hasWaited = false;
        WeakBuffer evicted = null;
        while ((evicted = this.cachePolicy.cache(wb)) == CachePolicy.CANNOT_EVICT) {
            if (DebugUtils.isTraceCachingEnabled() && !hasWaited) {
                LlapIoImpl.LOG.info("Failed to add a new block to cache; waiting for blocks to be unlocked");
                hasWaited = true;
            }
            Object object = this.evictionNotifyObj;
            synchronized (object) {
                ++this.evictionIsWaiting;
                this.evictionNotifyObj.wait(1000L);
                --this.evictionIsWaiting;
            }
        }
        if (DebugUtils.isTraceCachingEnabled() && hasWaited) {
            LlapIoImpl.LOG.info("Eviction is done waiting");
        }
        if (evicted != null) {
            evicted.clear();
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unblockEviction() {
        if (this.evictionIsWaiting <= 0) {
            return;
        }
        Object object = this.evictionNotifyObj;
        synchronized (object) {
            if (this.evictionIsWaiting <= 0) {
                return;
            }
            if (DebugUtils.isTraceCachingEnabled()) {
                LlapIoImpl.LOG.info("Notifying eviction that some block has been unlocked");
            }
            this.evictionNotifyObj.notifyAll();
        }
    }

    @VisibleForTesting
    public static WeakBuffer allocateFake() {
        return new WeakBuffer(null, ByteBuffer.wrap(new byte[1]));
    }

    public static final class WeakBuffer {
        private static final int EVICTED_REFCOUNT = -1;
        private final BufferPool parent;
        private ByteBuffer contents;
        private final AtomicInteger refCount = new AtomicInteger(0);
        public double priority;
        public long lastUpdate = -1L;
        public int indexInHeap = -1;
        public boolean isLockedInHeap = false;

        private WeakBuffer(BufferPool parent, ByteBuffer contents) {
            this.parent = parent;
            this.contents = contents;
        }

        public ByteBuffer getContents() {
            assert (this.isLocked()) : "Cannot get contents with refCount " + this.refCount.get();
            return this.contents;
        }

        public int hashCode() {
            if (this.contents == null) {
                return 0;
            }
            return System.identityHashCode(this.contents);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WeakBuffer)) {
                return false;
            }
            return this.contents == ((WeakBuffer)obj).contents;
        }

        public boolean lock(boolean doTouch) {
            int oldRefCount = -1;
            do {
                if ((oldRefCount = this.refCount.get()) == -1) {
                    return false;
                }
                assert (oldRefCount >= 0);
            } while (!this.refCount.compareAndSet(oldRefCount, oldRefCount + 1));
            if (doTouch && oldRefCount == 0 && this.parent != null) {
                this.parent.cachePolicy.notifyLock(this);
            }
            return true;
        }

        public boolean isLocked() {
            return this.refCount.get() > 0;
        }

        public boolean isInvalid() {
            return this.refCount.get() == -1;
        }

        public boolean isCleared() {
            return this.contents == null;
        }

        public void unlock() {
            int newRefCount = this.refCount.decrementAndGet();
            if (newRefCount < 0) {
                throw new AssertionError((Object)("Unexpected refCount " + newRefCount));
            }
            if (newRefCount == 0 && this.parent != null) {
                this.parent.cachePolicy.notifyUnlock(this);
                this.parent.unblockEviction();
            }
        }

        public String toString() {
            return "0x" + Integer.toHexString(this.hashCode());
        }

        boolean invalidate() {
            int value;
            do {
                if ((value = this.refCount.get()) == 0) continue;
                return false;
            } while (!this.refCount.compareAndSet(value, -1));
            if (DebugUtils.isTraceLockingEnabled()) {
                LlapIoImpl.LOG.info("Invalidated " + this + " due to eviction");
            }
            return true;
        }

        ByteBuffer clear() {
            assert (this.refCount.get() == -1);
            ByteBuffer result = this.contents;
            this.contents = null;
            return result;
        }

        public String toStringForCache() {
            return "[" + Integer.toHexString(this.hashCode()) + " " + String.format("%1$.2f", this.priority) + " " + this.lastUpdate + " " + (this.isLocked() ? "!" : ".") + "]";
        }
    }
}

