/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.old;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.old.BufferPool;

public class ChunkPool<K> {
    private final ConcurrentHashMap<K, Chunk> chunkCache = new ConcurrentHashMap();
    private final AtomicInteger newEvictions = new AtomicInteger(0);
    private final Thread cleanupThread = new CleanupThread();

    public ChunkPool() {
        this.cleanupThread.start();
    }

    public Chunk getChunk(K key, HashSet<BufferPool.WeakBuffer> lockedBuffers) {
        Chunk result;
        do {
            if ((result = this.chunkCache.get(key)) == null) {
                return null;
            }
            if (!this.lockChunk(result, lockedBuffers)) continue;
            return result;
        } while (!this.chunkCache.remove(key, result));
        return null;
    }

    private boolean lockChunk(Chunk result, HashSet<BufferPool.WeakBuffer> lockedBuffers) {
        boolean failedToLock = false;
        long blocksToUnlock = 0L;
        long bit = Integer.MIN_VALUE;
        Chunk chunk = result;
        while (chunk != null) {
            if (lockedBuffers.contains(chunk.buffer)) {
                assert (chunk.buffer.isLocked()) : chunk.buffer + " is in lockedBuffers but is not locked";
            } else if (chunk.buffer.lock(true)) {
                if (DebugUtils.isTraceLockingEnabled()) {
                    LlapIoImpl.LOG.info("Locked " + chunk.buffer + " for " + result);
                }
                lockedBuffers.add(chunk.buffer);
                blocksToUnlock += bit;
            } else {
                failedToLock = true;
                break;
            }
            chunk = chunk.nextChunk;
            if ((bit >>>= 1) == 1L && chunk != null) {
                throw new AssertionError((Object)"Chunk chain was too long");
            }
        }
        if (!failedToLock) {
            return true;
        }
        bit = Integer.MIN_VALUE;
        Chunk chunk2 = result;
        while (chunk2 != chunk) {
            if ((blocksToUnlock & bit) == bit) {
                if (DebugUtils.isTraceLockingEnabled()) {
                    LlapIoImpl.LOG.info("Unlocking " + chunk2.buffer + " due to failed chunk lock");
                }
                lockedBuffers.remove(chunk2.buffer);
                chunk2.buffer.unlock();
            }
            bit >>>= 1;
            chunk2 = chunk2.nextChunk;
        }
        return false;
    }

    private boolean verifyChunk(Chunk entry) {
        Chunk chunk = entry;
        while (chunk != null && chunk.buffer.lock(false)) {
            chunk = chunk.nextChunk;
        }
        Chunk chunk2 = entry;
        while (chunk2 != chunk) {
            chunk2.buffer.unlock();
            chunk2 = chunk2.nextChunk;
        }
        return chunk == null;
    }

    public Chunk addOrGetChunk(K key, Chunk val, HashSet<BufferPool.WeakBuffer> lockedBuffers) {
        assert (val.buffer.isLocked());
        Chunk oldVal;
        while ((oldVal = this.chunkCache.putIfAbsent(key, val)) != null) {
            if (DebugUtils.isTraceCachingEnabled()) {
                LlapIoImpl.LOG.info("Trying to cache when the chunk is already cached for " + key + "; old " + oldVal + ", new " + val);
            }
            if (this.lockChunk(oldVal, lockedBuffers)) {
                return oldVal;
            }
            this.chunkCache.remove(key, oldVal);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictionNotice(BufferPool.WeakBuffer evicted) {
        int oldValue = this.newEvictions.getAndIncrement();
        if (oldValue == 0) {
            AtomicInteger atomicInteger = this.newEvictions;
            synchronized (atomicInteger) {
                this.newEvictions.notifyAll();
            }
        }
    }

    private final class CleanupThread
    extends Thread {
        private int APPROX_CLEANUP_INTERVAL_SEC;

        public CleanupThread() {
            super("Llap ChunkPool cleanup thread");
            this.APPROX_CLEANUP_INTERVAL_SEC = 600;
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.doOneCleanupRound();
                }
            }
            catch (InterruptedException ex) {
                LlapIoImpl.LOG.warn("Cleanup thread has been interrupted");
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                LlapIoImpl.LOG.error("Cleanup has failed; the thread will now exit", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doOneCleanupRound() throws InterruptedException {
            int evictionsSinceLast;
            while ((evictionsSinceLast = ChunkPool.this.newEvictions.getAndSet(0)) <= 0) {
                AtomicInteger atomicInteger = ChunkPool.this.newEvictions;
                synchronized (atomicInteger) {
                    ChunkPool.this.newEvictions.wait(10000L);
                }
            }
            long endTime = System.nanoTime() + (long)this.APPROX_CLEANUP_INTERVAL_SEC * 1000000000L;
            int processed = 0;
            Iterator iter = ChunkPool.this.chunkCache.entrySet().iterator();
            while (iter.hasNext()) {
                int approxElementsLeft;
                if (!ChunkPool.this.verifyChunk((Chunk)iter.next().getValue())) {
                    iter.remove();
                }
                Thread.sleep((approxElementsLeft = ChunkPool.this.chunkCache.size() - ++processed) <= 0 ? 1L : (endTime - System.nanoTime()) / (1000000L * (long)approxElementsLeft));
            }
        }
    }

    public static class Chunk {
        public BufferPool.WeakBuffer buffer;
        public int offset;
        public int length;
        public Chunk nextChunk;

        public Chunk(BufferPool.WeakBuffer buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        public Chunk addChunk(Chunk another) {
            Chunk chunk = this;
            while (chunk.nextChunk != null) {
                chunk = chunk.nextChunk;
            }
            chunk.nextChunk = another;
            return this;
        }

        public String toString() {
            return "{" + this.buffer + ", " + this.offset + ", " + this.length + "}";
        }

        public String toFullString() {
            String result = "";
            Chunk chunk = this;
            while (chunk != null) {
                result = result + chunk.toString() + ", ";
                chunk = chunk.nextChunk;
            }
            return result;
        }
    }
}

