/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.registry.ServiceInstance;
import org.apache.hadoop.hive.llap.registry.ServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.security.LlapTokenProvider;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapSecurityHelper
implements LlapTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LlapSecurityHelper.class);
    private UserGroupInformation llapUgi;
    private final LlapRegistryService registry;
    private ServiceInstanceSet activeInstances;
    private final Configuration conf;
    private LlapManagementProtocolClientImpl client;
    private final SocketFactory socketFactory;
    private final RetryPolicy retryPolicy;

    public LlapSecurityHelper(Configuration conf) {
        this.conf = conf;
        this.registry = new LlapRegistryService(false);
        this.registry.init(conf);
        this.socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        this.retryPolicy = RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)16000L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static UserGroupInformation loginWithKerberos(String principal, String keytabFile) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return null;
        }
        if (principal.isEmpty() || keytabFile.isEmpty()) {
            throw new RuntimeException("Kerberos principal and/or keytab are empty");
        }
        LOG.info("Logging in as " + principal + " via " + keytabFile);
        UserGroupInformation.loginUserFromKeytab((String)SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), (String)keytabFile);
        return UserGroupInformation.getLoginUser();
    }

    public Token<LlapTokenIdentifier> getDelegationToken() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return null;
        }
        if (this.llapUgi == null) {
            this.llapUgi = UserGroupInformation.getCurrentUser();
        }
        Iterator<ServiceInstance> llaps = null;
        ServiceInstance someLlap = null;
        if (this.client == null) {
            llaps = this.getLlapServices(false);
            someLlap = llaps.next();
        }
        ByteString tokenBytes = null;
        boolean hasRefreshed = false;
        while (true) {
            try {
                tokenBytes = this.getTokenBytes(someLlap);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (IOException ex) {
                LOG.error("Cannot get a token, trying a different instance", (Throwable)ex);
                this.client = null;
                if (llaps == null || !llaps.hasNext()) {
                    if (hasRefreshed) {
                        throw new RuntimeException("Cannot find any LLAPs to get the token from");
                    }
                    llaps = this.getLlapServices(true);
                    hasRefreshed = true;
                }
                someLlap = llaps.next();
                continue;
            }
            break;
        }
        Token token = new Token();
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{tokenBytes.asReadOnlyByteBuffer()});
        token.readFields((DataInput)in);
        return token;
    }

    private ByteString getTokenBytes(final ServiceInstance si) throws InterruptedException, IOException {
        return (ByteString)this.llapUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ByteString>(){

            @Override
            public ByteString run() throws Exception {
                if (LlapSecurityHelper.this.client == null) {
                    LlapSecurityHelper.this.client = new LlapManagementProtocolClientImpl(LlapSecurityHelper.this.conf, si.getHost(), si.getManagementPort(), LlapSecurityHelper.this.retryPolicy, LlapSecurityHelper.this.socketFactory);
                }
                LlapDaemonProtocolProtos.GetTokenRequestProto req = LlapDaemonProtocolProtos.GetTokenRequestProto.newBuilder().build();
                return LlapSecurityHelper.this.client.getDelegationToken(null, req).getToken();
            }
        });
    }

    private Iterator<ServiceInstance> getLlapServices(boolean doForceRefresh) throws IOException {
        if (this.activeInstances == null) {
            this.registry.start();
            this.activeInstances = this.registry.getInstances();
        }
        Map daemons = this.activeInstances.getAll();
        if (doForceRefresh || daemons == null || daemons.isEmpty()) {
            this.activeInstances.refresh();
            daemons = this.activeInstances.getAll();
            if (daemons == null || daemons.isEmpty()) {
                throw new RuntimeException("No LLAPs found");
            }
        }
        return daemons.values().iterator();
    }
}

