/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.security.LlapSecurityHelper;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretManager
extends ZKDelegationTokenSecretManager<LlapTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(SecretManager.class);
    private static final Pattern hostsRe = Pattern.compile("[^A-Za-z0-9_-]");

    public SecretManager(Configuration conf) {
        super(conf);
        this.checkForZKDTSMBug(conf);
    }

    private void checkForZKDTSMBug(Configuration conf) {
        long expectedRenewTimeSec = conf.getLong("delegation-token.renew-interval.sec", -1L);
        LOG.info("Checking for tokenRenewInterval bug: " + expectedRenewTimeSec);
        if (expectedRenewTimeSec == -1L) {
            return;
        }
        Field f = null;
        try {
            Class<AbstractDelegationTokenSecretManager> c = AbstractDelegationTokenSecretManager.class;
            f = c.getDeclaredField("tokenRenewInterval");
            f.setAccessible(true);
        }
        catch (Throwable t) {
            LOG.error("Failed to check for tokenRenewInterval bug, hoping for the best", t);
            return;
        }
        try {
            long realValue = f.getLong((Object)this);
            long expectedValue = expectedRenewTimeSec * 1000L;
            LOG.info("tokenRenewInterval is: " + realValue + " (expected " + expectedValue + ")");
            if (realValue == expectedRenewTimeSec) {
                f.setLong((Object)this, expectedValue);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to address tokenRenewInterval bug", ex);
        }
    }

    public LlapTokenIdentifier createIdentifier() {
        return new LlapTokenIdentifier();
    }

    public LlapTokenIdentifier decodeTokenIdentifier(Token<LlapTokenIdentifier> token) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
        LlapTokenIdentifier id = new LlapTokenIdentifier();
        id.readFields((DataInput)dis);
        dis.close();
        return id;
    }

    private static String deriveZkPath(Configuration conf) throws IOException {
        String hosts = HiveConf.getTrimmedVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        String clusterName = hosts.startsWith("@") ? hosts.substring(1) : hosts;
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        return hostsRe.matcher(userName + "_" + clusterName).replaceAll("_");
    }

    public static SecretManager createSecretManager(Configuration conf, String llapPrincipal, String llapKeytab) {
        String zkPath;
        UserGroupInformation zkUgi = null;
        String principal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_KERBEROS_PRINCIPAL, (String)llapPrincipal);
        String keyTab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_KERBEROS_KEYTAB_FILE, (String)llapKeytab);
        try {
            zkUgi = LlapSecurityHelper.loginWithKerberos(principal, keyTab);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final Configuration zkConf = new Configuration(conf);
        long tokenLifetime = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DELEGATION_TOKEN_LIFETIME, (TimeUnit)TimeUnit.SECONDS);
        zkConf.setLong("delegation-token.max-lifetime.sec", tokenLifetime);
        zkConf.setLong("delegation-token.renew-interval.sec", tokenLifetime);
        zkConf.set("zk-dt-secret-manager.kerberos.principal", principal);
        zkConf.set("zk-dt-secret-manager.kerberos.keytab", keyTab);
        try {
            zkPath = SecretManager.deriveZkPath(conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("Using {} as ZK secret manager path", (Object)zkPath);
        zkConf.set("zk-dt-secret-manager.znodeWorkingPath", "zkdtsm_" + zkPath);
        SecretManager.setZkConfIfNotSet(zkConf, "zk-dt-secret-manager.zkAuthType", "sasl");
        SecretManager.setZkConfIfNotSet(zkConf, "zk-dt-secret-manager.zkConnectionString", HiveConf.getVar((Configuration)zkConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_ZK_CONNECTION_STRING));
        return (SecretManager)((Object)zkUgi.doAs((PrivilegedAction)new PrivilegedAction<SecretManager>(){

            @Override
            public SecretManager run() {
                SecretManager zkSecretManager = new SecretManager(zkConf);
                try {
                    zkSecretManager.startThreads();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return zkSecretManager;
            }
        }));
    }

    private static void setZkConfIfNotSet(Configuration zkConf, String name, String value) {
        if (zkConf.get(name) != null) {
            return;
        }
        zkConf.set(name, value);
    }
}

