/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.llap.io.encoded.SerDeEncodedDataReader;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerStripeMetadata;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.orc.CompressionKind;
import org.apache.hive.orc.OrcProto;
import org.apache.hive.orc.OrcUtils;
import org.apache.hive.orc.TypeDescription;

public class GenericColumnVectorProducer
implements ColumnVectorProducer {
    private final SerDeLowLevelCacheImpl cache;
    private final BufferUsageManager bufferManager;
    private final Configuration conf;
    private final LlapDaemonCacheMetrics cacheMetrics;
    private final LlapDaemonIOMetrics ioMetrics;

    public GenericColumnVectorProducer(SerDeLowLevelCacheImpl serdeCache, BufferUsageManager bufferManager, Configuration conf, LlapDaemonCacheMetrics cacheMetrics, LlapDaemonIOMetrics ioMetrics) {
        LlapIoImpl.LOG.info("Initializing ORC column vector producer");
        this.cache = serdeCache;
        this.bufferManager = bufferManager;
        this.conf = conf;
        this.cacheMetrics = cacheMetrics;
        this.ioMetrics = ioMetrics;
    }

    @Override
    public ReadPipeline createReadPipeline(Consumer<ColumnVectorBatch> consumer, FileSplit split, List<Integer> columnIds, SearchArgument sarg, String[] columnNames, QueryFragmentCounters counters, TypeDescription schema, InputFormat<?, ?> sourceInputFormat, Deserializer sourceSerDe, Reporter reporter, JobConf job, Map<String, PartitionDesc> parts) throws IOException {
        SerDeFileMetadata fm;
        this.cacheMetrics.incrCacheReadRequests();
        OrcEncodedDataConsumer edc = new OrcEncodedDataConsumer(consumer, columnIds.size(), false, counters, this.ioMetrics);
        try {
            fm = new SerDeFileMetadata(sourceSerDe);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        edc.setFileMetadata(fm);
        SerDeEncodedDataReader reader = new SerDeEncodedDataReader(this.cache, this.bufferManager, this.conf, split, columnIds, edc, job, reporter, sourceInputFormat, sourceSerDe, counters, fm.getSchema(), parts);
        edc.init(reader, (Callable<Void>)((Object)reader));
        if (LlapIoImpl.LOG.isDebugEnabled()) {
            LlapIoImpl.LOG.debug("Ignoring schema: " + schema);
        }
        return edc;
    }

    private static final class SerDeFileMetadata
    implements ConsumerFileMetadata {
        private final List<OrcProto.Type> orcTypes = new ArrayList<OrcProto.Type>();
        private final TypeDescription schema;

        public SerDeFileMetadata(Deserializer sourceSerDe) throws SerDeException {
            TypeDescription schema;
            this.schema = schema = OrcInputFormat.convertTypeInfo((TypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)sourceSerDe.getObjectInspector()));
            this.addTypesFromSchema(schema);
        }

        private void addTypesFromSchema(TypeDescription schema) {
            OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
            List children = OrcUtils.setTypeBuilderFromSchema((OrcProto.Type.Builder)type, (TypeDescription)schema);
            this.orcTypes.add(type.build());
            if (children == null) {
                return;
            }
            for (TypeDescription child : children) {
                this.addTypesFromSchema(child);
            }
        }

        @Override
        public List<OrcProto.Type> getTypes() {
            return this.orcTypes;
        }

        @Override
        public int getStripeCount() {
            return 1;
        }

        @Override
        public CompressionKind getCompressionKind() {
            return CompressionKind.NONE;
        }

        @Override
        public TypeDescription getSchema() {
            return this.schema;
        }
    }

    public static final class SerDeStripeMetadata
    implements ConsumerStripeMetadata {
        private final String writerTimezone = TimeZone.getDefault().getID();
        private List<OrcProto.ColumnEncoding> encodings;
        private final int stripeIx;
        private long rowCount = -1L;

        public SerDeStripeMetadata(int stripeIx) {
            this.stripeIx = stripeIx;
        }

        @Override
        public String getWriterTimezone() {
            return this.writerTimezone;
        }

        @Override
        public int getStripeIx() {
            return this.stripeIx;
        }

        @Override
        public long getRowCount() {
            return this.rowCount;
        }

        @Override
        public List<OrcProto.ColumnEncoding> getEncodings() {
            return this.encodings;
        }

        @Override
        public OrcProto.RowIndexEntry getRowIndexEntry(int colIx, int rgIx) {
            throw new UnsupportedOperationException();
        }

        public void setEncodings(List<OrcProto.ColumnEncoding> encodings) {
            this.encodings = encodings;
        }

        @Override
        public OrcProto.RowIndex[] getRowIndexes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsRowIndexes() {
            return false;
        }

        public void setRowCount(long value) {
            this.rowCount = value;
        }

        public String toString() {
            return "[stripeIx=" + this.stripeIx + ", rowCount=" + this.rowCount + ", encodings=" + this.encodings + "]".replace('\n', ' ');
        }
    }
}

