/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.llap.IncrementalObjectSizeEstimator;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerStripeMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hive.orc.DataReader;
import org.apache.hive.orc.OrcProto;
import org.apache.hive.orc.StripeInformation;
import org.apache.hive.orc.impl.OrcIndex;

public class OrcStripeMetadata
extends LlapCacheableBuffer
implements ConsumerStripeMetadata {
    private final OrcBatchKey stripeKey;
    private final List<OrcProto.ColumnEncoding> encodings;
    private final List<OrcProto.Stream> streams;
    private final String writerTimezone;
    private final long rowCount;
    private OrcIndex rowIndex;
    private final int estimatedMemUsage;
    private static final HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> SIZE_ESTIMATORS;
    private static final IncrementalObjectSizeEstimator.ObjectEstimator SIZE_ESTIMATOR;

    public OrcStripeMetadata(OrcBatchKey stripeKey, DataReader mr, StripeInformation stripe, boolean[] includes, boolean[] sargColumns) throws IOException {
        this.stripeKey = stripeKey;
        OrcProto.StripeFooter footer = mr.readStripeFooter(stripe);
        this.streams = footer.getStreamsList();
        this.encodings = footer.getColumnsList();
        this.writerTimezone = footer.getWriterTimezone();
        this.rowCount = stripe.getNumberOfRows();
        this.rowIndex = mr.readRowIndex(stripe, footer, includes, null, sargColumns, null);
        this.estimatedMemUsage = SIZE_ESTIMATOR.estimate(this, SIZE_ESTIMATORS);
    }

    private OrcStripeMetadata(Object id) {
        this.stripeKey = new OrcBatchKey(id, 0, 0);
        this.encodings = new ArrayList<OrcProto.ColumnEncoding>();
        this.streams = new ArrayList<OrcProto.Stream>();
        this.writerTimezone = "";
        this.estimatedMemUsage = 0;
        this.rowCount = 0;
    }

    @VisibleForTesting
    public static OrcStripeMetadata createDummy(Object id) {
        OrcStripeMetadata dummy = new OrcStripeMetadata(id);
        dummy.encodings.add(OrcProto.ColumnEncoding.getDefaultInstance());
        dummy.streams.add(OrcProto.Stream.getDefaultInstance());
        OrcProto.RowIndex ri = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(1L).setStatistics(OrcFileMetadata.createStatsDummy())).build();
        OrcProto.BloomFilterIndex bfi = OrcProto.BloomFilterIndex.newBuilder().addBloomFilter(OrcProto.BloomFilter.newBuilder().addBitset(0L)).build();
        dummy.rowIndex = new OrcIndex(new OrcProto.RowIndex[]{ri}, new OrcProto.BloomFilterIndex[]{bfi});
        return dummy;
    }

    public boolean hasAllIndexes(boolean[] includes) {
        for (int i = 0; i < includes.length; ++i) {
            if (!includes[i] || this.rowIndex.getRowGroupIndex()[i] != null) continue;
            return false;
        }
        return true;
    }

    public void loadMissingIndexes(DataReader mr, StripeInformation stripe, boolean[] includes, boolean[] sargColumns) throws IOException {
        int i;
        OrcProto.RowIndex[] existing = this.getRowIndexes();
        boolean[] superset = new boolean[Math.max(existing.length, includes.length)];
        for (i = 0; i < includes.length; ++i) {
            superset[i] = includes[i];
        }
        for (i = 0; i < existing.length; ++i) {
            superset[i] = superset[i] || existing[i] != null;
        }
        this.rowIndex = mr.readRowIndex(stripe, null, superset, this.rowIndex.getRowGroupIndex(), sargColumns, this.rowIndex.getBloomFilterIndex());
    }

    @Override
    public int getStripeIx() {
        return this.stripeKey.stripeIx;
    }

    @Override
    public OrcProto.RowIndex[] getRowIndexes() {
        return this.rowIndex.getRowGroupIndex();
    }

    public OrcProto.BloomFilterIndex[] getBloomFilterIndexes() {
        return this.rowIndex.getBloomFilterIndex();
    }

    @Override
    public List<OrcProto.ColumnEncoding> getEncodings() {
        return this.encodings;
    }

    public List<OrcProto.Stream> getStreams() {
        return this.streams;
    }

    @Override
    public String getWriterTimezone() {
        return this.writerTimezone;
    }

    @Override
    public long getMemoryUsage() {
        return this.estimatedMemUsage;
    }

    @Override
    public void notifyEvicted(EvictionDispatcher evictionDispatcher) {
        evictionDispatcher.notifyEvicted(this);
    }

    @Override
    protected boolean invalidate() {
        return true;
    }

    @Override
    protected boolean isLocked() {
        return false;
    }

    public OrcBatchKey getKey() {
        return this.stripeKey;
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @VisibleForTesting
    public void resetRowIndex() {
        this.rowIndex = null;
    }

    @Override
    public OrcProto.RowIndexEntry getRowIndexEntry(int colIx, int rgIx) {
        return this.rowIndex.getRowGroupIndex()[colIx].getEntry(rgIx);
    }

    @Override
    public boolean supportsRowIndexes() {
        return true;
    }

    static {
        OrcStripeMetadata osm = OrcStripeMetadata.createDummy(new SyntheticFileId());
        SIZE_ESTIMATORS = IncrementalObjectSizeEstimator.createEstimators(osm);
        IncrementalObjectSizeEstimator.addEstimator("com.google.protobuf.LiteralByteString", SIZE_ESTIMATORS);
        IncrementalObjectSizeEstimator.createEstimators(Long.class, SIZE_ESTIMATORS);
        SIZE_ESTIMATOR = SIZE_ESTIMATORS.get(OrcStripeMetadata.class);
    }
}

