/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import java.util.List;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerFileMetadata;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;

public final class OrcFileMetadata
implements FileMetadata,
ConsumerFileMetadata {
    private final List<StripeInformation> stripes;
    private final List<Integer> versionList;
    private final List<OrcProto.StripeStatistics> stripeStats;
    private final List<OrcProto.Type> types;
    private final List<OrcProto.ColumnStatistics> fileStats;
    private final Object fileKey;
    private final CompressionKind compressionKind;
    private final int rowIndexStride;
    private final int compressionBufferSize;
    private final int metadataSize;
    private final int writerVersionNum;
    private final long contentLength;
    private final long numberOfRows;
    private final boolean isOriginalFormat;

    public OrcFileMetadata(Object fileKey, OrcProto.Footer footer, OrcProto.PostScript ps, List<OrcProto.StripeStatistics> stats, List<StripeInformation> stripes) {
        this.stripeStats = stats;
        this.compressionKind = CompressionKind.valueOf((String)ps.getCompression().name());
        this.compressionBufferSize = (int)ps.getCompressionBlockSize();
        this.stripes = stripes;
        this.isOriginalFormat = OrcInputFormat.isOriginal((OrcProto.Footer)footer);
        this.writerVersionNum = ps.getWriterVersion();
        this.versionList = ps.getVersionList();
        this.metadataSize = (int)ps.getMetadataLength();
        this.types = footer.getTypesList();
        this.rowIndexStride = footer.getRowIndexStride();
        this.contentLength = footer.getContentLength();
        this.numberOfRows = footer.getNumberOfRows();
        this.fileStats = footer.getStatisticsList();
        this.fileKey = fileKey;
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return this.types;
    }

    public boolean isOriginalFormat() {
        return this.isOriginalFormat;
    }

    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    @Override
    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public int getCompressionBufferSize() {
        return this.compressionBufferSize;
    }

    public int getRowIndexStride() {
        return this.rowIndexStride;
    }

    public int getColumnCount() {
        return this.types.size();
    }

    public int getFlattenedColumnCount() {
        return this.types.get(0).getSubtypesCount();
    }

    public Object getFileKey() {
        return this.fileKey;
    }

    public List<Integer> getVersionList() {
        return this.versionList;
    }

    public int getMetadataSize() {
        return this.metadataSize;
    }

    public int getWriterVersionNum() {
        return this.writerVersionNum;
    }

    public List<OrcProto.StripeStatistics> getStripeStats() {
        return this.stripeStats;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public List<OrcProto.ColumnStatistics> getFileStats() {
        return this.fileStats;
    }

    @Override
    public int getStripeCount() {
        return this.stripes.size();
    }

    @Override
    public TypeDescription getSchema() {
        return OrcUtils.convertTypeFromProtobuf(this.types, (int)0);
    }
}

