/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocatorMXBean;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hive.common.util.CleanerUtil;

public final class SimpleAllocator
implements Allocator,
BuddyAllocatorMXBean {
    private final boolean isDirect;

    public SimpleAllocator(Configuration conf) {
        this.isDirect = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT);
        if (LlapIoImpl.LOG.isInfoEnabled()) {
            LlapIoImpl.LOG.info("Simple allocator with " + (this.isDirect ? "direct" : "byte") + " buffers");
        }
    }

    @Deprecated
    public void allocateMultiple(MemoryBuffer[] dest, int size) {
        this.allocateMultiple(dest, size, null);
    }

    public void allocateMultiple(MemoryBuffer[] dest, int size, Allocator.BufferObjectFactory factory) {
        for (int i = 0; i < dest.length; ++i) {
            LlapAllocatorBuffer buf = null;
            if (dest[i] == null) {
                buf = factory != null ? (LlapAllocatorBuffer)factory.create() : this.createUnallocated();
                dest[i] = buf;
            } else {
                buf = (LlapAllocatorBuffer)dest[i];
            }
            ByteBuffer bb = this.isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
            buf.initialize(bb, 0, size);
        }
    }

    public void deallocate(MemoryBuffer buffer) {
        LlapAllocatorBuffer buf = (LlapAllocatorBuffer)buffer;
        ByteBuffer bb = buf.byteBuffer;
        buf.byteBuffer = null;
        if (!bb.isDirect()) {
            return;
        }
        if (!CleanerUtil.UNMAP_SUPPORTED) {
            return;
        }
        try {
            CleanerUtil.getCleaner().freeBuffer(bb);
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.warn("Error using DirectByteBuffer cleaner", t);
        }
    }

    public boolean isDirectAlloc() {
        return this.isDirect;
    }

    @Deprecated
    public LlapAllocatorBuffer createUnallocated() {
        return new LlapDataBuffer();
    }

    @Override
    public boolean getIsDirect() {
        return this.isDirect;
    }

    @Override
    public int getMinAllocation() {
        return 0;
    }

    @Override
    public int getMaxAllocation() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getArenaSize() {
        return -1;
    }

    @Override
    public long getMaxCacheSize() {
        return Integer.MAX_VALUE;
    }
}

